import{a as n,o as c,e as i,y as a,u as s,q as e,z as h}from"./runtime-core.esm-bundler.22ec0346.js";const d={class:"markdown-body"},p=s("hr",null,null,-1),u=s("h2",{id:"the-relation-object",tabindex:"-1"},[s("a",{class:"header-anchor",href:"#the-relation-object"},"#"),e(" The Relation Object")],-1),_=s("p",null,[s("code",null,"collection"),e(),s("strong",null,"string"),s("br"),e(" Name of the collection. This matches the table name in the database.")],-1),j=s("p",null,[s("code",null,"field"),e(),s("strong",null,"string"),s("br"),e(" Name of the field that holds the related primary key. This matches the column name in the database.")],-1),g=s("p",null,[s("code",null,"related_collection"),e(),s("strong",null,"string"),s("br"),e(" Name of the related collection. This matches the table name in the database.")],-1),m=s("h4",{id:"meta",tabindex:"-1"},[s("a",{class:"header-anchor",href:"#meta"},"#"),e(" Meta")],-1),f=s("p",null,"Directus metadata. Used to enable non-database relationship types",-1),b=s("p",null,[s("code",null,"id"),e(),s("strong",null,"integer"),s("br"),e(" Primary key of the metadata row in "),s("code",null,"directus_relations"),e(".")],-1),y=s("p",null,[s("code",null,"many_collection"),e(),s("strong",null,"string"),s("br"),e(" Name of the collection. Matches the top level "),s("code",null,"collection"),e(" field.")],-1),x=s("p",null,[s("code",null,"many_field"),e(),s("strong",null,"string"),s("br"),e(" Name of the field. Matches the top level "),s("code",null,"field"),e(" field.")],-1),q=s("p",null,[s("code",null,"one_collection"),e(),s("strong",null,"string"),s("br"),e(" Name of the related collection. Matches the top level "),s("code",null,"related_collection"),e(" field.")],-1),T=s("p",null,[s("code",null,"one_field"),e(),s("strong",null,"string"),s("br"),e(" Name of the one to many field on the other side of the relation.")],-1),w=s("p",null,[s("code",null,"one_allowed_collections"),e(),s("strong",null,"string"),s("br"),e(" What collections are allowed to be used in a many-to-any context.")],-1),k=s("p",null,[s("code",null,"one_collection_field"),e(),s("strong",null,"string"),s("br"),e(" Field that holds the collection name in a many-to-any context.")],-1),E=s("p",null,[s("code",null,"one_deselect_action"),e(),s("strong",null,"nullify | delete"),s("br"),e(" Whether to nullify or delete related one-to-many records.")],-1),R=s("p",null,[s("code",null,"sort_field"),e(),s("strong",null,"string"),s("br"),e(" What field is used to hold the sort field.")],-1),P=s("p",null,[s("code",null,"junction_field"),e(),s("strong",null,"string"),s("br"),e(" What field connects two relations in a many-to-many (O2M-M2O) context.")],-1),S=s("h4",{id:"schema",tabindex:"-1"},[s("a",{class:"header-anchor",href:"#schema"},"#"),e(" Schema")],-1),v=s("p",null,"\u201CRaw\u201D database information. Based on the database vendor used, different information might be returned. The following are available for all drivers.",-1),L=s("p",null,[s("code",null,"table"),e(),s("strong",null,"string"),s("br"),e(" The table name.")],-1),A=s("p",null,[s("code",null,"column"),e(),s("strong",null,"string"),s("br"),e(" The column name.")],-1),Q=s("p",null,[s("code",null,"foreign_key_table"),e(),s("strong",null,"string"),s("br"),e(" Related table name.")],-1),D=s("p",null,[s("code",null,"foreign_key_column"),e(),s("strong",null,"string"),s("br"),e(" Related column name.")],-1),N=s("p",null,[s("code",null,"constraint_name"),e(),s("strong",null,"string"),s("br"),e(" Name for the foreign key constraint.")],-1),G=s("p",null,[s("code",null,"on_update"),e(),s("strong",null,"string"),s("br"),e(" Update trigger for the foreign key constraint.")],-1),O=s("p",null,[s("code",null,"on_delete"),e(),s("strong",null,"string"),s("br"),e(" Delete trigger for the foreign key constraint.")],-1),I=s("pre",null,[s("code",{class:"language-json"},[s("span",{class:"hljs-punctuation"},"{"),e(`
	`),s("span",{class:"hljs-attr"},'"collection"'),s("span",{class:"hljs-punctuation"},":"),e(),s("span",{class:"hljs-string"},'"about_us"'),s("span",{class:"hljs-punctuation"},","),e(`
	`),s("span",{class:"hljs-attr"},'"field"'),s("span",{class:"hljs-punctuation"},":"),e(),s("span",{class:"hljs-string"},'"logo"'),s("span",{class:"hljs-punctuation"},","),e(`
	`),s("span",{class:"hljs-attr"},'"related_collection"'),s("span",{class:"hljs-punctuation"},":"),e(),s("span",{class:"hljs-string"},'"directus_files"'),s("span",{class:"hljs-punctuation"},","),e(`
	`),s("span",{class:"hljs-attr"},'"schema"'),s("span",{class:"hljs-punctuation"},":"),e(),s("span",{class:"hljs-punctuation"},"{"),e(`
		`),s("span",{class:"hljs-attr"},'"table"'),s("span",{class:"hljs-punctuation"},":"),e(),s("span",{class:"hljs-string"},'"about_us"'),s("span",{class:"hljs-punctuation"},","),e(`
		`),s("span",{class:"hljs-attr"},'"column"'),s("span",{class:"hljs-punctuation"},":"),e(),s("span",{class:"hljs-string"},'"logo"'),s("span",{class:"hljs-punctuation"},","),e(`
		`),s("span",{class:"hljs-attr"},'"foreign_key_table"'),s("span",{class:"hljs-punctuation"},":"),e(),s("span",{class:"hljs-string"},'"directus_files"'),s("span",{class:"hljs-punctuation"},","),e(`
		`),s("span",{class:"hljs-attr"},'"foreign_key_column"'),s("span",{class:"hljs-punctuation"},":"),e(),s("span",{class:"hljs-string"},'"id"'),s("span",{class:"hljs-punctuation"},","),e(`
		`),s("span",{class:"hljs-attr"},'"constraint_name"'),s("span",{class:"hljs-punctuation"},":"),e(),s("span",{class:"hljs-string"},'"about_us_logo_foreign"'),s("span",{class:"hljs-punctuation"},","),e(`
		`),s("span",{class:"hljs-attr"},'"on_update"'),s("span",{class:"hljs-punctuation"},":"),e(),s("span",{class:"hljs-string"},'"NO ACTION"'),s("span",{class:"hljs-punctuation"},","),e(`
		`),s("span",{class:"hljs-attr"},'"on_delete"'),s("span",{class:"hljs-punctuation"},":"),e(),s("span",{class:"hljs-string"},'"SET NULL"'),e(`
	`),s("span",{class:"hljs-punctuation"},"}"),s("span",{class:"hljs-punctuation"},","),e(`
	`),s("span",{class:"hljs-attr"},'"meta"'),s("span",{class:"hljs-punctuation"},":"),e(),s("span",{class:"hljs-punctuation"},"{"),e(`
		`),s("span",{class:"hljs-attr"},'"id"'),s("span",{class:"hljs-punctuation"},":"),e(),s("span",{class:"hljs-number"},"1"),s("span",{class:"hljs-punctuation"},","),e(`
		`),s("span",{class:"hljs-attr"},'"junction_field"'),s("span",{class:"hljs-punctuation"},":"),e(),s("span",{class:"hljs-literal"},[s("span",{class:"hljs-keyword"},"null")]),s("span",{class:"hljs-punctuation"},","),e(`
		`),s("span",{class:"hljs-attr"},'"many_collection"'),s("span",{class:"hljs-punctuation"},":"),e(),s("span",{class:"hljs-string"},'"about_us"'),s("span",{class:"hljs-punctuation"},","),e(`
		`),s("span",{class:"hljs-attr"},'"many_field"'),s("span",{class:"hljs-punctuation"},":"),e(),s("span",{class:"hljs-string"},'"logo"'),s("span",{class:"hljs-punctuation"},","),e(`
		`),s("span",{class:"hljs-attr"},'"one_allowed_collections"'),s("span",{class:"hljs-punctuation"},":"),e(),s("span",{class:"hljs-literal"},[s("span",{class:"hljs-keyword"},"null")]),s("span",{class:"hljs-punctuation"},","),e(`
		`),s("span",{class:"hljs-attr"},'"one_collection"'),s("span",{class:"hljs-punctuation"},":"),e(),s("span",{class:"hljs-string"},'"directus_files"'),s("span",{class:"hljs-punctuation"},","),e(`
		`),s("span",{class:"hljs-attr"},'"one_collection_field"'),s("span",{class:"hljs-punctuation"},":"),e(),s("span",{class:"hljs-literal"},[s("span",{class:"hljs-keyword"},"null")]),s("span",{class:"hljs-punctuation"},","),e(`
		`),s("span",{class:"hljs-attr"},'"one_deselect_action"'),s("span",{class:"hljs-punctuation"},":"),e(),s("span",{class:"hljs-string"},'"nullify"'),s("span",{class:"hljs-punctuation"},","),e(`
		`),s("span",{class:"hljs-attr"},'"one_field"'),s("span",{class:"hljs-punctuation"},":"),e(),s("span",{class:"hljs-literal"},[s("span",{class:"hljs-keyword"},"null")]),s("span",{class:"hljs-punctuation"},","),e(`
		`),s("span",{class:"hljs-attr"},'"sort_field"'),s("span",{class:"hljs-punctuation"},":"),e(),s("span",{class:"hljs-literal"},[s("span",{class:"hljs-keyword"},"null")]),e(`
	`),s("span",{class:"hljs-punctuation"},"}"),e(`
`),s("span",{class:"hljs-punctuation"},"}"),e(`
`)])],-1),C=s("hr",null,null,-1),M=s("h2",{id:"list-relations",tabindex:"-1"},[s("a",{class:"header-anchor",href:"#list-relations"},"#"),e(" List relations")],-1),B=s("p",null,"List all relations that exist in Directus.",-1),U=s("div",{class:"tip hint"},[s("div",{class:"hint-title"},"Permissions"),s("p",null,"The data returned in this endpoint will be filtered based on the user\u2019s permissions. For example, relations that apply to a collection that the current user doesn\u2019t have access to are stripped out.")],-1),W=s("h3",{id:"query-parameters",tabindex:"-1"},[s("a",{class:"header-anchor",href:"#query-parameters"},"#"),e(" Query Parameters")],-1),F=s("p",null,"Doesn\u2019t support any query parameters.",-1),V=s("h3",{id:"returns",tabindex:"-1"},[s("a",{class:"header-anchor",href:"#returns"},"#"),e(" Returns")],-1),H=s("p",null,[e("Array of "),s("a",{href:"#the-relation-object"},"relation objects"),e(". If no items are available, data will be an empty array.")],-1),z=s("h3",{id:"rest-api",tabindex:"-1"},[s("a",{class:"header-anchor",href:"#rest-api"},"#"),e(" REST API")],-1),J=s("pre",null,[s("code",null,`GET /relations
`)],-1),K=s("h3",{id:"graphql",tabindex:"-1"},[s("a",{class:"header-anchor",href:"#graphql"},"#"),e(" GraphQL")],-1),X=s("pre",null,[s("code",null,`POST /graphql/system
`)],-1),Y=s("pre",null,[s("code",{class:"language-graphql"},[s("span",{class:"hljs-keyword"},"type"),s("span",{class:"hljs-type"}," Query"),e(` {
	relations: [directus_relations]
}
`)])],-1),Z=s("h5",{id:"example",tabindex:"-1"},[s("a",{class:"header-anchor",href:"#example"},"#"),e(" Example")],-1),$=s("pre",null,[s("code",{class:"language-graphql"},[s("span",{class:"hljs-keyword"},"query"),e(` {
	relations {
		collection
		field
	}
}
`)])],-1),ss=s("hr",null,null,-1),es=s("h2",{id:"list-relations-in-collection",tabindex:"-1"},[s("a",{class:"header-anchor",href:"#list-relations-in-collection"},"#"),e(" List relations in collection")],-1),ts=s("p",null,"List all relations that exist in a given collection.",-1),ns=s("div",{class:"tip hint"},[s("div",{class:"hint-title"},"Permissions"),s("p",null,"The data returned in this endpoint will be filtered based on the user\u2019s permissions. For example, relations that apply to a collection that the current user doesn\u2019t have access to are stripped out.")],-1),as=s("h3",{id:"query-parameters-1",tabindex:"-1"},[s("a",{class:"header-anchor",href:"#query-parameters-1"},"#"),e(" Query Parameters")],-1),ls=s("p",null,"Doesn\u2019t support any query parameters.",-1),os=s("h3",{id:"returns-1",tabindex:"-1"},[s("a",{class:"header-anchor",href:"#returns-1"},"#"),e(" Returns")],-1),rs=s("p",null,[e("Array of "),s("a",{href:"#the-relation-object"},"relation objects"),e(". If no items are available, data will be an empty array.")],-1),cs=s("h3",{id:"rest-api-1",tabindex:"-1"},[s("a",{class:"header-anchor",href:"#rest-api-1"},"#"),e(" REST API")],-1),is=s("pre",null,[s("code",null,`GET /relations/:collection
`)],-1),hs=s("h5",{id:"example-1",tabindex:"-1"},[s("a",{class:"header-anchor",href:"#example-1"},"#"),e(" Example")],-1),ds=s("pre",null,[s("code",null,`GET /relations/articles
`)],-1),ps=s("h3",{id:"graphql-1",tabindex:"-1"},[s("a",{class:"header-anchor",href:"#graphql-1"},"#"),e(" GraphQL")],-1),us=s("pre",null,[s("code",null,`POST /graphql/system
`)],-1),_s=s("pre",null,[s("code",{class:"language-graphql"},[s("span",{class:"hljs-keyword"},"type"),s("span",{class:"hljs-type"}," Query"),e(` {
	relations_in_collection(collection:`),s("span",{class:"hljs-type"}," String"),e(`!): [directus_relations]
}
`)])],-1),js=s("h5",{id:"example-2",tabindex:"-1"},[s("a",{class:"header-anchor",href:"#example-2"},"#"),e(" Example")],-1),gs=s("pre",null,[s("code",{class:"language-graphql"},[s("span",{class:"hljs-keyword"},"query"),e(` {
	relations_in_collection(collection: `),s("span",{class:"hljs-string"},'"articles"'),e(`) {
		collection
		field
	}
}
`)])],-1),ms=s("hr",null,null,-1),fs=s("h2",{id:"retrieve-a-relation",tabindex:"-1"},[s("a",{class:"header-anchor",href:"#retrieve-a-relation"},"#"),e(" Retrieve a relation")],-1),bs=s("p",null,"List an existing relation by collection/field name.",-1),ys=s("h3",{id:"query-parameters-2",tabindex:"-1"},[s("a",{class:"header-anchor",href:"#query-parameters-2"},"#"),e(" Query Parameters")],-1),xs=s("p",null,"Doesn\u2019t support any query parameters.",-1),qs=s("h3",{id:"returns-2",tabindex:"-1"},[s("a",{class:"header-anchor",href:"#returns-2"},"#"),e(" Returns")],-1),Ts=s("p",null,[e("Returns the requested "),s("a",{href:"#the-relation-object"},"relation object"),e(".")],-1),ws=s("h3",{id:"rest-api-2",tabindex:"-1"},[s("a",{class:"header-anchor",href:"#rest-api-2"},"#"),e(" REST API")],-1),ks=s("pre",null,[s("code",null,`GET /relations/:collection/:field
`)],-1),Es=s("h5",{id:"example-3",tabindex:"-1"},[s("a",{class:"header-anchor",href:"#example-3"},"#"),e(" Example")],-1),Rs=s("pre",null,[s("code",null,`GET /relations/articles/featured_image
`)],-1),Ps=s("h3",{id:"graphql-2",tabindex:"-1"},[s("a",{class:"header-anchor",href:"#graphql-2"},"#"),e(" GraphQL")],-1),Ss=s("pre",null,[s("code",null,`POST /graphql/system
`)],-1),vs=s("pre",null,[s("code",{class:"language-graphql"},[s("span",{class:"hljs-keyword"},"type"),s("span",{class:"hljs-type"}," Query"),e(` {
	relations_by_name(collection:`),s("span",{class:"hljs-type"}," String"),e("!, field:"),s("span",{class:"hljs-type"}," String"),e(`!): directus_relations
}
`)])],-1),Ls=s("h5",{id:"example-4",tabindex:"-1"},[s("a",{class:"header-anchor",href:"#example-4"},"#"),e(" Example")],-1),As=s("pre",null,[s("code",{class:"language-graphql"},[s("span",{class:"hljs-keyword"},"query"),e(` {
	relations_by_name(collection: `),s("span",{class:"hljs-string"},'"articles"'),e(", field: "),s("span",{class:"hljs-string"},'"featured_image"'),e(`) {
		collection
		field
		related_collection
	}
}
`)])],-1),Qs=s("hr",null,null,-1),Ds=s("h2",{id:"create-a-relation",tabindex:"-1"},[s("a",{class:"header-anchor",href:"#create-a-relation"},"#"),e(" Create a Relation")],-1),Ns=s("p",null,"Create a new relation.",-1),Gs=s("h3",{id:"query-parameters-3",tabindex:"-1"},[s("a",{class:"header-anchor",href:"#query-parameters-3"},"#"),e(" Query Parameters")],-1),Os=s("p",null,"Doesn\u2019t support any query parameters.",-1),Is=s("h3",{id:"request-body",tabindex:"-1"},[s("a",{class:"header-anchor",href:"#request-body"},"#"),e(" Request Body")],-1),Cs=s("p",null,[e("A partial "),s("a",{href:"#the-relation-object"},"relation object"),e(".")],-1),Ms=s("h3",{id:"returns-3",tabindex:"-1"},[s("a",{class:"header-anchor",href:"#returns-3"},"#"),e(" Returns")],-1),Bs=s("p",null,[e("Returns the "),s("a",{href:"#the-relation-object"},"relation object"),e(" for the created relation.")],-1),Us=s("h3",{id:"rest-api-3",tabindex:"-1"},[s("a",{class:"header-anchor",href:"#rest-api-3"},"#"),e(" REST API")],-1),Ws=s("pre",null,[s("code",null,`POST /relations
`)],-1),Fs=s("h5",{id:"example-5",tabindex:"-1"},[s("a",{class:"header-anchor",href:"#example-5"},"#"),e(" Example")],-1),Vs=s("pre",null,[s("code",{class:"language-json"},[s("span",{class:"hljs-comment"},"// POST /relations"),e(`

`),s("span",{class:"hljs-punctuation"},"{"),e(`
	`),s("span",{class:"hljs-attr"},'"collection"'),s("span",{class:"hljs-punctuation"},":"),e(),s("span",{class:"hljs-string"},'"articles"'),s("span",{class:"hljs-punctuation"},","),e(`
	`),s("span",{class:"hljs-attr"},'"field"'),s("span",{class:"hljs-punctuation"},":"),e(),s("span",{class:"hljs-string"},'"featured_image"'),s("span",{class:"hljs-punctuation"},","),e(`
	`),s("span",{class:"hljs-attr"},'"related_collection"'),s("span",{class:"hljs-punctuation"},":"),e(),s("span",{class:"hljs-string"},'"directus_files"'),e(`
`),s("span",{class:"hljs-punctuation"},"}"),e(`
`)])],-1),Hs=s("h3",{id:"graphql-3",tabindex:"-1"},[s("a",{class:"header-anchor",href:"#graphql-3"},"#"),e(" GraphQL")],-1),zs=s("pre",null,[s("code",null,`POST /graphql/system
`)],-1),Js=s("pre",null,[s("code",{class:"language-graphql"},[s("span",{class:"hljs-keyword"},"type"),s("span",{class:"hljs-type"}," Mutation"),e(` {
	create_relations_item(data: create_directus_relations_input!): directus_relations
}
`)])],-1),Ks=s("h5",{id:"example-6",tabindex:"-1"},[s("a",{class:"header-anchor",href:"#example-6"},"#"),e(" Example")],-1),Xs=s("pre",null,[s("code",{class:"language-graphql"},[s("span",{class:"hljs-keyword"},"mutation"),e(` {
	create_relations_item(
		data: { collection: `),s("span",{class:"hljs-string"},'"articles"'),e(", field: "),s("span",{class:"hljs-string"},'"featured_image"'),e(", related_collection: "),s("span",{class:"hljs-string"},'"directus_files"'),e(` }
	) {
		collection
		field
		related_collection
	}
}
`)])],-1),Ys=s("hr",null,null,-1),Zs=s("h2",{id:"update-a-relation",tabindex:"-1"},[s("a",{class:"header-anchor",href:"#update-a-relation"},"#"),e(" Update a Relation")],-1),$s=s("p",null,"Update an existing relation.",-1),se=s("h3",{id:"query-parameters-4",tabindex:"-1"},[s("a",{class:"header-anchor",href:"#query-parameters-4"},"#"),e(" Query Parameters")],-1),ee=s("p",null,"Doesn\u2019t support any query parameters.",-1),te=s("h3",{id:"request-body-1",tabindex:"-1"},[s("a",{class:"header-anchor",href:"#request-body-1"},"#"),e(" Request Body")],-1),ne=s("p",null,[e("A partial "),s("a",{href:"#the-relation-object"},"relation object"),e(".")],-1),ae=s("h3",{id:"returns-4",tabindex:"-1"},[s("a",{class:"header-anchor",href:"#returns-4"},"#"),e(" Returns")],-1),le=s("p",null,[e("Returns the "),s("a",{href:"#the-relation-object"},"relation object"),e(" for the created relation.")],-1),oe=s("h3",{id:"rest-api-4",tabindex:"-1"},[s("a",{class:"header-anchor",href:"#rest-api-4"},"#"),e(" REST API")],-1),re=s("pre",null,[s("code",null,`PATCH /relations/:collection/:field
`)],-1),ce=s("h5",{id:"example-7",tabindex:"-1"},[s("a",{class:"header-anchor",href:"#example-7"},"#"),e(" Example")],-1),ie=s("pre",null,[s("code",{class:"language-json"},[s("span",{class:"hljs-comment"},"// PATCH /relations/articles/author"),e(`

`),s("span",{class:"hljs-punctuation"},"{"),e(`
	`),s("span",{class:"hljs-attr"},'"meta"'),s("span",{class:"hljs-punctuation"},":"),e(),s("span",{class:"hljs-punctuation"},"{"),e(`
		`),s("span",{class:"hljs-attr"},'"one_field"'),s("span",{class:"hljs-punctuation"},":"),e(),s("span",{class:"hljs-string"},'"articles"'),e(`
	`),s("span",{class:"hljs-punctuation"},"}"),e(`
`),s("span",{class:"hljs-punctuation"},"}"),e(`
`)])],-1),he=s("h3",{id:"graphql-4",tabindex:"-1"},[s("a",{class:"header-anchor",href:"#graphql-4"},"#"),e(" GraphQL")],-1),de=s("pre",null,[s("code",null,`POST /graphql/system
`)],-1),pe=s("pre",null,[s("code",{class:"language-graphql"},[s("span",{class:"hljs-keyword"},"type"),s("span",{class:"hljs-type"}," Mutation"),e(` {
	update_relations_item(collection:`),s("span",{class:"hljs-type"}," String"),e("!, field:"),s("span",{class:"hljs-type"}," String"),e(`!, data: update_directus_relations_input!): directus_relations
}
`)])],-1),ue=s("h5",{id:"example-8",tabindex:"-1"},[s("a",{class:"header-anchor",href:"#example-8"},"#"),e(" Example")],-1),_e=s("pre",null,[s("code",{class:"language-graphql"},[s("span",{class:"hljs-keyword"},"mutation"),e(` {
	update_relations_item(collection: `),s("span",{class:"hljs-string"},'"articles"'),e(", field: "),s("span",{class:"hljs-string"},'"author"'),e(", data: { meta: { one_field: "),s("span",{class:"hljs-string"},'"articles"'),e(` } }) {
		collection
		field
		related_collection
	}
}
`)])],-1),je=s("hr",null,null,-1),ge=s("h2",{id:"delete-a-relation",tabindex:"-1"},[s("a",{class:"header-anchor",href:"#delete-a-relation"},"#"),e(" Delete a Relation")],-1),me=s("p",null,"Delete an existing relation.",-1),fe=s("h3",{id:"returns-5",tabindex:"-1"},[s("a",{class:"header-anchor",href:"#returns-5"},"#"),e(" Returns")],-1),be=s("p",null,"Empty body.",-1),ye=s("h3",{id:"rest-api-5",tabindex:"-1"},[s("a",{class:"header-anchor",href:"#rest-api-5"},"#"),e(" REST API")],-1),xe=s("pre",null,[s("code",null,`DELETE /relations/:collection/:field
`)],-1),qe=s("h5",{id:"example-9",tabindex:"-1"},[s("a",{class:"header-anchor",href:"#example-9"},"#"),e(" Example")],-1),Te=s("pre",null,[s("code",null,`DELETE /relations/articles/author
`)],-1),we=s("h3",{id:"graphql-5",tabindex:"-1"},[s("a",{class:"header-anchor",href:"#graphql-5"},"#"),e(" GraphQL")],-1),ke=s("pre",null,[s("code",null,`POST /graphql/system
`)],-1),Ee=s("pre",null,[s("code",{class:"language-graphql"},[s("span",{class:"hljs-keyword"},"type"),s("span",{class:"hljs-type"}," Mutation"),e(` {
	delete_relations_item(collection:`),s("span",{class:"hljs-type"}," String"),e("!, field:"),s("span",{class:"hljs-type"}," String"),e(`!): delete_one
}
`)])],-1),Re=s("h5",{id:"example-10",tabindex:"-1"},[s("a",{class:"header-anchor",href:"#example-10"},"#"),e(" Example")],-1),Pe=s("pre",null,[s("code",{class:"language-graphql"},[s("span",{class:"hljs-keyword"},"mutation"),e(` {
	delete_relations_item(collection: `),s("span",{class:"hljs-string"},'"articles"'),e(", field: "),s("span",{class:"hljs-string"},'"author"'),e(`) {
		collection
		field
	}
}
`)])],-1),Qe="Relations",De=!1,Ne="REST and GraphQL API documentation on the Relations collection in Directus.",Ge="5 min read",Oe="page-reference",Ie={__name:"relations",setup(Se,{expose:l}){const t={title:"Relations",modularExtension:!1,description:"REST and GraphQL API documentation on the Relations collection in Directus.",readTime:"5 min read",pageClass:"page-reference"};return l({frontmatter:t}),(ve,Le)=>{const o=n("router-link"),r=n("docs-wrapper");return c(),i(r,{frontmatter:t},{default:a(()=>[s("div",d,[s("blockquote",null,[s("p",null,[e("What data is linked to what other data. Allows you to assign authors to articles, products to sales, and whatever other structures you can think of. "),h(o,{to:"/docs/getting-started/glossary#relationships"},{default:a(()=>[e("Learn more about Relationships")]),_:1}),e(".")])]),p,u,_,j,g,m,f,b,y,x,q,T,w,k,E,R,P,S,v,L,A,Q,D,N,G,O,I,C,M,B,U,W,F,V,H,z,J,K,X,Y,Z,$,ss,es,ts,ns,as,ls,os,rs,cs,is,hs,ds,ps,us,_s,js,gs,ms,fs,bs,ys,xs,qs,Ts,ws,ks,Es,Rs,Ps,Ss,vs,Ls,As,Qs,Ds,Ns,Gs,Os,Is,Cs,Ms,Bs,Us,Ws,Fs,Vs,Hs,zs,Js,Ks,Xs,Ys,Zs,$s,se,ee,te,ne,ae,le,oe,re,ce,ie,he,de,pe,ue,_e,je,ge,me,fe,be,ye,xe,qe,Te,we,ke,Ee,Re,Pe])]),_:1})}}};export{Ie as default,Ne as description,De as modularExtension,Oe as pageClass,Ge as readTime,Qe as title};
