import{a as i,o as c,e as d,y as s,u as t,q as e,z as n}from"./runtime-core.esm-bundler.22ec0346.js";const u={class:"markdown-body"},h=t("blockquote",null,[t("p",null,"If you\u2019re looking for the fastest way to get up-and-running with Directus, this guide will walk you through getting things installed, configured, and modeled.")],-1),p=t("h2",{id:"1.-installation",tabindex:"-1"},[t("a",{class:"header-anchor",href:"#1.-installation"},"#"),e(" 1. Installation")],-1),_=t("p",null,[e("Make sure you have the latest LTS version or newer of "),t("a",{href:"https://nodejs.dev",target:"_blank",rel:"noopener noreferrer"},"Node.js"),e(" installed, and have a running database ready to connect to.")],-1),g=t("p",null,"Run the following command in your terminal and follow the prompts.",-1),m=t("pre",null,[t("code",{class:"language-bash"},`npm init directus-project example-project
`)],-1),f=t("p",null,"Choose SQLite from the list. Use up/down arrow keys to select the SQL type.",-1),b=t("pre",null,[t("code",{class:"language-bash"},`? Choose your database client SQLite
`)],-1),y=t("p",null,[e("After that a file path for "),t("code",null,"data.db"),e(", your database, will be suggested. Hit the enter key to stick with the default path.")],-1),w=t("pre",null,[t("code",{class:"language-bash"},`? Database File Path: <file-path>/example-project/data.db
`)],-1),v=t("p",null,"Next you\u2019ll set your username/email and password.",-1),k=t("pre",null,[t("code",{class:"language-bash"},`Create your first admin user:
? Email: admin@example.com
? Password: ********
`)],-1),j=t("p",null,"After that, you\u2019re all set!",-1),x=t("pre",null,[t("code",null,`Your project has been created at <file-path>/example-project.

The configuration can be found in <file-path>/example-project/.env
`)],-1),I=t("p",null,[e("Once the installation is complete, you can start Directus by navigating to your project folder "),t("em",null,[e("(in this case "),t("code",null,"example-project"),e(")")]),e(" and running:")],-1),P=t("pre",null,[t("code",{class:"language-bash"},`npx directus start
`)],-1),C=t("p",null,"After that, you will see this message:",-1),D=t("pre",null,[t("code",{class:"language-bash"},`\u2728 Server started at http://localhost:8055
`)],-1),A=t("h4",{id:"other-options",tabindex:"-1"},[t("a",{class:"header-anchor",href:"#other-options"},"#"),e(" Other Options")],-1),S=t("p",null,"When you link other types of SQL to Directus, you may have additional prompts:",-1),T=t("ul",null,[t("li",null,[t("strong",null,"Database Host"),e(" \u2013 IP address for your database.")]),t("li",null,[t("strong",null,"Port"),e(" \u2013 Port number your database is running on.")]),t("li",null,[t("strong",null,"Database Name"),e(" \u2013 Name of your existing database.")]),t("li",null,[t("strong",null,"Database User"),e(" \u2013 Name of existing user in database.")]),t("li",null,[t("strong",null,"Database Password"),e(" \u2013 Password to enter database.")]),t("li",null,[t("strong",null,"Enable SSL"),e(" \u2013 Select "),t("code",null,"Y"),e(" for yes or "),t("code",null,"N"),e(" for no.")]),t("li",null,[t("strong",null,"Root"),e(" \u2013 Provide the root name.")])],-1),N=t("p",null,"Simply configure these according to your project\u2019s needs.",-1),q=t("div",{class:"warning hint"},[t("div",{class:"hint-title"},"Directus seeds your database"),t("p",null,"Directus installs a few dozen tables into the database it is linked to. However, this will not alter the pre-existing data tables.")],-1),F=t("h2",{id:"2.-login-to-app",tabindex:"-1"},[t("a",{class:"header-anchor",href:"#2.-login-to-app"},"#"),e(" 2. Login to App")],-1),R=t("p",null,"With the server running, you\u2019re now able to login to your new Directus project and start using it.",-1),L=t("p",null,[e("Our start command stated that the server started at port "),t("code",null,"8055"),e(", which means we can navigate to "),t("code",null,"http://localhost:8055"),e(" to open Directus in the browser.")],-1),E=t("p",null,"Login using the admin credentials you configured during the installation in Step 1.",-1),M=t("h2",{id:"3.-create-a-collection",tabindex:"-1"},[t("a",{class:"header-anchor",href:"#3.-create-a-collection"},"#"),e(" 3. Create a Collection")],-1),O=t("p",null,"Once logged in, you\u2019re greeted with the option to create your first Collection:",-1),Q=t("p",null,[t("img",{src:"https://cdn.directus.io/docs/v9/getting-started/quickstart/quickstart-20220217A/empty-state-20220217A.webp",alt:"Directus Empty State"})],-1),W=t("p",null,[e("Follow the prompts and create a Collection. For the sake of this demo, we\u2019ll be calling ours "),t("code",null,"articles"),e(", but feel free to make it your own!")],-1),B={class:"tip hint"},H=t("div",{class:"hint-title"},"More Info on Collections",-1),z=t("h2",{id:"4.-create-a-field",tabindex:"-1"},[t("a",{class:"header-anchor",href:"#4.-create-a-field"},"#"),e(" 4. Create a Field")],-1),G=t("p",null,[e("With the Collection created, it\u2019s time to start adding some Fields. Click the "),t("strong",null,"\u201CCreate Field\u201D"),e(" button, and select "),t("strong",null,"\u201CInput\u201D"),e(":")],-1),U=t("video",{autoplay:"",playsinline:"",muted:"",loop:"",controls:""},[t("source",{src:"https://cdn.directus.io/docs/v9/getting-started/quickstart/quickstart-20220217A/add-field-20220217A.mp4",type:"video/mp4"})],-1),V=t("p",null,[e("We\u2019ll be calling our Field "),t("code",null,"title"),e(". While Directus offers a range of powerful field customization options, we\u2019ll be sticking to the defaults for now. These defaults use the \u201CString\u201D datatype.")],-1),Y={class:"tip hint"},J=t("div",{class:"hint-title"},"More Info on Fields",-1),K=t("h2",{id:"5.-create-an-item",tabindex:"-1"},[t("a",{class:"header-anchor",href:"#5.-create-an-item"},"#"),e(" 5. Create an Item")],-1),X=t("p",null,[e("Now that we have a Collection with a Field configured, it\u2019s time to start adding some content. Navigate to the Content Module (top left), and click "),t("span",{mi:"",btn:""},"add"),e(" in the top-right to get started. This will take you to the Create/Edit Item page:")],-1),Z=t("p",null,[t("img",{src:"https://cdn.directus.io/docs/v9/getting-started/quickstart/quickstart-20220217A/create-item-20220217A.webp",alt:"Directus Create Item"})],-1),$=t("p",null,[e("Once you\u2019re happy with your creation, click "),t("span",{mi:"",btn:""},"check"),e(" in the top-right to save your Item to the database.")],-1),tt={class:"tip hint"},et=t("div",{class:"hint-title"},"More Info on Items",-1),st=t("h2",{id:"6.-set-role%2Fpublic-permissions",tabindex:"-1"},[t("a",{class:"header-anchor",href:"#6.-set-role%2Fpublic-permissions"},"#"),e(" 6. Set Role/Public Permissions")],-1),ot=t("p",null,[e("By default, all content entered into Directus is considered private. This means that no data will be returned by the API, unless requested by an authenticated user that has the correct permissions. In order to have the API return our items, we\u2019ll have to setup some permissions. Navigate to "),t("strong",null,[e("Settings Module "),t("span",{mi:"",icon:"",dark:""},"chevron_right"),e(" Roles & Permissions")]),e(".")],-1),nt=t("p",null,[e("Directus ships with a special "),t("strong",null,"\u201CPublic\u201D"),e(" role that controls what data is returned to non-authenticated users. Select the Public Role, find your Collection, and click the icon under the "),t("span",{mi:"",icon:""},"visibility"),e(" icon (read/view permission) to allow the Public Role to read the Items in your Collection.")],-1),at=t("p",null,[t("img",{src:"https://cdn.directus.io/docs/v9/getting-started/quickstart/quickstart-20220217A/permissions-20220217A.webp",alt:"Directus Permissions"})],-1),it={class:"tip hint"},lt=t("div",{class:"hint-title"},"More Info on Roles & Permissions",-1),rt=t("h2",{id:"7.-connect-to-the-api",tabindex:"-1"},[t("a",{class:"header-anchor",href:"#7.-connect-to-the-api"},"#"),e(" 7. Connect to the API")],-1),ct=t("code",null,"/items/",-1),dt=t("p",null,[e("Use your browser or an API tool like "),t("a",{href:"http://postman.com",target:"_blank",rel:"noopener noreferrer"},"Postman"),e(" or "),t("a",{href:"https://paw.cloud",target:"_blank",rel:"noopener noreferrer"},"Paw"),e(" to open "),t("code",null,"http://localhost:8055/items/articles"),e(".")],-1),ut=t("p",null,"And there it is! The Article Item you just created is being served in beautiful JSON, ready to be used anywhere and everywhere!",-1),ht=t("pre",null,[t("code",{class:"language-json"},[t("span",{class:"hljs-punctuation"},"{"),e(`
	`),t("span",{class:"hljs-attr"},'"data"'),t("span",{class:"hljs-punctuation"},":"),e(),t("span",{class:"hljs-punctuation"},"["),e(`
		`),t("span",{class:"hljs-punctuation"},"{"),e(`
			`),t("span",{class:"hljs-attr"},'"id"'),t("span",{class:"hljs-punctuation"},":"),e(),t("span",{class:"hljs-number"},"1"),t("span",{class:"hljs-punctuation"},","),e(`
			`),t("span",{class:"hljs-attr"},'"title"'),t("span",{class:"hljs-punctuation"},":"),e(),t("span",{class:"hljs-string"},'"Hello World!"'),e(`
		`),t("span",{class:"hljs-punctuation"},"}"),e(`
	`),t("span",{class:"hljs-punctuation"},"]"),e(`
`),t("span",{class:"hljs-punctuation"},"}"),e(`
`)])],-1),ft="Quickstart Guide",bt=!1,yt="If you're looking for the fastest way to get up-and-running with Directus, this guide will walk you through getting things installed, configured, and modeled.",wt="5 min read",vt={__name:"quickstart",setup(pt,{expose:l}){const a={title:"Quickstart Guide",modularExtension:!1,description:"If you're looking for the fastest way to get up-and-running with Directus, this guide will walk you through getting things installed, configured, and modeled.",readTime:"5 min read"};return l({frontmatter:a}),(_t,gt)=>{const o=i("router-link"),r=i("docs-wrapper");return c(),d(r,{frontmatter:a},{default:s(()=>[t("div",u,[h,p,_,g,m,f,b,y,w,v,k,j,x,I,P,C,D,A,S,T,N,q,F,R,L,E,M,O,Q,W,t("div",B,[H,t("p",null,[e("To learn more, see our documentation "),n(o,{to:"/docs/app/content/collections"},{default:s(()=>[e("Collections")]),_:1}),e(".")])]),z,G,U,V,t("div",Y,[J,t("p",null,[e("To learn more, see our documentation on "),n(o,{to:"/docs/getting-started/glossary#fields"},{default:s(()=>[e("Fields")]),_:1}),e(".")])]),K,X,Z,$,t("div",tt,[et,t("p",null,[e("To learn more, see our documentation on "),n(o,{to:"/docs/app/content/items"},{default:s(()=>[e("Items")]),_:1}),e(".")])]),st,ot,nt,at,t("div",it,[lt,t("p",null,[e("Roles & Permissions are extremely powerful and can get pretty in-depth. To learn all about the nuances in setting these up, see "),n(o,{to:"/docs/reference/system/roles"},{default:s(()=>[e("Roles")]),_:1}),e(" & "),n(o,{to:"/docs/reference/system/permissions"},{default:s(()=>[e("Permissions")]),_:1}),e(".")])]),rt,t("p",null,[e("Now that your project has some content in it, it\u2019s time to start using this content externally. Data can be accessed in a number of ways, including the REST API, GraphQL, the CLI, or even straight from the database. In this case, we\u2019ll use "),n(o,{to:"/docs/reference/items"},{default:s(()=>[e("the "),ct,e(" REST API endpoint")]),_:1}),e(" to retrieve the item we just created.")]),dt,ut,ht])]),_:1})}}};export{vt as default,yt as description,bt as modularExtension,wt as readTime,ft as title};
