import{a,o as r,e as d,y as e,u as s,q as t,z as l}from"./runtime-core.esm-bundler.22ec0346.js";const u={class:"markdown-body"},h=s("p",null,[t("On many shared hosts you are not allowed to directly invoke node commands but you have to use the Plesk configuration panel instead. Unfortunately, Plesk does not allow the interactive execution of node scripts. Therefore we can\u2019t use Directus\u2019 "),s("code",null,"init"),t(" script and have to set up the project by our own.")],-1),p=s("div",{class:"tip hint"},[s("div",{class:"hint-title"},"Successful tests"),s("p",null,"This approach has successfully been tested with a webhosting offer from netcup.")],-1),_=s("h2",{id:"installation",tabindex:"-1"},[s("a",{class:"header-anchor",href:"#installation"},"#"),t(" Installation")],-1),f=s("h3",{id:"1.-setup-database",tabindex:"-1"},[s("a",{class:"header-anchor",href:"#1.-setup-database"},"#"),t(" 1. Setup database")],-1),g=s("p",null,"First, make sure that you\u2019ve already created a database and a user for it. We will use MySQL in this guide. If you plan to use SQLite you can ignore this step.",-1),m=s("h3",{id:"2.-setup-a-project-folder",tabindex:"-1"},[s("a",{class:"header-anchor",href:"#2.-setup-a-project-folder"},"#"),t(" 2. Setup a project folder")],-1),y=s("p",null,"Next you will need to create a project folder, we will be adding 4 files to this folder.",-1),j=s("h3",{id:"3.-add-.env-file",tabindex:"-1"},[s("a",{class:"header-anchor",href:"#3.-add-.env-file"},"#"),t(" 3. Add .env file")],-1),b=s("code",null,"init",-1),w=s("p",null,"If you have not already a user in the database make sure to add a first user by adding the following two lines so that you can later login to Directus.",-1),v=s("pre",null,[s("code",null,`ADMIN_EMAIL="admin@example.com"
ADMIN_PASSWORD="password"
`)],-1),k=s("div",{class:"tip hint"},[s("div",{class:"hint-title"},"Choosing a Port"),s("p",null,[t("Since Plesk uses the "),s("a",{href:"https://www.phusionpassenger.com",target:"_blank",rel:"noopener noreferrer"},"Phusion Passenger"),t(" application server to serve Node.js apps you do not need to worry about choosing a specific port. Just use an arbitrary number. To quote the Passenger docs:")]),s("blockquote",null,[s("p",null,"When run in Passenger, the port number that you pass to listen() is irrelevant and has no effect. Passenger always makes the app listen on a random Unix domain socket.")])],-1),x=s("h3",{id:"4.-add-package.json",tabindex:"-1"},[s("a",{class:"header-anchor",href:"#4.-add-package.json"},"#"),t(" 4. Add package.json")],-1),P=s("p",null,[t("Add Directus and your database connector as a dependency. To execute Directus\u2019 "),s("code",null,"bootstrap"),t(" command you also have to add a script entry for it.")],-1),A=s("pre",null,[s("code",{class:"language-json"},[s("span",{class:"hljs-punctuation"},"{"),t(`
	`),s("span",{class:"hljs-attr"},'"scripts"'),s("span",{class:"hljs-punctuation"},":"),t(),s("span",{class:"hljs-punctuation"},"{"),t(`
		`),s("span",{class:"hljs-attr"},'"bootstrap"'),s("span",{class:"hljs-punctuation"},":"),t(),s("span",{class:"hljs-string"},'"directus bootstrap"'),t(`
	`),s("span",{class:"hljs-punctuation"},"}"),s("span",{class:"hljs-punctuation"},","),t(`
	`),s("span",{class:"hljs-attr"},'"dependencies"'),s("span",{class:"hljs-punctuation"},":"),t(),s("span",{class:"hljs-punctuation"},"{"),t(`
		`),s("span",{class:"hljs-attr"},'"directus"'),s("span",{class:"hljs-punctuation"},":"),t(),s("span",{class:"hljs-string"},'"*"'),s("span",{class:"hljs-punctuation"},","),t(`
		`),s("span",{class:"hljs-attr"},'"mysql"'),s("span",{class:"hljs-punctuation"},":"),t(),s("span",{class:"hljs-string"},'"^2.18.1"'),t(`
	`),s("span",{class:"hljs-punctuation"},"}"),t(`
`),s("span",{class:"hljs-punctuation"},"}"),t(`
`)])],-1),D=s("h3",{id:"5.-add-application-startup-file-index.js",tabindex:"-1"},[s("a",{class:"header-anchor",href:"#5.-add-application-startup-file-index.js"},"#"),t(" 5. Add application startup file index.js")],-1),S=s("p",null,[t("Instead of a start command, Plesk wants a startup file. So create a "),s("code",null,"index.js"),t(" with the following content:")],-1),T=s("pre",null,[s("code",{class:"language-js"},[s("span",{class:"hljs-keyword"},"var"),t(" { startServer } = "),s("span",{class:"hljs-built_in"},"require"),t("("),s("span",{class:"hljs-string"},"'directus/server'"),t(`);

`),s("span",{class:"hljs-title function_"},"startServer"),t(`();
`)])],-1),I=s("h3",{id:"6.-add-.npmrc",tabindex:"-1"},[s("a",{class:"header-anchor",href:"#6.-add-.npmrc"},"#"),t(" 6. Add .npmrc")],-1),N=s("p",null,[t("We need to make a small configuration for npm by creating a "),s("code",null,".npmrc"),t(" file with the following content:")],-1),q=s("pre",null,[s("code",null,`scripts-prepend-node-path=true
`)],-1),C=s("h3",{id:"7.-add-document_root-folder",tabindex:"-1"},[s("a",{class:"header-anchor",href:"#7.-add-document_root-folder"},"#"),t(" 7. Add document_root folder")],-1),E=s("p",null,[t("Lastly, we need to add a "),s("code",null,"document_root"),t(" folder inside our project-directory.")],-1),L=s("p",null,"It\u2019s required by Plesk that the document root must be a subdirectory of the application root directory. The folder can stay empty.",-1),M=s("div",{class:"tip hint"},[s("div",{class:"hint-title"},"Store `document_root` in a version control"),s("p",null,[t("To maintain the folder with version control (e.g., git), be sure to create an empty "),s("code",null,".gitignore"),t(" file inside the folder.")])],-1),Y=s("h3",{id:"8.-activate-and-configure-node.js",tabindex:"-1"},[s("a",{class:"header-anchor",href:"#8.-activate-and-configure-node.js"},"#"),t(" 8. Activate and configure node.js")],-1),B=s("p",null,"In Plesk, choose your website and click \u201CNode.js\u201D. You should then see a button \u201CEnable Node.js\u201D and click on it.",-1),H=s("p",null,[t("Now, change the \u201CDocument root\u201D and \u201CApplication root\u201D to the location of your project folder. \u201CApplication startup file\u201D must point to the "),s("code",null,"index.js"),t(" file from the former step. The screen should now look like this:")],-1),V=s("p",null,[s("img",{src:"https://cdn.directus.io/docs/v9/self-hosted/installation/plesk/plesk-screenshot-20220810A.webp",alt:"Plesk Screenshot"})],-1),W=s("p",null,"You can now install the dependencies by clicking on the button \u201CNPM install\u201D.",-1),O=s("h3",{id:"9.-bootstrap-directus",tabindex:"-1"},[s("a",{class:"header-anchor",href:"#9.-bootstrap-directus"},"#"),t(" 9. Bootstrap Directus")],-1),U=s("p",null,[t("To set up the database tables (and the first user) for Directus, click on the button \u201CRun script\u201D and input "),s("code",null,"bootstrap"),t(". You get the console output after the script has run through.")],-1),F=s("div",{class:"tip hint"},[s("div",{class:"hint-title"},"Current Issue of Argon2"),s("p",null,"You may run into an error of argon2 telling you that glibc is missing. If that\u2019s the case try adding and running this script entry to your package.json:"),s("pre",null,[s("code",{class:"language-json"},[t("    "),s("span",{class:"hljs-string"},'"scripts"'),t(),s("span",{class:"hljs-punctuation"},"{"),t(`
        `),s("span",{class:"hljs-attr"},'"argon2-rebuild"'),s("span",{class:"hljs-punctuation"},":"),t(),s("span",{class:"hljs-string"},'"npm rebuild argon2 --build-from-source"'),s("span",{class:"hljs-punctuation"},","),t(`
        <...>
    `),s("span",{class:"hljs-punctuation"},"}"),t(`

`)])]),s("p",null,[t("Afterwards try "),s("code",null,"bootstrap"),t(" again.")])],-1),Q=s("h3",{id:"10.-clean-up-.env-file",tabindex:"-1"},[s("a",{class:"header-anchor",href:"#10.-clean-up-.env-file"},"#"),t(" 10. Clean up .env file")],-1),R=s("p",null,"It is good security practice not to leave emails and passwords stored in plain text, so if you had to create login details through the .env file you should now remove those details from the file.",-1),z=s("h3",{id:"11.-test-directus-access",tabindex:"-1"},[s("a",{class:"header-anchor",href:"#11.-test-directus-access"},"#"),t(" 11. Test Directus Access")],-1),J=s("p",null,"The Directus app should now work under your configured url. If not, try changing the application mode and wait a couple of seconds.",-1),$=s("h2",{id:"using-snapshots",tabindex:"-1"},[s("a",{class:"header-anchor",href:"#using-snapshots"},"#"),t(" Using snapshots")],-1),G=s("code",null,"package.json",-1),K=s("p",null,"To apply a snapshot you need a custom wrapper using the non-interactive version:",-1),X=s("pre",null,[s("code",{class:"language-json"},[t("    "),s("span",{class:"hljs-string"},'"scripts"'),t(),s("span",{class:"hljs-punctuation"},"{"),t(`
    	`),s("span",{class:"hljs-attr"},'"apply-snapshot--noninteractive"'),s("span",{class:"hljs-punctuation"},":"),t(),s("span",{class:"hljs-string"},'"npx directus schema apply --yes ./snapshots/\\"$npm_config_filename\\""'),s("span",{class:"hljs-punctuation"},","),t(`
        <...>
    `),s("span",{class:"hljs-punctuation"},"}"),t(`

`)])],-1),Z=s("p",null,"After that you can apply a snapshot by entering the following command to Plesk:",-1),ss=s("pre",null,[s("code",{class:"language-sh"},`apply-snapshot--noninteractive --filename=[file.yaml]
`)],-1),as="Shared Hosting with Plesk",ls=!1,is="How to host Directus on Plesk",cs="4 min read",rs={__name:"plesk",setup(ts,{expose:i}){const n={title:"Shared Hosting with Plesk",modularExtension:!1,description:"How to host Directus on Plesk",readTime:"4 min read"};return i({frontmatter:n}),(es,ns)=>{const o=a("router-link"),c=a("docs-wrapper");return r(),d(c,{frontmatter:n},{default:e(()=>[s("div",u,[h,p,_,f,g,m,y,j,s("p",null,[t("This file is used to configure Directus. Normally, the "),b,t(" script would create it for us. So now we have to do it manually. You can just copy it from another Directus installation or add the relevant variables using this help page: "),l(o,{to:"/docs/self-hosted/config-options"},{default:e(()=>[t("Environment Variables")]),_:1}),t(").")]),w,v,k,x,P,A,D,S,T,I,N,q,C,E,L,M,Y,B,H,V,W,O,U,F,Q,R,z,J,$,s("p",null,[t("On Plesk you can\u2019t directly run a npx command. To use the Directus snapshot feature, you\u2019d need to add a script to your "),G,t(". For snapshot creation you can find an example in the "),l(o,{to:"/docs/self-hosted/installation/plesk#snapshot-the-data-model"},{default:e(()=>[t("CLI docs: Date-based snapshots")]),_:1})]),K,X,Z,ss])]),_:1})}}};export{rs as default,is as description,ls as modularExtension,cs as readTime,as as title};
