import{a as o,o as r,e as h,y as e,u as s,q as t,z as a}from"./runtime-core.esm-bundler.22ec0346.js";const d={class:"markdown-body"},p=s("blockquote",null,[s("p",null,"Notifications allow you to send/receive messages to/from other users of the platform.")],-1),u=s("hr",null,null,-1),_=s("h2",{id:"the-notification-object",tabindex:"-1"},[s("a",{class:"header-anchor",href:"#the-notification-object"},"#"),t(" The Notification Object")],-1),f=s("p",null,[s("code",null,"id"),t(),s("strong",null,"integer"),s("br"),t(" Primary key of the revision.")],-1),m=s("p",null,[s("code",null,"timestamp"),t(),s("strong",null,"string"),s("br"),t(" Timestamp in ISO8601 when the notification was created.")],-1),j=s("p",null,[s("code",null,"status"),t(),s("strong",null,"string"),s("br"),t(" Current status of the notification. One of \u201Cinbox\u201D, \u201Carchived\u201D.")],-1),g=s("p",null,[s("code",null,"recipient"),t(),s("strong",null,"many-to-one"),s("br"),t(" User that received the notification.")],-1),b=s("p",null,[s("code",null,"sender"),t(),s("strong",null,"many-to-one"),s("br"),t(" User that sent the notification, if any.")],-1),y=s("p",null,[s("code",null,"subject"),t(),s("strong",null,"string"),s("br"),t(" Subject line of the message.")],-1),x=s("p",null,[s("code",null,"message"),t(),s("strong",null,"string"),s("br"),t(" Notification\u2019s message content. Will be sent in the email.")],-1),q=s("p",null,[s("code",null,"collection"),t(),s("strong",null,"string"),s("br"),t(" Collection this notification references.")],-1),E=s("p",null,[s("code",null,"item"),t(),s("strong",null,"string"),s("br"),t(" Primary key of the item this notification references.")],-1),T=s("pre",null,[s("code",{class:"language-json"},[s("span",{class:"hljs-punctuation"},"{"),t(`
	`),s("span",{class:"hljs-attr"},'"id"'),s("span",{class:"hljs-punctuation"},":"),t(),s("span",{class:"hljs-number"},"2"),s("span",{class:"hljs-punctuation"},","),t(`
	`),s("span",{class:"hljs-attr"},'"timestamp"'),s("span",{class:"hljs-punctuation"},":"),t(),s("span",{class:"hljs-string"},'"2021-11-24T13:57:35Z"'),s("span",{class:"hljs-punctuation"},","),t(`
	`),s("span",{class:"hljs-attr"},'"status"'),s("span",{class:"hljs-punctuation"},":"),t(),s("span",{class:"hljs-string"},'"inbox"'),s("span",{class:"hljs-punctuation"},","),t(`
	`),s("span",{class:"hljs-attr"},'"recipient"'),s("span",{class:"hljs-punctuation"},":"),t(),s("span",{class:"hljs-string"},'"3EE34828-B43C-4FB2-A721-5151579B08EA"'),s("span",{class:"hljs-punctuation"},","),t(`
	`),s("span",{class:"hljs-attr"},'"sender"'),s("span",{class:"hljs-punctuation"},":"),t(),s("span",{class:"hljs-string"},'"497a495e-5529-4e46-8feb-2f35e9b85601"'),s("span",{class:"hljs-punctuation"},","),t(`
	`),s("span",{class:"hljs-attr"},'"subject"'),s("span",{class:"hljs-punctuation"},":"),t(),s("span",{class:"hljs-string"},'"You were mentioned in articles"'),s("span",{class:"hljs-punctuation"},","),t(`
	`),s("span",{class:"hljs-attr"},'"message"'),s("span",{class:"hljs-punctuation"},":"),t(),s("span",{class:"hljs-string"},'"\\nHello admin@example.com,\\n\\rijk@directus.io has mentioned you in a comment:\\n\\n> Hello <em>admin@example.com</em>!\\n\\n<a href=\\"http://localhost:8080/admin/content/articles/1\\">Click here to view.</a>\\n"'),s("span",{class:"hljs-punctuation"},","),t(`
	`),s("span",{class:"hljs-attr"},'"collection"'),s("span",{class:"hljs-punctuation"},":"),t(),s("span",{class:"hljs-string"},'"articles"'),s("span",{class:"hljs-punctuation"},","),t(`
	`),s("span",{class:"hljs-attr"},'"item"'),s("span",{class:"hljs-punctuation"},":"),t(),s("span",{class:"hljs-string"},'"1"'),t(`
`),s("span",{class:"hljs-punctuation"},"}"),t(`
`)])],-1),k=s("hr",null,null,-1),P=s("h2",{id:"list-notifications",tabindex:"-1"},[s("a",{class:"header-anchor",href:"#list-notifications"},"#"),t(" List Notifications")],-1),R=s("p",null,"List all notifications that exist in Directus.",-1),S=s("h3",{id:"query-parameters",tabindex:"-1"},[s("a",{class:"header-anchor",href:"#query-parameters"},"#"),t(" Query Parameters")],-1),w=s("h3",{id:"returns",tabindex:"-1"},[s("a",{class:"header-anchor",href:"#returns"},"#"),t(" Returns")],-1),A=s("a",{href:"#the-notification-object"},"notification objects",-1),C=s("h3",{id:"rest-api",tabindex:"-1"},[s("a",{class:"header-anchor",href:"#rest-api"},"#"),t(" REST API")],-1),L=s("pre",null,[s("code",null,`GET /notifications
SEARCH /notifications
`)],-1),N=s("h3",{id:"graphql",tabindex:"-1"},[s("a",{class:"header-anchor",href:"#graphql"},"#"),t(" GraphQL")],-1),Q=s("pre",null,[s("code",null,`POST /graphql/system
`)],-1),I=s("pre",null,[s("code",{class:"language-graphql"},[s("span",{class:"hljs-keyword"},"type"),s("span",{class:"hljs-type"}," Query"),t(` {
	notifications: [directus_notifications]
}
`)])],-1),D=s("h5",{id:"example",tabindex:"-1"},[s("a",{class:"header-anchor",href:"#example"},"#"),t(" Example")],-1),O=s("pre",null,[s("code",{class:"language-graphql"},[s("span",{class:"hljs-keyword"},"query"),t(` {
	notifications {
		id
		recipient
		subject
	}
}
`)])],-1),H=s("hr",null,null,-1),v=s("h2",{id:"retrieve-a-notification",tabindex:"-1"},[s("a",{class:"header-anchor",href:"#retrieve-a-notification"},"#"),t(" Retrieve a notification")],-1),G=s("p",null,"List an existing notification by primary key.",-1),B=s("h3",{id:"query-parameters-1",tabindex:"-1"},[s("a",{class:"header-anchor",href:"#query-parameters-1"},"#"),t(" Query Parameters")],-1),M=s("h3",{id:"returns-1",tabindex:"-1"},[s("a",{class:"header-anchor",href:"#returns-1"},"#"),t(" Returns")],-1),U=s("p",null,[t("Returns the requested "),s("a",{href:"#the-notification-object"},"notification object"),t(".")],-1),Y=s("h3",{id:"rest-api-1",tabindex:"-1"},[s("a",{class:"header-anchor",href:"#rest-api-1"},"#"),t(" REST API")],-1),V=s("pre",null,[s("code",null,`GET /notifications/:id
`)],-1),z=s("h5",{id:"example-1",tabindex:"-1"},[s("a",{class:"header-anchor",href:"#example-1"},"#"),t(" Example")],-1),F=s("pre",null,[s("code",null,`GET /notifications/42
`)],-1),W=s("h3",{id:"graphql-1",tabindex:"-1"},[s("a",{class:"header-anchor",href:"#graphql-1"},"#"),t(" GraphQL")],-1),Z=s("pre",null,[s("code",null,`POST /graphql/system
`)],-1),J=s("pre",null,[s("code",{class:"language-graphql"},[s("span",{class:"hljs-keyword"},"type"),s("span",{class:"hljs-type"}," Query"),t(` {
	notifications_by_id(id:`),s("span",{class:"hljs-literal"}," ID"),t(`!): directus_notifications
}
`)])],-1),K=s("h5",{id:"example-2",tabindex:"-1"},[s("a",{class:"header-anchor",href:"#example-2"},"#"),t(" Example")],-1),X=s("pre",null,[s("code",{class:"language-graphql"},[s("span",{class:"hljs-keyword"},"query"),t(` {
	notifications_by_id(id: `),s("span",{class:"hljs-number"},"42"),t(`) {
		id
		sender
		recipient
		message
		subject
	}
}
`)])],-1),$=s("hr",null,null,-1),ss=s("h2",{id:"create-a-notification",tabindex:"-1"},[s("a",{class:"header-anchor",href:"#create-a-notification"},"#"),t(" Create a Notification")],-1),ts=s("p",null,"Create a new notification.",-1),es=s("h3",{id:"query-parameters-2",tabindex:"-1"},[s("a",{class:"header-anchor",href:"#query-parameters-2"},"#"),t(" Query Parameters")],-1),ns=s("h3",{id:"request-body",tabindex:"-1"},[s("a",{class:"header-anchor",href:"#request-body"},"#"),t(" Request Body")],-1),as=s("p",null,[t("A partial "),s("a",{href:"#the-notification-object"},"notification object"),t(".")],-1),is=s("h3",{id:"returns-2",tabindex:"-1"},[s("a",{class:"header-anchor",href:"#returns-2"},"#"),t(" Returns")],-1),os=s("p",null,[t("Returns the "),s("a",{href:"#the-notification-object"},"notification object"),t(" for the created notification.")],-1),ls=s("h3",{id:"rest-api-2",tabindex:"-1"},[s("a",{class:"header-anchor",href:"#rest-api-2"},"#"),t(" REST API")],-1),cs=s("pre",null,[s("code",null,`POST /notifications
`)],-1),rs=s("h5",{id:"example-3",tabindex:"-1"},[s("a",{class:"header-anchor",href:"#example-3"},"#"),t(" Example")],-1),hs=s("pre",null,[s("code",{class:"language-json"},[s("span",{class:"hljs-comment"},"// POST /notifications"),t(`

`),s("span",{class:"hljs-punctuation"},"{"),t(`
	`),s("span",{class:"hljs-attr"},'"recipient"'),s("span",{class:"hljs-punctuation"},":"),t(),s("span",{class:"hljs-string"},'"410b5772-e63f-4ae6-9ea2-39c3a31bd6ca"'),s("span",{class:"hljs-punctuation"},","),t(`
	`),s("span",{class:"hljs-attr"},'"subject"'),s("span",{class:"hljs-punctuation"},":"),t(),s("span",{class:"hljs-string"},'"Hi there!"'),t(`
`),s("span",{class:"hljs-punctuation"},"}"),t(`
`)])],-1),ds=s("h3",{id:"graphql-2",tabindex:"-1"},[s("a",{class:"header-anchor",href:"#graphql-2"},"#"),t(" GraphQL")],-1),ps=s("pre",null,[s("code",null,`POST /graphql/system
`)],-1),us=s("pre",null,[s("code",{class:"language-graphql"},[s("span",{class:"hljs-keyword"},"type"),s("span",{class:"hljs-type"}," Mutation"),t(` {
	create_notifications_item(data: create_directus_notifications_input!): directus_notifications
}
`)])],-1),_s=s("h5",{id:"example-4",tabindex:"-1"},[s("a",{class:"header-anchor",href:"#example-4"},"#"),t(" Example")],-1),fs=s("pre",null,[s("code",{class:"language-graphql"},[s("span",{class:"hljs-keyword"},"mutation"),t(` {
	create_notifications_item(data: { recipient: `),s("span",{class:"hljs-string"},'"410b5772-e63f-4ae6-9ea2-39c3a31bd6ca"'),t(", subject: "),s("span",{class:"hljs-string"},'"Hi there!"'),t(` }) {
		id
		recipient
	}
}
`)])],-1),ms=s("hr",null,null,-1),js=s("h2",{id:"create-multiple-notifications",tabindex:"-1"},[s("a",{class:"header-anchor",href:"#create-multiple-notifications"},"#"),t(" Create Multiple Notifications")],-1),gs=s("p",null,"Create multiple new notifications.",-1),bs=s("h3",{id:"query-parameters-3",tabindex:"-1"},[s("a",{class:"header-anchor",href:"#query-parameters-3"},"#"),t(" Query Parameters")],-1),ys=s("h3",{id:"request-body-1",tabindex:"-1"},[s("a",{class:"header-anchor",href:"#request-body-1"},"#"),t(" Request Body")],-1),xs=s("p",null,[t("An array of partial "),s("a",{href:"#the-notification-object"},"notification objects"),t(".")],-1),qs=s("h3",{id:"returns-3",tabindex:"-1"},[s("a",{class:"header-anchor",href:"#returns-3"},"#"),t(" Returns")],-1),Es=s("p",null,[t("Returns the "),s("a",{href:"#the-notification-object"},"notification object"),t(" for the created notification.")],-1),Ts=s("h3",{id:"rest-api-3",tabindex:"-1"},[s("a",{class:"header-anchor",href:"#rest-api-3"},"#"),t(" REST API")],-1),ks=s("pre",null,[s("code",null,`POST /notifications
`)],-1),Ps=s("h5",{id:"example-5",tabindex:"-1"},[s("a",{class:"header-anchor",href:"#example-5"},"#"),t(" Example")],-1),Rs=s("pre",null,[s("code",{class:"language-json"},[s("span",{class:"hljs-comment"},"// POST /notifications"),t(`

`),s("span",{class:"hljs-punctuation"},"["),t(`
	`),s("span",{class:"hljs-punctuation"},"{"),t(`
		`),s("span",{class:"hljs-attr"},'"collection"'),s("span",{class:"hljs-punctuation"},":"),t(),s("span",{class:"hljs-string"},'"directus_files"'),s("span",{class:"hljs-punctuation"},","),t(`
		`),s("span",{class:"hljs-attr"},'"recipient"'),s("span",{class:"hljs-punctuation"},":"),t(),s("span",{class:"hljs-string"},'"410b5772-e63f-4ae6-9ea2-39c3a31bd6ca"'),s("span",{class:"hljs-punctuation"},","),t(`
		`),s("span",{class:"hljs-attr"},'"message"'),s("span",{class:"hljs-punctuation"},":"),t(),s("span",{class:"hljs-string"},'"Hi there! You should check out these files"'),t(`
	`),s("span",{class:"hljs-punctuation"},"}"),s("span",{class:"hljs-punctuation"},","),t(`
	`),s("span",{class:"hljs-punctuation"},"{"),t(`
		`),s("span",{class:"hljs-attr"},'"collection"'),s("span",{class:"hljs-punctuation"},":"),t(),s("span",{class:"hljs-string"},'"articles"'),s("span",{class:"hljs-punctuation"},","),t(`
		`),s("span",{class:"hljs-attr"},'"recipient"'),s("span",{class:"hljs-punctuation"},":"),t(),s("span",{class:"hljs-string"},'"410b5772-e63f-4ae6-9ea2-39c3a31bd6ca"'),s("span",{class:"hljs-punctuation"},","),t(`
		`),s("span",{class:"hljs-attr"},'"message"'),s("span",{class:"hljs-punctuation"},":"),t(),s("span",{class:"hljs-string"},'"Hi there! You should check out these articles"'),t(`
	`),s("span",{class:"hljs-punctuation"},"}"),t(`
`),s("span",{class:"hljs-punctuation"},"]"),t(`
`)])],-1),Ss=s("h3",{id:"graphql-3",tabindex:"-1"},[s("a",{class:"header-anchor",href:"#graphql-3"},"#"),t(" GraphQL")],-1),ws=s("pre",null,[s("code",null,`POST /graphql/system
`)],-1),As=s("pre",null,[s("code",{class:"language-graphql"},[s("span",{class:"hljs-keyword"},"type"),s("span",{class:"hljs-type"}," Mutation"),t(` {
	create_notifications_items(data: [create_directus_notifications_input!]!): [directus_notifications]
}
`)])],-1),Cs=s("h5",{id:"example-6",tabindex:"-1"},[s("a",{class:"header-anchor",href:"#example-6"},"#"),t(" Example")],-1),Ls=s("pre",null,[s("code",{class:"language-graphql"},[s("span",{class:"hljs-keyword"},"mutation"),t(` {
	create_notifications_items(
		data: [
			{
				collection: `),s("span",{class:"hljs-string"},'"directus_files"'),t(`
				recipient: `),s("span",{class:"hljs-string"},'"410b5772-e63f-4ae6-9ea2-39c3a31bd6ca"'),t(`
				message: `),s("span",{class:"hljs-string"},'"Hi there! You should check out these files"'),t(`
			}
			{
				collection: `),s("span",{class:"hljs-string"},'"articles"'),t(`
				recipient: `),s("span",{class:"hljs-string"},'"410b5772-e63f-4ae6-9ea2-39c3a31bd6ca"'),t(`
				message: `),s("span",{class:"hljs-string"},'"Hi there! You should check out these articles"'),t(`
			}
		]
	) {
		id
		recipient
	}
}
`)])],-1),Ns=s("hr",null,null,-1),Qs=s("h2",{id:"update-a-notification",tabindex:"-1"},[s("a",{class:"header-anchor",href:"#update-a-notification"},"#"),t(" Update a Notification")],-1),Is=s("p",null,"Update an existing notification.",-1),Ds=s("div",{class:"tip hint"},[s("div",{class:"hint-title"},"Email Notifications"),s("p",null,"Emails are only sent when the notification is created. Updated to an existing notification won\u2019t trigger a new notification email to be sent.")],-1),Os=s("h3",{id:"query-parameters-4",tabindex:"-1"},[s("a",{class:"header-anchor",href:"#query-parameters-4"},"#"),t(" Query Parameters")],-1),Hs=s("h3",{id:"request-body-2",tabindex:"-1"},[s("a",{class:"header-anchor",href:"#request-body-2"},"#"),t(" Request Body")],-1),vs=s("p",null,[t("A partial "),s("a",{href:"#the-notification-object"},"notification object"),t(".")],-1),Gs=s("h3",{id:"returns-4",tabindex:"-1"},[s("a",{class:"header-anchor",href:"#returns-4"},"#"),t(" Returns")],-1),Bs=s("p",null,[t("Returns the "),s("a",{href:"#the-notification-object"},"notification object"),t(" for the updated notification.")],-1),Ms=s("h3",{id:"rest-api-4",tabindex:"-1"},[s("a",{class:"header-anchor",href:"#rest-api-4"},"#"),t(" REST API")],-1),Us=s("pre",null,[s("code",null,`PATCH /notifications/:id
`)],-1),Ys=s("h5",{id:"example-7",tabindex:"-1"},[s("a",{class:"header-anchor",href:"#example-7"},"#"),t(" Example")],-1),Vs=s("pre",null,[s("code",{class:"language-json"},[s("span",{class:"hljs-comment"},"// PATCH /notifications/34"),t(`

`),s("span",{class:"hljs-punctuation"},"{"),t(`
	`),s("span",{class:"hljs-attr"},'"message"'),s("span",{class:"hljs-punctuation"},":"),t(),s("span",{class:"hljs-string"},'"This is my updated notification"'),t(`
`),s("span",{class:"hljs-punctuation"},"}"),t(`
`)])],-1),zs=s("h3",{id:"graphql-4",tabindex:"-1"},[s("a",{class:"header-anchor",href:"#graphql-4"},"#"),t(" GraphQL")],-1),Fs=s("pre",null,[s("code",null,`POST /graphql/system
`)],-1),Ws=s("pre",null,[s("code",{class:"language-graphql"},[s("span",{class:"hljs-keyword"},"type"),s("span",{class:"hljs-type"}," Mutation"),t(` {
	update_notifications_item(id:`),s("span",{class:"hljs-literal"}," ID"),t(`!, data: update_directus_notifications_input): directus_notifications
}
`)])],-1),Zs=s("h5",{id:"example-8",tabindex:"-1"},[s("a",{class:"header-anchor",href:"#example-8"},"#"),t(" Example")],-1),Js=s("pre",null,[s("code",{class:"language-graphql"},[s("span",{class:"hljs-keyword"},"mutation"),t(` {
	update_notifications_item(id: `),s("span",{class:"hljs-number"},"32"),t(", data: { message: "),s("span",{class:"hljs-string"},'"This is my updated notification"'),t(` }) {
		id
		message
	}
}
`)])],-1),Ks=s("hr",null,null,-1),Xs=s("h2",{id:"update-multiple-notifications",tabindex:"-1"},[s("a",{class:"header-anchor",href:"#update-multiple-notifications"},"#"),t(" Update Multiple Notifications")],-1),$s=s("p",null,"Update multiple existing notifications.",-1),st=s("h3",{id:"query-parameters-5",tabindex:"-1"},[s("a",{class:"header-anchor",href:"#query-parameters-5"},"#"),t(" Query Parameters")],-1),tt=s("h3",{id:"request-body-3",tabindex:"-1"},[s("a",{class:"header-anchor",href:"#request-body-3"},"#"),t(" Request Body")],-1),et=s("p",null,[s("code",null,"keys"),t(),s("strong",null,"Required"),s("br"),t(" Array of primary keys of the notifications you\u2019d like to update.")],-1),nt=s("p",null,[s("code",null,"data"),t(),s("strong",null,"Required"),s("br"),t(" Any of "),s("a",{href:"#the-notification-object"},"the notification object"),t("\u2019s properties.")],-1),at=s("h3",{id:"returns-5",tabindex:"-1"},[s("a",{class:"header-anchor",href:"#returns-5"},"#"),t(" Returns")],-1),it=s("p",null,[t("Returns the "),s("a",{href:"#the-notification-object"},"notification objects"),t(" for the updated notifications.")],-1),ot=s("h3",{id:"rest-api-5",tabindex:"-1"},[s("a",{class:"header-anchor",href:"#rest-api-5"},"#"),t(" REST API")],-1),lt=s("pre",null,[s("code",null,`PATCH /notifications
`)],-1),ct=s("h5",{id:"example-9",tabindex:"-1"},[s("a",{class:"header-anchor",href:"#example-9"},"#"),t(" Example")],-1),rt=s("pre",null,[s("code",{class:"language-json"},[s("span",{class:"hljs-comment"},"// PATCH /notifications"),t(`

`),s("span",{class:"hljs-punctuation"},"{"),t(`
	`),s("span",{class:"hljs-attr"},'"keys"'),s("span",{class:"hljs-punctuation"},":"),t(),s("span",{class:"hljs-punctuation"},"["),s("span",{class:"hljs-number"},"15"),s("span",{class:"hljs-punctuation"},","),t(),s("span",{class:"hljs-number"},"64"),s("span",{class:"hljs-punctuation"},"]"),s("span",{class:"hljs-punctuation"},","),t(`
	`),s("span",{class:"hljs-attr"},'"data"'),s("span",{class:"hljs-punctuation"},":"),t(),s("span",{class:"hljs-punctuation"},"{"),t(`
		`),s("span",{class:"hljs-attr"},'"message"'),s("span",{class:"hljs-punctuation"},":"),t(),s("span",{class:"hljs-string"},'"Updated message!"'),t(`
	`),s("span",{class:"hljs-punctuation"},"}"),t(`
`),s("span",{class:"hljs-punctuation"},"}"),t(`
`)])],-1),ht=s("h3",{id:"graphql-5",tabindex:"-1"},[s("a",{class:"header-anchor",href:"#graphql-5"},"#"),t(" GraphQL")],-1),dt=s("pre",null,[s("code",null,`POST /graphql/system
`)],-1),pt=s("pre",null,[s("code",{class:"language-graphql"},[s("span",{class:"hljs-keyword"},"type"),s("span",{class:"hljs-type"}," Mutation"),t(` {
	update_notifications_items(ids: `),s("span",{class:"hljs-literal"},"[ID"),t(`!]!, data: update_directus_notifications_input): [directus_notifications]
}
`)])],-1),ut=s("h5",{id:"example-10",tabindex:"-1"},[s("a",{class:"header-anchor",href:"#example-10"},"#"),t(" Example")],-1),_t=s("pre",null,[s("code",{class:"language-graphql"},[s("span",{class:"hljs-keyword"},"mutation"),t(` {
	update_notifications_items(ids: [`),s("span",{class:"hljs-number"},"15"),t(", "),s("span",{class:"hljs-number"},"64"),t("], data: { message: "),s("span",{class:"hljs-string"},'"Updated message!"'),t(` }) {
		id
		recipient
	}
}
`)])],-1),ft=s("hr",null,null,-1),mt=s("h2",{id:"delete-a-notification",tabindex:"-1"},[s("a",{class:"header-anchor",href:"#delete-a-notification"},"#"),t(" Delete a Notification")],-1),jt=s("p",null,"Delete an existing notification.",-1),gt=s("h3",{id:"returns-6",tabindex:"-1"},[s("a",{class:"header-anchor",href:"#returns-6"},"#"),t(" Returns")],-1),bt=s("p",null,"Empty body.",-1),yt=s("h3",{id:"rest-api-6",tabindex:"-1"},[s("a",{class:"header-anchor",href:"#rest-api-6"},"#"),t(" REST API")],-1),xt=s("pre",null,[s("code",null,`DELETE /notifications/:id
`)],-1),qt=s("h5",{id:"example-11",tabindex:"-1"},[s("a",{class:"header-anchor",href:"#example-11"},"#"),t(" Example")],-1),Et=s("pre",null,[s("code",null,`DELETE /notifications/34
`)],-1),Tt=s("h3",{id:"graphql-6",tabindex:"-1"},[s("a",{class:"header-anchor",href:"#graphql-6"},"#"),t(" GraphQL")],-1),kt=s("pre",null,[s("code",null,`POST /graphql/system
`)],-1),Pt=s("pre",null,[s("code",{class:"language-graphql"},[s("span",{class:"hljs-keyword"},"type"),s("span",{class:"hljs-type"}," Mutation"),t(` {
	delete_notifications_item(id:`),s("span",{class:"hljs-literal"}," ID"),t(`!): delete_one
}
`)])],-1),Rt=s("h5",{id:"example-12",tabindex:"-1"},[s("a",{class:"header-anchor",href:"#example-12"},"#"),t(" Example")],-1),St=s("pre",null,[s("code",{class:"language-graphql"},[s("span",{class:"hljs-keyword"},"mutation"),t(` {
	delete_notifications_item(id: `),s("span",{class:"hljs-number"},"32"),t(`) {
		id
	}
}
`)])],-1),wt=s("hr",null,null,-1),At=s("h2",{id:"delete-multiple-notifications",tabindex:"-1"},[s("a",{class:"header-anchor",href:"#delete-multiple-notifications"},"#"),t(" Delete Multiple Notifications")],-1),Ct=s("p",null,"Delete multiple existing notifications.",-1),Lt=s("h3",{id:"request-body-4",tabindex:"-1"},[s("a",{class:"header-anchor",href:"#request-body-4"},"#"),t(" Request Body")],-1),Nt=s("p",null,"An array of notification primary keys",-1),Qt=s("h3",{id:"returns-7",tabindex:"-1"},[s("a",{class:"header-anchor",href:"#returns-7"},"#"),t(" Returns")],-1),It=s("p",null,"Empty body.",-1),Dt=s("h3",{id:"rest-api-7",tabindex:"-1"},[s("a",{class:"header-anchor",href:"#rest-api-7"},"#"),t(" REST API")],-1),Ot=s("pre",null,[s("code",null,`DELETE /notifications
`)],-1),Ht=s("h5",{id:"example-13",tabindex:"-1"},[s("a",{class:"header-anchor",href:"#example-13"},"#"),t(" Example")],-1),vt=s("pre",null,[s("code",{class:"language-json"},[s("span",{class:"hljs-comment"},"// DELETE /notifications"),t(`
`),s("span",{class:"hljs-punctuation"},"["),s("span",{class:"hljs-number"},"15"),s("span",{class:"hljs-punctuation"},","),t(),s("span",{class:"hljs-number"},"251"),s("span",{class:"hljs-punctuation"},","),t(),s("span",{class:"hljs-number"},"810"),s("span",{class:"hljs-punctuation"},"]"),t(`
`)])],-1),Gt=s("h3",{id:"graphql-7",tabindex:"-1"},[s("a",{class:"header-anchor",href:"#graphql-7"},"#"),t(" GraphQL")],-1),Bt=s("pre",null,[s("code",null,`POST /graphql/system
`)],-1),Mt=s("pre",null,[s("code",{class:"language-graphql"},[s("span",{class:"hljs-keyword"},"type"),s("span",{class:"hljs-type"}," Mutation"),t(` {
	delete_notifications_items(ids: `),s("span",{class:"hljs-literal"},"[ID"),t(`!]!): delete_many
}
`)])],-1),Ut=s("h5",{id:"example-14",tabindex:"-1"},[s("a",{class:"header-anchor",href:"#example-14"},"#"),t(" Example")],-1),Yt=s("pre",null,[s("code",{class:"language-graphql"},[s("span",{class:"hljs-keyword"},"mutation"),t(` {
	delete_notifications_items(ids: [`),s("span",{class:"hljs-number"},"15"),t(", "),s("span",{class:"hljs-number"},"251"),t(", "),s("span",{class:"hljs-number"},"810"),t(`]) {
		ids
	}
}
`)])],-1),Zt="Notifications",Jt=!1,Kt="REST and GraphQL API documentation on the Notifications collection in Directus.",Xt="5 min read",$t="page-reference",se={__name:"notifications",setup(Vt,{expose:l}){const i={title:"Notifications",modularExtension:!1,description:"REST and GraphQL API documentation on the Notifications collection in Directus.",readTime:"5 min read",pageClass:"page-reference"};return l({frontmatter:i}),(zt,Ft)=>{const n=o("router-link"),c=o("docs-wrapper");return r(),h(c,{frontmatter:i},{default:e(()=>[s("div",d,[p,u,_,f,m,j,g,b,y,x,q,E,T,k,P,R,S,s("p",null,[t("Supports all "),a(n,{to:"/docs/reference/query"},{default:e(()=>[t("global query parameters")]),_:1}),t(".")]),w,s("p",null,[t("An array of up to "),a(n,{to:"/docs/reference/query#limit"},{default:e(()=>[t("limit")]),_:1}),t(),A,t(". If no items are available, data will be an empty array.")]),C,L,s("p",null,[a(n,{to:"/docs/reference/introduction#search-http-method"},{default:e(()=>[t("Learn more about SEARCH ->")]),_:1})]),N,Q,I,D,O,H,v,G,B,s("p",null,[t("Supports all "),a(n,{to:"/docs/reference/query"},{default:e(()=>[t("global query parameters")]),_:1}),t(".")]),M,U,Y,V,z,F,W,Z,J,K,X,$,ss,ts,es,s("p",null,[t("Supports all "),a(n,{to:"/docs/reference/query"},{default:e(()=>[t("global query parameters")]),_:1}),t(".")]),ns,as,is,os,ls,cs,rs,hs,ds,ps,us,_s,fs,ms,js,gs,bs,s("p",null,[t("Supports all "),a(n,{to:"/docs/reference/query"},{default:e(()=>[t("global query parameters")]),_:1}),t(".")]),ys,xs,qs,Es,Ts,ks,Ps,Rs,Ss,ws,As,Cs,Ls,Ns,Qs,Is,Ds,Os,s("p",null,[t("Supports all "),a(n,{to:"/docs/reference/query"},{default:e(()=>[t("global query parameters")]),_:1}),t(".")]),Hs,vs,Gs,Bs,Ms,Us,Ys,Vs,zs,Fs,Ws,Zs,Js,Ks,Xs,$s,st,s("p",null,[t("Supports all "),a(n,{to:"/docs/reference/query"},{default:e(()=>[t("global query parameters")]),_:1}),t(".")]),tt,et,nt,at,it,ot,lt,ct,rt,ht,dt,pt,ut,_t,ft,mt,jt,gt,bt,yt,xt,qt,Et,Tt,kt,Pt,Rt,St,wt,At,Ct,Lt,Nt,Qt,It,Dt,Ot,Ht,vt,Gt,Bt,Mt,Ut,Yt])]),_:1})}}};export{se as default,Kt as description,Jt as modularExtension,$t as pageClass,Xt as readTime,Zt as title};
