import{a as o,o as l,e as r,y as i,u as s,q as e}from"./runtime-core.esm-bundler.22ec0346.js";const c=s("div",{class:"markdown-body"},[s("blockquote",null,[s("p",null,[e("Directus allows adding custom migration files that run whenever the "),s("code",null,"directus database migrate:*"),e(" commands are executed. All migrations must reside in the "),s("code",null,"extensions/migrations"),e(" folder.")])]),s("h2",{id:"file-name",tabindex:"-1"},[s("a",{class:"header-anchor",href:"#file-name"},"#"),e(" File Name")]),s("p",null,"The file name follows the following structure:"),s("pre",null,[s("code",null,`[identifier]-[name].js
`)]),s("p",null,"for example:"),s("pre",null,[s("code",null,`20201202A-my-custom-migration.js
`)]),s("h2",{id:"structure",tabindex:"-1"},[s("a",{class:"header-anchor",href:"#structure"},"#"),e(" Structure")]),s("p",null,[e("Migrations have to export an "),s("code",null,"up"),e(" and a "),s("code",null,"down"),e(" function. These functions get a "),s("a",{href:"http://knexjs.org",target:"_blank",rel:"noopener noreferrer"},"Knex"),e(" instance that can be used to do virtually whatever.")]),s("pre",null,[s("code",{class:"language-js"},[s("span",{class:"hljs-variable language_"},"module"),e("."),s("span",{class:"hljs-property"},"exports"),e(` = {
	`),s("span",{class:"hljs-keyword"},"async"),e(),s("span",{class:"hljs-title function_"},"up"),e("("),s("span",{class:"hljs-params"},"knex"),e(`) {
		`),s("span",{class:"hljs-keyword"},"await"),e(" knex."),s("span",{class:"hljs-property"},"schema"),e("."),s("span",{class:"hljs-title function_"},"createTable"),e("("),s("span",{class:"hljs-string"},"'test'"),e(", "),s("span",{class:"hljs-function"},[e("("),s("span",{class:"hljs-params"},"table"),e(") =>")]),e(` {
			table.`),s("span",{class:"hljs-title function_"},"increments"),e(`();
			table.`),s("span",{class:"hljs-title function_"},"string"),e("("),s("span",{class:"hljs-string"},"'rijk'"),e(`);
		});
	},

	`),s("span",{class:"hljs-keyword"},"async"),e(),s("span",{class:"hljs-title function_"},"down"),e("("),s("span",{class:"hljs-params"},"knex"),e(`) {
		`),s("span",{class:"hljs-keyword"},"await"),e(" knex."),s("span",{class:"hljs-property"},"schema"),e("."),s("span",{class:"hljs-title function_"},"dropTable"),e("("),s("span",{class:"hljs-string"},"'test'"),e(`);
	},
};
`)])]),s("div",{class:"danger hint"},[s("div",{class:"hint-title"},"Danger"),s("p",null,"Seeing that these migrations are a bit of a free-for-all, you can really harm your database. Please make sure you know what you\u2019re doing and backup your database before adding these migrations.")]),s("h2",{id:"migrations-and-directus-schema",tabindex:"-1"},[s("a",{class:"header-anchor",href:"#migrations-and-directus-schema"},"#"),e(" Migrations and Directus schema")]),s("p",null,[e("Migrations can be used for managing contents of Directus collections (e.g. initial hydration). In order to do it, you must ensure that schema is up to date before running migrations. One way of achieving it is opting out of default "),s("code",null,"directus bootstrap"),e(" process and running:")]),s("pre",null,[s("code",{class:"language-bash"},[e(`npx directus database install
`),s("span",{class:"hljs-comment"},"# notice that schema is applied before running migrations"),e(`
npx directus schema apply ./path/to/snapshot.yaml
npx directus database migrate:latest
`)])]),s("p",null,[e("You may want to add additional steps to reflect other responsibilities of "),s("code",null,"directus bootstrap"),e(".")])],-1),m="Custom Migrations",g=!1,f="A guide on how to setup your owns custom Migrations in Directus.",b="2 min read",j={__name:"migrations",setup(u,{expose:t}){const a={title:"Custom Migrations",modularExtension:!1,description:"A guide on how to setup your owns custom Migrations in Directus.",readTime:"2 min read"};return t({frontmatter:a}),(d,p)=>{const n=o("docs-wrapper");return l(),r(n,{frontmatter:a},{default:i(()=>[c]),_:1})}}};export{j as default,f as description,g as modularExtension,b as readTime,m as title};
