import{a as o,o as r,e as h,y as t,u as e,q as s,z as n}from"./runtime-core.esm-bundler.22ec0346.js";const d={class:"markdown-body"},p=e("hr",null,null,-1),u=e("h2",{id:"the-item-object",tabindex:"-1"},[e("a",{class:"header-anchor",href:"#the-item-object"},"#"),s(" The Item Object")],-1),_=e("p",null,[s("Items don\u2019t have a predefined schema. The format depends completely on how you configured your collections and fields in Directus. For the sake of documentation, we\u2019ll use a fictional articles collection with the following fields: "),e("code",null,"id"),s(", "),e("code",null,"status"),s(", "),e("code",null,"title"),s(", "),e("code",null,"body"),s(", "),e("code",null,"featured_image"),s(", and "),e("code",null,"author"),s(".")],-1),m={class:"tip hint"},j=e("div",{class:"hint-title"},"Relational Data",-1),b=e("pre",null,[e("code",{class:"language-json"},[e("span",{class:"hljs-punctuation"},"{"),s(`
	`),e("span",{class:"hljs-attr"},'"id"'),e("span",{class:"hljs-punctuation"},":"),s(),e("span",{class:"hljs-number"},"1"),e("span",{class:"hljs-punctuation"},","),s(`
	`),e("span",{class:"hljs-attr"},'"status"'),e("span",{class:"hljs-punctuation"},":"),s(),e("span",{class:"hljs-string"},'"published"'),e("span",{class:"hljs-punctuation"},","),s(`
	`),e("span",{class:"hljs-attr"},'"title"'),e("span",{class:"hljs-punctuation"},":"),s(),e("span",{class:"hljs-string"},'"Hello, world!"'),e("span",{class:"hljs-punctuation"},","),s(`
	`),e("span",{class:"hljs-attr"},'"body"'),e("span",{class:"hljs-punctuation"},":"),s(),e("span",{class:"hljs-string"},'"This is my first article"'),e("span",{class:"hljs-punctuation"},","),s(`
	`),e("span",{class:"hljs-attr"},'"featured_image"'),e("span",{class:"hljs-punctuation"},":"),s(),e("span",{class:"hljs-string"},'"768eabec-3c54-4110-a6bb-64b548116661"'),e("span",{class:"hljs-punctuation"},","),s(`
	`),e("span",{class:"hljs-attr"},'"author"'),e("span",{class:"hljs-punctuation"},":"),s(),e("span",{class:"hljs-string"},'"0bc7b36a-9ba9-4ce0-83f0-0a526f354e07"'),s(`
`),e("span",{class:"hljs-punctuation"},"}"),s(`
`)])],-1),f=e("hr",null,null,-1),g=e("h2",{id:"get-items",tabindex:"-1"},[e("a",{class:"header-anchor",href:"#get-items"},"#"),s(" Get Items")],-1),y=e("p",null,"List all items that exist in Directus.",-1),x=e("h3",{id:"query-parameters",tabindex:"-1"},[e("a",{class:"header-anchor",href:"#query-parameters"},"#"),s(" Query Parameters")],-1),q={class:"tip hint"},T=e("div",{class:"hint-title"},"Relational Data",-1),E=e("h3",{id:"returns",tabindex:"-1"},[e("a",{class:"header-anchor",href:"#returns"},"#"),s(" Returns")],-1),w=e("a",{href:"#the-item-object"},"item objects",-1),I=e("h4",{id:"singleton",tabindex:"-1"},[e("a",{class:"header-anchor",href:"#singleton"},"#"),s(" Singleton")],-1),P=e("p",null,"If your collection is a singleton, this endpoint will return the item. If the item doesn\u2019t exist in the database, the default values will be returned.",-1),R=e("h3",{id:"rest-api",tabindex:"-1"},[e("a",{class:"header-anchor",href:"#rest-api"},"#"),s(" REST API")],-1),S=e("pre",null,[e("code",null,`GET /items/:collection
SEARCH /items/:collection
`)],-1),k=e("h5",{id:"example",tabindex:"-1"},[e("a",{class:"header-anchor",href:"#example"},"#"),s(" Example")],-1),A=e("pre",null,[e("code",null,`GET /items/articles
`)],-1),D=e("h3",{id:"graphql",tabindex:"-1"},[e("a",{class:"header-anchor",href:"#graphql"},"#"),s(" GraphQL")],-1),Q=e("pre",null,[e("code",null,`POST /graphql
`)],-1),v=e("pre",null,[e("code",{class:"language-graphql"},[e("span",{class:"hljs-keyword"},"type"),e("span",{class:"hljs-type"}," Query"),s(` {
	<collection>: [<collection>]
}
`)])],-1),G=e("h5",{id:"example-1",tabindex:"-1"},[e("a",{class:"header-anchor",href:"#example-1"},"#"),s(" Example")],-1),L=e("pre",null,[e("code",{class:"language-graphql"},[e("span",{class:"hljs-keyword"},"query"),s(` {
	articles {
		id
		title
		author {
			first_name
		}
	}
}
`)])],-1),C=e("hr",null,null,-1),O=e("h2",{id:"get-item-by-id",tabindex:"-1"},[e("a",{class:"header-anchor",href:"#get-item-by-id"},"#"),s(" Get Item by ID")],-1),H=e("p",null,"Get an item that exists in Directus.",-1),M=e("h3",{id:"query-parameters-1",tabindex:"-1"},[e("a",{class:"header-anchor",href:"#query-parameters-1"},"#"),s(" Query Parameters")],-1),B=e("h3",{id:"returns-1",tabindex:"-1"},[e("a",{class:"header-anchor",href:"#returns-1"},"#"),s(" Returns")],-1),U=e("p",null,[s("Returns an "),e("a",{href:"#the-item-object"},"item object"),s(" if a valid primary key was provided.")],-1),F=e("h3",{id:"rest-api-1",tabindex:"-1"},[e("a",{class:"header-anchor",href:"#rest-api-1"},"#"),s(" REST API")],-1),N=e("pre",null,[e("code",null,`GET /items/:collection/:id
`)],-1),V=e("h5",{id:"example-2",tabindex:"-1"},[e("a",{class:"header-anchor",href:"#example-2"},"#"),s(" Example")],-1),z=e("pre",null,[e("code",null,`GET /items/articles/15
`)],-1),J=e("h3",{id:"graphql-1",tabindex:"-1"},[e("a",{class:"header-anchor",href:"#graphql-1"},"#"),s(" GraphQL")],-1),K=e("pre",null,[e("code",null,`POST /graphql
`)],-1),W=e("pre",null,[e("code",{class:"language-graphql"},[e("span",{class:"hljs-keyword"},"type"),e("span",{class:"hljs-type"}," Query"),s(` {
	<collection>_by_id(id:`),e("span",{class:"hljs-literal"}," ID"),s(`!): <collection>
}
`)])],-1),X=e("h5",{id:"example-3",tabindex:"-1"},[e("a",{class:"header-anchor",href:"#example-3"},"#"),s(" Example")],-1),Y=e("pre",null,[e("code",{class:"language-graphql"},[e("span",{class:"hljs-keyword"},"query"),s(` {
	articles_by_id(id: `),e("span",{class:"hljs-number"},"15"),s(`) {
		id
		title
	}
}
`)])],-1),Z=e("hr",null,null,-1),$=e("h2",{id:"create-an-item",tabindex:"-1"},[e("a",{class:"header-anchor",href:"#create-an-item"},"#"),s(" Create an Item")],-1),ee=e("p",null,"Create a new item in the given collection.",-1),se=e("h3",{id:"query-parameters-2",tabindex:"-1"},[e("a",{class:"header-anchor",href:"#query-parameters-2"},"#"),s(" Query Parameters")],-1),te=e("h3",{id:"request-body",tabindex:"-1"},[e("a",{class:"header-anchor",href:"#request-body"},"#"),s(" Request Body")],-1),ae=e("p",null,[s("An array of partial "),e("a",{href:"#the-item-object"},"item objects"),s(".")],-1),ne={class:"tip hint"},le=e("div",{class:"hint-title"},"Relational Data",-1),oe=e("h3",{id:"returns-2",tabindex:"-1"},[e("a",{class:"header-anchor",href:"#returns-2"},"#"),s(" Returns")],-1),ce=e("p",null,[s("Returns the "),e("a",{href:"#the-item-object"},"item objects"),s(" of the item that were created.")],-1),ie=e("h3",{id:"rest-api-2",tabindex:"-1"},[e("a",{class:"header-anchor",href:"#rest-api-2"},"#"),s(" REST API")],-1),re=e("pre",null,[e("code",null,`POST /items/:collection
`)],-1),he=e("h5",{id:"example-4",tabindex:"-1"},[e("a",{class:"header-anchor",href:"#example-4"},"#"),s(" Example")],-1),de=e("pre",null,[e("code",null,`POST /items/articles
`)],-1),pe=e("pre",null,[e("code",{class:"language-json"},[e("span",{class:"hljs-punctuation"},"{"),s(`
	`),e("span",{class:"hljs-attr"},'"title"'),e("span",{class:"hljs-punctuation"},":"),s(),e("span",{class:"hljs-string"},'"Hello world!"'),e("span",{class:"hljs-punctuation"},","),s(`
	`),e("span",{class:"hljs-attr"},'"body"'),e("span",{class:"hljs-punctuation"},":"),s(),e("span",{class:"hljs-string"},'"This is our first article"'),s(`
`),e("span",{class:"hljs-punctuation"},"}"),s(`
`)])],-1),ue=e("h3",{id:"graphql-2",tabindex:"-1"},[e("a",{class:"header-anchor",href:"#graphql-2"},"#"),s(" GraphQL")],-1),_e=e("pre",null,[e("code",null,`POST /graphql
`)],-1),me=e("pre",null,[e("code",{class:"language-graphql"},[e("span",{class:"hljs-keyword"},"type"),e("span",{class:"hljs-type"}," Mutation"),s(` {
	create_<collection>_item(data: create_<collection>_input): <collection>
}
`)])],-1),je=e("h5",{id:"example-5",tabindex:"-1"},[e("a",{class:"header-anchor",href:"#example-5"},"#"),s(" Example")],-1),be=e("pre",null,[e("code",{class:"language-graphql"},[e("span",{class:"hljs-keyword"},"mutation"),s(` {
	create_articles_item(data: { title: `),e("span",{class:"hljs-string"},'"Hello world!"'),s(", body: "),e("span",{class:"hljs-string"},'"This is our first article"'),s(` }) {
		id
		title
	}
}
`)])],-1),fe=e("hr",null,null,-1),ge=e("h2",{id:"create-multiple-items",tabindex:"-1"},[e("a",{class:"header-anchor",href:"#create-multiple-items"},"#"),s(" Create Multiple Items")],-1),ye=e("p",null,"Create new items in the given collection.",-1),xe=e("h3",{id:"query-parameters-3",tabindex:"-1"},[e("a",{class:"header-anchor",href:"#query-parameters-3"},"#"),s(" Query Parameters")],-1),qe=e("h3",{id:"request-body-1",tabindex:"-1"},[e("a",{class:"header-anchor",href:"#request-body-1"},"#"),s(" Request Body")],-1),Te=e("p",null,[s("An array of partial "),e("a",{href:"#the-item-object"},"item objects"),s(".")],-1),Ee=e("h3",{id:"returns-3",tabindex:"-1"},[e("a",{class:"header-anchor",href:"#returns-3"},"#"),s(" Returns")],-1),we=e("p",null,[s("Returns the "),e("a",{href:"#the-item-object"},"item objects"),s(" of the item that were created.")],-1),Ie=e("h3",{id:"rest-api-3",tabindex:"-1"},[e("a",{class:"header-anchor",href:"#rest-api-3"},"#"),s(" REST API")],-1),Pe=e("pre",null,[e("code",null,`POST /items/:collection
`)],-1),Re=e("h5",{id:"example-6",tabindex:"-1"},[e("a",{class:"header-anchor",href:"#example-6"},"#"),s(" Example")],-1),Se=e("pre",null,[e("code",null,`POST /items/articles
`)],-1),ke=e("pre",null,[e("code",{class:"language-json"},[e("span",{class:"hljs-punctuation"},"["),s(`
	`),e("span",{class:"hljs-punctuation"},"{"),s(`
		`),e("span",{class:"hljs-attr"},'"title"'),e("span",{class:"hljs-punctuation"},":"),s(),e("span",{class:"hljs-string"},'"Hello world!"'),e("span",{class:"hljs-punctuation"},","),s(`
		`),e("span",{class:"hljs-attr"},'"body"'),e("span",{class:"hljs-punctuation"},":"),s(),e("span",{class:"hljs-string"},'"This is our first article"'),s(`
	`),e("span",{class:"hljs-punctuation"},"}"),e("span",{class:"hljs-punctuation"},","),s(`
	`),e("span",{class:"hljs-punctuation"},"{"),s(`
		`),e("span",{class:"hljs-attr"},'"title"'),e("span",{class:"hljs-punctuation"},":"),s(),e("span",{class:"hljs-string"},'"Hello again, world!"'),e("span",{class:"hljs-punctuation"},","),s(`
		`),e("span",{class:"hljs-attr"},'"body"'),e("span",{class:"hljs-punctuation"},":"),s(),e("span",{class:"hljs-string"},'"This is our second article"'),s(`
	`),e("span",{class:"hljs-punctuation"},"}"),s(`
`),e("span",{class:"hljs-punctuation"},"]"),s(`
`)])],-1),Ae=e("h3",{id:"graphql-3",tabindex:"-1"},[e("a",{class:"header-anchor",href:"#graphql-3"},"#"),s(" GraphQL")],-1),De=e("pre",null,[e("code",null,`POST /graphql
`)],-1),Qe=e("pre",null,[e("code",{class:"language-graphql"},[e("span",{class:"hljs-keyword"},"type"),e("span",{class:"hljs-type"}," Mutation"),s(` {
	create_<collection>_items(data: [create_<collection>_input]): [<collection>]
}
`)])],-1),ve=e("h5",{id:"example-7",tabindex:"-1"},[e("a",{class:"header-anchor",href:"#example-7"},"#"),s(" Example")],-1),Ge=e("pre",null,[e("code",{class:"language-graphql"},[e("span",{class:"hljs-keyword"},"mutation"),s(` {
	create_articles_items(
		data: [
			{ title: `),e("span",{class:"hljs-string"},'"Hello world!"'),s(", body: "),e("span",{class:"hljs-string"},'"This is our first article"'),s(` }
			{ title: `),e("span",{class:"hljs-string"},'"Hello again, world!"'),s(", body: "),e("span",{class:"hljs-string"},'"This is our second article"'),s(` }
		]
	) {
		id
		title
	}
}
`)])],-1),Le=e("hr",null,null,-1),Ce=e("h2",{id:"update-an-item",tabindex:"-1"},[e("a",{class:"header-anchor",href:"#update-an-item"},"#"),s(" Update an Item")],-1),Oe=e("p",null,"Update an existing item.",-1),He=e("h3",{id:"query-parameters-4",tabindex:"-1"},[e("a",{class:"header-anchor",href:"#query-parameters-4"},"#"),s(" Query Parameters")],-1),Me=e("h3",{id:"request-body-2",tabindex:"-1"},[e("a",{class:"header-anchor",href:"#request-body-2"},"#"),s(" Request Body")],-1),Be=e("p",null,[s("A partial "),e("a",{href:"#the-item-object"},"item object"),s(".")],-1),Ue=e("h3",{id:"returns-4",tabindex:"-1"},[e("a",{class:"header-anchor",href:"#returns-4"},"#"),s(" Returns")],-1),Fe=e("p",null,[s("Returns the "),e("a",{href:"#the-item-object"},"item object"),s(" of the item that was updated.")],-1),Ne=e("h3",{id:"rest-api-4",tabindex:"-1"},[e("a",{class:"header-anchor",href:"#rest-api-4"},"#"),s(" REST API")],-1),Ve=e("pre",null,[e("code",null,`PATCH /items/:collection/:id
`)],-1),ze=e("h5",{id:"example-8",tabindex:"-1"},[e("a",{class:"header-anchor",href:"#example-8"},"#"),s(" Example")],-1),Je=e("pre",null,[e("code",null,`PATCH /items/articles/15
`)],-1),Ke=e("pre",null,[e("code",{class:"language-json"},[e("span",{class:"hljs-punctuation"},"{"),s(`
	`),e("span",{class:"hljs-attr"},'"title"'),e("span",{class:"hljs-punctuation"},":"),s(),e("span",{class:"hljs-string"},'"An updated title"'),s(`
`),e("span",{class:"hljs-punctuation"},"}"),s(`
`)])],-1),We=e("h3",{id:"graphql-4",tabindex:"-1"},[e("a",{class:"header-anchor",href:"#graphql-4"},"#"),s(" GraphQL")],-1),Xe=e("pre",null,[e("code",null,`POST /graphql
`)],-1),Ye=e("pre",null,[e("code",{class:"language-graphql"},[e("span",{class:"hljs-keyword"},"type"),e("span",{class:"hljs-type"}," Mutation"),s(` {
	update_<collection>_item(id:`),e("span",{class:"hljs-literal"}," ID"),s(`!, data: update_<collection>_input!): <collection>
}
`)])],-1),Ze=e("h5",{id:"example-9",tabindex:"-1"},[e("a",{class:"header-anchor",href:"#example-9"},"#"),s(" Example")],-1),$e=e("pre",null,[e("code",{class:"language-graphql"},[e("span",{class:"hljs-keyword"},"mutation"),s(` {
	update_articles_item(id: `),e("span",{class:"hljs-number"},"15"),s(", data: { title: "),e("span",{class:"hljs-string"},'"An updated title"'),s(` }) {
		id
		title
	}
}
`)])],-1),es=e("hr",null,null,-1),ss=e("h2",{id:"update-multiple-items",tabindex:"-1"},[e("a",{class:"header-anchor",href:"#update-multiple-items"},"#"),s(" Update Multiple Items")],-1),ts=e("p",null,"Update multiple items at the same time.",-1),as=e("h3",{id:"query-parameters-5",tabindex:"-1"},[e("a",{class:"header-anchor",href:"#query-parameters-5"},"#"),s(" Query Parameters")],-1),ns=e("h3",{id:"request-body-3",tabindex:"-1"},[e("a",{class:"header-anchor",href:"#request-body-3"},"#"),s(" Request Body")],-1),ls=e("p",null,[s("Object containing "),e("code",null,"data"),s(" for the values to set, and either "),e("code",null,"keys"),s(" or "),e("code",null,"query"),s(" to select what items to update.")],-1),os=e("h3",{id:"returns-5",tabindex:"-1"},[e("a",{class:"header-anchor",href:"#returns-5"},"#"),s(" Returns")],-1),cs=e("p",null,[s("Returns the "),e("a",{href:"#the-item-object"},"item objects"),s(" for the updated items.")],-1),is=e("h4",{id:"singleton-1",tabindex:"-1"},[e("a",{class:"header-anchor",href:"#singleton-1"},"#"),s(" Singleton")],-1),rs=e("p",null,[s("If your collection is a singleton, this endpoint will act the same as the "),e("a",{href:"#update-an-item"},"Update an Item"),s(" endpoint.")],-1),hs=e("h3",{id:"rest-api-5",tabindex:"-1"},[e("a",{class:"header-anchor",href:"#rest-api-5"},"#"),s(" REST API")],-1),ds=e("pre",null,[e("code",null,`PATCH /items/:collection
`)],-1),ps=e("h5",{id:"example-10",tabindex:"-1"},[e("a",{class:"header-anchor",href:"#example-10"},"#"),s(" Example")],-1),us=e("pre",null,[e("code",null,`PATCH /items/articles
`)],-1),_s=e("pre",null,[e("code",{class:"language-json"},[e("span",{class:"hljs-punctuation"},"{"),s(`
	`),e("span",{class:"hljs-attr"},'"keys"'),e("span",{class:"hljs-punctuation"},":"),s(),e("span",{class:"hljs-punctuation"},"["),e("span",{class:"hljs-number"},"1"),e("span",{class:"hljs-punctuation"},","),s(),e("span",{class:"hljs-number"},"2"),e("span",{class:"hljs-punctuation"},"]"),e("span",{class:"hljs-punctuation"},","),s(`
	`),e("span",{class:"hljs-attr"},'"data"'),e("span",{class:"hljs-punctuation"},":"),s(),e("span",{class:"hljs-punctuation"},"{"),s(`
		`),e("span",{class:"hljs-attr"},'"status"'),e("span",{class:"hljs-punctuation"},":"),s(),e("span",{class:"hljs-string"},'"published"'),s(`
	`),e("span",{class:"hljs-punctuation"},"}"),s(`
`),e("span",{class:"hljs-punctuation"},"}"),s(`
`)])],-1),ms=e("h3",{id:"graphql-5",tabindex:"-1"},[e("a",{class:"header-anchor",href:"#graphql-5"},"#"),s(" GraphQL")],-1),js=e("pre",null,[e("code",null,`POST /graphql
`)],-1),bs=e("pre",null,[e("code",{class:"language-graphql"},[e("span",{class:"hljs-keyword"},"type"),e("span",{class:"hljs-type"}," Mutation"),s(` {
	update_<collection>_items(ids: `),e("span",{class:"hljs-literal"},"[ID"),s(`!]!, data: [update_<collection>_input]): [<collection>]
}
`)])],-1),fs=e("h5",{id:"example-11",tabindex:"-1"},[e("a",{class:"header-anchor",href:"#example-11"},"#"),s(" Example")],-1),gs=e("pre",null,[e("code",{class:"language-graphql"},[e("span",{class:"hljs-keyword"},"mutation"),s(` {
	update_articles_items(ids: [`),e("span",{class:"hljs-number"},"1"),s(", "),e("span",{class:"hljs-number"},"2"),s("], data: { status: "),e("span",{class:"hljs-string"},'"published"'),s(` }) {
		id
		status
	}
}
`)])],-1),ys=e("hr",null,null,-1),xs=e("h2",{id:"delete-an-item",tabindex:"-1"},[e("a",{class:"header-anchor",href:"#delete-an-item"},"#"),s(" Delete an Item")],-1),qs=e("p",null,"Delete an existing item.",-1),Ts=e("h3",{id:"returns-6",tabindex:"-1"},[e("a",{class:"header-anchor",href:"#returns-6"},"#"),s(" Returns")],-1),Es=e("p",null,"Empty body.",-1),ws=e("h3",{id:"rest-api-6",tabindex:"-1"},[e("a",{class:"header-anchor",href:"#rest-api-6"},"#"),s(" REST API")],-1),Is=e("pre",null,[e("code",null,`DELETE /items/:collection/:id
`)],-1),Ps=e("h5",{id:"example-12",tabindex:"-1"},[e("a",{class:"header-anchor",href:"#example-12"},"#"),s(" Example")],-1),Rs=e("pre",null,[e("code",null,`DELETE /items/articles/15
`)],-1),Ss=e("h3",{id:"graphql-6",tabindex:"-1"},[e("a",{class:"header-anchor",href:"#graphql-6"},"#"),s(" GraphQL")],-1),ks=e("pre",null,[e("code",null,`POST /graphql
`)],-1),As=e("pre",null,[e("code",{class:"language-graphql"},[e("span",{class:"hljs-keyword"},"type"),e("span",{class:"hljs-type"}," Mutation"),s(` {
	delete_<collection>_item(id:`),e("span",{class:"hljs-literal"}," ID"),s(`!): delete_one
}
`)])],-1),Ds=e("h5",{id:"example-13",tabindex:"-1"},[e("a",{class:"header-anchor",href:"#example-13"},"#"),s(" Example")],-1),Qs=e("pre",null,[e("code",{class:"language-graphql"},[e("span",{class:"hljs-keyword"},"mutation"),s(` {
	delete_articles_item(id: `),e("span",{class:"hljs-number"},"15"),s(`) {
		id
	}
}
`)])],-1),vs=e("hr",null,null,-1),Gs=e("h2",{id:"delete-multiple-items",tabindex:"-1"},[e("a",{class:"header-anchor",href:"#delete-multiple-items"},"#"),s(" Delete Multiple Items")],-1),Ls=e("p",null,"Delete multiple existing items.",-1),Cs=e("h3",{id:"request-body-4",tabindex:"-1"},[e("a",{class:"header-anchor",href:"#request-body-4"},"#"),s(" Request Body")],-1),Os=e("p",null,"An array of item primary keys.",-1),Hs=e("h3",{id:"returns-7",tabindex:"-1"},[e("a",{class:"header-anchor",href:"#returns-7"},"#"),s(" Returns")],-1),Ms=e("p",null,"Empty body.",-1),Bs=e("h3",{id:"rest-api-7",tabindex:"-1"},[e("a",{class:"header-anchor",href:"#rest-api-7"},"#"),s(" REST API")],-1),Us=e("pre",null,[e("code",null,`DELETE /items/:collection
`)],-1),Fs=e("h5",{id:"example-14",tabindex:"-1"},[e("a",{class:"header-anchor",href:"#example-14"},"#"),s(" Example")],-1),Ns=e("pre",null,[e("code",null,`DELETE /items/articles
`)],-1),Vs=e("pre",null,[e("code",{class:"language-json"},[e("span",{class:"hljs-punctuation"},"["),e("span",{class:"hljs-number"},"15"),e("span",{class:"hljs-punctuation"},","),s(),e("span",{class:"hljs-number"},"16"),e("span",{class:"hljs-punctuation"},","),s(),e("span",{class:"hljs-number"},"21"),e("span",{class:"hljs-punctuation"},"]"),s(`
`)])],-1),zs=e("h3",{id:"graphql-7",tabindex:"-1"},[e("a",{class:"header-anchor",href:"#graphql-7"},"#"),s(" GraphQL")],-1),Js=e("pre",null,[e("code",null,`POST /graphql
`)],-1),Ks=e("pre",null,[e("code",{class:"language-graphql"},[e("span",{class:"hljs-keyword"},"type"),e("span",{class:"hljs-type"}," Mutation"),s(` {
	delete_<collection>_items(ids: `),e("span",{class:"hljs-literal"},"[ID"),s(`!]!): delete_many
}
`)])],-1),Ws=e("h5",{id:"example-15",tabindex:"-1"},[e("a",{class:"header-anchor",href:"#example-15"},"#"),s(" Example")],-1),Xs=e("pre",null,[e("code",{class:"language-graphql"},[e("span",{class:"hljs-keyword"},"mutation"),s(` {
	delete_articles_items(ids: [`),e("span",{class:"hljs-number"},"15"),s(", "),e("span",{class:"hljs-number"},"16"),s(", "),e("span",{class:"hljs-number"},"21"),s(`]) {
		ids
	}
}
`)])],-1),st="Accessing Items",tt=!1,at="REST and GraphQL API documentation to access and manage Items in Directus.",nt="5 min read",lt="page-reference",ot={__name:"items",setup(Ys,{expose:c}){const l={title:"Accessing Items",modularExtension:!1,description:"REST and GraphQL API documentation to access and manage Items in Directus.",readTime:"5 min read",pageClass:"page-reference"};return c({frontmatter:l}),(Zs,$s)=>{const a=o("router-link"),i=o("docs-wrapper");return r(),h(i,{frontmatter:l},{default:t(()=>[e("div",d,[e("blockquote",null,[e("p",null,[s("Items are individual pieces of data in your database. They can be anything, from articles, to IoT status checks. "),n(a,{to:"/docs/getting-started/glossary#items"},{default:t(()=>[s("Learn more about Items")]),_:1}),s(".")])]),p,u,_,e("div",m,[j,e("p",null,[s("Please see "),n(a,{to:"/docs/reference/introduction#relational-data"},{default:t(()=>[s("Relational Data")]),_:1}),s(" and "),n(a,{to:"/docs/reference/query#fields"},{default:t(()=>[s("Field Parameters")]),_:1}),s(" to learn more.")])]),b,f,g,y,x,e("p",null,[s("Supports all "),n(a,{to:"/docs/reference/query"},{default:t(()=>[s("global query parameters")]),_:1}),s(".")]),e("div",q,[T,e("p",null,[s("The "),n(a,{to:"/docs/reference/query#fields"},{default:t(()=>[s("Field Parameter")]),_:1}),s(" is required to return nested relational data.")])]),E,e("p",null,[s("An array of up to "),n(a,{to:"/docs/reference/query#limit"},{default:t(()=>[s("limit")]),_:1}),s(),w,s(". If no items are available, data will be an empty array.")]),I,P,R,S,e("p",null,[n(a,{to:"/docs/reference/introduction#search-http-method"},{default:t(()=>[s("Learn more about SEARCH ->")]),_:1})]),k,A,D,Q,v,G,L,C,O,H,M,e("p",null,[s("Supports all "),n(a,{to:"/docs/reference/query"},{default:t(()=>[s("global query parameters")]),_:1}),s(".")]),B,U,F,N,V,z,J,K,W,X,Y,Z,$,ee,se,e("p",null,[s("Supports all "),n(a,{to:"/docs/reference/query"},{default:t(()=>[s("global query parameters")]),_:1}),s(".")]),te,ae,e("div",ne,[le,e("p",null,[s("Relational data needs to be correctly nested to add new items successfully. Check out the "),n(a,{to:"/docs/reference/introduction#relational-data"},{default:t(()=>[s("relational data section")]),_:1}),s(" for more information.")])]),oe,ce,ie,re,he,de,pe,ue,_e,me,je,be,fe,ge,ye,xe,e("p",null,[s("Supports all "),n(a,{to:"/docs/reference/query"},{default:t(()=>[s("global query parameters")]),_:1}),s(".")]),qe,Te,Ee,we,Ie,Pe,Re,Se,ke,Ae,De,Qe,ve,Ge,Le,Ce,Oe,He,e("p",null,[s("Supports all "),n(a,{to:"/docs/reference/query"},{default:t(()=>[s("global query parameters")]),_:1}),s(".")]),Me,Be,Ue,Fe,Ne,Ve,ze,Je,Ke,We,Xe,Ye,Ze,$e,es,ss,ts,as,e("p",null,[s("Supports all "),n(a,{to:"/docs/reference/query"},{default:t(()=>[s("global query parameters")]),_:1}),s(".")]),ns,ls,os,cs,is,rs,hs,ds,ps,us,_s,ms,js,bs,fs,gs,ys,xs,qs,Ts,Es,ws,Is,Ps,Rs,Ss,ks,As,Ds,Qs,vs,Gs,Ls,Cs,Os,Hs,Ms,Bs,Us,Fs,Ns,Vs,zs,Js,Ks,Ws,Xs])]),_:1})}}};export{ot as default,at as description,tt as modularExtension,lt as pageClass,nt as readTime,st as title};
