import{a as o,o as r,e as u,y as n,u as t,q as s,z as a}from"./runtime-core.esm-bundler.22ec0346.js";const h={class:"markdown-body"},d=t("blockquote",null,[t("p",null,"Directus offers both a RESTful and GraphQL API to manage the data in the database. The API has predictable resource-oriented URLs, relies on standard HTTP status codes, and uses JSON for input and output.")],-1),p=t("h2",{id:"dynamic-api",tabindex:"-1"},[t("a",{class:"header-anchor",href:"#dynamic-api"},"#"),s(" Dynamic API")],-1),f=t("h2",{id:"rest-vs.-graphql",tabindex:"-1"},[t("a",{class:"header-anchor",href:"#rest-vs.-graphql"},"#"),s(" REST vs. GraphQL")],-1),m=t("p",null,[t("strong",null,"There is no difference in the functionality available between the REST and GraphQL endpoints."),s(" The functionality available in both is mapped to the same set of core services, meaning that you don\u2019t lose any performance or capabilities by choosing one or the other.")],-1),j=t("p",null,"Which one you choose is ultimately up to you.",-1),_=t("h2",{id:"authentication",tabindex:"-1"},[t("a",{class:"header-anchor",href:"#authentication"},"#"),s(" Authentication")],-1),y=t("p",null,"Useful references:",-1),g=t("h2",{id:"relational-data",tabindex:"-1"},[t("a",{class:"header-anchor",href:"#relational-data"},"#"),s(" Relational Data")],-1),b=t("code",null,"fields",-1),w=t("h3",{id:"creating-%2F-updating-%2F-deleting",tabindex:"-1"},[t("a",{class:"header-anchor",href:"#creating-%2F-updating-%2F-deleting"},"#"),s(" Creating / Updating / Deleting")],-1),T=t("p",null,"Similarly to fetching, relational content can be modified deeply as well.",-1),E=t("h4",{id:"many-to-one",tabindex:"-1"},[t("a",{class:"header-anchor",href:"#many-to-one"},"#"),s(" Many-to-One")],-1),v=t("p",null,"Many-to-One relationships are fairly straightforward to manage relationally. You can simply submit the changes you want as an object under the relational key in your collection. For example, if you wanted to create a new featured article on your page, you could submit:",-1),A=t("pre",null,[t("code",{class:"language-json"},[t("span",{class:"hljs-punctuation"},"{"),s(`
	`),t("span",{class:"hljs-attr"},'"featured_article"'),t("span",{class:"hljs-punctuation"},":"),s(),t("span",{class:"hljs-punctuation"},"{"),s(`
		`),t("span",{class:"hljs-attr"},'"title"'),t("span",{class:"hljs-punctuation"},":"),s(),t("span",{class:"hljs-string"},'"This is my new article!"'),s(`
	`),t("span",{class:"hljs-punctuation"},"}"),s(`
`),t("span",{class:"hljs-punctuation"},"}"),s(`
`)])],-1),k=t("p",null,[s("This will create a new record in the related collection, and save its primary key in the "),t("code",null,"featured_article"),s(" field for this item. To update an existing item, simply provide the primary key with the updates, and Directus will treat it as an update instead of a creation:")],-1),I=t("pre",null,[t("code",{class:"language-json"},[t("span",{class:"hljs-punctuation"},"{"),s(`
	`),t("span",{class:"hljs-attr"},'"featured_article"'),t("span",{class:"hljs-punctuation"},":"),s(),t("span",{class:"hljs-punctuation"},"{"),s(`
		`),t("span",{class:"hljs-attr"},'"id"'),t("span",{class:"hljs-punctuation"},":"),s(),t("span",{class:"hljs-number"},"15"),t("span",{class:"hljs-punctuation"},","),s(`
		`),t("span",{class:"hljs-attr"},'"title"'),t("span",{class:"hljs-punctuation"},":"),s(),t("span",{class:"hljs-string"},'"This is an updated title for my article!"'),s(`
	`),t("span",{class:"hljs-punctuation"},"}"),s(`
`),t("span",{class:"hljs-punctuation"},"}"),s(`
`)])],-1),P=t("p",null,"Seeing that the Many-to-One relationship stores the foreign key on the field itself, removing the item can be done by nullifying the field:",-1),x=t("pre",null,[t("code",{class:"language-json"},[t("span",{class:"hljs-punctuation"},"{"),s(`
	`),t("span",{class:"hljs-attr"},'"featured_article"'),t("span",{class:"hljs-punctuation"},":"),s(),t("span",{class:"hljs-literal"},[t("span",{class:"hljs-keyword"},"null")]),s(`
`),t("span",{class:"hljs-punctuation"},"}"),s(`
`)])],-1),D=t("h4",{id:"one-to-many-(%2F-many-to-many)",tabindex:"-1"},[t("a",{class:"header-anchor",href:"#one-to-many-(%2F-many-to-many)"},"#"),s(" One-to-Many (/ Many-to-Many)")],-1),S=t("p",null,"One-to-Many, and therefore Many-to-Many and Many-to-Any, relationships can be updated in one of two ways:",-1),R=t("p",null,[t("strong",null,"Basic")],-1),q=t("p",null,[s("The API will return one-to-many fields as an array of nested keys or items (based on the "),t("code",null,"fields"),s(" parameter). You can use this same structure to select what the related items are:")],-1),L=t("pre",null,[t("code",{class:"language-json"},[t("span",{class:"hljs-punctuation"},"{"),s(`
	`),t("span",{class:"hljs-attr"},'"children"'),t("span",{class:"hljs-punctuation"},":"),s(),t("span",{class:"hljs-punctuation"},"["),t("span",{class:"hljs-number"},"2"),t("span",{class:"hljs-punctuation"},","),s(),t("span",{class:"hljs-number"},"7"),t("span",{class:"hljs-punctuation"},","),s(),t("span",{class:"hljs-number"},"149"),t("span",{class:"hljs-punctuation"},"]"),s(`
`),t("span",{class:"hljs-punctuation"},"}"),s(`
`)])],-1),N=t("p",null,"You can also provide an object instead of a primary key in order to create new items nested on the fly, or an object with a primary key included to update an existing item:",-1),O=t("pre",null,[t("code",{class:"language-json"},[t("span",{class:"hljs-punctuation"},"{"),s(`
	`),t("span",{class:"hljs-attr"},'"children"'),t("span",{class:"hljs-punctuation"},":"),s(),t("span",{class:"hljs-punctuation"},"["),s(`
		`),t("span",{class:"hljs-number"},"2"),t("span",{class:"hljs-punctuation"},","),s(),t("span",{class:"hljs-comment"},"// assign existing item 2 to be a child of the current item"),s(`
		`),t("span",{class:"hljs-punctuation"},"{"),s(`
			`),t("span",{class:"hljs-attr"},'"name"'),t("span",{class:"hljs-punctuation"},":"),s(),t("span",{class:"hljs-string"},'"A new nested item"'),s(`
		`),t("span",{class:"hljs-punctuation"},"}"),t("span",{class:"hljs-punctuation"},","),s(`
		`),t("span",{class:"hljs-punctuation"},"{"),s(`
			`),t("span",{class:"hljs-attr"},'"id"'),t("span",{class:"hljs-punctuation"},":"),s(),t("span",{class:"hljs-number"},"149"),t("span",{class:"hljs-punctuation"},","),s(`
			`),t("span",{class:"hljs-attr"},'"name"'),t("span",{class:"hljs-punctuation"},":"),s(),t("span",{class:"hljs-string"},'"Assign and update existing item 149"'),s(`
		`),t("span",{class:"hljs-punctuation"},"}"),s(`
	`),t("span",{class:"hljs-punctuation"},"]"),s(`
`),t("span",{class:"hljs-punctuation"},"}"),s(`
`)])],-1),C=t("p",null,"To remove items from this relationship, simply omit them from the array:",-1),H=t("pre",null,[t("code",{class:"language-json"},[t("span",{class:"hljs-punctuation"},"{"),s(`
	`),t("span",{class:"hljs-attr"},'"children"'),t("span",{class:"hljs-punctuation"},":"),s(),t("span",{class:"hljs-punctuation"},"["),t("span",{class:"hljs-number"},"2"),t("span",{class:"hljs-punctuation"},","),s(),t("span",{class:"hljs-number"},"149"),t("span",{class:"hljs-punctuation"},"]"),s(`
`),t("span",{class:"hljs-punctuation"},"}"),s(`
`)])],-1),U=t("p",null,"This method of updating a one-to-many is very useful for smaller relational datasets.",-1),G=t("p",null,[t("strong",null,"\u201CDetailed\u201D")],-1),M=t("p",null,"Alternatively, you can provide an object detailing the changes as follows:",-1),V=t("pre",null,[t("code",{class:"language-json"},[t("span",{class:"hljs-punctuation"},"{"),s(`
	`),t("span",{class:"hljs-attr"},'"children"'),t("span",{class:"hljs-punctuation"},":"),s(),t("span",{class:"hljs-punctuation"},"{"),s(`
		`),t("span",{class:"hljs-attr"},'"create"'),t("span",{class:"hljs-punctuation"},":"),s(),t("span",{class:"hljs-punctuation"},"["),t("span",{class:"hljs-punctuation"},"{"),s(),t("span",{class:"hljs-attr"},'"name"'),t("span",{class:"hljs-punctuation"},":"),s(),t("span",{class:"hljs-string"},'"A new nested item"'),s(),t("span",{class:"hljs-punctuation"},"}"),t("span",{class:"hljs-punctuation"},"]"),t("span",{class:"hljs-punctuation"},","),s(`
		`),t("span",{class:"hljs-attr"},'"update"'),t("span",{class:"hljs-punctuation"},":"),s(),t("span",{class:"hljs-punctuation"},"["),t("span",{class:"hljs-punctuation"},"{"),s(),t("span",{class:"hljs-attr"},'"id"'),t("span",{class:"hljs-punctuation"},":"),s(),t("span",{class:"hljs-number"},"149"),t("span",{class:"hljs-punctuation"},","),s(),t("span",{class:"hljs-attr"},'"name"'),t("span",{class:"hljs-punctuation"},":"),s(),t("span",{class:"hljs-string"},'"A new nested item"'),s(),t("span",{class:"hljs-punctuation"},"}"),t("span",{class:"hljs-punctuation"},"]"),t("span",{class:"hljs-punctuation"},","),s(`
		`),t("span",{class:"hljs-attr"},'"delete"'),t("span",{class:"hljs-punctuation"},":"),s(),t("span",{class:"hljs-punctuation"},"["),t("span",{class:"hljs-number"},"7"),t("span",{class:"hljs-punctuation"},"]"),s(`
	`),t("span",{class:"hljs-punctuation"},"}"),s(`
`),t("span",{class:"hljs-punctuation"},"}"),s(`
`)])],-1),F=t("p",null,"This is useful if you need to have more tightly control on staged changes, or when you\u2019re working with a big relational dataset.",-1),Q=t("h4",{id:"many-to-any-(union-types)",tabindex:"-1"},[t("a",{class:"header-anchor",href:"#many-to-any-(union-types)"},"#"),s(" Many-to-Any (Union Types)")],-1),B=t("p",null,"Many-to-Any fields work very similar to a \u201Cregular\u201D many-to-many, with the exception that the related field can pull in the fields from any of the related collections, for example:",-1),Y=t("pre",null,[t("code",{class:"language-json"},[t("span",{class:"hljs-punctuation"},"{"),s(`
	`),t("span",{class:"hljs-attr"},'"sections"'),t("span",{class:"hljs-punctuation"},":"),s(),t("span",{class:"hljs-punctuation"},"["),s(`
		`),t("span",{class:"hljs-punctuation"},"{"),s(`
			`),t("span",{class:"hljs-attr"},'"collection"'),t("span",{class:"hljs-punctuation"},":"),s(),t("span",{class:"hljs-string"},'"headings"'),t("span",{class:"hljs-punctuation"},","),s(`
			`),t("span",{class:"hljs-attr"},'"item"'),t("span",{class:"hljs-punctuation"},":"),s(),t("span",{class:"hljs-punctuation"},"{"),s(`
				`),t("span",{class:"hljs-comment"},"/* headings fields */"),s(`
			`),t("span",{class:"hljs-punctuation"},"}"),s(`
		`),t("span",{class:"hljs-punctuation"},"}"),t("span",{class:"hljs-punctuation"},","),s(`
		`),t("span",{class:"hljs-punctuation"},"{"),s(`
			`),t("span",{class:"hljs-attr"},'"collection"'),t("span",{class:"hljs-punctuation"},":"),s(),t("span",{class:"hljs-string"},'"paragraphs"'),t("span",{class:"hljs-punctuation"},","),s(`
			`),t("span",{class:"hljs-attr"},'"item"'),t("span",{class:"hljs-punctuation"},":"),s(),t("span",{class:"hljs-punctuation"},"{"),s(`
				`),t("span",{class:"hljs-comment"},"/* paragraphs fields */"),s(`
			`),t("span",{class:"hljs-punctuation"},"}"),s(`
		`),t("span",{class:"hljs-punctuation"},"}"),s(`
	`),t("span",{class:"hljs-punctuation"},"]"),s(`
`),t("span",{class:"hljs-punctuation"},"}"),s(`
`)])],-1),W=t("h5",{id:"rest-api",tabindex:"-1"},[t("a",{class:"header-anchor",href:"#rest-api"},"#"),s(" REST API")],-1),z=t("p",null,[s("To scope the fields that are returned per collection type, you can use the "),t("code",null,"<field>:<scope>"),s(" syntax in the fields parameter as follows:")],-1),K=t("pre",null,[t("code",null,`GET /items/pages
	?fields[]=sections.item:headings.id
	&fields[]=sections.item:headings.title
	&fields[]=sections.item:paragraphs.body
	&fields[]=sections.item:paragraphs.background_color
`)],-1),X=t("h5",{id:"graphql",tabindex:"-1"},[t("a",{class:"header-anchor",href:"#graphql"},"#"),s(" GraphQL")],-1),J=t("p",null,"In GraphQL, you can use nested fragments on the Union Type to select the fields:",-1),Z=t("pre",null,[t("code",{class:"language-graphql"},[t("span",{class:"hljs-keyword"},"query"),s(` {
	pages {
		sections {
			item {
				`),t("span",{class:"hljs-keyword"},"..."),s(),t("span",{class:"hljs-keyword"},"on"),s(` headings {
					id
					title
				}

				`),t("span",{class:"hljs-keyword"},"..."),s(),t("span",{class:"hljs-keyword"},"on"),s(` paragraphs {
					body
					background_color
				}
			}
		}
	}
}
`)])],-1),$=t("div",{class:"tip hint"},[t("div",{class:"hint-title"},"Updating"),t("p",null,"Updating records in a many-to-any is identical to the other relationship types.")],-1),tt=t("h2",{id:"search-http-method",tabindex:"-1"},[t("a",{class:"header-anchor",href:"#search-http-method"},"#"),s(" SEARCH HTTP Method")],-1),st=t("p",null,"When using the REST API to read multiple items by (very) advanced filters, you might run into the issue where the URL simply can\u2019t hold enough data to include the full query structure. In those cases, you can use the SEARCH HTTP method as a drop-in replacement for GET, where you\u2019re allowed to put the query into the request body as follows:",-1),nt=t("p",null,[t("strong",null,"Before:")],-1),et=t("pre",null,[t("code",null,`GET /items/articles?filter[title][_eq]=Hello World
`)],-1),at=t("p",null,[t("strong",null,"After:")],-1),lt=t("pre",null,[t("code",{class:"language-json"},[s(`SEARCH /items/articles

`),t("span",{class:"hljs-punctuation"},"{"),s(`
	`),t("span",{class:"hljs-attr"},'"query"'),t("span",{class:"hljs-punctuation"},":"),s(),t("span",{class:"hljs-punctuation"},"{"),s(`
		`),t("span",{class:"hljs-attr"},'"filter"'),t("span",{class:"hljs-punctuation"},":"),s(),t("span",{class:"hljs-punctuation"},"{"),s(`
			`),t("span",{class:"hljs-attr"},'"title"'),t("span",{class:"hljs-punctuation"},":"),s(),t("span",{class:"hljs-punctuation"},"{"),s(`
				`),t("span",{class:"hljs-attr"},'"_eq"'),t("span",{class:"hljs-punctuation"},":"),s(),t("span",{class:"hljs-string"},'"Hello World"'),s(`
			`),t("span",{class:"hljs-punctuation"},"}"),s(`
		`),t("span",{class:"hljs-punctuation"},"}"),s(`
	`),t("span",{class:"hljs-punctuation"},"}"),s(`
`),t("span",{class:"hljs-punctuation"},"}"),s(`
`)])],-1),ot=t("p",null,[s("There\u2019s a lot of discussion around whether or not to put a body in a GET request, to use POSTs to create search queries, or to rely on a different method altogether. As of right now, we\u2019ve chosen "),t("a",{href:"https://datatracker.ietf.org/doc/draft-ietf-httpbis-safe-method-w-body",target:"_blank",rel:"noopener noreferrer"},[s("to align with IETF\u2019s "),t("em",null,"HTTP SEARCH Method"),s(" specification")]),s(". While we recognize this is still a draft spec, the SEARCH method has been used extensively before in the WebDAV world ("),t("a",{href:"https://tools.ietf.org/html/rfc5323",target:"_blank",rel:"noopener noreferrer"},"spec"),s("), and compared to the other available options, it feels like the \u201Ccleanest\u201D and most correct to handle this moving forward. As with everything else, if you have any ideas, opinions, or concerns, "),t("a",{href:"https://github.com/directus/directus/discussions/new",target:"_blank",rel:"noopener noreferrer"},"we\u2019d love to hear your thoughts"),s(".")],-1),it=t("p",null,"Useful reading:",-1),ct=t("ul",null,[t("li",null,[t("a",{href:"https://datatracker.ietf.org/doc/draft-ietf-httpbis-safe-method-w-body",target:"_blank",rel:"noopener noreferrer"},[t("em",null,"HTTP SEARCH Method"),s(" (IETF, 2021)")])]),t("li",null,[t("a",{href:"https://httptoolkit.tech/blog/http-search-method",target:"_blank",rel:"noopener noreferrer"},[t("em",null,"Defining a new HTTP method: HTTP SEARCH"),s(" (Tim Perry, 2021)")])]),t("li",null,[t("a",{href:"https://stackoverflow.com/questions/978061/http-get-with-request-body",target:"_blank",rel:"noopener noreferrer"},[t("em",null,"HTTP GET with request body"),s(" (StackOverflow, 2009 and ongoing)")])]),t("li",null,[t("a",{href:"https://www.elastic.co/guide/en/elasticsearch/guide/current/_empty_search.html",target:"_blank",rel:"noopener noreferrer"},[t("em",null,"Elastic Search GET body usage"),s(" (elastic, n.d.)")])]),t("li",null,[t("a",{href:"https://evertpot.com/dropbox-post-api",target:"_blank",rel:"noopener noreferrer"},[t("em",null,"Dropbox starts using POST, and why this is poor API design."),s(" (Evert Pot, 2015)")])])],-1),rt=t("h2",{id:"system-data-in-graphql",tabindex:"-1"},[t("a",{class:"header-anchor",href:"#system-data-in-graphql"},"#"),s(" System data in GraphQL")],-1),ut=t("p",null,[s("Due to restrictions in GraphQL itself, it\u2019s impossible to properly scope/namespace system functionality from regular data access. In order to prevent any naming conflicts between user-created and system data, we\u2019ve scoped the access of the two into separate endpoints for user and system data respectively: "),t("code",null,"/graphql"),s(" and "),t("code",null,"/graphql/system"),s(". Both endpoints share the same underlying schema, so "),t("strong",null,"nested relations will work as expected"),s(" regardless if they \u201Ccross over\u201D between user and system data. The only difference in the two endpoints are the root query and mutation fields available.")],-1),ht=t("h2",{id:"error-codes",tabindex:"-1"},[t("a",{class:"header-anchor",href:"#error-codes"},"#"),s(" Error Codes")],-1),dt=t("p",null,"Below are the global error codes used within Directus, and what they mean.",-1),pt=t("table",null,[t("thead",null,[t("tr",null,[t("th",null,"Error Code"),t("th",null,"HTTP Status"),t("th",null,"Description")])]),t("tbody",null,[t("tr",null,[t("td",null,[t("code",null,"FAILED_VALIDATION")]),t("td",null,"400"),t("td",null,"Validation for this particular item failed")]),t("tr",null,[t("td",null,[t("code",null,"FORBIDDEN")]),t("td",null,"403"),t("td",null,"You are not allowed to do the current action")]),t("tr",null,[t("td",null,[t("code",null,"INVALID_TOKEN")]),t("td",null,"403"),t("td",null,"Provided token is invalid")]),t("tr",null,[t("td",null,[t("code",null,"TOKEN_EXPIRED")]),t("td",null,"401"),t("td",null,"Provided token is valid but has expired")]),t("tr",null,[t("td",null,[t("code",null,"INVALID_CREDENTIALS")]),t("td",null,"401"),t("td",null,"Username / password or access token is wrong")]),t("tr",null,[t("td",null,[t("code",null,"INVALID_IP")]),t("td",null,"401"),t("td",null,"Your IP address isn\u2019t allow-listed to be used with this user")]),t("tr",null,[t("td",null,[t("code",null,"INVALID_OTP")]),t("td",null,"401"),t("td",null,"Wrong OTP was provided")]),t("tr",null,[t("td",null,[t("code",null,"INVALID_PAYLOAD")]),t("td",null,"400"),t("td",null,"Provided payload is invalid")]),t("tr",null,[t("td",null,[t("code",null,"INVALID_QUERY")]),t("td",null,"400"),t("td",null,"The requested query parameters can not be used")]),t("tr",null,[t("td",null,[t("code",null,"UNSUPPORTED_MEDIA_TYPE")]),t("td",null,"415"),t("td",null,[s("Provided payload format or "),t("code",null,"Content-Type"),s(" header is unsupported")])]),t("tr",null,[t("td",null,[t("code",null,"REQUESTS_EXCEEDED")]),t("td",null,"429"),t("td",null,"Hit the rate limit")]),t("tr",null,[t("td",null,[t("code",null,"ROUTE_NOT_FOUND")]),t("td",null,"404"),t("td",null,"Endpoint does not exist")]),t("tr",null,[t("td",null,[t("code",null,"SERVICE_UNAVAILABLE")]),t("td",null,"503"),t("td",null,"Could not use external service")]),t("tr",null,[t("td",null,[t("code",null,"UNPROCESSABLE_ENTITY")]),t("td",null,"422"),t("td",null,"You tried doing something illegal")])])],-1),ft=t("div",{class:"warning hint"},[t("div",{class:"hint-title"},"Security"),t("p",null,[s("To prevent leaking which items exist, all actions for non-existing items will return a "),t("code",null,"FORBIDDEN"),s(" error.")])],-1),gt="API Reference",bt=!1,wt="An introduction to the REST and GraphQL APIs in Directus.",Tt="7 min read",Et="page-reference",vt={__name:"introduction",setup(mt,{expose:i}){const l={title:"API Reference",modularExtension:!1,description:"An introduction to the REST and GraphQL APIs in Directus.",readTime:"7 min read",pageClass:"page-reference"};return i({frontmatter:l}),(jt,_t)=>{const e=o("router-link"),c=o("docs-wrapper");return r(),u(c,{frontmatter:l},{default:n(()=>[t("div",h,[d,p,t("p",null,[s("The platform\u2019s API uses "),a(e,{to:"/docs/getting-started/introduction#database-mirroring"},{default:n(()=>[s("Database Mirroring")]),_:1}),s(" to dynamically generate REST endpoints and a GraphQL schema based on the connected database\u2019s architecture. Since these endpoints return data based on your specific schema and configured permissions, the input/output of the API differs greatly for individual installations.")]),f,m,j,_,t("p",null,[s("By default, all data in the system is off-limits for unauthenticated users. To gain access to protected data, you must "),a(e,{to:"/docs/reference/authentication#access-tokens"},{default:n(()=>[s("include an access token with every request")]),_:1}),s(", or "),a(e,{to:"/docs/getting-started/quickstart#_6-set-role-public-permissions"},{default:n(()=>[s("configure permissions for the public role")]),_:1}),s(".")]),y,t("ul",null,[t("li",null,[a(e,{to:"/docs/reference/authentication"},{default:n(()=>[s("Authenticating into the API")]),_:1})]),t("li",null,[a(e,{to:"/docs/reference/authentication#login"},{default:n(()=>[s("Login endpoint reference")]),_:1})])]),g,t("p",null,[s("Directus only retrieves the fields in your items that explicitly have been requested. Relational data can be retrieved nested by using "),a(e,{to:"/docs/reference/query#fields"},{default:n(()=>[s("the "),b,s(" parameter")]),_:1}),s(" in REST, or regular nested queries in GraphQL. This allows you to retrieve the author of your article included in the articles data, or fetch related log entry points for your app\u2019s analytics data for example.")]),w,T,E,v,A,k,I,P,x,D,S,R,q,L,N,O,C,H,U,G,M,V,F,Q,B,Y,W,z,K,X,J,Z,$,tt,st,nt,et,at,lt,ot,it,ct,rt,ut,ht,dt,pt,ft])]),_:1})}}};export{vt as default,wt as description,bt as modularExtension,Et as pageClass,Tt as readTime,gt as title};
