import{a as o,o as a,e as c,y as i,u as l,q as e}from"./runtime-core.esm-bundler.22ec0346.js";const u=l("div",{class:"markdown-body"},[l("blockquote",null,[l("p",null,"Custom API Hooks allow running custom logic when a specified event occurs within your project. There are different types of events to choose from.")]),l("h2",{id:"extension-entrypoint",tabindex:"-1"},[l("a",{class:"header-anchor",href:"#extension-entrypoint"},"#"),e(" Extension Entrypoint")]),l("p",null,[e("The entrypoint of your hook is the "),l("code",null,"index"),e(" file inside the "),l("code",null,"src/"),e(" folder of your extension package. It exports a register function to register one or more event listeners.")]),l("p",null,"Example of an entrypoint:"),l("pre",null,[l("code",{class:"language-js"},[l("span",{class:"hljs-keyword"},"export"),e(),l("span",{class:"hljs-keyword"},"default"),e(` ({ filter, action }) => {
	`),l("span",{class:"hljs-title function_"},"filter"),e("("),l("span",{class:"hljs-string"},"'items.create'"),e(", "),l("span",{class:"hljs-function"},"() =>"),e(` {
		`),l("span",{class:"hljs-variable language_"},"console"),e("."),l("span",{class:"hljs-title function_"},"log"),e("("),l("span",{class:"hljs-string"},"'Creating Item!'"),e(`);
	});

	`),l("span",{class:"hljs-title function_"},"action"),e("("),l("span",{class:"hljs-string"},"'items.create'"),e(", "),l("span",{class:"hljs-function"},"() =>"),e(` {
		`),l("span",{class:"hljs-variable language_"},"console"),e("."),l("span",{class:"hljs-title function_"},"log"),e("("),l("span",{class:"hljs-string"},"'Item created!'"),e(`);
	});
};
`)])]),l("h2",{id:"events",tabindex:"-1"},[l("a",{class:"header-anchor",href:"#events"},"#"),e(" Events")]),l("p",null,"Your hook can trigger on a variety of different events. An event is defined by its type and its name."),l("p",null,"There are four event types to choose from:"),l("ul",null,[l("li",null,[l("a",{href:"#filter"},"Filter")]),l("li",null,[l("a",{href:"#action"},"Action")]),l("li",null,[l("a",{href:"#init"},"Init")]),l("li",null,[l("a",{href:"#schedule"},"Schedule")])]),l("p",null,"Use filter hooks when you want the hook to fire before the event. Use action hooks when you want the hook to fire after the event."),l("h3",{id:"filter",tabindex:"-1"},[l("a",{class:"header-anchor",href:"#filter"},"#"),e(" Filter")]),l("p",null,"Filter hooks act on the event\u2019s payload before the event is fired. They allow you to check, modify, or cancel an event."),l("p",null,[e("Below is an example of canceling a "),l("code",null,"create"),e(" event by throwing a standard Directus exception.")]),l("pre",null,[l("code",{class:"language-js"},[l("span",{class:"hljs-keyword"},"export"),e(),l("span",{class:"hljs-keyword"},"default"),e(` ({ filter }, { exceptions }) => {
	`),l("span",{class:"hljs-keyword"},"const"),e(" { "),l("span",{class:"hljs-title class_"},"InvalidPayloadException"),e(` } = exceptions;

	`),l("span",{class:"hljs-title function_"},"filter"),e("("),l("span",{class:"hljs-string"},"'items.create'"),e(", "),l("span",{class:"hljs-keyword"},"async"),e(` (input) => {
		`),l("span",{class:"hljs-keyword"},"if"),e(" ("),l("span",{class:"hljs-variable constant_"},"LOGIC_TO_CANCEL_EVENT"),e(`) {
			`),l("span",{class:"hljs-keyword"},"throw"),e(),l("span",{class:"hljs-keyword"},"new"),e(),l("span",{class:"hljs-title class_"},"InvalidPayloadException"),e("("),l("span",{class:"hljs-variable constant_"},"WHAT_IS_WRONG"),e(`);
		}

		`),l("span",{class:"hljs-keyword"},"return"),e(` input;
	});
};
`)])]),l("p",null,"The filter register function receives two parameters:"),l("ul",null,[l("li",null,"The event name"),l("li",null,"A callback function that is executed whenever the event fires.")]),l("p",null,"The callback function itself receives three parameters:"),l("ul",null,[l("li",null,"The modifiable payload"),l("li",null,"An event-specific meta object"),l("li",null,"A context object")]),l("p",null,"The context object has the following properties:"),l("ul",null,[l("li",null,[l("code",null,"database"),e(" \u2014 The current database transaction")]),l("li",null,[l("code",null,"schema"),e(" \u2014 The current API schema in use")]),l("li",null,[l("code",null,"accountability"),e(" \u2014 Information about the current user")])]),l("div",{class:"warning hint"},[l("div",{class:"hint-title"},"Performance"),l("p",null,[e("Filters can impact performance when not carefully implemented, as they are executed in a blocking manner. This applies in particular to filters firing on "),l("code",null,"read"),e(" events, where a single request can result in a large amount of database reads.")])]),l("h3",{id:"action",tabindex:"-1"},[l("a",{class:"header-anchor",href:"#action"},"#"),e(" Action")]),l("p",null,"Action hooks execute after a defined event and receive data related to the event. Use action hooks when you need to automate responses to CRUD events on items or server actions."),l("p",null,"The action register function receives two parameters:"),l("ul",null,[l("li",null,"The event name"),l("li",null,"A callback function that is executed whenever the event fires.")]),l("p",null,"The callback function itself receives two parameters:"),l("ul",null,[l("li",null,"An event-specific meta object"),l("li",null,"A context object")]),l("p",null,"The context object has the following properties:"),l("ul",null,[l("li",null,[l("code",null,"database"),e(" \u2014 The current database transaction")]),l("li",null,[l("code",null,"schema"),e(" \u2014 The current API schema in use")]),l("li",null,[l("code",null,"accountability"),e(" \u2014 Information about the current user")])]),l("h3",{id:"init",tabindex:"-1"},[l("a",{class:"header-anchor",href:"#init"},"#"),e(" Init")]),l("p",null,"Init hooks execute at a defined point within the life cycle of Directus. Use init hook objects to inject logic into internal services."),l("p",null,"The init register function receives two parameters:"),l("ul",null,[l("li",null,"The event name"),l("li",null,"A callback function that is executed whenever the event fires.")]),l("p",null,"The callback function itself receives one parameter:"),l("ul",null,[l("li",null,"An event-specific meta object")]),l("h3",{id:"schedule",tabindex:"-1"},[l("a",{class:"header-anchor",href:"#schedule"},"#"),e(" Schedule")]),l("p",null,[e("Schedule hooks execute at certain points in time rather than when Directus performs a specific action. This is supported through "),l("a",{href:"https://www.npmjs.com/package/node-cron",target:"_blank",rel:"noopener noreferrer"},[l("code",null,"node-cron")]),e(".")]),l("p",null,[e("To set up a scheduled event, provide a cron statement as the first parameter to the "),l("code",null,"schedule()"),e(" function. For example "),l("code",null,"schedule('15 14 1 * *', <...>)"),e(" (at 14:15 on day-of-month 1) or "),l("code",null,"schedule('5 4 * * sun', <...>)"),e(" (at 04:05 on Sunday).")]),l("p",null,"Below is an example of registering a schedule hook."),l("pre",null,[l("code",{class:"language-js"},[l("span",{class:"hljs-keyword"},"import"),e(" axios "),l("span",{class:"hljs-keyword"},"from"),e(),l("span",{class:"hljs-string"},"'axios'"),e(`;

`),l("span",{class:"hljs-keyword"},"export"),e(),l("span",{class:"hljs-keyword"},"default"),e(` ({ schedule }) => {
	`),l("span",{class:"hljs-title function_"},"schedule"),e("("),l("span",{class:"hljs-string"},"'*/15 * * * *'"),e(", "),l("span",{class:"hljs-keyword"},"async"),e(` () => {
		`),l("span",{class:"hljs-keyword"},"await"),e(" axios."),l("span",{class:"hljs-title function_"},"post"),e("("),l("span",{class:"hljs-string"},"'http://example.com/webhook'"),e(", { "),l("span",{class:"hljs-attr"},"message"),e(": "),l("span",{class:"hljs-string"},"'Another 15 minutes passed...'"),e(` });
	});
};
`)])]),l("h2",{id:"available-events",tabindex:"-1"},[l("a",{class:"header-anchor",href:"#available-events"},"#"),e(" Available Events")]),l("h3",{id:"filter-events",tabindex:"-1"},[l("a",{class:"header-anchor",href:"#filter-events"},"#"),e(" Filter Events")]),l("table",null,[l("thead",null,[l("tr",null,[l("th",null,"Name"),l("th",null,"Payload"),l("th",null,"Meta")])]),l("tbody",null,[l("tr",null,[l("td",null,[l("code",null,"request.not_found")]),l("td",null,[l("code",null,"false")]),l("td",null,[l("code",null,"request"),e(", "),l("code",null,"response")])]),l("tr",null,[l("td",null,[l("code",null,"request.error")]),l("td",null,"The request errors"),l("td",null,"\u2013")]),l("tr",null,[l("td",null,[l("code",null,"database.error")]),l("td",null,"The database error"),l("td",null,[l("code",null,"client")])]),l("tr",null,[l("td",null,[l("code",null,"auth.login")]),l("td",null,"The login payload"),l("td",null,[l("code",null,"status"),e(", "),l("code",null,"user"),e(", "),l("code",null,"provider")])]),l("tr",null,[l("td",null,[l("code",null,"auth.jwt")]),l("td",null,"The auth token"),l("td",null,[l("code",null,"status"),e(", "),l("code",null,"user"),e(", "),l("code",null,"provider"),e(", "),l("code",null,"type")])]),l("tr",null,[l("td",null,[l("code",null,"authenticate")]),l("td",null,"The empty accountability object"),l("td",null,[l("code",null,"req")])]),l("tr",null,[l("td",null,[l("code",null,"(<collection>.)items.query")]),l("td",null,"The items query"),l("td",null,[l("code",null,"collection")])]),l("tr",null,[l("td",null,[l("code",null,"(<collection>.)items.read")]),l("td",null,"The read item"),l("td",null,[l("code",null,"query"),e(", "),l("code",null,"collection")])]),l("tr",null,[l("td",null,[l("code",null,"(<collection>.)items.create")]),l("td",null,"The new item"),l("td",null,[l("code",null,"collection")])]),l("tr",null,[l("td",null,[l("code",null,"(<collection>.)items.update")]),l("td",null,"The updated item"),l("td",null,[l("code",null,"keys"),e(", "),l("code",null,"collection")])]),l("tr",null,[l("td",null,[l("code",null,"(<collection>.)items.delete")]),l("td",null,"The keys of the item"),l("td",null,[l("code",null,"collection")])]),l("tr",null,[l("td",null,[l("code",null,"<system-collection>.create")]),l("td",null,"The new item"),l("td",null,[l("code",null,"collection")])]),l("tr",null,[l("td",null,[l("code",null,"<system-collection>.update")]),l("td",null,"The updated item"),l("td",null,[l("code",null,"keys"),e(", "),l("code",null,"collection")])]),l("tr",null,[l("td",null,[l("code",null,"<system-collection>.delete")]),l("td",null,"The keys of the item"),l("td",null,[l("code",null,"collection")])])])]),l("div",{class:"tip hint"},[l("div",{class:"hint-title"},"System Collections"),l("p",null,[l("code",null,"<system-collection>"),e(" should be replaced with one of the system collection names "),l("code",null,"activity"),e(", "),l("code",null,"collections"),e(", "),l("code",null,"dashboards"),e(", "),l("code",null,"fields"),e(", "),l("code",null,"files"),e(" (except create/update), "),l("code",null,"flows"),e(", "),l("code",null,"folders"),e(", "),l("code",null,"migrations"),e(", "),l("code",null,"notifications"),e(", "),l("code",null,"operations"),e(", "),l("code",null,"panels"),e(", "),l("code",null,"permissions"),e(", "),l("code",null,"presets"),e(", "),l("code",null,"relations"),e(", "),l("code",null,"revisions"),e(", "),l("code",null,"roles"),e(", "),l("code",null,"sessions"),e(", "),l("code",null,"settings"),e(", "),l("code",null,"shares"),e(", "),l("code",null,"users"),e(" or "),l("code",null,"webhooks"),e(".")])]),l("h3",{id:"action-events",tabindex:"-1"},[l("a",{class:"header-anchor",href:"#action-events"},"#"),e(" Action Events")]),l("table",null,[l("thead",null,[l("tr",null,[l("th",null,"Name"),l("th",null,"Meta")])]),l("tbody",null,[l("tr",null,[l("td",null,[l("code",null,"server.start")]),l("td",null,[l("code",null,"server")])]),l("tr",null,[l("td",null,[l("code",null,"server.stop")]),l("td",null,[l("code",null,"server")])]),l("tr",null,[l("td",null,[l("code",null,"response")]),l("td",null,[l("code",null,"request"),e(", "),l("code",null,"response"),e(", "),l("code",null,"ip"),e(", "),l("code",null,"duration"),e(", "),l("code",null,"finished")])]),l("tr",null,[l("td",null,[l("code",null,"auth.login")]),l("td",null,[l("code",null,"payload"),e(", "),l("code",null,"status"),e(", "),l("code",null,"user"),e(", "),l("code",null,"provider")])]),l("tr",null,[l("td",null,[l("code",null,"files.upload")]),l("td",null,[l("code",null,"payload"),e(", "),l("code",null,"key"),e(", "),l("code",null,"collection")])]),l("tr",null,[l("td",null,[l("code",null,"(<collection>.)items.read")]),l("td",null,[l("code",null,"payload"),e(", "),l("code",null,"query"),e(", "),l("code",null,"collection")])]),l("tr",null,[l("td",null,[l("code",null,"(<collection>.)items.create")]),l("td",null,[l("code",null,"payload"),e(", "),l("code",null,"key"),e(", "),l("code",null,"collection")])]),l("tr",null,[l("td",null,[l("code",null,"(<collection>.)items.update")]),l("td",null,[l("code",null,"payload"),e(", "),l("code",null,"keys"),e(", "),l("code",null,"collection")])]),l("tr",null,[l("td",null,[l("code",null,"(<collection>.)items.delete")]),l("td",null,[l("code",null,"keys"),e(", "),l("code",null,"collection")])]),l("tr",null,[l("td",null,[l("code",null,"(<collection>.)items.sort")]),l("td",null,[l("code",null,"collection"),e(", "),l("code",null,"item"),e(", "),l("code",null,"to")])]),l("tr",null,[l("td",null,[l("code",null,"<system-collection>.create")]),l("td",null,[l("code",null,"payload"),e(", "),l("code",null,"key"),e(", "),l("code",null,"collection")])]),l("tr",null,[l("td",null,[l("code",null,"<system-collection>.update")]),l("td",null,[l("code",null,"payload"),e(", "),l("code",null,"keys"),e(", "),l("code",null,"collection")])]),l("tr",null,[l("td",null,[l("code",null,"<system-collection>.delete")]),l("td",null,[l("code",null,"keys"),e(", "),l("code",null,"collection")])])])]),l("div",{class:"tip hint"},[l("div",{class:"hint-title"},"System Collections"),l("p",null,[l("code",null,"<system-collection>"),e(" should be replaced with one of the system collection names "),l("code",null,"activity"),e(", "),l("code",null,"collections"),e(", "),l("code",null,"dashboards"),e(", "),l("code",null,"fields"),e(", "),l("code",null,"files"),e(" (except create/update), "),l("code",null,"flows"),e(", "),l("code",null,"folders"),e(", "),l("code",null,"migrations"),e(", "),l("code",null,"notifications"),e(", "),l("code",null,"operations"),e(", "),l("code",null,"panels"),e(", "),l("code",null,"permissions"),e(", "),l("code",null,"presets"),e(", "),l("code",null,"relations"),e(", "),l("code",null,"revisions"),e(", "),l("code",null,"roles"),e(", "),l("code",null,"sessions"),e(", "),l("code",null,"settings"),e(", "),l("code",null,"shares"),e(", "),l("code",null,"users"),e(" or "),l("code",null,"webhooks"),e(".")])]),l("h3",{id:"init-events",tabindex:"-1"},[l("a",{class:"header-anchor",href:"#init-events"},"#"),e(" Init Events")]),l("table",null,[l("thead",null,[l("tr",null,[l("th",null,"Name"),l("th",null,"Meta")])]),l("tbody",null,[l("tr",null,[l("td",null,[l("code",null,"cli.before")]),l("td",null,[l("code",null,"program")])]),l("tr",null,[l("td",null,[l("code",null,"cli.after")]),l("td",null,[l("code",null,"program")])]),l("tr",null,[l("td",null,[l("code",null,"app.before")]),l("td",null,[l("code",null,"app")])]),l("tr",null,[l("td",null,[l("code",null,"app.after")]),l("td",null,[l("code",null,"app")])]),l("tr",null,[l("td",null,[l("code",null,"routes.before")]),l("td",null,[l("code",null,"app")])]),l("tr",null,[l("td",null,[l("code",null,"routes.after")]),l("td",null,[l("code",null,"app")])]),l("tr",null,[l("td",null,[l("code",null,"routes.custom.before")]),l("td",null,[l("code",null,"app")])]),l("tr",null,[l("td",null,[l("code",null,"routes.custom.after")]),l("td",null,[l("code",null,"app")])]),l("tr",null,[l("td",null,[l("code",null,"middlewares.before")]),l("td",null,[l("code",null,"app")])]),l("tr",null,[l("td",null,[l("code",null,"middlewares.after")]),l("td",null,[l("code",null,"app")])])])]),l("h2",{id:"register-function",tabindex:"-1"},[l("a",{class:"header-anchor",href:"#register-function"},"#"),e(" Register Function")]),l("p",null,"The register function receives an object containing the type-specific register functions as the first parameter:"),l("ul",null,[l("li",null,[l("code",null,"filter"),e(" \u2014 Listen for a filter event")]),l("li",null,[l("code",null,"action"),e(" \u2014 Listen for an action event")]),l("li",null,[l("code",null,"init"),e(" \u2014 Listen for an init event")]),l("li",null,[l("code",null,"schedule"),e(" \u2014 Execute a function at certain points in time")])]),l("p",null,"The second parameter is a context object with the following properties:"),l("ul",null,[l("li",null,[l("code",null,"services"),e(" \u2014 All API internal services")]),l("li",null,[l("code",null,"exceptions"),e(" \u2014 API exception objects that can be used for throwing \u201Cproper\u201D errors")]),l("li",null,[l("code",null,"database"),e(" \u2014 Knex instance that is connected to the current database")]),l("li",null,[l("code",null,"getSchema"),e(" \u2014 Async function that reads the full available schema for use in services")]),l("li",null,[l("code",null,"env"),e(" \u2014 Parsed environment variables")]),l("li",null,[l("code",null,"logger"),e(" \u2014 "),l("a",{href:"https://github.com/pinojs/pino",target:"_blank",rel:"noopener noreferrer"},"Pino"),e(" instance.")]),l("li",null,[l("code",null,"emitter"),e(" \u2014 "),l("a",{href:"https://github.com/directus/directus/blob/main/api/src/emitter.ts",target:"_blank",rel:"noopener noreferrer"},"Event emitter"),e(" instance that can be used to trigger custom events for other extensions.")])]),l("div",{class:"warning hint"},[l("div",{class:"hint-title"},"Event loop"),l("p",null,"When implementing custom events using the emitter make sure you never directly or indirectly emit the same event your hook is currently handling as that would result in an infinite loop!")]),l("h2",{id:"example%3A-sync-with-external",tabindex:"-1"},[l("a",{class:"header-anchor",href:"#example%3A-sync-with-external"},"#"),e(" Example: Sync with External")]),l("pre",null,[l("code",{class:"language-js"},[l("span",{class:"hljs-keyword"},"import"),e(" axios "),l("span",{class:"hljs-keyword"},"from"),e(),l("span",{class:"hljs-string"},"'axios'"),e(`;

`),l("span",{class:"hljs-keyword"},"export"),e(),l("span",{class:"hljs-keyword"},"default"),e(` ({ filter }, { services, exceptions }) => {
	`),l("span",{class:"hljs-keyword"},"const"),e(" { "),l("span",{class:"hljs-title class_"},"MailService"),e(` } = services;
	`),l("span",{class:"hljs-keyword"},"const"),e(" { "),l("span",{class:"hljs-title class_"},"ServiceUnavailableException"),e(", "),l("span",{class:"hljs-title class_"},"ForbiddenException"),e(` } = exceptions;

	`),l("span",{class:"hljs-comment"},"// Sync with external recipes service, cancel creation on failure"),e(`
	`),l("span",{class:"hljs-title function_"},"filter"),e("("),l("span",{class:"hljs-string"},"'items.create'"),e(", "),l("span",{class:"hljs-keyword"},"async"),e(` (input, { collection }, { schema, database }) => {
		`),l("span",{class:"hljs-keyword"},"if"),e(" (collection !== "),l("span",{class:"hljs-string"},"'recipes'"),e(") "),l("span",{class:"hljs-keyword"},"return"),e(` input;

		`),l("span",{class:"hljs-keyword"},"const"),e(" mailService = "),l("span",{class:"hljs-keyword"},"new"),e(),l("span",{class:"hljs-title class_"},"MailService"),e("({ schema, "),l("span",{class:"hljs-attr"},"knex"),e(`: database });

		`),l("span",{class:"hljs-keyword"},"try"),e(` {
			`),l("span",{class:"hljs-keyword"},"await"),e(" axios."),l("span",{class:"hljs-title function_"},"post"),e("("),l("span",{class:"hljs-string"},"'https://example.com/recipes'"),e(`, input);
			`),l("span",{class:"hljs-keyword"},"await"),e(" mailService."),l("span",{class:"hljs-title function_"},"send"),e(`({
				`),l("span",{class:"hljs-attr"},"to"),e(": "),l("span",{class:"hljs-string"},"'person@example.com'"),e(`,
				`),l("span",{class:"hljs-attr"},"template"),e(`: {
					`),l("span",{class:"hljs-attr"},"name"),e(": "),l("span",{class:"hljs-string"},"'item-created'"),e(`,
					`),l("span",{class:"hljs-attr"},"data"),e(`: {
						`),l("span",{class:"hljs-attr"},"collection"),e(`: collection,
					},
				},
			});
		} `),l("span",{class:"hljs-keyword"},"catch"),e(` (error) {
			`),l("span",{class:"hljs-keyword"},"throw"),e(),l("span",{class:"hljs-keyword"},"new"),e(),l("span",{class:"hljs-title class_"},"ServiceUnavailableException"),e(`(error);
		}

		input.`),l("span",{class:"hljs-property"},"syncedWithExample"),e(" = "),l("span",{class:"hljs-literal"},"true"),e(`;

		`),l("span",{class:"hljs-keyword"},"return"),e(` input;
	});
};
`)])])],-1),f="Custom API Hooks",m=!0,y="A guide on how to build custom hooks in Directus.",v="7 min read",j={__name:"hooks",setup(r,{expose:t}){const n={title:"Custom API Hooks",modularExtension:!0,description:"A guide on how to build custom hooks in Directus.",readTime:"7 min read"};return t({frontmatter:n}),(d,h)=>{const s=o("docs-wrapper");return a(),c(s,{frontmatter:n},{default:i(()=>[u]),_:1})}}};export{j as default,y as description,m as modularExtension,v as readTime,f as title};
