import{a as r,o as d,e as c,y as o,u as e,q as t,z as s}from"./runtime-core.esm-bundler.22ec0346.js";const u={class:"markdown-body"},h=e("h2",{id:"asset-storage",tabindex:"-1"},[e("a",{class:"header-anchor",href:"#asset-storage"},"#"),t(" Asset Storage")],-1),p=e("p",null,[t("Directus Core allows asset storage for any type of file. This applies to all Cloud Projects. However, on Directus Cloud, certain hard technical limits apply to file uploads, such as limits on size per asset and total asset storage per Project. For more details, see "),e("a",{href:"https://directus.io/cloud-policies#",target:"_blank",rel:"noopener noreferrer"},"Cloud Policies"),t(".")],-1),m=e("h2",{id:"automatic-updates",tabindex:"-1"},[e("a",{class:"header-anchor",href:"#automatic-updates"},"#"),t(" Automatic Updates")],-1),f=e("p",null,[t("Software updates on any app can be a time-consuming chore, taking developer energy and focus away from core business logic. Cloud Projects are updated every two weeks in rolling releases "),e("em",null,"(i.e. done with no downtime)"),t(". These updates keep your Project on the latest version and fully up to date with all "),e("a",{href:"#cloud-exclusives"},"Cloud Exclusives"),t(", dependencies and security patches.")],-1),_=e("div",{class:"tip hint"},[e("div",{class:"hint-title"},"Version-locking"),e("p",null,"Version-locking is available on Enterprise Projects.")],-1),g=e("h2",{id:"backups",tabindex:"-1"},[e("a",{class:"header-anchor",href:"#backups"},"#"),t(" Backups")],-1),y=e("p",null,[t("By default, file assets and databases are backed up once per day on all Standard and Enterprise Projects. Additionally, Enterprise customers can work with our team for more tailored backup solutions. In the event of an emergency, such as your Node crashing, don\u2019t worry! Your data will be safe. If you need access to your backed-up data, "),e("a",{href:"https://directus.io/contact",target:"_blank",rel:"noopener noreferrer"},"contact us"),t(".")],-1),b=e("div",{class:"warning hint"},[e("p",null,"Please note that Community Projects are not backed up.")],-1),w=e("h2",{id:"caching",tabindex:"-1"},[e("a",{class:"header-anchor",href:"#caching"},"#"),t(" Caching")],-1),v=e("p",null,[t("Caching is enabled on Cloud Projects. Public data is cached in the CDN for a short period of time. All Directus Cloud Projects are running behind a "),e("a",{href:"#global-cdn"},"Global CDN"),t(", but Enterprise Projects offer advanced caching strategies, as well.")],-1),P=e("h2",{id:"cloud-exclusives",tabindex:"-1"},[e("a",{class:"header-anchor",href:"#cloud-exclusives"},"#"),t(" Cloud Exclusives")],-1),C=e("p",null,[t("Our managed service includes several Cloud-Exclusive "),e("a",{href:"#extensions"},"Extensions"),t(" that are not available to self-hosted users. It\u2019s important to note that these are "),e("strong",null,"not"),t(" paywalled Core features, but are progressive enhancements that add to the base offering. Our team is always adding new exclusives, so check back often to stay up to date with the latest and greatest features! Cloud Exclusives development is managed by the Core Team, so these will stay up to date with the "),e("a",{href:"#automatic-updates"},"latest version of Directus"),t(". Examples include:")],-1),x=e("ul",null,[e("li",null,"Kanban Layout")],-1),j=e("div",{class:"tip hint"},[e("p",null,[t("Looking to sponsor development of an Extension or Cloud Exclusive? "),e("a",{href:"https://directus.io/contact",target:"_blank",rel:"noopener noreferrer"},"Contact Us"),t(".")])],-1),k=e("h2",{id:"data-portability",tabindex:"-1"},[e("a",{class:"header-anchor",href:"#data-portability"},"#"),t(" Data Portability")],-1),S=e("p",null,"Directus Core is totally detached from the database. Data can be cleanly imported and exported on Projects with the API via the schema endpoints.",-1),E=e("div",{class:"tip hint"},[e("div",{class:"hint-title"},"Enterprise Clients"),e("p",null,[t("The Directus Team will help you work through this process on all "),e("a",{href:"https://directus.io/contact",target:"_blank",rel:"noopener noreferrer"},"Enterprise Projects"),t(".")])],-1),D=e("h2",{id:"datacenter-regions",tabindex:"-1"},[e("a",{class:"header-anchor",href:"#datacenter-regions"},"#"),t(" Datacenter Regions")],-1),T=e("p",null,"The location you choose to host your Project in can have a measurable impact. To help optimize your Project and meet any local data compliance laws such as GDPR, Standard and Enterprise offer multiple Datacenter regions to host from. There are 19 regions available for Enterprise Projects, 3 for Standard Projects, and 1 for Community Projects:",-1),A=e("table",null,[e("tr",null,[e("th",null,"Region"),e("th",null,"Enterprise"),e("th",null,"Standard"),e("th",null,"Community")]),e("tr",null,[e("td",null,"United States, East"),e("td",null,"\u2705"),e("td",null,"\u2705"),e("td",null,"\u2705")]),e("tr",null,[e("td",null,"Europe, Frankfurt"),e("td",null,"\u2705"),e("td",null,"\u2705"),e("td")]),e("tr",null,[e("td",null,"Asia Pacific, Singapore"),e("td",null,"\u2705"),e("td",null,"\u2705"),e("td")]),e("tr",null,[e("td",null,"United States, West"),e("td",null,"\u2705"),e("td"),e("td")]),e("tr",null,[e("td",null,"Africa, Cape Town"),e("td",null,"\u2705"),e("td"),e("td")]),e("tr",null,[e("td",null,"Asia Pacific, Hong Kong"),e("td",null,"\u2705"),e("td"),e("td")]),e("tr",null,[e("td",null,"Asia Pacific, Jakarta"),e("td",null,"\u2705"),e("td"),e("td")]),e("tr",null,[e("td",null,"Asia Pacific, Mumbai"),e("td",null,"\u2705"),e("td"),e("td")]),e("tr",null,[e("td",null,"Asia Pacific, Osaka"),e("td",null,"\u2705"),e("td"),e("td")]),e("tr",null,[e("td",null,"Asia Pacific, Seoul"),e("td",null,"\u2705"),e("td"),e("td")]),e("tr",null,[e("td",null,"Asia Pacific, Sydney"),e("td",null,"\u2705"),e("td"),e("td")]),e("tr",null,[e("td",null,"Asia Pacific, Tokyo"),e("td",null,"\u2705"),e("td"),e("td")]),e("tr",null,[e("td",null,"Canada, Central"),e("td",null,"\u2705"),e("td"),e("td")]),e("tr",null,[e("td",null,"Europe, Ireland"),e("td",null,"\u2705"),e("td"),e("td")]),e("tr",null,[e("td",null,"Europe, London"),e("td",null,"\u2705"),e("td"),e("td")]),e("tr",null,[e("td",null,"Europe, Paris"),e("td",null,"\u2705"),e("td"),e("td")]),e("tr",null,[e("td",null,"Europe, Stockholm"),e("td",null,"\u2705"),e("td"),e("td")]),e("tr",null,[e("td",null,"Middle East, Bahrain"),e("td",null,"\u2705"),e("td"),e("td")]),e("tr",null,[e("td",null,"South America, S\xE3o Paulo"),e("td",null,"\u2705"),e("td"),e("td")])],-1),N=e("h2",{id:"encryption-and-security",tabindex:"-1"},[e("a",{class:"header-anchor",href:"#encryption-and-security"},"#"),t(" Encryption and Security")],-1),I=e("p",null,[e("a",{href:"#asset-storage"},"Asset Storage"),t(", data storage and in-transit encryption are included on all Cloud Projects. All data at rest remains encrypted, and HTTPS/TLS protocols are enabled on all in-transit data. Cloud Projects are created with secure and safe "),e("a",{href:"#multi-tenancy"},"tenancy architectures"),t(".")],-1),q=e("div",{class:"tip hint"},[e("div",{class:"hint-title"},"Directus Core Security Features"),e("p",null,"Directus core comes with even more security features out-of-the-box, including IP address whitelabeling, MFA enabling, SSO options, customization for Password Rule requirements and the flexibility to use any access token paradigm desired.")],-1),R=e("h2",{id:"extensions",tabindex:"-1"},[e("a",{class:"header-anchor",href:"#extensions"},"#"),t(" Extensions")],-1),G=e("em",null,"Extension",-1),L=e("p",null,[t("All Cloud Projects have access to the "),e("a",{href:"#cloud-exclusives"},"Cloud Exclusive Extensions"),t(", which are developed and maintained by the Core Team. Enterprise Projects get all Cloud Exclusives, but also have the option to implement their own custom Extensions as needed.")],-1),B=e("h2",{id:"global-cdn",tabindex:"-1"},[e("a",{class:"header-anchor",href:"#global-cdn"},"#"),t(" Global CDN")],-1),H=e("p",null,"A Global CDN is provided for all Cloud Projects, out-of-the-box, with over 300 cache locations. This means assets and data will be delivered with the lowest possible latency.",-1),F=e("h2",{id:"infrastructure",tabindex:"-1"},[e("a",{class:"header-anchor",href:"#infrastructure"},"#"),t(" Infrastructure")],-1),z=e("a",{href:"#multi-tenancy"},"database",-1),M=e("a",{href:"#nodes"},"serverless nodes",-1),U=e("a",{href:"#asset-storage"},"asset storage",-1),V=e("a",{href:"#global-cdn"},"global CDN",-1),O=e("a",{href:"https://directus.io/pricing",target:"_blank",rel:"noopener noreferrer"},"Pricing page",-1),Y=e("h2",{id:"nodes",tabindex:"-1"},[e("a",{class:"header-anchor",href:"#nodes"},"#"),t(" Nodes")],-1),W=e("p",null,"When you configure a project on Directus Cloud, you get to choose processing power of its Nodes as well as the number of Nodes it runs on. You can configure and reconfigure Nodes to meet traffic needs at any scale.",-1),K=e("p",null,[t("In general, there are two approaches to scale performance: vertical-scaling and horizontal-scaling. Vertical-scaling refers to the use of improved hardware "),e("em",null,"(e.g. better CPUs and more RAM)"),t(" to scale up. In Directus Cloud, configuring the Node Type will provide vertical-scaling. Horizontal-scaling refers to increasing the number of Nodes to scale up. In Directus Cloud, adding more Reserved Nodes will provide horizontal-scaling.")],-1),J=e("h3",{id:"node-types",tabindex:"-1"},[e("a",{class:"header-anchor",href:"#node-types"},"#"),t(" Node Types")],-1),Q=e("p",null,"Each Node Type provides a different level of processing power.",-1),X=e("strong",null,"Community",-1),Z=e("br",null,null,-1),$=e("li",null,[e("p",null,[e("strong",null,"Lite"),e("br"),t(" Lite Nodes are the basic Node Type offered on Standard Projects. These Nodes are the right choice for most small- to medium- scale, production-ready use cases.")])],-1),ee=e("li",null,[e("p",null,[e("strong",null,"General Purpose Tier"),e("br"),t(" General Purpose Tier Nodes provide better performance under certain conditions, such as for handling Image transformations as well as fetching deeply nested or complex relationships via the API.")])],-1),te=e("li",null,[e("p",null,[e("strong",null,"Enterprise"),e("br"),t(" Configuration options are flexible and customizable, tailored to your Project\u2019s needs.")])],-1),oe=e("h3",{id:"reserved-nodes",tabindex:"-1"},[e("a",{class:"header-anchor",href:"#reserved-nodes"},"#"),t(" Reserved Nodes")],-1),ne=e("strong",null,"Reserved Nodes",-1),se=e("h2",{id:"quotas",tabindex:"-1"},[e("a",{class:"header-anchor",href:"#quotas"},"#"),t(" Quotas")],-1),ae=e("p",null,[t("Directus does not impose "),e("em",null,"arbitrary"),t(" software-based limits of any kind. So for things like Collections, Roles or Users - whether you have 10 or 10,000 of them - you are free to build out your Project as needed, with no up-charge. However, actual Project performance is going to depend on Node configuration, so there are hard technical limits. For details, see "),e("a",{href:"https://directus.io/cloud-policies",target:"_blank",rel:"noopener noreferrer"},"Cloud Policies"),t(".")],-1),re=e("h2",{id:"rate-limiting",tabindex:"-1"},[e("a",{class:"header-anchor",href:"#rate-limiting"},"#"),t(" Rate Limiting")],-1),ie=e("p",null,"Rate limiting refers to technical limitations within Directus Cloud as well as Cloud Projects. You will encounter the following API request limits at each node tier.",-1),le=e("table",null,[e("thead",null,[e("tr",null,[e("th",null,"Tier"),e("th",null,"Limit")])]),e("tbody",null,[e("tr",null,[e("td",null,"Community"),e("td",null,[t("10 requests per second per IP "),e("em",null,"(50 per second max)")])]),e("tr",null,[e("td",null,"Standard (Lite)"),e("td",null,"25 requests per second per node per IP")]),e("tr",null,[e("td",null,"Standard (General Purpose)"),e("td",null,"50 requests per second per node per IP")]),e("tr",null,[e("td",null,"Enterprise"),e("td",null,"100 requests per second per node per IP")])])],-1),de=e("div",{class:"tip hint"},[e("p",null,[t("These limits are additive and load balanced. For example, a Standard Project with two General Purpose nodes would get 100 requests per second per IP "),e("code",null,"50 requests * 2 nodes = 100"),t(".")])],-1),ce=e("div",{class:"tip hint"},[e("div",{class:"hint-title"},"Learn More"),e("p",null,[t("For details on other limitations, please see "),e("a",{href:"https://directus.io/cloud-policies/#",target:"_blank",rel:"noopener noreferrer"},"Cloud Policies"),t(".")])],-1),ue=e("h2",{id:"support-options",tabindex:"-1"},[e("a",{class:"header-anchor",href:"#support-options"},"#"),t(" Support Options")],-1),he=e("p",null,"There are three types of support for Directus:",-1),pe=e("h3",{id:"community-support",tabindex:"-1"},[e("a",{class:"header-anchor",href:"#community-support"},"#"),t(" Community Support")],-1),me=e("p",null,[t("Because Directus is an open-source Project, you\u2019re encouraged to reach out to the Community for help on Projects, "),e("em",null,"and of course help others as well"),t(". Find us on "),e("a",{href:"https://github.com/directus/directus/discussions",target:"_blank",rel:"noopener noreferrer"},"GitHub"),t(" and "),e("a",{href:"https://directus.chat",target:"_blank",rel:"noopener noreferrer"},"Discord"),t(" to join the thousands of other developers all discussing and guiding the future of the Directus platform. Most common questions have already been asked and answered and can be easily searched.")],-1),fe=e("div",{class:"warning hint"},[e("div",{class:"hint-title"},"No Guaranteed Response Time"),e("p",null,"While the Directus Core Team plays an active and engaged role in community discussions and aims to answer questions within a few days, there is no guaranteed response time for Community Support.")],-1),_e=e("h3",{id:"basic-and-premium-support",tabindex:"-1"},[e("a",{class:"header-anchor",href:"#basic-and-premium-support"},"#"),t(" Basic and Premium Support")],-1),ge=e("p",null,"Basic and Premium Support offer direct communication with the Directus Core Team. Basic support is included on all Enterprise Projects, and Premium Support adds 24/7 response times for critical software issues only.",-1),ye=e("div",{class:"tip hint"},[e("div",{class:"hint-title"},"Add-on Support"),e("p",null,[t("Looking for Basic or Premium Support on a self-hosted Project? "),e("a",{href:"https://directus.io/contact",target:"_blank",rel:"noopener noreferrer"},"Contact Sales"),t(".")])],-1),be=e("h2",{id:"system-status",tabindex:"-1"},[e("a",{class:"header-anchor",href:"#system-status"},"#"),t(" System Status")],-1),we=e("video",{alt:"System Status",loop:"",muted:"",controls:"",autoplay:"",playsinline:""},[e("source",{src:"https://cdn.directus.io/docs/v9/cloud/glossary/glossary-20220322A/system-status-20220329A.mp4",type:"video/mp4"})],-1),ve=e("p",null,[t("Click "),e("span",{mi:"",icon:""},"check"),t(" in the Dashboard Header to navigate to the System Status page. This page is where to "),e("em",null,"find out what happened"),t(" in the super rare event that the network slows down or goes offline. Here you can view the current connectivity status of Directus Cloud, the status on individual Projects by URL and a daily Incidents log. For more information, see "),e("a",{href:"https://directus.io/cloud-policies#",target:"_blank",rel:"noopener noreferrer"},"Cloud Policies"),t(".")],-1),Pe=e("h2",{id:"multi-tenancy",tabindex:"-1"},[e("a",{class:"header-anchor",href:"#multi-tenancy"},"#"),t(" Multi-tenancy")],-1),Ce=e("p",null,"Tenancy refers to how client data is stored within a database. In single-tenancy architecture, a database stores data from only one tenant. In multi-tenancy architecture, a database stores data from multiple tenants, with mechanisms in place to protect data privacy. In the context of Directus Cloud, each Project represents a tenant.",-1),xe=e("p",null,[e("strong",null,"Community"),e("br"),t(" Community project databases are technically single-tenant, but also file-based, and therefore may be too limited on power for a production-ready environment.")],-1),je=e("p",null,[e("strong",null,"Standard"),e("br"),t(" Standard Projects are created using a multi-tenant architecture. However, if your neighbor\u2019s Project gets busy, it will not impact your Project, because each Standard Project is scoped to one container per Project with dedicated minimum resources. Projects also have the ability to scale beyond this minimum allocation based on currently available resources within the multitenant pool. However, these additional resources are not guaranteed and are offered on a dynamic first-come, first-serve basis. For end-to-end, single-tenant infrastructure with fully dedicated resources, "),e("a",{href:"https://directus.io/contact",target:"_blank",rel:"noopener noreferrer"},"contact us about our Enterprise Tier")],-1),ke=e("p",null,[e("strong",null,"Enterprise"),e("br"),t(" Databases on Enterprise Projects are single-tenant, 100% dedicated to your Project - no neighbors! Ready to upgrade to Enterprise? "),e("a",{href:"https://directus.io/contact",target:"_blank",rel:"noopener noreferrer"},"Contact us")],-1),Se=e("div",{class:"tip hint"},[e("p",null,"This section refers to how your Cloud Project is stored alongside other Cloud Projects and has nothing to do with how you design your Project\u2019s data model. You can implement single or multi-tenant architecture within any Directus Cloud Project.")],-1),Ne="Glossary",Ie=!1,qe="A glossary of terms specific to Directus Cloud.",Re="10 min read",Ge={__name:"glossary",setup(Ee,{expose:i}){const a={title:"Glossary",modularExtension:!1,description:"A glossary of terms specific to Directus Cloud.",readTime:"10 min read"};return i({frontmatter:a}),(De,Te)=>{const n=r("router-link"),l=r("docs-wrapper");return d(),c(l,{frontmatter:a},{default:o(()=>[e("div",u,[h,p,m,f,_,g,y,b,w,v,P,C,x,j,k,S,E,D,T,A,N,I,q,R,e("p",null,[t("The term "),G,t(" refers to any feature or component that adds to the functionality of Directus Core. Directus has been architected to be "),s(n,{to:"/docs/extensions/introduction"},{default:o(()=>[t("completely modular and extensible")]),_:1}),t(" to ensure you will never hit a hard feature ceiling within the platform.")]),L,B,H,F,e("p",null,[t("In the context of these docs, Infrastructure refers to the hardware running your Project, including the "),z,t(", "),M,t(", "),U,t(" and "),V,t(". Infrastructure differs by Project tier. Please refer to "),s(n,{to:"/docs/cloud/projects"},{default:o(()=>[t("Projects")]),_:1}),t(" as well as the Infrastructure section on the "),O,t(" for side-by-side comparisons.")]),Y,W,K,J,Q,e("ul",null,[e("li",null,[e("p",null,[X,Z,t(" Community Projects come equipped with one Node, which can handle basic web traffic required for hobby projects, learning and demoing Directus Cloud, and other non-production use cases. Community Nodes are paused after a certain duration of runtime. However, you can "),s(n,{to:"/docs/cloud/projects#resume-a-community-project"},{default:o(()=>[t("extend this period")]),_:1}),t(" forever.")])]),$,ee,te]),oe,e("p",null,[t("The term "),ne,t(" indicates the number of nodes available to immediately handle incoming requests, including rapid spikes.This determines your base "),s(n,{to:"/docs/cloud/teams.md#manage-billing"},{default:o(()=>[t("monthly billing")]),_:1}),t(".")]),se,ae,re,ie,le,de,ce,ue,he,pe,me,fe,_e,ge,ye,be,we,ve,Pe,Ce,xe,je,ke,Se])]),_:1})}}};export{Ge as default,qe as description,Ie as modularExtension,Re as readTime,Ne as title};
