import{a as l,o as r,e as d,y as n,u as t,q as e,z as s}from"./runtime-core.esm-bundler.22ec0346.js";const u={class:"markdown-body"},h=t("blockquote",null,[t("p",null,"Flows enable custom, event-driven data processing and task automation within Directus. Each flow is composed of one trigger, followed by a series of operations.")],-1),p={class:"tip hint"},g=t("div",{class:"hint-title"},"Before You Begin",-1),f={class:"tip hint"},w=t("div",{class:"hint-title"},"Learn More",-1),_=t("h2",{id:"what%E2%80%99s-a-flow%3F",tabindex:"-1"},[t("a",{class:"header-anchor",href:"#what%E2%80%99s-a-flow%3F"},"#"),e(" What\u2019s a Flow?")],-1),m=t("p",null,[t("img",{src:"https://cdn.directus.io/docs/v9/configuration/flows/flows/flows-20220603A/whats-a-flow-20220603A.webp",alt:"What's a Flow?"})],-1),y=t("p",null,"Each flow is made up of three elements: A trigger, operations, and a data chain.",-1),b=t("h3",{id:"triggers",tabindex:"-1"},[t("a",{class:"header-anchor",href:"#triggers"},"#"),e(),t("strong",null,"Triggers")],-1),v=t("h3",{id:"operations",tabindex:"-1"},[t("a",{class:"header-anchor",href:"#operations"},"#"),e(" Operations")],-1),j=t("em",null,"send off emails, push in-app notifications, send webhooks, and beyond",-1),k=t("p",null,"To put it in conceptual terms, operations do three things:",-1),x=t("ul",null,[t("li",null,[t("strong",null,"Get data"),e(" from Directus or another outside service.")]),t("li",null,[t("strong",null,"Process data"),e(" a.k.a. transform it, validate it, or whatever.")]),t("li",null,[t("strong",null,"Send data"),e(" to Directus or another outside service.")])],-1),T={class:"tip hint"},C=t("div",{class:"hint-title"},"Developers",-1),F=t("h3",{id:"data-chains",tabindex:"-1"},[t("a",{class:"header-anchor",href:"#data-chains"},"#"),e(" Data Chains")],-1),A=t("p",null,[e("In order for a flow\u2019s operations to track and access the same data, each flow creates its own "),t("a",{href:"#the-data-chain"},"data chain"),e(". Every operation has access to this data chain and each operation appends some value onto this object after it runs. This means you can dynamically access data from a previous operation in the current operation with "),t("a",{href:"#data-chain-variables"},"data chain variables"),e(".")],-1),$=t("h3",{id:"control-flow",tabindex:"-1"},[t("a",{class:"header-anchor",href:"#control-flow"},"#"),e(" Control Flow")],-1),D=t("em",null,"fails by design",-1),E=t("p",null,[e("These kinds of failed operations do not immediately stop your flow. Instead, flows let you implement "),t("a",{href:"https://en.wikipedia.org/wiki/Control_flow",target:"_blank",rel:"noopener noreferrer"},"control flow"),e(", by providing "),t("strong",null,"success paths"),e(" and "),t("strong",null,"failure paths"),e(" within a flow:")],-1),N=t("ul",null,[t("li",null,[t("strong",null,"Success"),e(" \u2014 If "),t("code",null,"operation1"),e(" executes successfully, then "),t("code",null,"operation2"),e(" executes.")]),t("li",null,[t("strong",null,"Failure"),e(" \u2014 Else if "),t("code",null,"operation1"),e(" fails on execution, then "),t("code",null,"operation3"),e(" executes.")])],-1),O=t("p",null,[t("em",null,"And there we have it!"),e(" These are the conceptual cornerstones of any flow. Now you\u2019ll need to know how to actually create a flow, which we discuss in the next section.")],-1),S=t("h2",{id:"configure-a-flow",tabindex:"-1"},[t("a",{class:"header-anchor",href:"#configure-a-flow"},"#"),e(" Configure A Flow")],-1),I=t("video",{autoplay:"",playsinline:"",muted:"",loop:"",controls:"",title:"Create a Flow"},[t("source",{src:"https://cdn.directus.io/docs/v9/configuration/flows/flows/flows-20220603A/create-a-flow-20220603A.mp4",type:"video/mp4"})],-1),L=t("h3",{id:"create-a-flow",tabindex:"-1"},[t("a",{class:"header-anchor",href:"#create-a-flow"},"#"),e(" Create a Flow")],-1),Y=t("ol",null,[t("li",null,[e("Navigate to "),t("strong",null,"Settings > Flows"),e(" and click "),t("span",{mi:"",btn:""},"add"),e(" in the page header. A drawer will open.")]),t("li",null,[e("Under "),t("strong",null,"Flow Setup"),e(", fill in a "),t("strong",null,"Name"),e(" for the flow and the following "),t("em",null,"optional"),e(" details: "),t("ul",null,[t("li",null,[t("strong",null,"Status"),e(" \u2014 Sets the flow to active or inactive.")]),t("li",null,[t("strong",null,"Icon"),e(" \u2014 Adds an icon to help quickly identify the flow.")]),t("li",null,[t("strong",null,"Description"),e(" \u2014 Sets a brief verbal description of the flow.")]),t("li",null,[t("strong",null,"Color"),e(" \u2014 Sets a color to help identify the flow.")]),t("li",null,[t("strong",null,"Activity and Logs Tracking"),e(" \u2014 Lets you "),t("strong",null,"Track Activity and Logs"),e(", "),t("strong",null,"Activity"),e(", or "),t("strong",null,"Neither"),e(".")])])])],-1),K={class:"tip hint"},q=t("a",{href:"#logs"},"Logs",-1),R=t("h3",{id:"configure-a-trigger",tabindex:"-1"},[t("a",{class:"header-anchor",href:"#configure-a-trigger"},"#"),e(" Configure a Trigger")],-1),P={start:"3"},W=t("span",{mi:"",btn:""},"arrow_forward",-1),B=t("strong",null,"Trigger Setup",-1),V=t("li",null,[e("Click "),t("span",{mi:"",btn:""},"done"),e(" in the menu header to confirm.")],-1),H=t("p",null,"You\u2019ll now see your trigger in an empty grid area. Its time to start adding operations.",-1),J=t("h3",{id:"configure-an-operation",tabindex:"-1"},[t("a",{class:"header-anchor",href:"#configure-an-operation"},"#"),e(" Configure an Operation")],-1),z={start:"5"},G=t("li",null,[e("On the trigger panel, click "),t("span",{mi:""},"add"),e(" and the "),t("strong",null,"Create Operation"),e(" side drawer will open.")],-1),M=t("strong",null,"Name",-1),U=t("br",null,null,-1),Q=t("a",{href:"#the-data-chain"},"data chain",-1),X=t("br",null,null,-1),Z=t("li",null,[e("Next, click "),t("span",{mi:"",btn:""},"done"),e(" in the page header to confirm and return to the flow grid area.")],-1),tt=t("li",null,[e("From here, you can make the following optional configurations: "),t("ul",null,[t("li",null,[t("strong",null,"Reposition"),e(" \u2014 You can drag and drop panels to reposition as desired.")]),t("li",null,[t("strong",null,"Unlink/Relink"),e(" \u2014 Click and drag "),t("span",{mi:"",icon:"",prmry:""},"adjust"),e(" or "),t("span",{mi:"",icon:"",prmry:""},"arrow_forward"),e(" to unlink/relink flows.")]),t("li",null,[t("strong",null,"Duplicate an Operation"),e(" \u2014 To duplicate an operation, click "),t("span",{mi:"",icon:""},"more_vert"),e(" to open its context menu. Click "),t("span",{mi:"",icon:""},"control_point_duplicate"),e(" and a duplicate of the operation (and its configuration details) will be created.")]),t("li",null,[t("strong",null,"Copy an Operation"),e(" \u2014 To copy and paste an operation into another flow, click "),t("span",{mi:"",icon:""},"more_vert"),e(" to open its context menu. Click "),t("span",{mi:"",icon:""},"input"),e(" and a popup menu will open. Choose the desired flow from the dropdown and click "),t("strong",null,"Copy"),e(".")]),t("li",null,[t("strong",null,[t("span",{mi:"",icon:""},"data_object"),e(" Toggle Raw Editor")]),e(" \u2014 Click "),t("span",{mi:"",icon:""},"data_object"),e(" on an operations\u2019 form input fields to toggle the input type between standard and raw value. This is allows you to add a raw value or "),t("a",{href:"#data-chain-variables"},"Data Chain Variables"),e(" within any type of configuration option, even dropdown menus, checkboxes, and radio buttons.")]),t("li",null,[t("strong",null,"Delete an Operation"),e(" \u2014 To delete an operation, click "),t("span",{mi:"",icon:""},"more_vert"),e(" then "),t("span",{mi:"",icon:"",dngr:""},"delete"),e(". A popup menu will appear. Click "),t("strong",null,"Delete"),e(" to confirm.")])])],-1),et=t("li",null,[e("On the newly created operation panel: "),t("ul",null,[t("li",null,[e("Click "),t("span",{mi:"",icon:""},"add"),e(" to add an operation to the "),t("strong",null,"success path"),e(".")]),t("li",null,[e("Click "),t("span",{mi:"",icon:""},"remove"),e(" to add an operation to the "),t("strong",null,"failure path"),e(".")])])],-1),nt=t("li",null,"Repeat steps 5-10 to build out your flow as desired.",-1),ot=t("li",null,[e("Click "),t("span",{mi:"",btn:""},"done"),e(" to confirm and create your flow.")],-1),st=t("li",null,[e("Click "),t("span",{mi:"",btn:""},"arrow_back"),e(" to return to the flows list.")],-1),at=t("li",null,"Once created, you may need to re-edit your flow, toggle it to inactive, or delete it.",-1),lt=t("h3",{id:"edit-a-flow",tabindex:"-1"},[t("a",{class:"header-anchor",href:"#edit-a-flow"},"#"),e(" Edit a Flow")],-1),it=t("ol",null,[t("li",null,"Navigate to the desired flow."),t("li",null,[e("Click "),t("span",{mi:"",btn:"",muted:""},"edit"),e(" in the flow page header and make reconfigurations as desired.")]),t("li",null,[e("Click "),t("span",{mi:"",btn:""},"done"),e(" to confirm.")])],-1),ct=t("h3",{id:"toggle-a-flow-to-inactive",tabindex:"-1"},[t("a",{class:"header-anchor",href:"#toggle-a-flow-to-inactive"},"#"),e(" Toggle a Flow to Inactive")],-1),rt=t("ol",null,[t("li",null,[e("Navigate to "),t("strong",null,"Settings > Flows"),e(" and click "),t("span",{mi:"",icon:""},"more_vert"),e(" on the desired flow.")]),t("li",null,[e("Click "),t("strong",null,[t("span",{mi:"",icon:""},"check"),e(" Set Flow to Active")]),e(" or "),t("strong",null,[t("span",{mi:"",icon:""},"block"),e(" Set Flow to Inactive")]),e(".")])],-1),dt=t("h3",{id:"delete-a-flow",tabindex:"-1"},[t("a",{class:"header-anchor",href:"#delete-a-flow"},"#"),e(" Delete a Flow")],-1),ut=t("ol",null,[t("li",null,[e("Click "),t("span",{mi:"",icon:""},"more_vert"),e(" on the desired flow to open its context menu.")]),t("li",null,[e("Click "),t("span",{mi:"",icon:"",dngr:""},"delete"),e(" and a popup menu will appear. Click "),t("strong",null,"Delete"),e(" to confirm.")])],-1),ht=t("p",null,"Now that we know how to create and configure a flow, it\u2019s time to get a firmer understanding of the data chain.",-1),pt=t("h2",{id:"the-data-chain",tabindex:"-1"},[t("a",{class:"header-anchor",href:"#the-data-chain"},"#"),e(" The Data Chain")],-1),gt=t("p",null,"Remember, each flow creates its own JSON object to store any data generated.",-1),ft=t("p",null,[e("When the flow begins, three keys are appended to the data chain: "),t("code",null,"$trigger"),e(", "),t("code",null,"$accountability"),e(", and "),t("code",null,"$last"),e(". Then, as each operation runs, it has access to this data chain. Once an operation finishes, its data is appended under its "),t("code",null,"<operationKey>"),e(". When the operation doesn\u2019t generate data, "),t("code",null,"null"),e(" is appended under its key.")],-1),wt=t("p",null,"The following is a highly generic example of a data chain.",-1),_t=t("pre",null,[t("code",{class:"language-json"},[t("span",{class:"hljs-punctuation"},"{"),e(`
	`),t("span",{class:"hljs-attr"},'"$trigger"'),t("span",{class:"hljs-punctuation"},":"),e(),t("span",{class:"hljs-punctuation"},"{"),e(`
		`),t("span",{class:"hljs-comment"},"// Contains data generated by the flow's trigger."),e(`
		`),t("span",{class:"hljs-comment"},"// This could include headers, access tokens, payloads, etc."),e(`
		`),t("span",{class:"hljs-comment"},"// Every data chain has a $trigger key."),e(`
	`),t("span",{class:"hljs-punctuation"},"}"),t("span",{class:"hljs-punctuation"},","),e(`
	`),t("span",{class:"hljs-attr"},'"$accountability"'),t("span",{class:"hljs-punctuation"},":"),e(),t("span",{class:"hljs-punctuation"},"{"),e(`
		`),t("span",{class:"hljs-comment"},"// Provides details on who/what started the flow."),e(`
		`),t("span",{class:"hljs-comment"},"// This could include user's id, role, ip address, etc..."),e(`
		`),t("span",{class:"hljs-comment"},"// Every data chain has an $accountability key."),e(`
	`),t("span",{class:"hljs-punctuation"},"}"),t("span",{class:"hljs-punctuation"},","),e(`
	`),t("span",{class:"hljs-attr"},'"$last"'),t("span",{class:"hljs-punctuation"},":"),e(),t("span",{class:"hljs-punctuation"},"{"),e(`
		`),t("span",{class:"hljs-comment"},"// The value appended under $last changes after each operation."),e(`
		`),t("span",{class:"hljs-comment"},"// It stores data of the last operation that executed in the flow."),e(`
		`),t("span",{class:"hljs-comment"},"// That way, you don't have to remember the previous operation's unique keyname."),e(`
		`),t("span",{class:"hljs-comment"},"// It's a handy little convenience tool!"),e(`
		`),t("span",{class:"hljs-comment"},"// Every data chain has a $last key."),e(`
	`),t("span",{class:"hljs-punctuation"},"}"),t("span",{class:"hljs-punctuation"},","),e(`
	`),t("span",{class:"hljs-attr"},'"operationKey1"'),t("span",{class:"hljs-punctuation"},":"),e(),t("span",{class:"hljs-string"},'"A value"'),t("span",{class:"hljs-punctuation"},","),e(),t("span",{class:"hljs-comment"},"// The data (if any) generated by the first operation."),e(`
	`),t("span",{class:"hljs-attr"},'"operationKey2"'),t("span",{class:"hljs-punctuation"},":"),e(),t("span",{class:"hljs-punctuation"},"{"),e(`
		`),t("span",{class:"hljs-attr"},'"nestedKey"'),t("span",{class:"hljs-punctuation"},":"),e(),t("span",{class:"hljs-punctuation"},"["),t("span",{class:"hljs-string"},'"nested val"'),t("span",{class:"hljs-punctuation"},","),e(),t("span",{class:"hljs-string"},'"nested val 2"'),t("span",{class:"hljs-punctuation"},"]"),e(),t("span",{class:"hljs-comment"},"// It will be common to have nested JSON data."),e(`
	`),t("span",{class:"hljs-punctuation"},"}"),t("span",{class:"hljs-punctuation"},","),e(`
	`),t("span",{class:"hljs-attr"},'"operationKey3"'),t("span",{class:"hljs-punctuation"},":"),e(),t("span",{class:"hljs-literal"},[t("span",{class:"hljs-keyword"},"null")]),e(),t("span",{class:"hljs-comment"},"// A null value is appended if no data generated."),e(`
`),t("span",{class:"hljs-punctuation"},"}"),e(`
`)])],-1),mt=t("p",null,[e("As you can see, the example above doesn\u2019t have any substantial data inside each key. In reality, there\u2019s going to be a lot of data and it will always be slightly different, based on your flow\u2019s unique configuration. During configuration and debugging, you\u2019ll need to use a tool like "),t("a",{href:"#logs"},"The Log"),e(" to view your data chain and make sure each operation is accessing and generating data as you intended.")],-1),yt=t("div",{class:"tip hint"},[t("p",null,[e("In our examples, we are using generic "),t("em",null,"placeholders"),e(" for operation keys, like "),t("code",null,"<operationKey>"),e(", which might look funny to low-code users. In practice, operation keys will actually have unique and descriptive names, like "),t("code",null,"send_email_7538"),e(".")])],-1),bt=t("div",{class:"tip hint"},[t("p",null,[e("Remember, "),t("code",null,"$trigger"),e(", "),t("code",null,"$accountability"),e(", and "),t("code",null,"$last"),e(" begin with "),t("code",null,"$"),e(", but not "),t("code",null,"operationKeys"),e(".")])],-1),vt=t("h2",{id:"data-chain-variables",tabindex:"-1"},[t("a",{class:"header-anchor",href:"#data-chain-variables"},"#"),e(" Data Chain Variables")],-1),jt=t("p",null,[e("While "),t("a",{href:"#configure-an-operation"},"configuring your operations"),e(", you can use keys from the data chain as variables to access data. Simply wrap the variable with quotes and "),t("em",null,"double mustaches"),e(". For example:")],-1),kt=t("pre",null,[t("code",{class:"language-json"},[t("span",{class:"hljs-string"},'"{{ $accountability }}"'),e(`
`)])],-1),xt=t("p",null,[e("will get the data nested under the "),t("code",null,"$accountability"),e(" key, producing something like this:")],-1),Tt=t("pre",null,[t("code",{class:"language-json"},[t("span",{class:"hljs-punctuation"},"{"),e(`
	`),t("span",{class:"hljs-attr"},'"user"'),t("span",{class:"hljs-punctuation"},":"),e(),t("span",{class:"hljs-string"},'"4b11492d-631d-4b8a-bca7-2beasdfadf58b"'),t("span",{class:"hljs-punctuation"},","),e(`
	`),t("span",{class:"hljs-attr"},'"role"'),t("span",{class:"hljs-punctuation"},":"),e(),t("span",{class:"hljs-string"},'"12c79228-5361-4905-929b-d69d3w46trs6b"'),t("span",{class:"hljs-punctuation"},","),e(`
	`),t("span",{class:"hljs-attr"},'"admin"'),t("span",{class:"hljs-punctuation"},":"),e(),t("span",{class:"hljs-literal"},[t("span",{class:"hljs-keyword"},"true")]),t("span",{class:"hljs-punctuation"},","),e(`
	`),t("span",{class:"hljs-attr"},'"app"'),t("span",{class:"hljs-punctuation"},":"),e(),t("span",{class:"hljs-literal"},[t("span",{class:"hljs-keyword"},"true")]),t("span",{class:"hljs-punctuation"},","),e(`
	`),t("span",{class:"hljs-attr"},'"ip"'),t("span",{class:"hljs-punctuation"},":"),e(),t("span",{class:"hljs-string"},'"127.0.0.1"'),t("span",{class:"hljs-punctuation"},","),e(`
	`),t("span",{class:"hljs-attr"},'"userAgent"'),t("span",{class:"hljs-punctuation"},":"),e(),t("span",{class:"hljs-string"},'"Amazon CloudFront"'),e(`
`),t("span",{class:"hljs-punctuation"},"}"),e(`
`)])],-1),Ct=t("p",null,[e("You can mix your own hard-coded JSON alongside variables."),t("br"),e(" You can also use dot-notation and array indexing to retrieve sub-nested values.")],-1),Ft=t("pre",null,[t("code",{class:"language-json"},[t("span",{class:"hljs-punctuation"},"{"),e(`
	`),t("span",{class:"hljs-attr"},'"key0"'),t("span",{class:"hljs-punctuation"},":"),e(),t("span",{class:"hljs-string"},'"a hard-coded value"'),t("span",{class:"hljs-punctuation"},","),e(`
	`),t("span",{class:"hljs-attr"},'"key1"'),t("span",{class:"hljs-punctuation"},":"),e(),t("span",{class:"hljs-string"},'"{{ $trigger.payload }}"'),t("span",{class:"hljs-punctuation"},","),e(`
	`),t("span",{class:"hljs-attr"},'"key2"'),t("span",{class:"hljs-punctuation"},":"),e(),t("span",{class:"hljs-string"},'"{{ operationKey.payload.friend_list[0] }}"'),e(`
`),t("span",{class:"hljs-punctuation"},"}"),e(`
`)])],-1),At=t("p",null,[e("You "),t("strong",null,"cannot"),e(" pass any type of computation using double-moustache syntax.")],-1),$t=t("pre",null,[t("code",{class:"language-js"},[e(`{
	`),t("span",{class:"hljs-string"},'"key"'),e(": "),t("span",{class:"hljs-string"},'"{{ 2 + 2 }}"'),e(`,
	`),t("span",{class:"hljs-string"},'"key2"'),e(": "),t("span",{class:"hljs-string"},'"{{ $trigger.payload.toLowerCase() }}"'),e(`
}
`)])],-1),Dt={class:"tip hint"},Et=t("p",null,[e("Certain operations use dropdowns, toggles, checkboxes, and other input options. However, you can bypass this entirely to input raw values directly with "),t("a",{href:"#configure-an-operation"},"Toggle to Raw Editor"),e(". You can use double-moustache syntax to access data dynamically in these input options as well.")],-1),Nt=t("h2",{id:"logs",tabindex:"-1"},[t("a",{class:"header-anchor",href:"#logs"},"#"),e(" Logs")],-1),Ot=t("video",{autoplay:"",playsinline:"",muted:"",loop:"",controls:"",title:""},[t("source",{src:"https://cdn.directus.io/docs/v9/configuration/flows/flows/flows-20220603A/logs-20220603A.mp4",type:"video/mp4"})],-1),St=t("p",null,"Accessible from the sidebar, logs store information for each flow execution. Each log will display information from triggers as well as each operation in the flow. To access a flow\u2019s logs, follow these steps.",-1),It=t("ol",null,[t("li",null,[e("Navigate to "),t("strong",null,"Settings > Flows"),e(" and click the desired flow.")]),t("li",null,[e("Click "),t("strong",null,[t("span",{mi:"",icon:"",prmry:""},"fact_check"),e(" Logs")]),e(" in the sidebar. A side drawer will open, displaying the flow\u2019s logs.")]),t("li",null,"Click a log and another side drawer will open, allowing you to peer through its data."),t("li",null,[e("When finished, click "),t("span",{mi:"",btn:"",muted:""},"close"),e(" to close the drawer.")])],-1),Lt=t("p",null,"Logs are not a 1:1 mapping to the data chain. Each trigger and operation gets its own dropdown, which stores its relevant data. Here\u2019s what you\u2019ll get from each of these:",-1),Yt=t("p",null,[t("strong",null,"Trigger")],-1),Kt=t("ul",null,[t("li",null,[t("strong",null,"Options"),e(" \u2014 The values you input when you configured the trigger."),t("br"),t("em",null,"(These configuration options are not stored on the data chain)"),e(".")]),t("li",null,[t("strong",null,"Payload"),e(" \u2014 Displays the data appended under "),t("code",null,"$trigger"),e(".")]),t("li",null,[t("strong",null,"Accountability"),e(" \u2014 Displays data appended under "),t("code",null,"$accountability"),e(".")])],-1),qt=t("p",null,[e("Note that "),t("code",null,"$accountability"),e(" is not nested under the "),t("code",null,"$trigger"),e(" key. However, it is listed under the Trigger in the Log because "),t("code",null,"$accountability"),e(" is generated by the trigger.")],-1),Rt=t("p",null,[t("strong",null,[t("code",null,"<OperationKey>")])],-1),Pt=t("ul",null,[t("li",null,[t("strong",null,"Options"),e(" \u2014 The values you input when you configured the operation."),t("br"),t("em",null,"(These configuration options are not stored on the data chain)"),e(".")]),t("li",null,[t("strong",null,"Payload"),e(" \u2014 Displays the data appended under this "),t("code",null,"<operationKey>"),e(".")])],-1),Wt=t("strong",null,"Options",-1),Bt=t("code",null,"message",-1),Vt=t("code",null,'"The last operation was a success"',-1),Ht=t("pre",null,[t("code",null,`{
	"message": "The last operation was a success"
}
`)],-1),Jt=t("div",{class:"warning hint"},[t("div",{class:"hint-title"},"Logs are stored in the database"),t("p",null,"Keep in mind that if you\u2019ve configured a flow to track logs, all this information is stored in the database. You may need to periodically delete this data.")],-1),zt=t("div",{class:"tip hint"},[t("div",{class:"hint-title"},"Where is `$last`?"),t("p",null,[e("You may notice "),t("code",null,"$last"),e(" is not in the Logs. Remember, "),t("code",null,"$last"),e(" constantly updates to store the data of the most recently executed operation. The log shows the results of the entire flow. Therefore "),t("code",null,"$last"),e(" would simply be the very last operation in the flow.")])],-1),Gt=t("div",{class:"tip hint"},[t("div",{class:"hint-title"},"More on Debugging"),t("p",null,[e("You may find a tool like "),t("a",{href:"https://www.postman.com/",target:"_blank",rel:"noopener noreferrer"},"Postman"),e(" quite helpful for viewing data and debugging flows.")])],-1),Zt="Flows",te=!1,ee="Flows enable custom, event-driven data processing and task automation within Directus. Each flow is composed of one trigger, followed by a series of operations.",ne="5 min read",oe={__name:"flows",setup(Mt,{expose:i}){const a={title:"Flows",modularExtension:!1,description:"Flows enable custom, event-driven data processing and task automation within Directus. Each flow is composed of one trigger, followed by a series of operations.",readTime:"5 min read"};return i({frontmatter:a}),(Ut,Qt)=>{const o=l("router-link"),c=l("docs-wrapper");return r(),d(c,{frontmatter:a},{default:n(()=>[t("div",u,[h,t("div",p,[g,t("p",null,[e("Please be sure to see the "),s(o,{to:"/docs/getting-started/quickstart.md"},{default:n(()=>[e("Quickstart Guide")]),_:1}),e(" to get a basic overview of the platform.")])]),t("div",f,[w,t("p",null,[e("There is also dedicated API documentation on "),s(o,{to:"/docs/reference/system/flows"},{default:n(()=>[e("Flows")]),_:1}),e(" and "),s(o,{to:"/docs/reference/system/operations"},{default:n(()=>[e("Operations")]),_:1}),e(".")])]),_,m,y,b,t("p",null,[e("Each flow begins with a "),s(o,{to:"/docs/configuration/flows/triggers"},{default:n(()=>[e("trigger")]),_:1}),e(", which defines the action or event that starts the Flow. This action or event could be some type of transaction within the app, an incoming webhook, a cron job, etc.")]),v,t("p",null,[e("An "),s(o,{to:"/docs/configuration/flows/operations"},{default:n(()=>[e("operation")]),_:1}),e(" is an action or process performed within the flow. These enable you to manage data: "),j,e(".")]),k,x,t("div",T,[C,t("p",null,[e("You can even develop your own "),s(o,{to:"/docs/extensions/operations.md"},{default:n(()=>[e("custom operations")]),_:1}),e(" to fit any use-case.")])]),F,A,$,t("p",null,[e("Not every operation that executes in a flow does so successfully. In some cases, your operations are going to fail. Perhaps an operation tried to access data that doesn\u2019t exist, or a webhook operation fails for some reason, or perhaps you set a "),s(o,{to:"/docs/configuration/flows/operations.md#condition"},{default:n(()=>[e("condition")]),_:1}),e(" operation, which "),D,e(" when its condition is not met.")]),E,N,O,S,I,L,Y,t("div",K,[t("p",null,[e("To learn more, see the section below on "),q,e(" as well as the "),s(o,{to:"/docs/configuration/activity-log.html"},{default:n(()=>[e("Activity Log")]),_:1}),e(" documentation.")])]),R,t("ol",P,[t("li",null,[e("Click "),W,e(" to navigate to "),B,e(". Select a "),s(o,{to:"/docs/configuration/flows/triggers"},{default:n(()=>[e("trigger")]),_:1}),e(" type and configure as desired.")]),V]),H,J,t("ol",z,[G,t("li",null,[e("Choose a "),M,e(", an "),s(o,{to:"/docs/configuration/flows/operations"},{default:n(()=>[e("operation")]),_:1}),e(" type, and configure as desired."),U,e(" Directus will convert the name into a unique operation key, used on the "),Q,e("."),X,e(" If you don\u2019t choose a name, the system will auto-generate a name and key for you.")]),Z,tt,et,nt,ot,st,at]),lt,it,ct,rt,dt,ut,ht,pt,gt,ft,wt,_t,mt,yt,bt,vt,jt,kt,xt,Tt,Ct,Ft,At,$t,t("div",Dt,[t("p",null,[e("To perform computations on flow data, use the "),s(o,{to:"/docs/configuration/flows/operations.md#script"},{default:n(()=>[e("script operation")]),_:1}),e(" or a "),s(o,{to:"/docs/configuration/flows/operations.md#webhook"},{default:n(()=>[e("webhook")]),_:1}),e(".")])]),Et,Nt,Ot,St,It,Lt,Yt,Kt,qt,Rt,Pt,t("p",null,[e("Remember, the "),s(o,{to:"/docs/configuration/flows/operations.md#log-to-console"},{default:n(()=>[e("Log to Console")]),_:1}),e(" operation is a key debugging tool. It does not append data to the data chain. You will view your log message under "),Wt,e(". Therefore, anything you log will always be displayed as nested under a "),Bt,e(" key. For example, if you decide to log "),Vt,e(", it will be displayed as:")]),Ht,Jt,zt,Gt])]),_:1})}}};export{oe as default,ee as description,te as modularExtension,ne as readTime,Zt as title};
