import{a as l,o as c,e as i,y as a,u as t,q as n,z as r}from"./runtime-core.esm-bundler.22ec0346.js";const p={class:"markdown-body"},h=t("blockquote",null,[t("p",null,[n("Permissions, validation, and the API\u2019s "),t("code",null,"filter"),n(" parameter all rely on a specific JSON structure to define their rules. This page describes the syntax for creating flat, relational, or complex filter rules.")])],-1),d=t("h2",{id:"syntax",tabindex:"-1"},[t("a",{class:"header-anchor",href:"#syntax"},"#"),n(" Syntax")],-1),j=t("ul",null,[t("li",null,[t("strong",null,"Field"),n(" \u2014 Any valid root field, "),t("a",{href:"#relational"},"relational field"),n(", or "),t("a",{href:"#logical-operators"},"logical operator")]),t("li",null,[t("strong",null,"Operator"),n(" \u2014 Any valid "),t("a",{href:"#filter-operators"},"filter operator")]),t("li",null,[t("strong",null,"Value"),n(" \u2014 Any valid static value, or "),t("a",{href:"#dynamic-variables"},"dynamic variable")])],-1),_=t("pre",null,[t("code",null,`{
	<field>: {
		<operator>: <value>
	}
}
`)],-1),f=t("h3",{id:"examples",tabindex:"-1"},[t("a",{class:"header-anchor",href:"#examples"},"#"),n(" Examples")],-1),m=t("pre",null,[t("code",{class:"language-json"},[t("span",{class:"hljs-punctuation"},"{"),n(`
	`),t("span",{class:"hljs-attr"},'"title"'),t("span",{class:"hljs-punctuation"},":"),n(),t("span",{class:"hljs-punctuation"},"{"),n(`
		`),t("span",{class:"hljs-attr"},'"_contains"'),t("span",{class:"hljs-punctuation"},":"),n(),t("span",{class:"hljs-string"},'"Directus"'),n(`
	`),t("span",{class:"hljs-punctuation"},"}"),n(`
`),t("span",{class:"hljs-punctuation"},"}"),n(`
`)])],-1),g=t("pre",null,[t("code",{class:"language-json"},[t("span",{class:"hljs-punctuation"},"{"),n(`
	`),t("span",{class:"hljs-attr"},'"owner"'),t("span",{class:"hljs-punctuation"},":"),n(),t("span",{class:"hljs-punctuation"},"{"),n(`
		`),t("span",{class:"hljs-attr"},'"_eq"'),t("span",{class:"hljs-punctuation"},":"),n(),t("span",{class:"hljs-string"},'"$CURRENT_USER"'),n(`
	`),t("span",{class:"hljs-punctuation"},"}"),n(`
`),t("span",{class:"hljs-punctuation"},"}"),n(`
`)])],-1),b=t("pre",null,[t("code",{class:"language-json"},[t("span",{class:"hljs-punctuation"},"{"),n(`
	`),t("span",{class:"hljs-attr"},'"datetime"'),t("span",{class:"hljs-punctuation"},":"),n(),t("span",{class:"hljs-punctuation"},"{"),n(`
		`),t("span",{class:"hljs-attr"},'"_lte"'),t("span",{class:"hljs-punctuation"},":"),n(),t("span",{class:"hljs-string"},'"$NOW"'),n(`
	`),t("span",{class:"hljs-punctuation"},"}"),n(`
`),t("span",{class:"hljs-punctuation"},"}"),n(`
`)])],-1),y=t("h2",{id:"filter-operators",tabindex:"-1"},[t("a",{class:"header-anchor",href:"#filter-operators"},"#"),n(" Filter Operators")],-1),v=t("table",null,[t("thead",null,[t("tr",null,[t("th",null,[n("Operator Title "),t("em",null,"(in app)")]),t("th",null,"Operator"),t("th",null,"Description")])]),t("tbody",null,[t("tr",null,[t("td",null,"Equals"),t("td",null,[t("code",null,"_eq")]),t("td",null,"Equal to")]),t("tr",null,[t("td",null,"Doesn\u2019t equal"),t("td",null,[t("code",null,"_neq")]),t("td",null,"Not equal to")]),t("tr",null,[t("td",null,"Less than"),t("td",null,[t("code",null,"_lt")]),t("td",null,"Less than")]),t("tr",null,[t("td",null,"Less than or equal to"),t("td",null,[t("code",null,"_lte")]),t("td",null,"Less than or equal to")]),t("tr",null,[t("td",null,"Greater than"),t("td",null,[t("code",null,"_gt")]),t("td",null,"Greater than")]),t("tr",null,[t("td",null,"Greater than or equal to"),t("td",null,[t("code",null,"_gte")]),t("td",null,"Greater than or equal to")]),t("tr",null,[t("td",null,"Is one of"),t("td",null,[t("code",null,"_in")]),t("td",null,"Matches any of the values")]),t("tr",null,[t("td",null,"Is not one of"),t("td",null,[t("code",null,"_nin")]),t("td",null,"Doesn\u2019t match any of the values")]),t("tr",null,[t("td",null,"Is null"),t("td",null,[t("code",null,"_null")]),t("td",null,[n("Is "),t("code",null,"null")])]),t("tr",null,[t("td",null,"Isn\u2019t null"),t("td",null,[t("code",null,"_nnull")]),t("td",null,[n("Is not "),t("code",null,"null")])]),t("tr",null,[t("td",null,"Contains"),t("td",null,[t("code",null,"_contains")]),t("td",null,"Contains the substring")]),t("tr",null,[t("td",null,"Doesn\u2019t contain"),t("td",null,[t("code",null,"_ncontains")]),t("td",null,"Doesn\u2019t contain the substring")]),t("tr",null,[t("td",null,"Starts with"),t("td",null,[t("code",null,"_starts_with")]),t("td",null,"Starts with")]),t("tr",null,[t("td",null,"Doesn\u2019t start with"),t("td",null,[t("code",null,"_nstarts_with")]),t("td",null,"Doesn\u2019t start with")]),t("tr",null,[t("td",null,"Ends with"),t("td",null,[t("code",null,"_ends_with")]),t("td",null,"Ends with")]),t("tr",null,[t("td",null,"Doesn\u2019t end with"),t("td",null,[t("code",null,"_nends_with")]),t("td",null,"Doesn\u2019t end with")]),t("tr",null,[t("td",null,"Is between"),t("td",null,[t("code",null,"_between")]),t("td",null,"Is between two values (inclusive)")]),t("tr",null,[t("td",null,"Isn\u2019t between"),t("td",null,[t("code",null,"_nbetween")]),t("td",null,"Is not between two values (inclusive)")]),t("tr",null,[t("td",null,"Is empty"),t("td",null,[t("code",null,"_empty")]),t("td",null,[n("Is empty ("),t("code",null,"null"),n(" or falsy)")])]),t("tr",null,[t("td",null,"Isn\u2019t empty"),t("td",null,[t("code",null,"_nempty")]),t("td",null,[n("Is not empty ("),t("code",null,"null"),n(" or falsy)")])]),t("tr",null,[t("td",null,"Intersects"),t("td",null,[t("code",null,"_intersects"),n(),t("sup",null,"[1]")]),t("td",null,"Value intersects a given point")]),t("tr",null,[t("td",null,"Doesn\u2019t intersect"),t("td",null,[t("code",null,"_nintersects"),n(),t("sup",null,"[1]")]),t("td",null,"Value does not intersect a given point")]),t("tr",null,[t("td",null,"Intersects Bounding box"),t("td",null,[t("code",null,"_intersects_bbox"),n(),t("sup",null,"[1]")]),t("td",null,"Value is in a bounding box")]),t("tr",null,[t("td",null,"Doesn\u2019t intersect bounding box"),t("td",null,[t("code",null,"_nintersects_bbox"),n(),t("sup",null,"[1]")]),t("td",null,"Value is not in a bounding box")])])],-1),R=t("p",null,[n("The following operator has no Title on the Filter Interface as it is "),t("strong",null,"only available in validation permissions"),n(":")],-1),w=t("table",null,[t("thead",null,[t("tr",null,[t("th",null,"Operator"),t("th",null,"Description")])]),t("tbody",null,[t("tr",null,[t("td",null,[t("code",null,"_regex"),n(),t("sup",null,"[2]")]),t("td",null,"Field has to match regex")])])],-1),x=t("p",null,[t("sup",null,"[1]"),n(" Only available on Geometry types."),t("br"),t("sup",null,"[2]"),n(" JavaScript \u201Cflavor\u201D regex. Make sure to escape backslashes.")],-1),E=t("h2",{id:"relational",tabindex:"-1"},[t("a",{class:"header-anchor",href:"#relational"},"#"),n(" Relational")],-1),T=t("p",null,[n("You can target related values by nesting field names. For example, if you have a relational Many-to-One "),t("code",null,"author"),n(" field, you can set a rule for the "),t("code",null,"author.name"),n(" field using the following syntax.")],-1),I=t("pre",null,[t("code",{class:"language-json"},[t("span",{class:"hljs-punctuation"},"{"),n(`
	`),t("span",{class:"hljs-attr"},'"author"'),t("span",{class:"hljs-punctuation"},":"),n(),t("span",{class:"hljs-punctuation"},"{"),n(`
		`),t("span",{class:"hljs-attr"},'"name"'),t("span",{class:"hljs-punctuation"},":"),n(),t("span",{class:"hljs-punctuation"},"{"),n(`
			`),t("span",{class:"hljs-attr"},'"_eq"'),t("span",{class:"hljs-punctuation"},":"),n(),t("span",{class:"hljs-string"},'"Rijk van Zanten"'),n(`
		`),t("span",{class:"hljs-punctuation"},"}"),n(`
	`),t("span",{class:"hljs-punctuation"},"}"),n(`
`),t("span",{class:"hljs-punctuation"},"}"),n(`
`)])],-1),N=t("p",null,[n("When using M2M relationships, a junction table will be created and the filter applies to the junction table itself. For example, if you have a "),t("code",null,"books"),n(" collection, with a M2M relationship to authors of each book, the junction collection will probably be named "),t("code",null,"books_authors"),n(" and have 3 fields : "),t("code",null,"id"),n(", "),t("code",null,"books_id"),n(" and "),t("code",null,"authors_id"),n(". To filter specific books depending on their authors you must go through the junction table and the "),t("code",null,"authors_id"),n(" field :")],-1),q=t("pre",null,[t("code",{class:"language-json"},[t("span",{class:"hljs-punctuation"},"{"),n(`
	`),t("span",{class:"hljs-attr"},'"authors"'),t("span",{class:"hljs-punctuation"},":"),n(),t("span",{class:"hljs-punctuation"},"{"),n(`
		`),t("span",{class:"hljs-attr"},'"authors_id"'),t("span",{class:"hljs-punctuation"},":"),n(),t("span",{class:"hljs-punctuation"},"{"),n(`
			`),t("span",{class:"hljs-attr"},'"name"'),t("span",{class:"hljs-punctuation"},":"),n(),t("span",{class:"hljs-punctuation"},"{"),n(`
				`),t("span",{class:"hljs-attr"},'"_eq"'),t("span",{class:"hljs-punctuation"},":"),n(),t("span",{class:"hljs-string"},'"Rijk van Zanten"'),n(`
			`),t("span",{class:"hljs-punctuation"},"}"),n(`
		`),t("span",{class:"hljs-punctuation"},"}"),n(`
	`),t("span",{class:"hljs-punctuation"},"}"),n(`
`),t("span",{class:"hljs-punctuation"},"}"),n(`
`)])],-1),O=t("h2",{id:"logical-operators",tabindex:"-1"},[t("a",{class:"header-anchor",href:"#logical-operators"},"#"),n(" Logical Operators")],-1),D=t("p",null,[n("You can nest or group multiple rules using the "),t("code",null,"_and"),n(" or "),t("code",null,"_or"),n(" logical operators. Each logical operator holds an array of Filter Rules, allowing for more complex filtering. Also note in the example that Logical Operators can be sub-nested into Logical Operators. However, they cannot be sub-nested into Filter Rules.")],-1),k=t("pre",null,[t("code",{class:"language-json"},[t("span",{class:"hljs-punctuation"},"{"),n(`
	`),t("span",{class:"hljs-attr"},'"_or"'),t("span",{class:"hljs-punctuation"},":"),n(),t("span",{class:"hljs-punctuation"},"["),n(`
		`),t("span",{class:"hljs-punctuation"},"{"),n(`
			`),t("span",{class:"hljs-attr"},'"_and"'),t("span",{class:"hljs-punctuation"},":"),n(),t("span",{class:"hljs-punctuation"},"["),n(`
				`),t("span",{class:"hljs-punctuation"},"{"),n(`
					`),t("span",{class:"hljs-attr"},'"user_created"'),t("span",{class:"hljs-punctuation"},":"),n(),t("span",{class:"hljs-punctuation"},"{"),n(`
						`),t("span",{class:"hljs-attr"},'"_eq"'),t("span",{class:"hljs-punctuation"},":"),n(),t("span",{class:"hljs-string"},'"$CURRENT_USER"'),n(`
					`),t("span",{class:"hljs-punctuation"},"}"),n(`
				`),t("span",{class:"hljs-punctuation"},"}"),t("span",{class:"hljs-punctuation"},","),n(`
				`),t("span",{class:"hljs-punctuation"},"{"),n(`
					`),t("span",{class:"hljs-attr"},'"status"'),t("span",{class:"hljs-punctuation"},":"),n(),t("span",{class:"hljs-punctuation"},"{"),n(`
						`),t("span",{class:"hljs-attr"},'"_in"'),t("span",{class:"hljs-punctuation"},":"),n(),t("span",{class:"hljs-punctuation"},"["),t("span",{class:"hljs-string"},'"published"'),t("span",{class:"hljs-punctuation"},","),n(),t("span",{class:"hljs-string"},'"draft"'),t("span",{class:"hljs-punctuation"},"]"),n(`
					`),t("span",{class:"hljs-punctuation"},"}"),n(`
				`),t("span",{class:"hljs-punctuation"},"}"),n(`
			`),t("span",{class:"hljs-punctuation"},"]"),n(`
		`),t("span",{class:"hljs-punctuation"},"}"),t("span",{class:"hljs-punctuation"},","),n(`
		`),t("span",{class:"hljs-punctuation"},"{"),n(`
			`),t("span",{class:"hljs-attr"},'"_and"'),t("span",{class:"hljs-punctuation"},":"),n(),t("span",{class:"hljs-punctuation"},"["),n(`
				`),t("span",{class:"hljs-punctuation"},"{"),n(`
					`),t("span",{class:"hljs-attr"},'"user_created"'),t("span",{class:"hljs-punctuation"},":"),n(),t("span",{class:"hljs-punctuation"},"{"),n(`
						`),t("span",{class:"hljs-attr"},'"_neq"'),t("span",{class:"hljs-punctuation"},":"),n(),t("span",{class:"hljs-string"},'"$CURRENT_USER"'),n(`
					`),t("span",{class:"hljs-punctuation"},"}"),n(`
				`),t("span",{class:"hljs-punctuation"},"}"),t("span",{class:"hljs-punctuation"},","),n(`
				`),t("span",{class:"hljs-punctuation"},"{"),n(`
					`),t("span",{class:"hljs-attr"},'"status"'),t("span",{class:"hljs-punctuation"},":"),n(),t("span",{class:"hljs-punctuation"},"{"),n(`
						`),t("span",{class:"hljs-attr"},'"_in"'),t("span",{class:"hljs-punctuation"},":"),n(),t("span",{class:"hljs-punctuation"},"["),t("span",{class:"hljs-string"},'"published"'),t("span",{class:"hljs-punctuation"},"]"),n(`
					`),t("span",{class:"hljs-punctuation"},"}"),n(`
				`),t("span",{class:"hljs-punctuation"},"}"),n(`
			`),t("span",{class:"hljs-punctuation"},"]"),n(`
		`),t("span",{class:"hljs-punctuation"},"}"),n(`
	`),t("span",{class:"hljs-punctuation"},"]"),n(`
`),t("span",{class:"hljs-punctuation"},"}"),n(`
`)])],-1),U=t("h3",{id:"some-vs-none-in-one-to-many",tabindex:"-1"},[t("a",{class:"header-anchor",href:"#some-vs-none-in-one-to-many"},"#"),n(" Some vs None in One-to-Many")],-1),F=t("p",null,"When applying filters to a one-to-many field, Directus will default to a \u201Csome\u201D search, for example in:",-1),S=t("pre",null,[t("code",{class:"language-json"},[t("span",{class:"hljs-punctuation"},"{"),n(`
	`),t("span",{class:"hljs-attr"},'"categories"'),t("span",{class:"hljs-punctuation"},":"),n(),t("span",{class:"hljs-punctuation"},"{"),n(`
		`),t("span",{class:"hljs-attr"},'"name"'),t("span",{class:"hljs-punctuation"},":"),n(),t("span",{class:"hljs-punctuation"},"{"),n(`
			`),t("span",{class:"hljs-attr"},'"_eq"'),t("span",{class:"hljs-punctuation"},":"),n(),t("span",{class:"hljs-string"},'"Recipe"'),n(`
		`),t("span",{class:"hljs-punctuation"},"}"),n(`
	`),t("span",{class:"hljs-punctuation"},"}"),n(`
`),t("span",{class:"hljs-punctuation"},"}"),n(`
`)])],-1),$=t("p",null,[n("the top level parent will be returned if "),t("em",null,"one of"),n(" the categories has the name "),t("code",null,"Recipe"),n(". This behavior can be overridden by using the explicit "),t("code",null,"_some"),n(" and "),t("code",null,"_none"),n(" operators, for example:")],-1),C=t("pre",null,[t("code",{class:"language-json"},[t("span",{class:"hljs-punctuation"},"{"),n(`
	`),t("span",{class:"hljs-attr"},'"categories"'),t("span",{class:"hljs-punctuation"},":"),n(),t("span",{class:"hljs-punctuation"},"{"),n(`
		`),t("span",{class:"hljs-attr"},'"_none"'),t("span",{class:"hljs-punctuation"},":"),n(),t("span",{class:"hljs-punctuation"},"{"),n(`
			`),t("span",{class:"hljs-attr"},'"name"'),t("span",{class:"hljs-punctuation"},":"),n(),t("span",{class:"hljs-punctuation"},"{"),n(`
				`),t("span",{class:"hljs-attr"},'"_eq"'),t("span",{class:"hljs-punctuation"},":"),n(),t("span",{class:"hljs-string"},'"Recipe"'),n(`
			`),t("span",{class:"hljs-punctuation"},"}"),n(`
		`),t("span",{class:"hljs-punctuation"},"}"),n(`
	`),t("span",{class:"hljs-punctuation"},"}"),n(`
`),t("span",{class:"hljs-punctuation"},"}"),n(`
`)])],-1),L=t("p",null,"will fetch all parent items that don\u2019t have the category \u201CRecipe\u201D",-1),V=t("h2",{id:"dynamic-variables",tabindex:"-1"},[t("a",{class:"header-anchor",href:"#dynamic-variables"},"#"),n(" Dynamic Variables")],-1),M=t("p",null,[n("In addition to static values, you can also filter against "),t("em",null,"dynamic"),n(" values using the following variables.")],-1),W=t("ul",null,[t("li",null,[t("code",null,"$CURRENT_USER"),n(" \u2014 The primary key of the currently authenticated user")]),t("li",null,[t("code",null,"$CURRENT_ROLE"),n(" \u2014 The primary key of the role for the currently authenticated user")]),t("li",null,[t("code",null,"$NOW"),n(" \u2014 The current timestamp")]),t("li",null,[t("code",null,"$NOW(<adjustment>)"),n(" - The current timestamp plus/minus a given distance, for example "),t("code",null,"$NOW(-1 year)"),n(", "),t("code",null,"$NOW(+2 hours)")])],-1),A={class:"tip hint"},G=t("div",{class:"hint-title"},"Functions",-1),P=t("div",{class:"tip hint"},[t("div",{class:"hint-title"},"Nested User / Role variables in Permissions"),t("p",null,[n("When configuring permissions, "),t("code",null,"$CURRENT_USER"),n(" and "),t("code",null,"$CURRENT_ROLE"),n(" allow you to specify any (nested) field under the current user/role as well as the root ID. For example: "),t("code",null,"$CURRENT_ROLE.name"),n(" or "),t("code",null,"$CURRENT_USER.avatar.filesize"),n(". This includes custom fields that were added to the directus_users/directus_roles tables.")]),t("p",null,"Note: This feature is only available for permissions, validation, and presets. Regular filters and conditional fields currently only support the root ID.")],-1),Q="Filter Rules",Z=!1,H="REST and GraphQL API documentation for filter rules in Directus.",K="5 min read",X={__name:"filter-rules",setup(B,{expose:e}){const s={title:"Filter Rules",modularExtension:!1,description:"REST and GraphQL API documentation for filter rules in Directus.",readTime:"5 min read"};return e({frontmatter:s}),(Y,z)=>{const u=l("router-link"),o=l("docs-wrapper");return c(),i(o,{frontmatter:s},{default:a(()=>[t("div",p,[h,d,j,_,f,m,g,b,y,v,R,w,x,E,T,I,N,q,O,D,k,U,F,S,$,C,L,V,M,W,t("div",A,[G,t("p",null,[n("You can also use "),r(u,{to:"/docs/reference/query#functions"},{default:a(()=>[n("Function Parameters")]),_:1}),n(" when building Filters.")])]),P])]),_:1})}}};export{X as default,H as description,Z as modularExtension,K as readTime,Q as title};
