import{a as o,o as c,e as h,y as a,u as s,q as e,z as n}from"./runtime-core.esm-bundler.22ec0346.js";const d={class:"markdown-body"},u=s("blockquote",null,[s("p",null,[e("Every file managed by the platform is uploaded to the configured storage adapter, and its associated metadata is tracked within the "),s("code",null,"directus_files"),e(" system collection. Any requested file transformations are handled on the fly, and are only saved to storage.")])],-1),p=s("hr",null,null,-1),_=s("h2",{id:"accessing-a-file",tabindex:"-1"},[s("a",{class:"header-anchor",href:"#accessing-a-file"},"#"),e(" Accessing a File")],-1),f=s("p",null,"The location of your actual file originals is based on the project\u2019s configuration, but you can consistently access them via the API using the following URL.",-1),m=s("pre",null,[s("code",{class:"language-txt"},`example.com/assets/<file-id>
example.com/assets/1ac73658-8b62-4dea-b6da-529fbc9d01a4
`)],-1),g=s("div",{class:"tip hint"},[s("div",{class:"hint-title"},"SEO"),s("p",null,"You can provide an optional filename after the UUID to optimize for SEO, for example:"),s("pre",null,[s("code",{class:"language-txt"},`example.com/assets/<file-id>/<filename>
example.com/assets/1ac73658-8b62-4dea-b6da-529fbc9d01a4/directus-logo.png
`)]),s("p",null,[e("This optional filename is also used in the Content-Disposition header when the "),s("code",null,"?download"),e(" query parameter is used.")])],-1),j=s("div",{class:"warning hint"},[s("div",{class:"hint-title"},"Direct File Access"),s("p",null,[e("While you may "),s("em",null,"technically"),e(" be able to expose your storage adapters root file system and access your raw files through there, it is recommended that you always use the Directus API. This is the only way that you can take advantage of file permissions and other built-in features.")])],-1),b=s("p",null,[s("img",{src:"https://cdn.directus.io/docs/v9/reference/files/original-20220216A.jpg",alt:"Original File"}),e(),s("em",null,"Original File Used \u2014 602KB and 1800x1200")],-1),y=s("hr",null,null,-1),x=s("h2",{id:"downloading-a-file",tabindex:"-1"},[s("a",{class:"header-anchor",href:"#downloading-a-file"},"#"),e(" Downloading a File")],-1),q=s("p",null,[e("To download an asset with the correct filename, you need to add the "),s("code",null,"?download"),e(" query parameter to the request and the "),s("code",null,"download"),e(" attribute to your anchor tag. This will ensure the appropriate "),s("a",{href:"https://www.w3.org/Protocols/rfc2616/rfc2616-sec19.html",target:"_blank",rel:"noopener noreferrer"},"Content-Disposition"),e(" headers are added. Without this, the download will work on the "),s("em",null,"same"),e(" domain, however it will have the file\u2019s \u201Cid\u201D as the filename for cross-origin requests.")],-1),w=s("h3",{id:"example",tabindex:"-1"},[s("a",{class:"header-anchor",href:"#example"},"#"),e(" Example")],-1),v=s("pre",null,[s("code",{class:"language-html"},[s("span",{class:"hljs-tag"},[e("<"),s("span",{class:"hljs-name"},"a"),e(),s("span",{class:"hljs-attr"},"href"),e("="),s("span",{class:"hljs-string"},'"https://your-directus.com/assets/<file-id>?download"'),e(),s("span",{class:"hljs-attr"},"target"),e("="),s("span",{class:"hljs-string"},'"_blank"'),e(),s("span",{class:"hljs-attr"},"download"),e("="),s("span",{class:"hljs-string"},'"Your File.pdf"'),e(">")]),e("Download"),s("span",{class:"hljs-tag"},[e("</"),s("span",{class:"hljs-name"},"a"),e(">")]),e(`
`)])],-1),T=s("hr",null,null,-1),k=s("h2",{id:"requesting-a-thumbnail",tabindex:"-1"},[s("a",{class:"header-anchor",href:"#requesting-a-thumbnail"},"#"),e(" Requesting a Thumbnail")],-1),E=s("p",null,[e("Fetching thumbnails is as easy as adding a "),s("code",null,"key"),e(" query parameter to the original file\u2019s URL. In the Admin App, you can configure different asset presets that control the output of any given image. If a requested thumbnail doesn\u2019t yet exist, it is dynamically generated and immediately returned.")],-1),R=s("h3",{id:"preset-transformations",tabindex:"-1"},[s("a",{class:"header-anchor",href:"#preset-transformations"},"#"),e(" Preset Transformations")],-1),A=s("strong",null,[s("code",null,"key")],-1),S=s("strong",null,"key",-1),D=s("h3",{id:"custom-transformations",tabindex:"-1"},[s("a",{class:"header-anchor",href:"#custom-transformations"},"#"),e(" Custom Transformations")],-1),P=s("p",null,"Alternatively, if you have \u201CStorage Asset Transform\u201D set to all, you can use the following parameters for more fine grained control:",-1),I=s("ul",null,[s("li",null,[s("strong",null,[s("code",null,"fit")]),e(" \u2014 The "),s("strong",null,"fit"),e(" of the thumbnail while always preserving the aspect ratio, can be any of the following options: "),s("ul",null,[s("li",null,[s("code",null,"cover"),e(" \u2014 Covers both width/height by cropping/clipping to fit")]),s("li",null,[s("code",null,"contain"),e(" \u2014 Contain within both width/height using \u201Cletterboxing\u201D as needed")]),s("li",null,[s("code",null,"inside"),e(" \u2014 Resize to be as large as possible, ensuring dimensions are less than or equal to the requested width and height")]),s("li",null,[s("code",null,"outside"),e(" \u2014 Resize to be as small as possible, ensuring dimensions are greater than or equal to the requested width and height")])])]),s("li",null,[s("strong",null,[s("code",null,"width")]),e(" \u2014 The "),s("strong",null,"width"),e(" of the thumbnail in pixels")]),s("li",null,[s("strong",null,[s("code",null,"height")]),e(" \u2014 The "),s("strong",null,"height"),e(" of the thumbnail in pixels")]),s("li",null,[s("strong",null,[s("code",null,"quality")]),e(" \u2014 The optional "),s("strong",null,"quality"),e(" of the thumbnail ("),s("code",null,"1"),e(" to "),s("code",null,"100"),e(")")]),s("li",null,[s("strong",null,[s("code",null,"withoutEnlargement")]),e(" \u2014 Disable image up-scaling")]),s("li",null,[s("strong",null,[s("code",null,"format")]),e(" \u2014 What file format to return the thumbnail in. One of "),s("code",null,"jpg"),e(", "),s("code",null,"png"),e(", "),s("code",null,"webp"),e(", "),s("code",null,"tiff")])],-1),C=s("h3",{id:"advanced-transformations",tabindex:"-1"},[s("a",{class:"header-anchor",href:"#advanced-transformations"},"#"),e(" Advanced Transformations")],-1),F=s("p",null,[e("For even more advanced control over the file generation, Directus exposes "),s("a",{href:"https://sharp.pixelplumbing.com/api-operation",target:"_blank",rel:"noopener noreferrer"},[e("the full "),s("code",null,"sharp"),e(" API")]),e(" through the "),s("code",null,"transforms"),e(" query parameter. This parameter accepts a two-dimensional array with the format "),s("code",null,"[Operation, ...arguments]"),e(".")],-1),O=s("h3",{id:"quality-vs-file-size",tabindex:"-1"},[s("a",{class:"header-anchor",href:"#quality-vs-file-size"},"#"),e(" Quality vs File Size")],-1),Q=s("p",null,[e("The quality parameter can be any integer from "),s("code",null,"0-100"),e(". Qualities closer to "),s("code",null,"0"),e(" have lower file sizes, but also poor image quality due to compression artifacts. Values closer to "),s("code",null,"100"),e(" have larger file sizes, but better image quality. Below are four possible qualities (200x200 cover) to visually compare the balance between compression and file size.")],-1),L=s("table",null,[s("thead",null,[s("tr",null,[s("th",null,"25%"),s("th",null,"50%"),s("th",null,"75%"),s("th",null,"100%")])]),s("tbody",null,[s("tr",null,[s("td",null,[s("img",{src:"https://cdn.directus.io/docs/v9/reference/files/200-200-cover-25-20220216A.jpg",alt:"25%"}),s("br"),s("em",null,"4KB")]),s("td",null,[s("img",{src:"https://cdn.directus.io/docs/v9/reference/files/200-200-cover-50-20220216A.jpg",alt:"50%"}),s("br"),s("em",null,"6KB")]),s("td",null,[s("img",{src:"https://cdn.directus.io/docs/v9/reference/files/200-200-cover-75-20220216A.jpg",alt:"75%"}),s("br"),s("em",null,"8KB")]),s("td",null,[s("img",{src:"https://cdn.directus.io/docs/v9/reference/files/200-200-cover-100-20220216A.jpg",alt:"100%"}),s("br"),s("em",null,"38KB")])])])],-1),X=s("h3",{id:"preset",tabindex:"-1"},[s("a",{class:"header-anchor",href:"#preset"},"#"),e(" Preset")],-1),B=s("pre",null,[s("code",{class:"language-txt"},`example.com/assets/<file-id>?key=<key>
`)],-1),U=s("h3",{id:"custom",tabindex:"-1"},[s("a",{class:"header-anchor",href:"#custom"},"#"),e(" Custom")],-1),Y=s("pre",null,[s("code",{class:"language-txt"},`example.com/assets/<file-id>?fit=<fit>&width=<width>&height=<height>&quality=<quality>
example.com/assets/1ac73658-8b62-4dea-b6da-529fbc9d01a4?fit=cover&width=200&height=200&quality=80
`)],-1),G=s("h3",{id:"advanced",tabindex:"-1"},[s("a",{class:"header-anchor",href:"#advanced"},"#"),e(" Advanced")],-1),M=s("pre",null,[s("code",{class:"language-txt"},`?transforms=[
	["blur", 45],
	["tint", "rgb(255, 0, 0)"],
	["expand", { "right": 200, "bottom": 150 }]
]
`)],-1),z=s("hr",null,null,-1),N=s("h2",{id:"the-file-object",tabindex:"-1"},[s("a",{class:"header-anchor",href:"#the-file-object"},"#"),e(" The File Object")],-1),Z=s("p",null,[s("code",null,"id"),e(),s("strong",null,"uuid"),s("br"),e(" Primary key of the file")],-1),H=s("p",null,[s("code",null,"storage"),e(),s("strong",null,"string"),s("br"),e(" Storage adapter used for the file.")],-1),W=s("p",null,[s("code",null,"filename_disk"),e(),s("strong",null,"string"),s("br"),e(" Name of the file as saved on the storage adapter.")],-1),K=s("p",null,[s("code",null,"filename_download"),e(),s("strong",null,"string"),s("br"),e(" Preferred filename when file is downloaded.")],-1),J=s("p",null,[s("code",null,"title"),e(),s("strong",null,"string"),s("br"),e(" Title for the file.")],-1),V=s("p",null,[s("code",null,"type"),e(),s("strong",null,"string"),s("br"),e(" Mimetype of the file.")],-1),$=s("code",null,"folder",-1),ss=s("strong",null,"many-to-one",-1),es=s("br",null,null,-1),as=s("code",null,"uploaded_by",-1),ts=s("strong",null,"many-to-one",-1),ns=s("br",null,null,-1),ls=s("p",null,[s("code",null,"uploaded_on"),e(),s("strong",null,"datetime"),s("br"),e(" When the file was uploaded.")],-1),os=s("code",null,"modified_by",-1),is=s("strong",null,"many-to-one",-1),rs=s("br",null,null,-1),cs=s("p",null,[s("code",null,"filesize"),e(),s("strong",null,"number"),s("br"),e(" Size of the file in bytes.")],-1),hs=s("p",null,[s("code",null,"width"),e(),s("strong",null,"number"),s("br"),e(" If the file is a(n) image/video, it\u2019s the width in px.")],-1),ds=s("p",null,[s("code",null,"height"),e(),s("strong",null,"number"),s("br"),e(" If the file is a(n) image/video, it\u2019s the height in px.")],-1),us=s("p",null,[s("code",null,"duration"),e(),s("strong",null,"number"),s("br"),e(" If the file contains audio/video, it\u2019s the duration in milliseconds.")],-1),ps=s("p",null,[s("code",null,"description"),e(),s("strong",null,"string"),s("br"),e(" Description of the file.")],-1),_s=s("p",null,[s("code",null,"location"),e(),s("strong",null,"string"),s("br"),e(" Location of the file.")],-1),fs=s("p",null,[s("code",null,"tags"),e(),s("strong",null,"array"),s("br"),e(" Tags for the file.")],-1),ms=s("p",null,[s("code",null,"metadata"),e(),s("strong",null,"object"),s("br"),e(" Any additional metadata Directus was able to scrape from the file. For images, this includes EXIF, IPTC, and ICC information.")],-1),gs=s("pre",null,[s("code",{class:"language-json"},[s("span",{class:"hljs-punctuation"},"{"),e(`
	`),s("span",{class:"hljs-attr"},'"id"'),s("span",{class:"hljs-punctuation"},":"),e(),s("span",{class:"hljs-string"},'"4f4b14fa-a43a-46d0-b7ad-90af5919bebb"'),s("span",{class:"hljs-punctuation"},","),e(`
	`),s("span",{class:"hljs-attr"},'"storage"'),s("span",{class:"hljs-punctuation"},":"),e(),s("span",{class:"hljs-string"},'"local"'),s("span",{class:"hljs-punctuation"},","),e(`
	`),s("span",{class:"hljs-attr"},'"filename_disk"'),s("span",{class:"hljs-punctuation"},":"),e(),s("span",{class:"hljs-string"},'"4f4b14fa-a43a-46d0-b7ad-90af5919bebb.jpeg"'),s("span",{class:"hljs-punctuation"},","),e(`
	`),s("span",{class:"hljs-attr"},'"filename_download"'),s("span",{class:"hljs-punctuation"},":"),e(),s("span",{class:"hljs-string"},'"paulo-silva-vSRgXtQuns8-unsplash.jpg"'),s("span",{class:"hljs-punctuation"},","),e(`
	`),s("span",{class:"hljs-attr"},'"title"'),s("span",{class:"hljs-punctuation"},":"),e(),s("span",{class:"hljs-string"},'"Paulo Silva (via Unsplash)"'),s("span",{class:"hljs-punctuation"},","),e(`
	`),s("span",{class:"hljs-attr"},'"type"'),s("span",{class:"hljs-punctuation"},":"),e(),s("span",{class:"hljs-string"},'"image/jpeg"'),s("span",{class:"hljs-punctuation"},","),e(`
	`),s("span",{class:"hljs-attr"},'"folder"'),s("span",{class:"hljs-punctuation"},":"),e(),s("span",{class:"hljs-literal"},[s("span",{class:"hljs-keyword"},"null")]),s("span",{class:"hljs-punctuation"},","),e(`
	`),s("span",{class:"hljs-attr"},'"uploaded_by"'),s("span",{class:"hljs-punctuation"},":"),e(),s("span",{class:"hljs-string"},'"0bc7b36a-9ba9-4ce0-83f0-0a526f354e07"'),s("span",{class:"hljs-punctuation"},","),e(`
	`),s("span",{class:"hljs-attr"},'"uploaded_on"'),s("span",{class:"hljs-punctuation"},":"),e(),s("span",{class:"hljs-string"},'"2021-02-04T11:37:41-05:00"'),s("span",{class:"hljs-punctuation"},","),e(`
	`),s("span",{class:"hljs-attr"},'"modified_by"'),s("span",{class:"hljs-punctuation"},":"),e(),s("span",{class:"hljs-literal"},[s("span",{class:"hljs-keyword"},"null")]),s("span",{class:"hljs-punctuation"},","),e(`
	`),s("span",{class:"hljs-attr"},'"modified_on"'),s("span",{class:"hljs-punctuation"},":"),e(),s("span",{class:"hljs-string"},'"2021-02-04T11:37:42-05:00"'),s("span",{class:"hljs-punctuation"},","),e(`
	`),s("span",{class:"hljs-attr"},'"filesize"'),s("span",{class:"hljs-punctuation"},":"),e(),s("span",{class:"hljs-number"},"3442252"),s("span",{class:"hljs-punctuation"},","),e(`
	`),s("span",{class:"hljs-attr"},'"width"'),s("span",{class:"hljs-punctuation"},":"),e(),s("span",{class:"hljs-number"},"3456"),s("span",{class:"hljs-punctuation"},","),e(`
	`),s("span",{class:"hljs-attr"},'"height"'),s("span",{class:"hljs-punctuation"},":"),e(),s("span",{class:"hljs-number"},"5184"),s("span",{class:"hljs-punctuation"},","),e(`
	`),s("span",{class:"hljs-attr"},'"duration"'),s("span",{class:"hljs-punctuation"},":"),e(),s("span",{class:"hljs-literal"},[s("span",{class:"hljs-keyword"},"null")]),s("span",{class:"hljs-punctuation"},","),e(`
	`),s("span",{class:"hljs-attr"},'"description"'),s("span",{class:"hljs-punctuation"},":"),e(),s("span",{class:"hljs-literal"},[s("span",{class:"hljs-keyword"},"null")]),s("span",{class:"hljs-punctuation"},","),e(`
	`),s("span",{class:"hljs-attr"},'"location"'),s("span",{class:"hljs-punctuation"},":"),e(),s("span",{class:"hljs-literal"},[s("span",{class:"hljs-keyword"},"null")]),s("span",{class:"hljs-punctuation"},","),e(`
	`),s("span",{class:"hljs-attr"},'"tags"'),s("span",{class:"hljs-punctuation"},":"),e(),s("span",{class:"hljs-punctuation"},"["),s("span",{class:"hljs-string"},'"photo"'),s("span",{class:"hljs-punctuation"},","),e(),s("span",{class:"hljs-string"},'"pretty"'),s("span",{class:"hljs-punctuation"},"]"),s("span",{class:"hljs-punctuation"},","),e(`
	`),s("span",{class:"hljs-attr"},'"metadata"'),s("span",{class:"hljs-punctuation"},":"),e(),s("span",{class:"hljs-punctuation"},"{"),e(`
		`),s("span",{class:"hljs-attr"},'"icc"'),s("span",{class:"hljs-punctuation"},":"),e(),s("span",{class:"hljs-punctuation"},"{"),e(`
			`),s("span",{class:"hljs-attr"},'"version"'),s("span",{class:"hljs-punctuation"},":"),e(),s("span",{class:"hljs-string"},'"2.1"'),s("span",{class:"hljs-punctuation"},","),e(`
			`),s("span",{class:"hljs-attr"},'"intent"'),s("span",{class:"hljs-punctuation"},":"),e(),s("span",{class:"hljs-string"},'"Perceptual"'),s("span",{class:"hljs-punctuation"},","),e(`
			`),s("span",{class:"hljs-attr"},'"cmm"'),s("span",{class:"hljs-punctuation"},":"),e(),s("span",{class:"hljs-string"},'"lcms"'),s("span",{class:"hljs-punctuation"},","),e(`
			`),s("span",{class:"hljs-attr"},'"deviceClass"'),s("span",{class:"hljs-punctuation"},":"),e(),s("span",{class:"hljs-string"},'"Monitor"'),s("span",{class:"hljs-punctuation"},","),e(`
			`),s("span",{class:"hljs-attr"},'"colorSpace"'),s("span",{class:"hljs-punctuation"},":"),e(),s("span",{class:"hljs-string"},'"RGB"'),s("span",{class:"hljs-punctuation"},","),e(`
			`),s("span",{class:"hljs-attr"},'"connectionSpace"'),s("span",{class:"hljs-punctuation"},":"),e(),s("span",{class:"hljs-string"},'"XYZ"'),s("span",{class:"hljs-punctuation"},","),e(`
			`),s("span",{class:"hljs-attr"},'"platform"'),s("span",{class:"hljs-punctuation"},":"),e(),s("span",{class:"hljs-string"},'"Apple"'),s("span",{class:"hljs-punctuation"},","),e(`
			`),s("span",{class:"hljs-attr"},'"creator"'),s("span",{class:"hljs-punctuation"},":"),e(),s("span",{class:"hljs-string"},'"lcms"'),s("span",{class:"hljs-punctuation"},","),e(`
			`),s("span",{class:"hljs-attr"},'"description"'),s("span",{class:"hljs-punctuation"},":"),e(),s("span",{class:"hljs-string"},'"c2"'),s("span",{class:"hljs-punctuation"},","),e(`
			`),s("span",{class:"hljs-attr"},'"copyright"'),s("span",{class:"hljs-punctuation"},":"),e(),s("span",{class:"hljs-string"},'""'),e(`
		`),s("span",{class:"hljs-punctuation"},"}"),e(`
	`),s("span",{class:"hljs-punctuation"},"}"),e(`
`),s("span",{class:"hljs-punctuation"},"}"),e(`
`)])],-1),js=s("hr",null,null,-1),bs=s("h2",{id:"list-files",tabindex:"-1"},[s("a",{class:"header-anchor",href:"#list-files"},"#"),e(" List Files")],-1),ys=s("p",null,"List all files that exist in Directus.",-1),xs=s("h3",{id:"query-parameters",tabindex:"-1"},[s("a",{class:"header-anchor",href:"#query-parameters"},"#"),e(" Query Parameters")],-1),qs=s("h3",{id:"returns",tabindex:"-1"},[s("a",{class:"header-anchor",href:"#returns"},"#"),e(" Returns")],-1),ws=s("a",{href:"#the-file-object"},"file objects",-1),vs=s("h3",{id:"rest-api",tabindex:"-1"},[s("a",{class:"header-anchor",href:"#rest-api"},"#"),e(" REST API")],-1),Ts=s("pre",null,[s("code",null,`GET /files
SEARCH /files
`)],-1),ks=s("h3",{id:"graphql",tabindex:"-1"},[s("a",{class:"header-anchor",href:"#graphql"},"#"),e(" GraphQL")],-1),Es=s("pre",null,[s("code",{class:"language-txt"},`POST /graphql/system
`)],-1),Rs=s("pre",null,[s("code",{class:"language-graphql"},[s("span",{class:"hljs-keyword"},"type"),s("span",{class:"hljs-type"}," Query"),e(` {
	files: [directus_files]
}
`)])],-1),As=s("h5",{id:"example-1",tabindex:"-1"},[s("a",{class:"header-anchor",href:"#example-1"},"#"),e(" Example")],-1),Ss=s("pre",null,[s("code",{class:"language-graphql"},[s("span",{class:"hljs-keyword"},"query"),e(` {
	files {
		id
		filename_disk
	}
}
`)])],-1),Ds=s("hr",null,null,-1),Ps=s("h2",{id:"retrieve-a-file",tabindex:"-1"},[s("a",{class:"header-anchor",href:"#retrieve-a-file"},"#"),e(" Retrieve a File")],-1),Is=s("p",null,"Retrieve a single file by primary key.",-1),Cs=s("h3",{id:"query-parameters-1",tabindex:"-1"},[s("a",{class:"header-anchor",href:"#query-parameters-1"},"#"),e(" Query Parameters")],-1),Fs=s("h3",{id:"returns-1",tabindex:"-1"},[s("a",{class:"header-anchor",href:"#returns-1"},"#"),e(" Returns")],-1),Os=s("p",null,[e("Returns a "),s("a",{href:"#the-file-object"},"file object"),e(" if a valid primary key was provided.")],-1),Qs=s("h3",{id:"rest-api-1",tabindex:"-1"},[s("a",{class:"header-anchor",href:"#rest-api-1"},"#"),e(" REST API")],-1),Ls=s("pre",null,[s("code",{class:"language-txt"},`GET /files/:id
`)],-1),Xs=s("h5",{id:"example-2",tabindex:"-1"},[s("a",{class:"header-anchor",href:"#example-2"},"#"),e(" Example")],-1),Bs=s("pre",null,[s("code",{class:"language-txt"},`GET /files/0fca80c4-d61c-4404-9fd7-6ba86b64154d
`)],-1),Us=s("h3",{id:"graphql-1",tabindex:"-1"},[s("a",{class:"header-anchor",href:"#graphql-1"},"#"),e(" GraphQL")],-1),Ys=s("pre",null,[s("code",{class:"language-txt"},`POST /graphql/system
`)],-1),Gs=s("pre",null,[s("code",{class:"language-graphql"},[s("span",{class:"hljs-keyword"},"type"),s("span",{class:"hljs-type"}," Query"),e(` {
	files_by_id(id:`),s("span",{class:"hljs-literal"}," ID"),e(`!): directus_files
}
`)])],-1),Ms=s("h5",{id:"example-3",tabindex:"-1"},[s("a",{class:"header-anchor",href:"#example-3"},"#"),e(" Example")],-1),zs=s("pre",null,[s("code",{class:"language-graphql"},[s("span",{class:"hljs-keyword"},"query"),e(` {
	files_by_id(id: `),s("span",{class:"hljs-string"},'"0fca80c4-d61c-4404-9fd7-6ba86b64154d"'),e(`) {
		id
		filename_disk
	}
}
`)])],-1),Ns=s("h2",{id:"upload-a-file",tabindex:"-1"},[s("a",{class:"header-anchor",href:"#upload-a-file"},"#"),e(" Upload a File")],-1),Zs=s("p",null,"Upload/create a new file.",-1),Hs=s("p",null,[e("To upload a file, use "),s("code",null,"multipart/form-data"),e(" as the encoding type. The file contents has to be provided in a part called "),s("code",null,"file"),e(". All other properties of "),s("a",{href:"#the-file-object"},"the file object"),e(" can be provided as parts as well, except "),s("code",null,"filename_disk"),e(" and "),s("code",null,"filename_download"),e(".")],-1),Ws=s("p",null,[e("Alternatively, you can use "),s("code",null,"application/json"),e(" with JSON request body to associate metadata to a file that already exists in the storage. The "),s("code",null,"type"),e(" property will be required to specify the mimetype of that file.")],-1),Ks=s("div",{class:"tip hint"},[s("div",{class:"hint-title"},"Order Matters"),s("p",null,[e("Make sure to define the non-file properties "),s("em",null,"first"),e(". This ensures that the file metadata is associated with the correct file.")])],-1),Js=s("p",null,"You can upload multiple files at a time by repeating the payload with different contents, for example:",-1),Vs=s("pre",null,[s("code",null,`--__X_BOUNDARY__
Content-Disposition: form-data; name="title"

Example
--__X_BOUNDARY__
Content-Disposition: form-data; name="file"; filename="paulo-silva-vSRgXtQuns8-unsplash.jpg"
Content-Type: image/jpeg

// binary data

--__X_BOUNDARY__
Content-Disposition: form-data; name="title"

Another Title
--__X_BOUNDARY__
Content-Disposition: form-data; name="file"; filename="mae-mu-GFhqNX1gE9E-unsplash.jpg"
Content-Type: image/jpeg

// binary data
`)],-1),$s=s("p",null,[e("In JavaScript, this can be achieved using the native "),s("code",null,"FormData"),e(" class:")],-1),se=s("pre",null,[s("code",{class:"language-js"},[s("span",{class:"hljs-keyword"},"import"),e(" axios "),s("span",{class:"hljs-keyword"},"from"),e(),s("span",{class:"hljs-string"},"'axios'"),e(`;

`),s("span",{class:"hljs-keyword"},"const"),e(" fileInput = "),s("span",{class:"hljs-variable language_"},"document"),e("."),s("span",{class:"hljs-title function_"},"querySelector"),e("("),s("span",{class:"hljs-string"},`'input[type="file"]'`),e(`);
`),s("span",{class:"hljs-keyword"},"const"),e(" formData = "),s("span",{class:"hljs-keyword"},"new"),e(),s("span",{class:"hljs-title class_"},"FormData"),e(`();

formData.`),s("span",{class:"hljs-title function_"},"append"),e("("),s("span",{class:"hljs-string"},"'title'"),e(", "),s("span",{class:"hljs-string"},"'My First File'"),e(`);
formData.`),s("span",{class:"hljs-title function_"},"append"),e("("),s("span",{class:"hljs-string"},"'file'"),e(", fileInput."),s("span",{class:"hljs-property"},"files"),e("["),s("span",{class:"hljs-number"},"0"),e(`]);

`),s("span",{class:"hljs-keyword"},"await"),e(" axios."),s("span",{class:"hljs-title function_"},"post"),e("("),s("span",{class:"hljs-string"},"'/files'"),e(`, formData);
`)])],-1),ee=s("h3",{id:"query-parameters-2",tabindex:"-1"},[s("a",{class:"header-anchor",href:"#query-parameters-2"},"#"),e(" Query Parameters")],-1),ae=s("h3",{id:"returns-2",tabindex:"-1"},[s("a",{class:"header-anchor",href:"#returns-2"},"#"),e(" Returns")],-1),te=s("p",null,[e("Returns the "),s("a",{href:"#the-file-object"},"file object"),e(" for the uploaded file, or an array of "),s("a",{href:"#the-file-object"},"file objects"),e(" if multiple files were uploaded at once.")],-1),ne=s("pre",null,[s("code",{class:"language-txt"},`POST /files
`)],-1),le=s("pre",null,[s("code",null,`// Request

Content-Type: multipart/form-data; charset=utf-8; boundary=__X_BOUNDARY__
Content-Length: 3442422

--__X_BOUNDARY__
Content-Disposition: form-data; name="file"; filename="paulo-silva-vSRgXtQuns8-unsplash.jpg"
Content-Type: image/jpeg

\xFF\xD8\xFF\xE0JFIFHH\xFF\xE2ICC_PROFILE\flcmsmntrRGB XYZ \x07\xDC)9acspAPPL\xF6\xD6\xD3-lcms
desc\xFC^cprt\\\vwtpthbkpt|rXYZ\x90gXYZ\xA4bXYZ\xB8rTRC\xCC@gTRC\xCC@bTRC\xCC@descc2textIXXYZ \xF6\xD6\xD3-XYZ 3\xA4XYZ o\xA28\xF5\x90XYZ b\x99\xB7\x85\xDAXYZ $\xA0\x84\xB6\xCFcurv\xCB\xC9c\x92\bk\v\xF6?Q\x1B4!\xF1)\x902;\x92FQw]\xEDkpz\x89\xB1\x9A|\xACi\xBF}\xD3\xC3\xE90\xFF\xFF\xFF\xDB\x84\b\b\x07\x07
`)],-1),oe=s("hr",null,null,-1),ie=s("h2",{id:"import-a-file",tabindex:"-1"},[s("a",{class:"header-anchor",href:"#import-a-file"},"#"),e(" Import a File")],-1),re=s("p",null,"Import a file from the web",-1),ce=s("h3",{id:"query-parameters-3",tabindex:"-1"},[s("a",{class:"header-anchor",href:"#query-parameters-3"},"#"),e(" Query Parameters")],-1),he=s("h3",{id:"request-body",tabindex:"-1"},[s("a",{class:"header-anchor",href:"#request-body"},"#"),e(" Request Body")],-1),de=s("p",null,[s("code",null,"url"),e(),s("strong",null,"Required"),s("br"),e(" The URL to download the file from.")],-1),ue=s("p",null,[s("code",null,"data"),s("br"),e(" Any of "),s("a",{href:"#the-file-object"},"the file object"),e("\u2019s properties.")],-1),pe=s("h3",{id:"returns-3",tabindex:"-1"},[s("a",{class:"header-anchor",href:"#returns-3"},"#"),e(" Returns")],-1),_e=s("p",null,[e("Returns the "),s("a",{href:"#the-file-object"},"file object"),e(" for the imported file.")],-1),fe=s("h3",{id:"rest-api-2",tabindex:"-1"},[s("a",{class:"header-anchor",href:"#rest-api-2"},"#"),e(" REST API")],-1),me=s("pre",null,[s("code",{class:"language-txt"},`POST /files/import
`)],-1),ge=s("h5",{id:"example-4",tabindex:"-1"},[s("a",{class:"header-anchor",href:"#example-4"},"#"),e(" Example")],-1),je=s("pre",null,[s("code",{class:"language-json"},[s("span",{class:"hljs-comment"},"// POST /files/import"),e(`

`),s("span",{class:"hljs-punctuation"},"{"),e(`
	`),s("span",{class:"hljs-attr"},'"url"'),s("span",{class:"hljs-punctuation"},":"),e(),s("span",{class:"hljs-string"},'"https://source.unsplash.com/random"'),s("span",{class:"hljs-punctuation"},","),e(`
	`),s("span",{class:"hljs-attr"},'"data"'),s("span",{class:"hljs-punctuation"},":"),e(),s("span",{class:"hljs-punctuation"},"{"),e(`
		`),s("span",{class:"hljs-attr"},'"title"'),s("span",{class:"hljs-punctuation"},":"),e(),s("span",{class:"hljs-string"},'"Example"'),e(`
	`),s("span",{class:"hljs-punctuation"},"}"),e(`
`),s("span",{class:"hljs-punctuation"},"}"),e(`
`)])],-1),be=s("h3",{id:"graphql-2",tabindex:"-1"},[s("a",{class:"header-anchor",href:"#graphql-2"},"#"),e(" GraphQL")],-1),ye=s("pre",null,[s("code",{class:"language-txt"},`POST /graphql/system
`)],-1),xe=s("pre",null,[s("code",{class:"language-graphql"},[s("span",{class:"hljs-keyword"},"type"),s("span",{class:"hljs-type"}," Mutation"),e(` {
	import_file(url:`),s("span",{class:"hljs-type"}," String"),e(`!, data: create_directus_files_input!): directus_files
}
`)])],-1),qe=s("h5",{id:"example-5",tabindex:"-1"},[s("a",{class:"header-anchor",href:"#example-5"},"#"),e(" Example")],-1),we=s("pre",null,[s("code",{class:"language-graphql"},[s("span",{class:"hljs-keyword"},"mutation"),e(` {
	import_file(url: `),s("span",{class:"hljs-string"},'"https://source.unsplash.com/random"'),e(", data: { title: "),s("span",{class:"hljs-string"},'"Example"'),e(` }) {
		id
	}
}
`)])],-1),ve=s("hr",null,null,-1),Te=s("h2",{id:"update-a-file",tabindex:"-1"},[s("a",{class:"header-anchor",href:"#update-a-file"},"#"),e(" Update a File")],-1),ke=s("p",null,"Update an existing file, and/or replace it\u2019s file contents.",-1),Ee=s("h3",{id:"query-parameters-4",tabindex:"-1"},[s("a",{class:"header-anchor",href:"#query-parameters-4"},"#"),e(" Query Parameters")],-1),Re=s("h3",{id:"request-body-1",tabindex:"-1"},[s("a",{class:"header-anchor",href:"#request-body-1"},"#"),e(" Request Body")],-1),Ae=s("p",null,[e("You can either submit a JSON object consisting of a partial "),s("a",{href:"#the-file-object"},"file object"),e(" to update the file meta, or send a multipart/form-data request to replace the file contents on disk. See "),s("a",{href:"#upload-a-file"},"Upload a File"),e(" for more information on the structure of this "),s("code",null,"multipart/form-data"),e(" request.")],-1),Se=s("h3",{id:"returns-4",tabindex:"-1"},[s("a",{class:"header-anchor",href:"#returns-4"},"#"),e(" Returns")],-1),De=s("p",null,[e("Returns the "),s("a",{href:"#the-file-object"},"file object"),e(" for the updated file.")],-1),Pe=s("h3",{id:"rest-api-3",tabindex:"-1"},[s("a",{class:"header-anchor",href:"#rest-api-3"},"#"),e(" REST API")],-1),Ie=s("pre",null,[s("code",{class:"language-txt"},`PATCH /files/:id
`)],-1),Ce=s("h5",{id:"example-6",tabindex:"-1"},[s("a",{class:"header-anchor",href:"#example-6"},"#"),e(" Example")],-1),Fe=s("pre",null,[s("code",{class:"language-json"},[s("span",{class:"hljs-comment"},"// PATCH /files/0fca80c4-d61c-4404-9fd7-6ba86b64154d"),e(`

`),s("span",{class:"hljs-punctuation"},"{"),e(`
	`),s("span",{class:"hljs-attr"},'"title"'),s("span",{class:"hljs-punctuation"},":"),e(),s("span",{class:"hljs-string"},'"Example"'),e(`
`),s("span",{class:"hljs-punctuation"},"}"),e(`
`)])],-1),Oe=s("h3",{id:"graphql-3",tabindex:"-1"},[s("a",{class:"header-anchor",href:"#graphql-3"},"#"),e(" GraphQL")],-1),Qe=s("pre",null,[s("code",{class:"language-txt"},`POST /graphql/system
`)],-1),Le=s("pre",null,[s("code",{class:"language-graphql"},[s("span",{class:"hljs-keyword"},"type"),s("span",{class:"hljs-type"}," Mutation"),e(` {
	update_files_item(id:`),s("span",{class:"hljs-literal"}," ID"),e(`!, data: update_directus_files_input!): directus_files
}
`)])],-1),Xe=s("h5",{id:"example-7",tabindex:"-1"},[s("a",{class:"header-anchor",href:"#example-7"},"#"),e(" Example")],-1),Be=s("pre",null,[s("code",{class:"language-graphql"},[s("span",{class:"hljs-keyword"},"mutation"),e(` {
	update_files_item(id: `),s("span",{class:"hljs-string"},'"0fca80c4-d61c-4404-9fd7-6ba86b64154d"'),e(", data: { title: "),s("span",{class:"hljs-string"},'"Example"'),e(` }) {
		id
		title
	}
}
`)])],-1),Ue=s("hr",null,null,-1),Ye=s("h2",{id:"update-multiple-files",tabindex:"-1"},[s("a",{class:"header-anchor",href:"#update-multiple-files"},"#"),e(" Update Multiple Files")],-1),Ge=s("p",null,"Update multiple files at the same time.",-1),Me=s("h3",{id:"query-parameters-5",tabindex:"-1"},[s("a",{class:"header-anchor",href:"#query-parameters-5"},"#"),e(" Query Parameters")],-1),ze=s("h3",{id:"request-body-2",tabindex:"-1"},[s("a",{class:"header-anchor",href:"#request-body-2"},"#"),e(" Request Body")],-1),Ne=s("p",null,[s("code",null,"keys"),e(),s("strong",null,"Required"),s("br"),e(" Array of primary keys of the files you\u2019d like to update.")],-1),Ze=s("p",null,[s("code",null,"data"),e(),s("strong",null,"Required"),s("br"),e(" Any of "),s("a",{href:"#the-file-object"},"the file object"),e("\u2019s properties.")],-1),He=s("h3",{id:"returns-5",tabindex:"-1"},[s("a",{class:"header-anchor",href:"#returns-5"},"#"),e(" Returns")],-1),We=s("p",null,[e("Returns the "),s("a",{href:"#the-file-object"},"file objects"),e(" for the updated files.")],-1),Ke=s("h3",{id:"rest-api-4",tabindex:"-1"},[s("a",{class:"header-anchor",href:"#rest-api-4"},"#"),e(" REST API")],-1),Je=s("pre",null,[s("code",{class:"language-txt"},`PATCH /files
`)],-1),Ve=s("h5",{id:"example-8",tabindex:"-1"},[s("a",{class:"header-anchor",href:"#example-8"},"#"),e(" Example")],-1),$e=s("pre",null,[s("code",{class:"language-json"},[s("span",{class:"hljs-comment"},"// PATCH /files"),e(`

`),s("span",{class:"hljs-punctuation"},"{"),e(`
	`),s("span",{class:"hljs-attr"},'"keys"'),s("span",{class:"hljs-punctuation"},":"),e(),s("span",{class:"hljs-punctuation"},"["),s("span",{class:"hljs-string"},'"b6123925-2fc0-4a30-9d86-863eafc0a6e7"'),s("span",{class:"hljs-punctuation"},","),e(),s("span",{class:"hljs-string"},'"d17c10aa-0bad-4864-9296-84f522c753e5"'),s("span",{class:"hljs-punctuation"},"]"),s("span",{class:"hljs-punctuation"},","),e(`
	`),s("span",{class:"hljs-attr"},'"data"'),s("span",{class:"hljs-punctuation"},":"),e(),s("span",{class:"hljs-punctuation"},"{"),e(`
		`),s("span",{class:"hljs-attr"},'"tags"'),s("span",{class:"hljs-punctuation"},":"),e(),s("span",{class:"hljs-punctuation"},"["),s("span",{class:"hljs-string"},'"cities"'),s("span",{class:"hljs-punctuation"},"]"),e(`
	`),s("span",{class:"hljs-punctuation"},"}"),e(`
`),s("span",{class:"hljs-punctuation"},"}"),e(`
`)])],-1),sa=s("h3",{id:"graphql-4",tabindex:"-1"},[s("a",{class:"header-anchor",href:"#graphql-4"},"#"),e(" GraphQL")],-1),ea=s("pre",null,[s("code",{class:"language-txt"},`POST /graphql/system
`)],-1),aa=s("pre",null,[s("code",{class:"language-graphql"},[s("span",{class:"hljs-keyword"},"type"),s("span",{class:"hljs-type"}," Mutation"),e(` {
	update_files_items(ids: `),s("span",{class:"hljs-literal"},"[ID"),e(`!]!, data: update_directus_files!): [directus_files]
}
`)])],-1),ta=s("h5",{id:"example-9",tabindex:"-1"},[s("a",{class:"header-anchor",href:"#example-9"},"#"),e(" Example")],-1),na=s("pre",null,[s("code",{class:"language-graphql"},[s("span",{class:"hljs-keyword"},"mutation"),e(` {
	update_files_items(
		ids: [`),s("span",{class:"hljs-string"},'"b6123925-2fc0-4a30-9d86-863eafc0a6e7"'),e(", "),s("span",{class:"hljs-string"},'"d17c10aa-0bad-4864-9296-84f522c753e5"'),e(`]
		data: { tags: [`),s("span",{class:"hljs-string"},'"cities"'),e(`] }
	)
}
`)])],-1),la=s("hr",null,null,-1),oa=s("h2",{id:"delete-a-file",tabindex:"-1"},[s("a",{class:"header-anchor",href:"#delete-a-file"},"#"),e(" Delete a File")],-1),ia=s("p",null,"Delete an existing file.",-1),ra=s("div",{class:"danger hint"},[s("div",{class:"hint-title"},"Destructive"),s("p",null,"This will also delete the file from disk.")],-1),ca=s("h3",{id:"query-parameters-6",tabindex:"-1"},[s("a",{class:"header-anchor",href:"#query-parameters-6"},"#"),e(" Query Parameters")],-1),ha=s("h3",{id:"returns-6",tabindex:"-1"},[s("a",{class:"header-anchor",href:"#returns-6"},"#"),e(" Returns")],-1),da=s("p",null,"Empty response.",-1),ua=s("h3",{id:"rest-api-5",tabindex:"-1"},[s("a",{class:"header-anchor",href:"#rest-api-5"},"#"),e(" REST API")],-1),pa=s("pre",null,[s("code",{class:"language-txt"},`DELETE /files/:id
`)],-1),_a=s("h5",{id:"example-10",tabindex:"-1"},[s("a",{class:"header-anchor",href:"#example-10"},"#"),e(" Example")],-1),fa=s("pre",null,[s("code",{class:"language-txt"},`DELETE /files/0fca80c4-d61c-4404-9fd7-6ba86b64154d
`)],-1),ma=s("h3",{id:"graphql-5",tabindex:"-1"},[s("a",{class:"header-anchor",href:"#graphql-5"},"#"),e(" GraphQL")],-1),ga=s("pre",null,[s("code",{class:"language-txt"},`POST /graphql/system
`)],-1),ja=s("pre",null,[s("code",{class:"language-graphql"},[s("span",{class:"hljs-keyword"},"type"),s("span",{class:"hljs-type"}," Mutation"),e(` {
	delete_files_item(id:`),s("span",{class:"hljs-literal"}," ID"),e(`!): delete_one
}
`)])],-1),ba=s("pre",null,[s("code",{class:"language-graphql"},[s("span",{class:"hljs-keyword"},"mutation"),e(` {
	delete_files_item(id: `),s("span",{class:"hljs-string"},'"0fca80c4-d61c-4404-9fd7-6ba86b64154d"'),e(`) {
		id
	}
}
`)])],-1),ya=s("hr",null,null,-1),xa=s("h2",{id:"delete-multiple-files",tabindex:"-1"},[s("a",{class:"header-anchor",href:"#delete-multiple-files"},"#"),e(" Delete Multiple Files")],-1),qa=s("p",null,"Delete multiple files at once.",-1),wa=s("div",{class:"danger hint"},[s("div",{class:"hint-title"},"Destructive"),s("p",null,"This will also delete the files from disk.")],-1),va=s("h3",{id:"request-body-3",tabindex:"-1"},[s("a",{class:"header-anchor",href:"#request-body-3"},"#"),e(" Request Body")],-1),Ta=s("p",null,"Array of file primary keys",-1),ka=s("h3",{id:"returns-7",tabindex:"-1"},[s("a",{class:"header-anchor",href:"#returns-7"},"#"),e(" Returns")],-1),Ea=s("p",null,"Empty response.",-1),Ra=s("h3",{id:"rest-api-6",tabindex:"-1"},[s("a",{class:"header-anchor",href:"#rest-api-6"},"#"),e(" REST API")],-1),Aa=s("pre",null,[s("code",{class:"language-txt"},`DELETE /files
`)],-1),Sa=s("h5",{id:"example-11",tabindex:"-1"},[s("a",{class:"header-anchor",href:"#example-11"},"#"),e(" Example")],-1),Da=s("pre",null,[s("code",{class:"language-json"},[s("span",{class:"hljs-comment"},"// DELETE /files"),e(`

`),s("span",{class:"hljs-punctuation"},"["),s("span",{class:"hljs-string"},'"d17c10aa-0bad-4864-9296-84f522c753e5"'),s("span",{class:"hljs-punctuation"},","),e(),s("span",{class:"hljs-string"},'"b6123925-2fc0-4a30-9d86-863eafc0a6e7"'),s("span",{class:"hljs-punctuation"},"]"),e(`
`)])],-1),Pa=s("h3",{id:"graphql-6",tabindex:"-1"},[s("a",{class:"header-anchor",href:"#graphql-6"},"#"),e(" GraphQL")],-1),Ia=s("pre",null,[s("code",{class:"language-txt"},`POST /graphql/system
`)],-1),Ca=s("pre",null,[s("code",{class:"language-graphql"},[s("span",{class:"hljs-keyword"},"type"),s("span",{class:"hljs-type"}," Mutation"),e(` {
	delete_files_items(ids: `),s("span",{class:"hljs-literal"},"[ID"),e(`!]!): delete_many
}
`)])],-1),Fa=s("h5",{id:"example-12",tabindex:"-1"},[s("a",{class:"header-anchor",href:"#example-12"},"#"),e(" Example")],-1),Oa=s("pre",null,[s("code",{class:"language-graphql"},[s("span",{class:"hljs-keyword"},"mutation"),e(` {
	delete_files_items(ids: [`),s("span",{class:"hljs-string"},'"d17c10aa-0bad-4864-9296-84f522c753e5"'),e(", "),s("span",{class:"hljs-string"},'"b6123925-2fc0-4a30-9d86-863eafc0a6e7"'),e(`]) {
		ids
	}
}
`)])],-1),Ua="Accessing Files",Ya=!1,Ga="REST and GraphQL API documentation for file access and management in Directus.",Ma="10 min read",za="page-reference",Na={__name:"files",setup(Qa,{expose:i}){const l={title:"Accessing Files",modularExtension:!1,description:"REST and GraphQL API documentation for file access and management in Directus.",readTime:"10 min read",pageClass:"page-reference"};return i({frontmatter:l}),(La,Xa)=>{const t=o("router-link"),r=o("docs-wrapper");return c(),h(r,{frontmatter:l},{default:a(()=>[s("div",d,[u,p,_,f,m,g,j,b,y,x,q,w,v,T,k,E,R,s("ul",null,[s("li",null,[A,e(" \u2014 This "),S,e(" of the "),n(t,{to:"/docs/configuration/project-settings#files-thumbnails"},{default:a(()=>[e("Storage Asset Preset")]),_:1}),e(", a shortcut for the below parameters")])]),D,P,I,C,F,O,Q,L,X,B,U,Y,G,M,z,N,Z,H,W,K,J,V,s("p",null,[$,e(),ss,es,e(" What (virtual) folder the file is in. Many-to-one to "),n(t,{to:"/docs/reference/system/folders"},{default:a(()=>[e("folders")]),_:1}),e(".")]),s("p",null,[as,e(),ts,ns,e(" Who uploaded the file. Many-to-one to "),n(t,{to:"/docs/reference/system/users"},{default:a(()=>[e("users")]),_:1}),e(".")]),ls,s("p",null,[os,e(),is,rs,e(" Who updated the file last. Many-to-one to "),n(t,{to:"/docs/reference/system/users"},{default:a(()=>[e("users")]),_:1}),e(".")]),cs,hs,ds,us,ps,_s,fs,ms,gs,js,bs,ys,xs,s("p",null,[e("Supports all "),n(t,{to:"/docs/reference/query"},{default:a(()=>[e("global query parameters")]),_:1}),e(".")]),qs,s("p",null,[e("An array of up to "),n(t,{to:"/docs/reference/query#limit"},{default:a(()=>[e("limit")]),_:1}),e(),ws,e(". If no items are available, data will be an empty array.")]),vs,Ts,s("p",null,[n(t,{to:"/docs/reference/introduction#search-http-method"},{default:a(()=>[e("Learn more about SEARCH ->")]),_:1})]),ks,Es,Rs,As,Ss,Ds,Ps,Is,Cs,s("p",null,[e("Supports all "),n(t,{to:"/docs/reference/query"},{default:a(()=>[e("global query parameters")]),_:1}),e(".")]),Fs,Os,Qs,Ls,Xs,Bs,Us,Ys,Gs,Ms,zs,Ns,Zs,Hs,Ws,Ks,Js,Vs,$s,se,ee,s("p",null,[e("Supports all "),n(t,{to:"/docs/reference/query"},{default:a(()=>[e("global query parameters")]),_:1}),e(".")]),ae,te,ne,le,oe,ie,re,ce,s("p",null,[e("Supports all "),n(t,{to:"/docs/reference/query"},{default:a(()=>[e("global query parameters")]),_:1}),e(".")]),he,de,ue,pe,_e,fe,me,ge,je,be,ye,xe,qe,we,ve,Te,ke,Ee,s("p",null,[e("Supports all "),n(t,{to:"/docs/reference/query"},{default:a(()=>[e("global query parameters")]),_:1}),e(".")]),Re,Ae,Se,De,Pe,Ie,Ce,Fe,Oe,Qe,Le,Xe,Be,Ue,Ye,Ge,Me,s("p",null,[e("Supports all "),n(t,{to:"/docs/reference/query"},{default:a(()=>[e("global query parameters")]),_:1}),e(".")]),ze,Ne,Ze,He,We,Ke,Je,Ve,$e,sa,ea,aa,ta,na,la,oa,ia,ra,ca,s("p",null,[e("Supports all "),n(t,{to:"/docs/reference/query"},{default:a(()=>[e("global query parameters")]),_:1}),e(".")]),ha,da,ua,pa,_a,fa,ma,ga,ja,ba,ya,xa,qa,wa,va,Ta,ka,Ea,Ra,Aa,Sa,Da,Pa,Ia,Ca,Fa,Oa])]),_:1})}}};export{Na as default,Ga as description,Ya as modularExtension,za as pageClass,Ma as readTime,Ua as title};
