import{a,o,e as r,y as i,u as s,q as e}from"./runtime-core.esm-bundler.22ec0346.js";const c=s("div",{class:"markdown-body"},[s("blockquote",null,[s("p",null,"Custom API Endpoints register new API routes which can be used to infinitely extend the core functionality of the platform.")]),s("h2",{id:"extension-entrypoint",tabindex:"-1"},[s("a",{class:"header-anchor",href:"#extension-entrypoint"},"#"),e(" Extension Entrypoint")]),s("p",null,[e("The entrypoint of your endpoint is the "),s("code",null,"index"),e(" file inside the "),s("code",null,"src/"),e(" folder of your extension package. It exports a register function to register one or more custom routes. Each route of your endpoint will be a sub-route of "),s("code",null,"/<extension-name>"),e(".")]),s("div",{class:"tip hint"},[s("div",{class:"hint-title"},"Extension Name"),s("p",null,"The extension name is usually the name of the folder where you put your extension when deploying it.")]),s("p",null,"Example of an entrypoint:"),s("pre",null,[s("code",{class:"language-js"},[s("span",{class:"hljs-keyword"},"export"),e(),s("span",{class:"hljs-keyword"},"default"),e(` (router) => {
	router.`),s("span",{class:"hljs-title function_"},"get"),e("("),s("span",{class:"hljs-string"},"'/'"),e(", "),s("span",{class:"hljs-function"},[e("("),s("span",{class:"hljs-params"},"req, res"),e(") =>")]),e(" res."),s("span",{class:"hljs-title function_"},"send"),e("("),s("span",{class:"hljs-string"},"'Hello, World!'"),e(`));
};
`)])]),s("p",null,"Alternatively, you can export a configuration object to be able to customize the root route:"),s("pre",null,[s("code",{class:"language-js"},[s("span",{class:"hljs-keyword"},"export"),e(),s("span",{class:"hljs-keyword"},"default"),e(` {
	`),s("span",{class:"hljs-attr"},"id"),e(": "),s("span",{class:"hljs-string"},"'greet'"),e(`,
	`),s("span",{class:"hljs-attr"},"handler"),e(": "),s("span",{class:"hljs-function"},[e("("),s("span",{class:"hljs-params"},"router"),e(") =>")]),e(` {
		router.`),s("span",{class:"hljs-title function_"},"get"),e("("),s("span",{class:"hljs-string"},"'/'"),e(", "),s("span",{class:"hljs-function"},[e("("),s("span",{class:"hljs-params"},"req, res"),e(") =>")]),e(" res."),s("span",{class:"hljs-title function_"},"send"),e("("),s("span",{class:"hljs-string"},"'Hello, World!'"),e(`));
		router.`),s("span",{class:"hljs-title function_"},"get"),e("("),s("span",{class:"hljs-string"},"'/intro'"),e(", "),s("span",{class:"hljs-function"},[e("("),s("span",{class:"hljs-params"},"req, res"),e(") =>")]),e(" res."),s("span",{class:"hljs-title function_"},"send"),e("("),s("span",{class:"hljs-string"},"'Nice to meet you.'"),e(`));
		router.`),s("span",{class:"hljs-title function_"},"get"),e("("),s("span",{class:"hljs-string"},"'/goodbye'"),e(", "),s("span",{class:"hljs-function"},[e("("),s("span",{class:"hljs-params"},"req, res"),e(") =>")]),e(" res."),s("span",{class:"hljs-title function_"},"send"),e("("),s("span",{class:"hljs-string"},"'Goodbye!'"),e(`));
	},
};
`)])]),s("p",null,[e("The routes of this endpoint are accessible at "),s("code",null,"/greet"),e(", "),s("code",null,"/greet/intro"),e(" and "),s("code",null,"/greet/goodbye"),e(".")]),s("h4",{id:"available-options",tabindex:"-1"},[s("a",{class:"header-anchor",href:"#available-options"},"#"),e(" Available Options")]),s("ul",null,[s("li",null,[s("code",null,"id"),e(" \u2014 The unique key for this endpoint. Each route of your endpoint will be a sub-route of "),s("code",null,"/<id>"),e(".")]),s("li",null,[s("code",null,"handler"),e(" \u2014 The endpoint\u2019s registration handler function.")])]),s("h2",{id:"register-function",tabindex:"-1"},[s("a",{class:"header-anchor",href:"#register-function"},"#"),e(" Register Function")]),s("p",null,[e("The register function receives the two parameters "),s("code",null,"router"),e(" and "),s("code",null,"context"),e(". "),s("code",null,"router"),e(" is an Express router instance. "),s("code",null,"context"),e(" is an object with the following properties:")]),s("ul",null,[s("li",null,[s("code",null,"services"),e(" \u2014 All API internal services.")]),s("li",null,[s("code",null,"exceptions"),e(" \u2014 API exception objects that can be used to throw \u201Cproper\u201D errors.")]),s("li",null,[s("code",null,"database"),e(" \u2014 Knex instance that is connected to the current database.")]),s("li",null,[s("code",null,"getSchema"),e(" \u2014 Async function that reads the full available schema for use in services")]),s("li",null,[s("code",null,"env"),e(" \u2014 Parsed environment variables.")]),s("li",null,[s("code",null,"logger"),e(" \u2014 "),s("a",{href:"https://github.com/pinojs/pino",target:"_blank",rel:"noopener noreferrer"},"Pino"),e(" instance.")]),s("li",null,[s("code",null,"emitter"),e(" \u2014 "),s("a",{href:"https://github.com/directus/directus/blob/main/api/src/emitter.ts",target:"_blank",rel:"noopener noreferrer"},"Event emitter"),e(" instance that can be used to trigger custom events for other extensions.")])]),s("div",{class:"warning hint"},[s("div",{class:"hint-title"},"Event loop"),s("p",null,"When implementing custom events using the emitter make sure you never directly or indirectly emit the same event your hook is currently handling as that would result in an infinite loop!")]),s("h2",{id:"example%3A-recipes",tabindex:"-1"},[s("a",{class:"header-anchor",href:"#example%3A-recipes"},"#"),e(" Example: Recipes")]),s("pre",null,[s("code",{class:"language-js"},[s("span",{class:"hljs-keyword"},"export"),e(),s("span",{class:"hljs-keyword"},"default"),e(` (router, { services, exceptions }) => {
	`),s("span",{class:"hljs-keyword"},"const"),e(" { "),s("span",{class:"hljs-title class_"},"ItemsService"),e(` } = services;
	`),s("span",{class:"hljs-keyword"},"const"),e(" { "),s("span",{class:"hljs-title class_"},"ServiceUnavailableException"),e(` } = exceptions;

	router.`),s("span",{class:"hljs-title function_"},"get"),e("("),s("span",{class:"hljs-string"},"'/'"),e(", "),s("span",{class:"hljs-function"},[e("("),s("span",{class:"hljs-params"},"req, res, next"),e(") =>")]),e(` {
		`),s("span",{class:"hljs-keyword"},"const"),e(" recipeService = "),s("span",{class:"hljs-keyword"},"new"),e(),s("span",{class:"hljs-title class_"},"ItemsService"),e("("),s("span",{class:"hljs-string"},"'recipes'"),e(", { "),s("span",{class:"hljs-attr"},"schema"),e(": req."),s("span",{class:"hljs-property"},"schema"),e(", "),s("span",{class:"hljs-attr"},"accountability"),e(": req."),s("span",{class:"hljs-property"},"accountability"),e(` });

		recipeService
			.`),s("span",{class:"hljs-title function_"},"readByQuery"),e("({ "),s("span",{class:"hljs-attr"},"sort"),e(": ["),s("span",{class:"hljs-string"},"'name'"),e("], "),s("span",{class:"hljs-attr"},"fields"),e(": ["),s("span",{class:"hljs-string"},"'*'"),e(`] })
			.`),s("span",{class:"hljs-title function_"},"then"),e("("),s("span",{class:"hljs-function"},[e("("),s("span",{class:"hljs-params"},"results"),e(") =>")]),e(" res."),s("span",{class:"hljs-title function_"},"json"),e(`(results))
			.`),s("span",{class:"hljs-title function_"},"catch"),e("("),s("span",{class:"hljs-function"},[e("("),s("span",{class:"hljs-params"},"error"),e(") =>")]),e(` {
				`),s("span",{class:"hljs-keyword"},"return"),e(),s("span",{class:"hljs-title function_"},"next"),e("("),s("span",{class:"hljs-keyword"},"new"),e(),s("span",{class:"hljs-title class_"},"ServiceUnavailableException"),e("(error."),s("span",{class:"hljs-property"},"message"),e(`));
			});
	});
};
`)])])],-1),j="Custom API Endpoints",f=!0,m="A guide on how to build custom API endpoints in Directus.",g="3 min read",y={__name:"endpoints",setup(p,{expose:t}){const n={title:"Custom API Endpoints",modularExtension:!0,description:"A guide on how to build custom API endpoints in Directus.",readTime:"3 min read"};return t({frontmatter:n}),(u,h)=>{const l=a("docs-wrapper");return o(),r(l,{frontmatter:n},{default:i(()=>[c]),_:1})}}};export{y as default,m as description,f as modularExtension,g as readTime,j as title};
