import{a as l,o as r,e as c,y as a,u as e,q as t,z as n}from"./runtime-core.esm-bundler.22ec0346.js";const u={class:"markdown-body"},h=e("blockquote",null,[e("p",null,"The Directus data studio enables no-code configuration and management for any SQL database, with no arbitrary restrictions on how you build your data model. You get control over table, column and relationship configuration, as well as how users view and interact with data inside the data studio.")],-1),m={class:"tip hint"},p=e("div",{class:"hint-title"},"Learn More",-1),y=e("h2",{id:"relational-data-models",tabindex:"-1"},[e("a",{class:"header-anchor",href:"#relational-data-models"},"#"),t(" Relational Data Models")],-1),b=e("p",null,[t("In order to understand how Directus handles data models, you will need an understanding of what relational data models are. This section provides a brief summary of the core concepts. It may be useful as a review, or for business users working on your team that want a simple explanation of how data models work. If you have a firm knowledge of relational data model concepts, such as databases, data tables, columns, data types, primary and foreign keys, rows, relationships, and schemas then feel free to jump to "),e("a",{href:"#data-models-in-directus"},"Data Models in Directus"),t(".")],-1),f=e("h3",{id:"databases",tabindex:"-1"},[e("a",{class:"header-anchor",href:"#databases"},"#"),t(" Databases")],-1),g=e("p",null,"Directus is an SQL database wrapper. A database is a set of data stored in a computer, in a structured way, making it organized, accessible, and scalable. The specific way you structure your data within a database is called your data model.",-1),w=e("p",null,[e("img",{src:"https://cdn.directus.io/docs/v9/configuration/data-model/data-model-20220805/database-schema-20220805A.webp",alt:"A Database Schema"})],-1),_=e("h3",{id:"database-vs-excel",tabindex:"-1"},[e("a",{class:"header-anchor",href:"#database-vs-excel"},"#"),t(" Database vs Excel")],-1),v=e("p",null,[t("To make a comparison most business users can relate with, storing data in a database is "),e("em",null,"somewhat"),t(" similar to storing data in Excel spreadsheets. You know how you can build a table on one sheet in Excel, build another table on another sheet, then link the rows of each table together? That is pretty much how a relational data model works. But there are some key points where Excel and relational databases differ.")],-1),k=e("p",null,[e("img",{src:"https://cdn.directus.io/docs/v9/configuration/data-model/data-model-20220805/spreadsheet-20220805A.webp",alt:"Data in an Excel Spreadsheet"})],-1),D=e("p",null,[t("Many times, we store data as a table in Excel, but that\u2019s not always the case, as the program serves tons of other purposes. Excel lets you make your data stylized "),e("em",null,"(bold, italicized, colored, custom fonts, etc.)"),t(", set dynamic functions in cells, add graphics like charts and graphs, and input any kind of data into any cell you\u2019d like with no enforced structure. Your Excel spreadsheet is a blank canvas, designed to store up to tens of thousands of rows of information.")],-1),T=e("p",null,[e("img",{src:"https://cdn.directus.io/docs/v9/configuration/data-model/data-model-20220805/datatable-20220805A.webp",alt:"A data table"})],-1),x=e("p",null,[t("There is no stylization within databases. They strictly store raw data values in a structured way. Any time you want to style data, build a function, put data into a graph, "),e("em",null,"etc.,"),t(" you must create that functionality in your app or website. Databases store raw, un-stylized, structured data and are designed to handle millions, "),e("em",null,"and in some cases billions and trillions"),t(", of rows of information.")],-1),I=e("h3",{id:"data-tables",tabindex:"-1"},[e("a",{class:"header-anchor",href:"#data-tables"},"#"),t(" Data Tables")],-1),A=e("p",null,[e("img",{src:"https://cdn.directus.io/docs/v9/configuration/data-model/data-model-20220805/rows-and-columns.webp",alt:"A Data Table: rows and columns"})],-1),S=e("p",null,[t("SQL databases store data across data tables. Data tables typically store information about one distinct type of record, object, or observation, such as a financial transaction, blog post, geo-position, user, IoT event, "),e("em",null,"or anything"),t(". Data tables are further broken down into columns and rows.")],-1),M=e("h3",{id:"columns",tabindex:"-1"},[e("a",{class:"header-anchor",href:"#columns"},"#"),t(" Columns")],-1),j=e("p",null,[e("img",{src:"https://cdn.directus.io/docs/v9/configuration/data-model/data-model-20220805/columns-20220805A.webp",alt:"A Column"})],-1),E=e("p",null,[t("Columns are categories that store one kind of information. Each column has a unique, descriptive name and stores one unit of information in each of its "),e("a",{href:"#cell-values"},"cell values"),t(". Columns keep the data organized, consistent, and easily accessible. The columns you choose to add to a data table will completely depend on the information you need to store.")],-1),R=e("h3",{id:"cell-values",tabindex:"-1"},[e("a",{class:"header-anchor",href:"#cell-values"},"#"),t(" Cell Values")],-1),q=e("p",null,[e("img",{src:"https://cdn.directus.io/docs/v9/configuration/data-model/data-model-20220805/datatable-cell-value-20220805A.webp",alt:"Cell Values"})],-1),C=e("p",null,[t("Each value in a column is stored in its own cell. In general, you want to create columns that save "),e("em",null,"atomic"),t(" values. That means create the column to store the smallest indivisible units There is no restriction for the kinds of information to include in a column, but there are good and bad practices. For example:")],-1),F=e("ul",null,[e("li",null,[e("strong",null,"A Bad Column:"),t(" A "),e("code",null,"city_state_zipcode"),t(" column.")]),e("li",null,[e("strong",null,"Good Columns:"),t(" Separate "),e("code",null,"city"),t(", "),e("code",null,"state"),t(" and "),e("code",null,"zipcode"),t(" columns.")])],-1),z=e("h3",{id:"data-types",tabindex:"-1"},[e("a",{class:"header-anchor",href:"#data-types"},"#"),t(" Data Types")],-1),L=e("p",null,[t("To further maintain structure and consistency, when you create a column, you must also define its data type. For example, an "),e("code",null,"age"),t(" column might be assigned "),e("code",null,"INTEGER"),t(" and a "),e("code",null,"blog_content"),t(" column may be assigned a "),e("code",null,"STRING"),t(" or "),e("code",null,"TEXT"),t(" data type. There are countless incongruent, unexpected, and potentially dangerous behaviors that could emerge when a program tries to process data with the wrong data type.")],-1),N=e("p",null,[t("To give an example, if you type the character "),e("code",null,"2"),t(", it may be stored as an "),e("code",null,"INTEGER"),t(" or as "),e("code",null,"STRING"),t(". If you stored "),e("code",null,"2"),t(" as an "),e("code",null,"INTEGER"),t(", when you try to add "),e("code",null,"2 + 2"),t(", the computer will typically calculate "),e("code",null,"4"),t(". In some languages, if you stored the character "),e("code",null,'"2"'),t(" as a "),e("code",null,"STRING"),t(", when you try to add "),e("code",null,'"2" + "2"'),t(", the computer will concatenate them into "),e("code",null,"22"),t(", while in others, trying to do this may crash the program!")],-1),P=e("p",null,"Therefore when you work with data, it is important to know what its data type is because the wrong data type can cause unexpected and even dangerous behaviors in your program.",-1),Q=e("h3",{id:"rows",tabindex:"-1"},[e("a",{class:"header-anchor",href:"#rows"},"#"),t(" Rows")],-1),O=e("p",null,[e("img",{src:"https://cdn.directus.io/docs/v9/configuration/data-model/data-model-20220805/row-20220805A.webp",alt:"Rows"})],-1),U=e("p",null,[t("Each row stores data associated to a unique record, event, object, entity, observation, etc. Data tables can contain millions, "),e("em",null,"even billions and trillions"),t(" of rows of data.")],-1),Y=e("h3",{id:"primary-keys",tabindex:"-1"},[e("a",{class:"header-anchor",href:"#primary-keys"},"#"),t(" Primary Keys")],-1),G=e("p",null,[e("img",{src:"https://cdn.directus.io/docs/v9/configuration/data-model/data-model-20220805/primary-keys-20220805A.webp",alt:"Primary Key"})],-1),W=e("p",null,[t("In order to uniquely identify and track each row, every data table must have a primary key column. A primary key is a unique ID that identifies a specific row. Any pattern or system could be used to generate primary keys, so long as it guarantees each key is unique. Perhaps the most common is incrementing integers, where the primary key on each new row increments as follows "),e("code",null,"1"),t(", "),e("code",null,"2"),t(", "),e("code",null,"3"),t(", "),e("code",null,"4"),t(", etc\u2026 The primary key column guarantees you can always find a row and differentiate it from other rows.")],-1),B=e("h3",{id:"foreign-keys",tabindex:"-1"},[e("a",{class:"header-anchor",href:"#foreign-keys"},"#"),t(" Foreign Keys")],-1),H=e("p",null,[e("img",{src:"https://cdn.directus.io/docs/v9/configuration/data-model/data-model-20220805/foreign-keys-20220805A.webp",alt:"Foreign Keys"})],-1),K=e("p",null,[t("Since primary keys uniquely identify each and every row in a data table, they are the perfect tool to create relationships. If you want to relationally link rows between two data tables, you create a column to store "),e("em",null,"foreign keys"),t(", which are simply primary keys from a foreign table. This is called a "),e("em",null,"foreign key column"),t(", to signify it stores the keys from a foreign table.")],-1),V=e("h3",{id:"parent-vs.-related-tables",tabindex:"-1"},[e("a",{class:"header-anchor",href:"#parent-vs.-related-tables"},"#"),t(" Parent vs. Related Tables")],-1),J=e("p",null,[t("When we talk about two related tables, we refer to them as the "),e("em",null,"parent table"),t(" and the "),e("em",null,"related table"),t(". These two terms are based solely on perspective, similar to the terms "),e("em",null,"this"),t(" and "),e("em",null,"that"),t(" or the terms "),e("em",null,"here"),t(" and "),e("em",null,"there"),t(", signifying the perspective from which you are looking at the relationship.")],-1),X=e("p",null,[t("For example, within the data model, a "),e("a",{href:"#types-of-relationships"},"many-to-one relationship"),t(" is the same as a "),e("a",{href:"#types-of-relationships"},"one-to-many relationship"),t(", the term used just depends on which collection you consider the parent.")],-1),Z=e("h3",{id:"types-of-relationships",tabindex:"-1"},[e("a",{class:"header-anchor",href:"#types-of-relationships"},"#"),t(" Types of Relationships")],-1),$=e("p",null,"There are several ways you can relationally link tables:",-1),ee=e("ul",null,[e("li",null,[e("strong",null,"One to One"),t(" \u2014 Each row in the parent data table can link to one row "),e("em",null,"(max)"),t(" in the related table.")]),e("li",null,[e("strong",null,"Many to One"),t(" \u2014 Many rows in the parent data table can link to one row in the related table.")]),e("li",null,[e("strong",null,"One to Many"),t(" \u2014 Each row in a data table can link to many rows in another data table."),e("br"),e("em",null,"Note: in a data model, Many-to-One and One-to-Many relationships are identical. The naming difference is a matter of perspective.")]),e("li",null,[e("strong",null,"Many to Many"),t(" \u2014 Many rows in the parent table can link to many rows in the related table. M2M relationships require a third table, called junction table. An M2M is nothing more than an O2M and an M2O stored on the junction table.")]),e("li",null,[e("strong",null,"Many to Any"),t(" \u2014 Many Rows in a data table can link to many rows across any other table in the database. Similar to M2M relationships, M2As require a junction data table as well as an additional column on the junction table to store the related tables\u2019 names.")])],-1),te=e("h3",{id:"database-schemas",tabindex:"-1"},[e("a",{class:"header-anchor",href:"#database-schemas"},"#"),t(" Database Schemas")],-1),ae=e("p",null,[e("img",{src:"https://cdn.directus.io/docs/v9/configuration/data-model/data-model-20220805/datatable-to-schema-20220805A.webp",alt:"Data Table to schema"})],-1),oe=e("p",null,[t("In our examples so far, we have seen and described actual "),e("a",{href:"#data-tables"},"data tables"),t(". As you design your relational data model, you will need to create a schema to keep track of its complexity.")],-1),ne=e("p",null,"A schema is a blueprint for your data model, which defines its data tables, columns in each table, details about each column and relationships between tables. It does not include the actual data points stored. Here is a simple schema of two relationally linked tables:",-1),se=e("pre",null,[e("code",null,`table_one
- column1 (primary key)
- column2 (data type, optionally explain what the column stores)
- column3 (...)
`)],-1),le=e("pre",null,[e("code",null,`table_two
- column1 (primary key)
- column2 (...)
- column3 (...)
- table_one_id (foreign key, relationally links rows via table_one.column1)
`)],-1),ie=e("p",null,[t("In the schema above, we defined two tables with overtly generic names "),e("code",null,"table_one"),t(", "),e("code",null,"table_two"),t(" and "),e("code",null,"column1"),t(", "),e("code",null,"column2"),t(", etc. The names you choose for data tables and columns are up to you. Ideally, you should pick unique, memorable names that identify the data contents stored within.")],-1),de=e("p",null,[t("In this documentation, we bend the rules of traditional database schemas in two ways. First, we sometimes add a full-length explanation of what a column is. Notice in "),e("code",null,"table_one.column2"),t(" there is a note after the column name "),e("code",null,"(data type, optionally...."),t(". It is common practice to include a column\u2019s data type in a table schema, but full descriptions are not. Second, in our examples, if columns exist in the table but its data type or other details are irrelevant to the current learning point, we omit their details so you can focus on the important columns.")],-1),re=e("p",null,[t("Please note too, that with more complex schemas, containing dozens "),e("em",null,"(or maybe hundreds!)"),t(" of relationally linked data tables, you usually include datatype information as well as a visualization of how each and every table interlinks.")],-1),ce=e("p",null,[e("img",{src:"https://cdn.directus.io/docs/v9/configuration/data-model/data-model-20220805/complex-schema.webp",alt:"A Complex Schema"})],-1),ue=e("h3",{id:"avoid-data-duplication",tabindex:"-1"},[e("a",{class:"header-anchor",href:"#avoid-data-duplication"},"#"),t(" Avoid Data Duplication")],-1),he=e("p",null,"Relational databases allow us to build data models that avoid data duplication, or in other words, when you have the same data stored in multiple locations in your database. Data Duplication is inefficient and dangerous.",-1),me=e("p",null,[t("To give an example, let\u2019s consider a "),e("code",null,"blog"),t(" table. In a blog, you may want to display the author\u2019s details, so you add an "),e("code",null,"author_name"),t(" column.")],-1),pe=e("pre",null,[e("code",null,`blog
- id
- title
- content
- author_name (string, stores author's full name)
`)],-1),ye=e("p",null,[t("The table above stores the author name directly inside of the "),e("code",null,"blog"),t(" data table. However, let\u2019s imagine that along with our blog posts, we want to display more information about authors, such as their email address, social media, etc. We "),e("em",null,"could"),t(" put this author information into the "),e("code",null,"blog"),t(" data table.")],-1),be=e("pre",null,[e("code",null,`blog
- id
- title
- content
- author_name (string, stores author's full name)
- author_email (string, stores author's email)
- author_img (string, stores link to author's profile picture)
`)],-1),fe=e("p",null,[t("You might be starting to notice this data table no longer represents one single object, but two: blog posts and authors. This is "),e("em",null,"almost always"),t(" a sign the data should be split across different tables and relationally linked.")],-1),ge=e("p",null,[t("Now let\u2019s also imagine that authors are one type of user. All user details are stored in a "),e("code",null,"users"),t(" data table and its data is displayed on each user profile page, for chat messaging and other types of transactions, "),e("em",null,"this is a common situation in many projects"),t(". In this case, the author name and other details would also need to exist in the "),e("code",null,"users"),t(" table.")],-1),we=e("p",null,[e("img",{src:"https://cdn.directus.io/docs/v9/configuration/data-model/data-model-20220805/duplicate-data-20220829A.webp",alt:"Duplicate Data"})],-1),_e=e("p",null,"This creates duplicate data. There are two big problems with this:",-1),ve=e("p",null,[t("First, it becomes difficult or impossible to maintain accurate information. If the author decides to change their social media information under "),e("code",null,"users"),t(", someone would have to go through and update author details on every single row containing their blog posts. With just 10 or even 100 blog posts, this would be annoying but perhaps not a massive problem. However, as volume of data grows to millions or billions of rows, updating duplicate data becomes a serious problem.")],-1),ke=e("p",null,"Furthermore, an error on an author\u2019s name and personal information may not be a truly dangerous situation, but inaccurate information would be catastrophic in data tables containing banking transactions or medical records!",-1),De=e("p",null,"Second, it wastes storage space and slows down performance. With a data model containing a few hundred blog posts, duplicate data may not take up enough space to cause huge drops in performance. But again, if you have the same information repeated again and again over millions or billions of rows, storage is wasted on a massive scale.",-1),Te=e("h3",{id:"why-we-use-relational-data-models",tabindex:"-1"},[e("a",{class:"header-anchor",href:"#why-we-use-relational-data-models"},"#"),t(" Why We Use Relational Data Models")],-1),xe=e("p",null,[t("As shown from the previous section, you want to make sure that every single data point is unique. This is where the "),e("em",null,"relational"),t(" part of relational data models comes into play. To avoid data duplication, it is always best practice to "),e("em",null,"normalize your data model"),t(", which is the technical term used to describe designing a data model so that there is no duplicate information stored "),e("em",null,"at all"),t(". Instead of storing all information needed in a given situation in one table, like we saw when mixing up blog and author information above, database normalization is the process of splitting up this information across tables and relationally linking it all together so that information is never repeated.")],-1),Ie=e("p",null,[t("There is a lot to learn to master database normalization and a thorough education in the practice goes beyond the scope of this document. There are plenty of resources to learn about it online. However, to provide one simple example by improving the example "),e("code",null,"blog"),t(" data table provided in the previous "),e("a",{href:"#avoid-data-duplication"},"Avoid Data Duplication"),t(" section:")],-1),Ae=e("pre",null,[e("code",null,`blog
- id
- title
- content
- author_name
- author_email
- author_img
`)],-1),Se=e("code",null,"author_name",-1),Me=e("code",null,"blog",-1),je=e("code",null,"author_id",-1),Ee=e("code",null,"users",-1),Re=e("pre",null,[e("code",null,`blog
- id
- title
- content
- author_id (stores foreign key from users.id)
`)],-1),qe=e("pre",null,[e("code",null,`users
- id
- name
- email
- role
- email
- twitter
`)],-1),Ce=e("p",null,[t("Notice the difference. Previously, we placed the author\u2019s name directly into a column on the "),e("code",null,"blog"),t(" data table "),e("em",null,"(creating duplicate data)"),t(". Here, we replaced "),e("code",null,"author_name"),t(", "),e("code",null,"author_email"),t(" and "),e("code",null,"author_img"),t(", with the "),e("code",null,"author_id"),t(" column, which contains foreign keys from "),e("code",null,"users"),t(". From here, we can use the foreign key to relationally link data between "),e("code",null,"blog"),t(" and "),e("code",null,"users"),t(".")],-1),Fe=e("h3",{id:"working-with-relational-data-models",tabindex:"-1"},[e("a",{class:"header-anchor",href:"#working-with-relational-data-models"},"#"),t(" Working With Relational Data Models")],-1),ze=e("p",null,[e("img",{src:"https://cdn.directus.io/docs/v9/configuration/data-model/data-model-20220805/database-backend-frontend-20220805A.webp",alt:"Database, Backend, Frontend"})],-1),Le=e("p",null,"Once you\u2019ve designed your data model conceptually, you typically build and interact with it using SQL, or Structured Querying Language. This language is used to create, read & query, update, and delete anything and everything in the database.",-1),Ne=e("p",null,"Once the initial data tables are designed and built, a common next step is to build a backed using something like Node.js or Flask. In your backend, you must code custom API endpoints and logic to create, read, query, update, and delete data for your specific data model. However, when the backend accesses data, it is still raw, with no stylization. Raw data is easy to work with for computers, but often quite difficult to work with for humans.",-1),Pe=e("p",null,"To those who are unfamiliar, the SQL language, raw data, and traditional relational database jargon can feel unintuitive and overly-technical.",-1),Qe=e("p",null,[t("It may not be practical to teach everyone on the team how to work with and think in terms of raw data. In some cases, business users may find it difficult or nearly impossible to work with raw data. People are accustomed to see information displayed "),e("em",null,"colorfully, stylized, embedded on a map, etc."),t(" For example, "),e("em",null,"most people in most situations"),t(" would find it easy to work with pinpoints on a map, yet find it nearly impossible to identify a position on a world map from raw latitude and longitude points stored as JSON.")],-1),Oe=e("pre",null,[e("code",{class:"language-json"},[e("span",{class:"hljs-attr"},'"location"'),e("span",{class:"hljs-punctuation"},":"),t(),e("span",{class:"hljs-punctuation"},"{"),t(`
  `),e("span",{class:"hljs-attr"},'"lat"'),e("span",{class:"hljs-punctuation"},":"),t(),e("span",{class:"hljs-number"},"36.088010"),e("span",{class:"hljs-punctuation"},","),t(`
  `),e("span",{class:"hljs-attr"},'"lng"'),e("span",{class:"hljs-punctuation"},":"),t(),e("span",{class:"hljs-number"},"120.379771"),t(`
`),e("span",{class:"hljs-punctuation"},"}"),t(`
`)])],-1),Ue=e("p",null,"Therefore, developers need to build front-ends with polished UIs and custom display logic to make working with the data human-friendly. However, even for developers with strong SQL database skills, building out APIs and GUIs to build and manage a data model is time consuming.",-1),Ye=e("h2",{id:"data-models-in-directus",tabindex:"-1"},[e("a",{class:"header-anchor",href:"#data-models-in-directus"},"#"),t(" Data Models in Directus")],-1),Ge=e("video",{title:"Settings > Data Model",autoplay:"",playsinline:"",muted:"",loop:"",controls:""},[e("source",{src:"https://cdn.directus.io/docs/v9/configuration/data-model/data-model-20220805/data-model-overview-20220805A.mp4",type:"video/mp4"})],-1),We=e("p",null,"All relational data model concepts listed above apply in Directus. You get complete, un-opinionated, relational data model design and configuration. The difference is that Directus handles all SQL, builds the API, and provides a Data Studio which lets business users work with data in a human-friendly way.",-1),Be=e("p",null,"You have the power to do the following things, without a line of code or SQL:",-1),He=e("ul",null,[e("li",null,"View, configure, and manage your relational data model and asset storage."),e("li",null,"Configure how data is displayed within the Data Studio."),e("li",null,"Configure how data is interacted with by users in the Data Studio."),e("li",null,"Translate any and all text in the Data Studio into any language.")],-1),Ke=e("p",null,[t("Directus replaces traditional relational database jargon with more user-friendly terms and concepts. Please keep in mind that while traditional relational database jargon strictly encompasses database concepts, some of the new Directus terms encompass these relational database concepts "),e("em",null,"plus display and interaction logic"),t(". The following sections will introduce Directus terms and map them to classic relational database concepts.")],-1),Ve=e("h2",{id:"collections",tabindex:"-1"},[e("a",{class:"header-anchor",href:"#collections"},"#"),t(" Collections")],-1),Je=e("video",{title:"Collections",autoplay:"",playsinline:"",muted:"",loop:"",controls:""},[e("source",{src:"https://cdn.directus.io/docs/v9/configuration/data-model/data-model-20220805/collections-20220805A.mp4",type:"video/mp4"})],-1),Xe=e("p",null,[t("A collection "),e("em",null,[t("is a set of "),e("a",{href:"#items"},"items")]),t(". This can be a 1-1 match-up with a data table in SQL, a group of other collections, or a readonly view.")],-1),Ze=e("strong",null,"Settings > Data Model",-1),$e=e("h2",{id:"fields",tabindex:"-1"},[e("a",{class:"header-anchor",href:"#fields"},"#"),t(" Fields")],-1),et=e("video",{title:"Fields",autoplay:"",playsinline:"",muted:"",loop:"",controls:""},[e("source",{src:"https://cdn.directus.io/docs/v9/configuration/data-model/data-model-20220805/fields-20220805A.mp4",type:"video/mp4"})],-1),tt=e("p",null,"Fields are database columns, but with a twist.",-1),at=e("h2",{id:"items",tabindex:"-1"},[e("a",{class:"header-anchor",href:"#items"},"#"),t(" Items")],-1),ot=e("video",{title:"Collections",autoplay:"",playsinline:"",muted:"",loop:"",controls:""},[e("source",{src:"https://cdn.directus.io/docs/v9/configuration/data-model/data-model-20220805/items-20220805A.mp4",type:"video/mp4"})],-1),nt=e("p",null,"Items are data table rows, but with a twist.",-1),st=e("p",null,[t("Remember from our discussion above about traditional databases, the ideal relational database is "),e("em",null,"normalized"),t(". Unfortunately, normalized data is not always the easiest for people to imagine or envision because related data is spread across multiple data tables. Therefore, when you access an item, you may get more than just the current collection\u2019s row level-data, "),e("em",null,"in some cases an item may provide access to the data in related rows.")],-1),lt=e("h2",{id:"data-type-superset",tabindex:"-1"},[e("a",{class:"header-anchor",href:"#data-type-superset"},"#"),t(" Data Type Superset")],-1),it=e("h2",{id:"keys-and-ids",tabindex:"-1"},[e("a",{class:"header-anchor",href:"#keys-and-ids"},"#"),t(" Keys and IDs")],-1),dt=e("video",{title:"Keys and IDs",autoplay:"",playsinline:"",muted:"",loop:"",controls:""},[e("source",{src:"https://cdn.directus.io/docs/v9/configuration/data-model/data-model-20220805/keys-and-ids-20220805A.mp4",type:"video/mp4"})],-1),rt=e("code",null,"id",-1),ct=e("ul",null,[e("li",null,[e("strong",null,"Auto-Incremented Integer"),t(" \u2014 IDs increment "),e("code",null,"1"),t(", "),e("code",null,"2"),t(", "),e("code",null,"3"),t(" up to "),e("code",null,"2^31-1"),t(" or "),e("code",null,"2,147,483,647"),t(".")]),e("li",null,[e("strong",null,"Auto-Incremented Big Integer"),t(" \u2014 IDs increment "),e("code",null,"1"),t(", "),e("code",null,"2"),t(", "),e("code",null,"3"),t(" up to "),e("code",null,"2^63-1"),t(" or "),e("code",null,"9,223,372,036,854,775,807"),t(". "),e("em",null,"(only available in MySQL and PostgreSQL)")]),e("li",null,[e("strong",null,"Generated UUID"),t(" \u2014 Universally Unique Identifier. Creates a completely unique ID. IDs generated with this system "),e("em",null,"(not just in your database, but anywhere this system is used)"),t(" are so statistically unlikely to be repeated that for all practical purposes they are unique.")]),e("li",null,[e("strong",null,"Manually Entered String"),t(" \u2014 You manually type out a unique string as the ID for each item.")])],-1),ut=e("h2",{id:"relationships",tabindex:"-1"},[e("a",{class:"header-anchor",href:"#relationships"},"#"),t(" Relationships")],-1),ht=e("video",{title:"Relations",autoplay:"",playsinline:"",muted:"",loop:"",controls:""},[e("source",{src:"https://cdn.directus.io/docs/v9/configuration/data-model/data-model-20220805/relationships-20220805A.mp4",type:"video/mp4"})],-1),mt=e("a",{href:"#types-of-relationships"},"types of relationships",-1),gt="Data Model",wt=!1,_t="The data model describes the structure of your database's schema using Collections, database tables, and Fields.",vt="15 min read",kt={__name:"data-model",setup(pt,{expose:i}){const s={title:"Data Model",modularExtension:!1,description:"The data model describes the structure of your database's schema using Collections, database tables, and Fields.",readTime:"15 min read"};return i({frontmatter:s}),(yt,bt)=>{const o=l("router-link"),d=l("docs-wrapper");return r(),c(d,{frontmatter:s},{default:a(()=>[e("div",u,[h,e("div",m,[p,e("p",null,[t("Remember, you will have full access to manage your database using SQL. Directus will mirror any changes. You can also configure your data model programmatically via the API. To learn more, see our API documentation on "),n(o,{to:"/docs/reference/system/collections"},{default:a(()=>[t("Collections")]),_:1}),t(", "),n(o,{to:"/docs/reference/system/fields"},{default:a(()=>[t("Fields")]),_:1}),t(", and "),n(o,{to:"/docs/reference/system/relations"},{default:a(()=>[t("Relations")]),_:1}),t(".")])]),y,b,f,g,w,_,v,k,D,T,x,I,A,S,M,j,E,R,q,C,F,z,L,N,P,Q,O,U,Y,G,W,B,H,K,V,J,X,Z,$,ee,e("p",null,[t("To learn more about how these relationships work conceptually, as well as how they are handled within Directus, see our guide on "),n(o,{to:"/docs/configuration/data-model/relationships"},{default:a(()=>[t("relationships")]),_:1}),t(".")]),te,ae,oe,ne,se,le,ie,de,re,ce,ue,he,me,pe,ye,be,fe,ge,we,_e,ve,ke,De,Te,xe,Ie,Ae,e("p",null,[t("As described in the section on "),n(o,{to:"/docs/configuration/data-model#rows"},{default:a(()=>[t("Rows")]),_:1}),t(", we want each row in a data table to represent one unique record, event, object, entity, observation, etc. To do this, we can remove the "),Se,t(" column from the "),Me,t(" table and replace it with an "),je,t(" foreign key table, which stores foreign keys from the "),Ee,t(" table.")]),Re,qe,Ce,Fe,ze,Le,Ne,Pe,Qe,Oe,Ue,Ye,Ge,We,e("p",null,[t("The Data Studio also offers features and functionalities to display and interact with your data intuitively. Once your data model is configured, the data is accessible across the other "),n(o,{to:"/docs/getting-started/glossary#modules"},{default:a(()=>[t("modules")]),_:1}),t(".")]),Be,He,Ke,Ve,Je,Xe,e("p",null,[t("You access all collections, including built-in system collections required to power your project, under "),Ze,t(". From there, click a collection to open its configurations page. To learn more, see our guide on "),n(o,{to:"/docs/configuration/data-model/collections"},{default:a(()=>[t("collections")]),_:1}),t(".")]),$e,et,tt,e("p",null,[t("Remember, SQL database columns store pure, raw data. From there, developers build out custom logic and UIs to determine how this data is displayed and interacted with. In Directus, fields encompass column configurations, as well as custom configuration over how to the data is displayed and interacted with in the Data Studio. Directus also has "),n(o,{to:"/docs/getting-started/glossary#alias"},{default:a(()=>[t("alias fields")]),_:1}),t(", which are virtual and do not match directly to a column. To learn more, see our guide on "),n(o,{to:"/docs/configuration/data-model/fields/"},{default:a(()=>[t("fields")]),_:1}),t(".")]),at,ot,nt,st,e("p",null,[t("You access items from other app modules, such as "),n(o,{to:"/docs/app/content"},{default:a(()=>[t("Content")]),_:1}),t(", "),n(o,{to:"/docs/app/user-directory"},{default:a(()=>[t("User Directory")]),_:1}),t(", and "),n(o,{to:"/docs/app/file-library"},{default:a(()=>[t("File Library")]),_:1}),t(".")]),lt,e("p",null,[t("Directus abstracts type differences between SQL vendors with a "),n(o,{to:"/docs/getting-started/glossary#data-type-superset"},{default:a(()=>[t("Data Type Superset")]),_:1}),t(".")]),it,dt,e("p",null,[t("Primary keys are called IDs in Directus fairly frequently. When you "),n(o,{to:"/docs/configuration/data-model/collections#create-a-collection"},{default:a(()=>[t("create a collection")]),_:1}),t(", you must add an "),rt,t(" field. Directus supports the following types of IDs:")]),ct,ut,ht,e("p",null,[t("Directus supports all standard "),mt,t(", as well as a few more of its own compound types. To learn more, see our guide on "),n(o,{to:"/docs/configuration/data-model/relationships"},{default:a(()=>[t("relationships")]),_:1}),t(".")])])]),_:1})}}};export{kt as default,_t as description,wt as modularExtension,vt as readTime,gt as title};
