import{a as l,o as d,e as r,y as t,u as e,z as o,q as n}from"./runtime-core.esm-bundler.22ec0346.js";const u={class:"markdown-body"},h=e("h2",{id:"scaffolding-your-directus-extension",tabindex:"-1"},[e("a",{class:"header-anchor",href:"#scaffolding-your-directus-extension"},"#"),n(" Scaffolding your Directus Extension")],-1),p=e("p",null,[n("The easiest way to start developing extensions is to use the "),e("code",null,"create-directus-extension"),n(" utility:")],-1),f=e("pre",null,[e("code",{class:"language-bash"},`npm init directus-extension
`)],-1),x=e("p",null,"After specifying the name of the extension, the type of the extension and the programming language you want to use, the utility will create a folder with the recommended file structure to create an extension.",-1),_=e("h3",{id:"extension-folder-structure",tabindex:"-1"},[e("a",{class:"header-anchor",href:"#extension-folder-structure"},"#"),n(" Extension Folder Structure")],-1),g=e("p",null,[n("The folder created by the utility is in fact an npm package. It comes with a few pre-installed packages depending on the extension type and the language you chose. The most important one is "),e("code",null,"@directus/extensions-sdk"),n(". This package includes a CLI, which allows you to build your extension and to scaffold additional extensions, and it provides Typescript helpers and other utilities.")],-1),y=e("p",null,[n("Inside the created folder there is a "),e("code",null,"src/"),n(" folder. This folder contains the entrypoint of your extension. If you write additional source files, they should go into this folder.")],-1),m=e("div",{class:"tip hint"},[e("div",{class:"hint-title"},"Entrypoint"),e("p",null,[n("The entrypoint is either called "),e("code",null,"index.js"),n(" or "),e("code",null,"index.ts"),n(", depending on which programming language you chose.")])],-1),b=e("p",null,[n("The generated "),e("code",null,"package.json"),n(" file contains an additional "),e("code",null,"directus:extension"),n(" field with the following sub-fields:")],-1),w=e("ul",null,[e("li",null,[e("code",null,"type"),n(" \u2014 The type of the extension")]),e("li",null,[e("code",null,"path"),n(" \u2014 The path to the built extension")]),e("li",null,[e("code",null,"source"),n(" \u2014 The path to the source entrypoint")]),e("li",null,[e("code",null,"host"),n(" \u2014 A semver string that indicates with which versions of the Directus host, the extension is compatible with")])],-1),k=e("p",null,"The CLI will use those fields by default to determine the input and output file paths and how the extension should be built.",-1),v=e("h2",{id:"building-your-extension",tabindex:"-1"},[e("a",{class:"header-anchor",href:"#building-your-extension"},"#"),n(" Building your Extension")],-1),T=e("p",null,[n("Before your extension can be used by Directus, it has to be built. If you used the "),e("code",null,"create-directus-extension"),n(" utility to scaffold your extension, building your extension is as easy as running:")],-1),j=e("pre",null,[e("code",{class:"language-bash"},`npm run build
`)],-1),E=e("p",null,[n("The generated "),e("code",null,"package.json"),n(" contains a script that calls the "),e("code",null,"directus-extension"),n(" CLI which is part of "),e("code",null,"@directus/extensions-sdk"),n(":")],-1),I=e("pre",null,[e("code",{class:"language-json"},[e("span",{class:"hljs-punctuation"},"{"),n(`
	`),e("span",{class:"hljs-attr"},'"scripts"'),e("span",{class:"hljs-punctuation"},":"),n(),e("span",{class:"hljs-punctuation"},"{"),n(`
		`),e("span",{class:"hljs-attr"},'"build"'),e("span",{class:"hljs-punctuation"},":"),n(),e("span",{class:"hljs-string"},'"directus-extension build"'),n(`
	`),e("span",{class:"hljs-punctuation"},"}"),n(`
`),e("span",{class:"hljs-punctuation"},"}"),n(`
`)])],-1),C=e("p",null,[n("If you prefer to scaffold your extension manually, you can use the "),e("code",null,"directus-extension"),n(" CLI binary directly. The "),e("code",null,"--help"),n(" flag provides useful information regarding the available options and flags.")],-1),L=e("p",null,"Internally, the CLI uses Rollup to bundle your extension to a single entrypoint.",-1),D=e("div",{class:"tip hint"},[e("div",{class:"hint-title"},"Watch"),e("p",null,[n("The CLI supports rebuilding extensions whenever a file has changed by using the "),e("code",null,"--watch"),n(" flag.")])],-1),A=e("h3",{id:"configuring-the-cli",tabindex:"-1"},[e("a",{class:"header-anchor",href:"#configuring-the-cli"},"#"),n(" Configuring the CLI")],-1),S=e("p",null,[n("Most of the time, it should be sufficient to use the CLI as is. But, in some cases it might be necessary to customize it to your specific needs. This can be done by creating a "),e("code",null,"extension.config.js"),n(" file at the root of your extension package with the following content:")],-1),B=e("pre",null,[e("code",{class:"language-js"},[e("span",{class:"hljs-variable language_"},"module"),n("."),e("span",{class:"hljs-property"},"exports"),n(` = {
	`),e("span",{class:"hljs-attr"},"plugins"),n(`: [],
};
`)])],-1),O=e("h4",{id:"supported-options",tabindex:"-1"},[e("a",{class:"header-anchor",href:"#supported-options"},"#"),n(" Supported Options")],-1),P=e("ul",null,[e("li",null,[e("code",null,"plugins"),n(" \u2014 An array of Rollup plugins that will be used when building extensions in addition to the built-in ones.")])],-1),M=e("div",{class:"tip hint"},[e("div",{class:"hint-title"},"CommonJS or ESM"),e("p",null,[n("By using the "),e("code",null,"type"),n(" field inside your "),e("code",null,"package.json"),n(" file or using the appropriate file extension ("),e("code",null,".mjs"),n(" or "),e("code",null,".cjs"),n("), the config file can be loaded as a CommonJS or ESM file.")])],-1),N=e("h2",{id:"developing-your-extension",tabindex:"-1"},[e("a",{class:"header-anchor",href:"#developing-your-extension"},"#"),n(" Developing your Extension")],-1),R=e("p",null,"To learn more about developing extensions of a specific type, you can refer to one of the individual guides:",-1),V=e("h4",{id:"app-extensions",tabindex:"-1"},[e("a",{class:"header-anchor",href:"#app-extensions"},"#"),n(" App Extensions")],-1),z=e("h4",{id:"api-extensions",tabindex:"-1"},[e("a",{class:"header-anchor",href:"#api-extensions"},"#"),n(" API Extensions")],-1),F=e("h4",{id:"hybrid-extensions",tabindex:"-1"},[e("a",{class:"header-anchor",href:"#hybrid-extensions"},"#"),n(" Hybrid Extensions")],-1),H={class:"tip hint"},J=e("div",{class:"hint-title"},"Live Reloading",-1),W=e("code",null,"EXTENSIONS_AUTO_RELOAD",-1),q=e("h2",{id:"publishing-your-extension",tabindex:"-1"},[e("a",{class:"header-anchor",href:"#publishing-your-extension"},"#"),n(" Publishing your Extension")],-1),U=e("p",null,[n("To make an extension available to all Directus users, you can publish the npm package created by "),e("code",null,"@directus/extensions-sdk"),n(" to the npm registry. Make sure the name of the package follows the naming convention for package extensions: "),e("code",null,"directus-extension-<extension-name>"),n(" or "),e("code",null,"@<scope>/directus-extension-<extension-name>"),n(". "),e("code",null,"<extension-name>"),n(" has to be replaced with the name of your extension.")],-1),X=e("h2",{id:"installing-an-extension",tabindex:"-1"},[e("a",{class:"header-anchor",href:"#installing-an-extension"},"#"),n(" Installing an Extension")],-1),G=e("p",null,"There are two ways to install an extension.",-1),K=e("h3",{id:"package-extension",tabindex:"-1"},[e("a",{class:"header-anchor",href:"#package-extension"},"#"),n(" Package Extension")],-1),Q=e("p",null,"Package extensions are essentially npm packages. They can be installed from the npm registry, from a tarball, from a git repository or any other means supported by npm. On startup, Directus will automatically load any package extension installed into your Directus project folder.",-1),Y=e("p",null,"To install an extension from the npm registry, simply use the npm CLI:",-1),Z=e("pre",null,[e("code",{class:"language-bash"},[e("span",{class:"hljs-built_in"},"cd"),n(` <directus-project-folder>
npm install <full-package-extension-name>
`)])],-1),$=e("p",null,[e("code",null,"<project-folder>"),n(" has to be replaced by the Directus project folder. "),e("code",null,"<full-package-extension-name>"),n(" should be replaced with the full name of the package extension (e.g. "),e("code",null,"directus-extension-custom"),n(").")],-1),ee=e("h3",{id:"local-extension",tabindex:"-1"},[e("a",{class:"header-anchor",href:"#local-extension"},"#"),n(" Local Extension")],-1),ne=e("p",null,[n("Local extensions are essentially the files generated by the "),e("code",null,"directus-extension build"),n(" command. They can be installed by copying those files into a specific extensions folder.")],-1),te=e("p",null,[n("To install an extension locally, you have to move the output from the "),e("code",null,"dist/"),n(" folder into your project\u2019s "),e("code",null,"./extensions/<extension-folder>/<extension-name>/"),n(" folder. "),e("code",null,"<extension-folder>"),n(" has to be replaced by the extension type in plural form (e.g. interfaces). "),e("code",null,"<extension-name>"),n(" should be replaced with the name of your extension.")],-1),se=e("div",{class:"warning hint"},[e("div",{class:"hint-title"},"Configurable Folders"),e("p",null,"The path to the built extension as well as the extensions directory are configurable and may be located elsewhere.")],-1),ce="Creating Extensions",de=!1,re="A guide on how to scaffold your Directus Extension.",ue="5 min read",he={__name:"creating-extensions",setup(oe,{expose:a}){const i={title:"Creating Extensions",modularExtension:!1,description:"A guide on how to scaffold your Directus Extension.",readTime:"5 min read"};return a({frontmatter:i}),(ie,le)=>{const s=l("router-link"),c=l("docs-wrapper");return d(),r(c,{frontmatter:i},{default:t(()=>[e("div",u,[h,p,f,x,_,g,y,m,b,w,k,v,T,j,E,I,C,L,D,A,S,B,O,P,M,N,R,V,e("ul",null,[e("li",null,[o(s,{to:"/docs/extensions/interfaces"},{default:t(()=>[n("Interfaces")]),_:1})]),e("li",null,[o(s,{to:"/docs/extensions/displays"},{default:t(()=>[n("Displays")]),_:1})]),e("li",null,[o(s,{to:"/docs/extensions/layouts"},{default:t(()=>[n("Layouts")]),_:1})]),e("li",null,[o(s,{to:"/docs/extensions/modules"},{default:t(()=>[n("Modules")]),_:1})]),e("li",null,[o(s,{to:"/docs/extensions/panels"},{default:t(()=>[n("Panels")]),_:1})])]),z,e("ul",null,[e("li",null,[o(s,{to:"/docs/extensions/hooks"},{default:t(()=>[n("Hooks")]),_:1})]),e("li",null,[o(s,{to:"/docs/extensions/endpoints"},{default:t(()=>[n("Endpoints")]),_:1})])]),F,e("ul",null,[e("li",null,[o(s,{to:"/docs/extensions/operations"},{default:t(()=>[n("Operations")]),_:1})])]),e("div",H,[J,e("p",null,[n("When working on extensions, try setting the "),o(s,{to:"/docs/self-hosted/config-options"},{default:t(()=>[W,n(" environment variable")]),_:1}),n(". This will make the API reload extensions on changes automatically.")])]),q,U,X,G,K,Q,Y,Z,$,ee,ne,te,se])]),_:1})}}};export{he as default,re as description,de as modularExtension,ue as readTime,ce as title};
