import{a as s,o as r,e as i,y as n,u as l,q as e,z as o}from"./runtime-core.esm-bundler.22ec0346.js";const c={class:"markdown-body"},h=l("blockquote",null,[l("p",null,"Environment variables are used for all configuration within a Directus project. These variables can be defined in a number of ways, which we cover below.")],-1),_=l("h2",{id:"configuration-files",tabindex:"-1"},[l("a",{class:"header-anchor",href:"#configuration-files"},"#"),e(" Configuration Files")],-1),p=l("p",null,[e("By default, Directus will read the "),l("code",null,".env"),e(" file located next to your project\u2019s "),l("code",null,"package.json"),e(" (typically in the root folder of your project) for its configuration. You can change this path and filename by setting the "),l("code",null,"CONFIG_PATH"),e(" environment variable before starting Directus. For example:")],-1),f=l("pre",null,[l("code",{class:"language-bash"},[e("CONFIG_PATH="),l("span",{class:"hljs-string"},'"/path/to/config.js"'),e(` npx directus start
`)])],-1),m=l("p",null,[e("In case you prefer using a configuration file instead of environment variables, you can also use the "),l("code",null,"CONFIG_PATH"),e(" environment variable to instruct Directus to use a local configuration file instead of environment variables. The config file can be one of the following formats:")],-1),E=l("ul",null,[l("li",null,[l("a",{href:"#env"},".env")]),l("li",null,[l("a",{href:"#config-json"},"config.json")]),l("li",null,[l("a",{href:"#config-yaml"},"config.yaml")]),l("li",null,[l("a",{href:"#config-js"},"config.js")])],-1),A=l("h3",{id:".env",tabindex:"-1"},[l("a",{class:"header-anchor",href:"#.env"},"#"),e(" .env")],-1),T=l("p",null,"If the config path has no file extension, or a file extension that\u2019s not one of the other supported formats, Directus will try reading the file config path as environment variables. This has the following structure:",-1),g=l("pre",null,[l("code",null,`HOST="0.0.0.0"
PORT=8055

DB_CLIENT="pg"
DB_HOST="localhost"
DB_PORT=5432

etc
`)],-1),R=l("h3",{id:"config.json",tabindex:"-1"},[l("a",{class:"header-anchor",href:"#config.json"},"#"),e(" config.json")],-1),b=l("p",null,"If you prefer a single JSON file for your configuration, create a JSON file with the environment variables as keys, for example:",-1),S=l("pre",null,[l("code",null,`CONFIG_PATH="/path/to/config.json"
`)],-1),I=l("pre",null,[l("code",{class:"language-json"},[l("span",{class:"hljs-punctuation"},"{"),e(`
	`),l("span",{class:"hljs-attr"},'"HOST"'),l("span",{class:"hljs-punctuation"},":"),e(),l("span",{class:"hljs-string"},'"0.0.0.0"'),l("span",{class:"hljs-punctuation"},","),e(`
	`),l("span",{class:"hljs-attr"},'"PORT"'),l("span",{class:"hljs-punctuation"},":"),e(),l("span",{class:"hljs-number"},"8055"),l("span",{class:"hljs-punctuation"},","),e(`

	`),l("span",{class:"hljs-attr"},'"DB_CLIENT"'),l("span",{class:"hljs-punctuation"},":"),e(),l("span",{class:"hljs-string"},'"pg"'),l("span",{class:"hljs-punctuation"},","),e(`
	`),l("span",{class:"hljs-attr"},'"DB_HOST"'),l("span",{class:"hljs-punctuation"},":"),e(),l("span",{class:"hljs-string"},'"localhost"'),l("span",{class:"hljs-punctuation"},","),e(`
	`),l("span",{class:"hljs-attr"},'"DB_PORT"'),l("span",{class:"hljs-punctuation"},":"),e(),l("span",{class:"hljs-number"},"5432"),e(`

	`),l("span",{class:"hljs-comment"},"// etc"),e(`
`),l("span",{class:"hljs-punctuation"},"}"),e(`
`)])],-1),O=l("h3",{id:"config.yaml",tabindex:"-1"},[l("a",{class:"header-anchor",href:"#config.yaml"},"#"),e(" config.yaml")],-1),D=l("p",null,[e("Similar to JSON, you can use a "),l("code",null,".yaml"),e(" (or "),l("code",null,".yml"),e(") file for your config:")],-1),y=l("pre",null,[l("code",null,`CONFIG_PATH="/path/to/config.yaml"
`)],-1),L=l("pre",null,[l("code",{class:"language-yaml"},[l("span",{class:"hljs-attr"},"HOST:"),e(),l("span",{class:"hljs-number"},"0.0"),l("span",{class:"hljs-number"},".0"),l("span",{class:"hljs-number"},".0"),e(`
`),l("span",{class:"hljs-attr"},"PORT:"),e(),l("span",{class:"hljs-number"},"8055"),e(`

`),l("span",{class:"hljs-attr"},"DB_CLIENT:"),e(),l("span",{class:"hljs-string"},"pg"),e(`
`),l("span",{class:"hljs-attr"},"DB_HOST:"),e(),l("span",{class:"hljs-string"},"localhost"),e(`
`),l("span",{class:"hljs-attr"},"DB_PORT:"),e(),l("span",{class:"hljs-number"},"5432"),e(`
`),l("span",{class:"hljs-comment"},"#"),e(`
`),l("span",{class:"hljs-comment"},"# etc"),e(`
`)])],-1),C=l("h3",{id:"config.js",tabindex:"-1"},[l("a",{class:"header-anchor",href:"#config.js"},"#"),e(" config.js")],-1),v=l("p",null,[e("Using a JavaScript file for your config allows you to dynamically generate the configuration of the project during startup. The JavaScript configuration supports two different formats, either an "),l("strong",null,"Object Structure"),e(" where the key is the environment variable name:")],-1),H=l("pre",null,[l("code",{class:"language-js"},[l("span",{class:"hljs-comment"},"// Object Syntax"),e(`

`),l("span",{class:"hljs-variable language_"},"module"),e("."),l("span",{class:"hljs-property"},"exports"),e(` = {
	`),l("span",{class:"hljs-attr"},"HOST"),e(": "),l("span",{class:"hljs-string"},"'0.0.0.0'"),e(`,
	`),l("span",{class:"hljs-attr"},"PORT"),e(": "),l("span",{class:"hljs-number"},"8055"),e(`,

	`),l("span",{class:"hljs-attr"},"DB_CLIENT"),e(": "),l("span",{class:"hljs-string"},"'pg'"),e(`,
	`),l("span",{class:"hljs-attr"},"DB_HOST"),e(": "),l("span",{class:"hljs-string"},"'localhost'"),e(`,
	`),l("span",{class:"hljs-attr"},"DB_PORT"),e(": "),l("span",{class:"hljs-number"},"5432"),e(`,

	`),l("span",{class:"hljs-comment"},"// etc"),e(`
};
`)])],-1),w=l("p",null,[e("Or a "),l("strong",null,"Function Structure"),e(" that "),l("em",null,"returns"),e(" the same object format as above. The function gets "),l("code",null,"process.env"),e(" as its parameter.")],-1),U=l("pre",null,[l("code",{class:"language-js"},[l("span",{class:"hljs-comment"},"// Function Syntax"),e(`

`),l("span",{class:"hljs-variable language_"},"module"),e("."),l("span",{class:"hljs-property"},"exports"),e(" = "),l("span",{class:"hljs-keyword"},"function"),e(" ("),l("span",{class:"hljs-params"},"env"),e(`) {
	`),l("span",{class:"hljs-keyword"},"return"),e(` {
		`),l("span",{class:"hljs-attr"},"HOST"),e(": "),l("span",{class:"hljs-string"},"'0.0.0.0'"),e(`,
		`),l("span",{class:"hljs-attr"},"PORT"),e(": "),l("span",{class:"hljs-number"},"8055"),e(`,

		`),l("span",{class:"hljs-attr"},"DB_CLIENT"),e(": "),l("span",{class:"hljs-string"},"'pg'"),e(`,
		`),l("span",{class:"hljs-attr"},"DB_HOST"),e(": "),l("span",{class:"hljs-string"},"'localhost'"),e(`,
		`),l("span",{class:"hljs-attr"},"DB_PORT"),e(": "),l("span",{class:"hljs-number"},"5432"),e(`,

		`),l("span",{class:"hljs-comment"},"// etc"),e(`
	};
};
`)])],-1),P=l("h2",{id:"environment-variable-files",tabindex:"-1"},[l("a",{class:"header-anchor",href:"#environment-variable-files"},"#"),e(" Environment Variable Files")],-1),N=l("p",null,[e("Any of the environment variable values can be imported from a file, by appending "),l("code",null,"_FILE"),e(" to the environment variable name. This is especially useful when used in conjunction with Docker Secrets, so you can keep sensitive data out of your compose files. For example:")],-1),x=l("pre",null,[l("code",null,`DB_PASSWORD_FILE="/run/secrets/db_password"
`)],-1),M=l("h2",{id:"type-casting-and-nesting",tabindex:"-1"},[l("a",{class:"header-anchor",href:"#type-casting-and-nesting"},"#"),e(" Type Casting and Nesting")],-1),V=l("p",null,"Environment variables are automatically type cast based on the structure of the variable, for example:",-1),j=l("pre",null,[l("code",null,`PUBLIC_URL="https://example.com"
// "https://example.com"

DB_HOST="3306"
// 3306

CORS_ENABLED="false"
// false

STORAGE_LOCATIONS="s3,local,example"
// ["s3", "local", "example"]
`)],-1),k=l("p",null,[e("In cases where the environment variables are converted to a configuration object for third party library use, like in "),l("code",null,"DB_*"),e(" or "),l("code",null,"RATE_LIMITER_REDIS_*"),e(", the environment variable will be converted to camelCase. You can use a double underscore ("),l("code",null,"__"),e(") for nested objects:")],-1),B=l("pre",null,[l("code",null,`DB_CLIENT="pg"
DB_CONNECTION_STRING="postgresql://postgres:example@127.0.0.1"
DB_SSL__REJECT_UNAUTHORIZED="false"

{
	client: "pg",
	connectionString: "postgresql://postgres:example@127.0.0.1",
	ssl: {
		rejectUnauthorized: false
	}
}
`)],-1),G=l("h2",{id:"environment-syntax-prefix",tabindex:"-1"},[l("a",{class:"header-anchor",href:"#environment-syntax-prefix"},"#"),e(" Environment Syntax Prefix")],-1),F=l("p",null,[e("Directus will attempt to "),l("a",{href:"#type-casting-and-nesting"},"automatically type cast environment variables"),e(" based on context clues. If you have a specific need for a given type, you can tell Directus what type to use for the given value by prefixing the value with "),l("code",null,"{type}:"),e(". The following types are available:")],-1),W=l("table",null,[l("thead",null,[l("tr",null,[l("th",null,"Syntax Prefix"),l("th",null,"Example"),l("th",null,"Output")])]),l("tbody",null,[l("tr",null,[l("td",null,[l("code",null,"string")]),l("td",null,[l("code",null,"string:value")]),l("td",null,[l("code",null,'"value"')])]),l("tr",null,[l("td",null,[l("code",null,"number")]),l("td",null,[l("code",null,"number:3306")]),l("td",null,[l("code",null,"3306")])]),l("tr",null,[l("td",null,[l("code",null,"regex")]),l("td",null,[l("code",null,"regex:\\.example\\.com$")]),l("td",null,[l("code",null,"/\\.example\\.com$/")])]),l("tr",null,[l("td",null,[l("code",null,"array")]),l("td",null,[l("code",null,"array:https://example.com,https://example2.com"),e(),l("br"),e(),l("code",null,"array:string:https://example.com,regex:\\.example3\\.com$")]),l("td",null,[l("code",null,'["https://example.com", "https://example2.com"]'),e(),l("br"),e(),l("code",null,'["https://example.com", "https://example2.com", /\\.example3\\.com$/]')])]),l("tr",null,[l("td",null,[l("code",null,"json")]),l("td",null,[l("code",null,'json:{"items": ["example1", "example2"]}')]),l("td",null,[l("code",null,'{"items": ["example1", "example2"]}')])])])],-1),q=l("hr",null,null,-1),K=l("h2",{id:"general",tabindex:"-1"},[l("a",{class:"header-anchor",href:"#general"},"#"),e(" General")],-1),Y=l("table",null,[l("thead",null,[l("tr",null,[l("th",null,"Variable"),l("th",null,"Description"),l("th",null,"Default Value")])]),l("tbody",null,[l("tr",null,[l("td",null,[l("code",null,"CONFIG_PATH")]),l("td",null,[e("Where your config file is located. See "),l("a",{href:"#configuration-files"},"Configuration Files")]),l("td",null,[l("code",null,".env")])]),l("tr",null,[l("td",null,[l("code",null,"HOST")]),l("td",null,"IP or host the API listens on."),l("td",null,[l("code",null,"0.0.0.0")])]),l("tr",null,[l("td",null,[l("code",null,"PORT")]),l("td",null,"What port to run the API under."),l("td",null,[l("code",null,"8055")])]),l("tr",null,[l("td",null,[l("code",null,"PUBLIC_URL"),l("sup",null,"[1]")]),l("td",null,"URL where your API can be reached on the web."),l("td",null,[l("code",null,"/")])]),l("tr",null,[l("td",null,[l("code",null,"LOG_LEVEL")]),l("td",null,[e("What level of detail to log. One of "),l("code",null,"fatal"),e(", "),l("code",null,"error"),e(", "),l("code",null,"warn"),e(", "),l("code",null,"info"),e(", "),l("code",null,"debug"),e(", "),l("code",null,"trace"),e(" or "),l("code",null,"silent"),e(".")]),l("td",null,[l("code",null,"info")])]),l("tr",null,[l("td",null,[l("code",null,"LOG_STYLE")]),l("td",null,[e("Render the logs human readable (pretty) or as JSON. One of "),l("code",null,"pretty"),e(", "),l("code",null,"raw"),e(".")]),l("td",null,[l("code",null,"pretty")])]),l("tr",null,[l("td",null,[l("code",null,"MAX_PAYLOAD_SIZE")]),l("td",null,"Controls the maximum request body size. Accepts number of bytes, or human readable string."),l("td",null,[l("code",null,"1mb")])]),l("tr",null,[l("td",null,[l("code",null,"ROOT_REDIRECT")]),l("td",null,[e("Where to redirect to when navigating to "),l("code",null,"/"),e(". Accepts a relative path, absolute URL, or "),l("code",null,"false"),e(" to disable.")]),l("td",null,[l("code",null,"./admin")])]),l("tr",null,[l("td",null,[l("code",null,"SERVE_APP")]),l("td",null,[e("Whether or not to serve the Admin App under "),l("code",null,"/admin"),e(".")]),l("td",null,[l("code",null,"true")])]),l("tr",null,[l("td",null,[l("code",null,"GRAPHQL_INTROSPECTION")]),l("td",null,"Whether or not to enable GraphQL Introspection"),l("td",null,[l("code",null,"true")])]),l("tr",null,[l("td",null,[l("code",null,"MAX_RELATIONAL_DEPTH")]),l("td",null,[e("The maximum depth when filtering / querying relational fields, with a minimum value of "),l("code",null,"2"),e(".")]),l("td",null,[l("code",null,"10")])])])],-1),z=l("p",null,[l("sup",null,"[1]"),e(" The PUBLIC_URL value is used for things like OAuth redirects, forgot-password emails, and logos that needs to be publicly available on the internet.")],-1),X=l("div",{class:"tip hint"},[l("div",{class:"hint-title"},"Additional Logger Variables"),l("p",null,[e("All "),l("code",null,"LOGGER_*"),e(" environment variables are passed to the "),l("code",null,"options"),e(" configuration of a "),l("a",{href:"https://github.com/pinojs/pino/blob/master/docs/api.md#options",target:"_blank",rel:"noopener noreferrer"},[l("code",null,"Pino"),e(" instance")]),e(". All "),l("code",null,"LOGGER_HTTP*"),e(" environment variables are passed to the "),l("code",null,"options"),e(" configuration of a "),l("a",{href:"https://github.com/pinojs/pino-http#api",target:"_blank",rel:"noopener noreferrer"},[l("code",null,"Pino-http"),e(" instance")]),e(". Based on your project\u2019s needs, you can extend the "),l("code",null,"LOGGER_*"),e(" environment variables with any config you need to pass to the logger instance. If a LOGGER_LEVELS key is added, these values will be passed to the logger frontmatter, as described "),l("a",{href:"https://github.com/pinojs/pino/blob/master/docs/help.md#mapping-pino-log-levels-to-google-cloud-logging-stackdriver-severity-levels",target:"_blank",rel:"noopener noreferrer"},"here"),e(" for example. The format for adding LEVELS values is: "),l("code",null,'LOGGER_LEVELS="trace:DEBUG,debug:DEBUG,info:INFO,warn:WARNING,error:ERROR,fatal:CRITICAL"')])],-1),Z=l("h2",{id:"server",tabindex:"-1"},[l("a",{class:"header-anchor",href:"#server"},"#"),e(" Server")],-1),J=l("table",null,[l("thead",null,[l("tr",null,[l("th",null,"Variable"),l("th",null,"Description"),l("th",null,"Default Value")])]),l("tbody",null,[l("tr",null,[l("td",null,[l("code",null,"SERVER_KEEP_ALIVE_TIMEOUT")]),l("td",null,"Timeout in milliseconds for socket to be destroyed"),l("td",null,[l("a",{href:"https://github.com/nodejs/node/blob/master/doc/api/http.md#serverkeepalivetimeout",target:"_blank",rel:"noopener noreferrer"},"server.keepAliveTimeout")])]),l("tr",null,[l("td",null,[l("code",null,"SERVER_HEADERS_TIMEOUT")]),l("td",null,"Timeout in milliseconds to parse HTTP headers"),l("td",null,[l("a",{href:"https://github.com/nodejs/node/blob/master/doc/api/http.md#serverheaderstimeout",target:"_blank",rel:"noopener noreferrer"},"server.headersTimeout")])])])],-1),Q=l("div",{class:"tip hint"},[l("div",{class:"hint-title"},"Additional Server Variables"),l("p",null,[e("All "),l("code",null,"SERVER_*"),e(" environment variables are merged with "),l("code",null,"server"),e(" instance properties created from "),l("a",{href:"https://github.com/nodejs/node/blob/master/doc/api/http.md#class-httpserver",target:"_blank",rel:"noopener noreferrer"},"http.Server"),e(". This allows to configure server behind a proxy, a load balancer, etc. Be careful to not override methods of this instance otherwise you may incur into unexpected behaviors.")])],-1),$=l("h2",{id:"database",tabindex:"-1"},[l("a",{class:"header-anchor",href:"#database"},"#"),e(" Database")],-1),ll=l("table",null,[l("thead",null,[l("tr",null,[l("th",null,"Variable"),l("th",null,"Description"),l("th",null,"Default Value")])]),l("tbody",null,[l("tr",null,[l("td",null,[l("code",null,"DB_CLIENT")]),l("td",null,[l("strong",null,"Required"),e(". What database client to use. One of "),l("code",null,"pg"),e(" or "),l("code",null,"postgres"),e(", "),l("code",null,"mysql"),e(", "),l("code",null,"oracledb"),e(", "),l("code",null,"mssql"),e(", "),l("code",null,"sqlite3"),e(", "),l("code",null,"cockroachdb"),e(".")]),l("td",null,"\u2013")]),l("tr",null,[l("td",null,[l("code",null,"DB_HOST")]),l("td",null,[e("Database host. "),l("strong",null,"Required"),e(" when using "),l("code",null,"pg"),e(", "),l("code",null,"mysql"),e(", "),l("code",null,"oracledb"),e(", or "),l("code",null,"mssql"),e(".")]),l("td",null,"\u2013")]),l("tr",null,[l("td",null,[l("code",null,"DB_PORT")]),l("td",null,[e("Database port. "),l("strong",null,"Required"),e(" when using "),l("code",null,"pg"),e(", "),l("code",null,"mysql"),e(", "),l("code",null,"oracledb"),e(", or "),l("code",null,"mssql"),e(".")]),l("td",null,"\u2013")]),l("tr",null,[l("td",null,[l("code",null,"DB_DATABASE")]),l("td",null,[e("Database name. "),l("strong",null,"Required"),e(" when using "),l("code",null,"pg"),e(", "),l("code",null,"mysql"),e(", "),l("code",null,"oracledb"),e(", or "),l("code",null,"mssql"),e(".")]),l("td",null,"\u2013")]),l("tr",null,[l("td",null,[l("code",null,"DB_USER")]),l("td",null,[e("Database user. "),l("strong",null,"Required"),e(" when using "),l("code",null,"pg"),e(", "),l("code",null,"mysql"),e(", "),l("code",null,"oracledb"),e(", or "),l("code",null,"mssql"),e(".")]),l("td",null,"\u2013")]),l("tr",null,[l("td",null,[l("code",null,"DB_PASSWORD")]),l("td",null,[e("Database user\u2019s password. "),l("strong",null,"Required"),e(" when using "),l("code",null,"pg"),e(", "),l("code",null,"mysql"),e(", "),l("code",null,"oracledb"),e(", or "),l("code",null,"mssql"),e(".")]),l("td",null,"\u2013")]),l("tr",null,[l("td",null,[l("code",null,"DB_FILENAME")]),l("td",null,[e("Where to read/write the SQLite database. "),l("strong",null,"Required"),e(" when using "),l("code",null,"sqlite3"),e(".")]),l("td",null,"\u2013")]),l("tr",null,[l("td",null,[l("code",null,"DB_CONNECTION_STRING")]),l("td",null,[e("When using "),l("code",null,"pg"),e(", you can submit a connection string instead of individual properties. Using this will ignore any of the other connection settings.")]),l("td",null,"\u2013")]),l("tr",null,[l("td",null,[l("code",null,"DB_POOL__*")]),l("td",null,[e("Pooling settings. Passed on to "),l("a",{href:"https://github.com/vincit/tarn.js#usage",target:"_blank",rel:"noopener noreferrer"},[e("the "),l("code",null,"tarn.js")]),e(" library.")]),l("td",null,"\u2013")]),l("tr",null,[l("td",null,[l("code",null,"DB_EXCLUDE_TABLES")]),l("td",null,"CSV of tables you want Directus to ignore completely"),l("td",null,[l("code",null,"spatial_ref_sys,sysdiagrams")])]),l("tr",null,[l("td",null,[l("code",null,"DB_CHARSET")]),l("td",null,"Charset/collation to use in the connection to MySQL/MariaDB"),l("td",null,[l("code",null,"UTF8_GENERAL_CI")])]),l("tr",null,[l("td",null,[l("code",null,"DB_VERSION")]),l("td",null,"Database version, in case you use the PostgreSQL adapter to connect a non-standard database. Not normally required."),l("td",null,"\u2013")]),l("tr",null,[l("td",null,[l("code",null,"DB_HEALTHCHECK_THRESHOLD")]),l("td",null,"Healthcheck timeout threshold in ms."),l("td",null,[l("code",null,"150")])])])],-1),el=l("div",{class:"tip hint"},[l("div",{class:"hint-title"},"Additional Database Variables"),l("p",null,[e("All "),l("code",null,"DB_*"),e(" environment variables are passed to the "),l("code",null,"connection"),e(" configuration of a "),l("a",{href:"http://knexjs.org",target:"_blank",rel:"noopener noreferrer"},[l("code",null,"Knex"),e(" instance")]),e(". Based on your project\u2019s needs, you can extend the "),l("code",null,"DB_*"),e(" environment variables with any config you need to pass to the database instance.")])],-1),nl=l("div",{class:"tip hint"},[l("div",{class:"hint-title"},"Pooling"),l("p",null,[e("All the "),l("code",null,"DB_POOL__"),e(" prefixed options are passed to "),l("a",{href:"https://github.com/vincit/tarn.js#usage",target:"_blank",rel:"noopener noreferrer"},[l("code",null,"tarn.js")]),e(" through "),l("a",{href:"http://knexjs.org#Installation-pooling",target:"_blank",rel:"noopener noreferrer"},"Knex")])],-1),tl=l("h2",{id:"security",tabindex:"-1"},[l("a",{class:"header-anchor",href:"#security"},"#"),e(" Security")],-1),ol=l("thead",null,[l("tr",null,[l("th",null,"Variable"),l("th",null,"Description"),l("th",null,"Default Value")])],-1),ul=l("tr",null,[l("td",null,[l("code",null,"KEY")]),l("td",null,"Unique identifier for the project."),l("td",null,"\u2013")],-1),sl=l("tr",null,[l("td",null,[l("code",null,"SECRET")]),l("td",null,"Secret string for the project."),l("td",null,"\u2013")],-1),al=l("tr",null,[l("td",null,[l("code",null,"ACCESS_TOKEN_TTL")]),l("td",null,"The duration that the access token is valid."),l("td",null,[l("code",null,"15m")])],-1),dl=l("tr",null,[l("td",null,[l("code",null,"REFRESH_TOKEN_TTL")]),l("td",null,"The duration that the refresh token is valid, and also how long users stay logged-in to the App."),l("td",null,[l("code",null,"7d")])],-1),rl=l("tr",null,[l("td",null,[l("code",null,"REFRESH_TOKEN_COOKIE_DOMAIN")]),l("td",null,"Which domain to use for the refresh cookie. Useful for development mode."),l("td",null,"\u2013")],-1),il=l("tr",null,[l("td",null,[l("code",null,"REFRESH_TOKEN_COOKIE_SECURE")]),l("td",null,"Whether or not to use a secure cookie for the refresh token in cookie mode."),l("td",null,[l("code",null,"false")])],-1),cl=l("tr",null,[l("td",null,[l("code",null,"REFRESH_TOKEN_COOKIE_SAME_SITE")]),l("td",null,[e("Value for "),l("code",null,"sameSite"),e(" in the refresh token cookie when in cookie mode.")]),l("td",null,[l("code",null,"lax")])],-1),hl=l("tr",null,[l("td",null,[l("code",null,"REFRESH_TOKEN_COOKIE_NAME")]),l("td",null,"Name of refresh token cookie ."),l("td",null,[l("code",null,"directus_refresh_token")])],-1),_l=l("tr",null,[l("td",null,[l("code",null,"LOGIN_STALL_TIME")]),l("td",null,"The duration in milliseconds that a login request will be stalled for, and it should be greater than the time taken for a login request with an invalid password"),l("td",null,[l("code",null,"500")])],-1),pl=l("td",null,[l("code",null,"PASSWORD_RESET_URL_ALLOW_LIST")],-1),fl=l("code",null,"reset_url",-1),ml=l("td",null,"\u2013",-1),El=l("td",null,[l("code",null,"USER_INVITE_URL_ALLOW_LIST")],-1),Al=l("code",null,"invite_url",-1),Tl=l("td",null,"\u2013",-1),gl=l("tr",null,[l("td",null,[l("code",null,"IP_TRUST_PROXY")]),l("td",null,[e("Settings for "),l("a",{href:"https://expressjs.com/en/guide/behind-proxies.html",target:"_blank",rel:"noopener noreferrer"},"express\u2019 trust proxy setting")]),l("td",null,"true")],-1),Rl=l("tr",null,[l("td",null,[l("code",null,"IP_CUSTOM_HEADER")]),l("td",null,"What custom request header to use for the IP address"),l("td",null,"false")],-1),bl=l("tr",null,[l("td",null,[l("code",null,"ASSETS_CONTENT_SECURITY_POLICY")]),l("td",null,[e("Custom overrides for the Content-Security-Policy header for the /assets endpoint. See "),l("a",{href:"https://helmetjs.github.io",target:"_blank",rel:"noopener noreferrer"},"helmet\u2019s documentation"),e(" for more information.")]),l("td",null,"\u2013")],-1),Sl=l("tr",null,[l("td",null,[l("code",null,"IMPORT_IP_DENY_LIST")]),l("td",null,[e("Deny importing files from these IP addresses. Use "),l("code",null,"0.0.0.0"),e(" for any local IP address")]),l("td",null,[l("code",null,"0.0.0.0")])],-1),Il=l("tr",null,[l("td",null,[l("code",null,"CONTENT_SECURITY_POLICY_*")]),l("td",null,[e("Custom overrides for the Content-Security-Policy header. See "),l("a",{href:"https://helmetjs.github.io",target:"_blank",rel:"noopener noreferrer"},"helmet\u2019s documentation"),e(" for more information.")]),l("td",null,"\u2013")],-1),Ol=l("tr",null,[l("td",null,[l("code",null,"HSTS_ENABLED")]),l("td",null,"Enable the Strict-Transport-Security policy header."),l("td",null,[l("code",null,"false")])],-1),Dl=l("tr",null,[l("td",null,[l("code",null,"HSTS_*")]),l("td",null,[e("Custom overrides for the Strict-Transport-Security header. See "),l("a",{href:"https://helmetjs.github.io",target:"_blank",rel:"noopener noreferrer"},"helmet\u2019s documentation"),e(" for more information.")]),l("td",null,"\u2013")],-1),yl=l("div",{class:"tip hint"},[l("div",{class:"hint-title"},"Cookie Strictness"),l("p",null,[e("Browser are pretty strict when it comes to third-party cookies. If you\u2019re running into unexpected problems when running your project and API on different domains, make sure to verify your configuration for "),l("code",null,"REFRESH_TOKEN_COOKIE_NAME"),e(", "),l("code",null,"REFRESH_TOKEN_COOKIE_SECURE"),e(" and "),l("code",null,"REFRESH_TOKEN_COOKIE_SAME_SITE"),e(".")])],-1),Ll=l("h3",{id:"hashing",tabindex:"-1"},[l("a",{class:"header-anchor",href:"#hashing"},"#"),e(" Hashing")],-1),Cl=l("table",null,[l("thead",null,[l("tr",null,[l("th",null,"Variable"),l("th",null,"Description"),l("th",null,"Default Value")])]),l("tbody",null,[l("tr",null,[l("td",null,[l("code",null,"HASH_MEMORY_COST")]),l("td",null,"How much memory to use when generating hashes, in KiB."),l("td",null,[l("code",null,"4096"),e(" (4 MiB)")])]),l("tr",null,[l("td",null,[l("code",null,"HASH_LENGTH")]),l("td",null,"The length of the hash function output in bytes."),l("td",null,[l("code",null,"32")])]),l("tr",null,[l("td",null,[l("code",null,"HASH_TIME_COST")]),l("td",null,"The amount of passes (iterations) used by the hash function. It increases hash strength at the cost of time required to compute."),l("td",null,[l("code",null,"3")])]),l("tr",null,[l("td",null,[l("code",null,"HASH_PARALLELISM")]),l("td",null,[e("The amount of threads to compute the hash on. Each thread has a memory pool with "),l("code",null,"HASH_MEMORY_COST"),e(" size.")]),l("td",null,[l("code",null,"1"),e(" (single thread)")])]),l("tr",null,[l("td",null,[l("code",null,"HASH_TYPE")]),l("td",null,[e("The variant of the hash function ("),l("code",null,"0"),e(": argon2d, "),l("code",null,"1"),e(": argon2i, or "),l("code",null,"2"),e(": argon2id).")]),l("td",null,[l("code",null,"2"),e(" (argon2id)")])]),l("tr",null,[l("td",null,[l("code",null,"HASH_ASSOCIATED_DATA")]),l("td",null,"An extra and optional non-secret value. The value will be included Base64 encoded in the parameters portion of the digest."),l("td",null,"\u2013")])])],-1),vl=l("code",null,"Hash",-1),Hl=l("p",null,[e("All "),l("code",null,"HASH_*"),e(" environment variable parameters are passed to the "),l("code",null,"argon2.hash"),e(" function. See the "),l("a",{href:"https://github.com/ranisalt/node-argon2/wiki/Options",target:"_blank",rel:"noopener noreferrer"},"node-argon2 library options page"),e(" for reference.")],-1),wl=l("div",{class:"tip hint"},[l("div",{class:"hint-title"},"Memory Usage"),l("p",null,[e("Modifying "),l("code",null,"HASH_MEMORY_COST"),e(" and/or "),l("code",null,"HASH_PARALLELISM"),e(" will affect the amount of memory directus uses when computing hashes; each thread gets "),l("code",null,"HASH_MEMORY_COST"),e(" amount of memory, so the total additional memory will be these two values multiplied. This may cause out of memory errors, especially when running in containerized environments.")])],-1),Ul=l("h2",{id:"cors",tabindex:"-1"},[l("a",{class:"header-anchor",href:"#cors"},"#"),e(" CORS")],-1),Pl=l("table",null,[l("thead",null,[l("tr",null,[l("th",null,"Variable"),l("th",null,"Description"),l("th",null,"Default Value")])]),l("tbody",null,[l("tr",null,[l("td",null,[l("code",null,"CORS_ENABLED")]),l("td",null,"Whether or not to enable the CORS headers."),l("td",null,[l("code",null,"false")])]),l("tr",null,[l("td",null,[l("code",null,"CORS_ORIGIN")]),l("td",null,[e("Value for the "),l("code",null,"Access-Control-Allow-Origin"),e(" header. Use "),l("code",null,"true"),e(" to match the Origin header, or provide a domain or a CSV of domains for specific access")]),l("td",null,[l("code",null,"false")])]),l("tr",null,[l("td",null,[l("code",null,"CORS_METHODS")]),l("td",null,[e("Value for the "),l("code",null,"Access-Control-Allow-Methods"),e(" header.")]),l("td",null,[l("code",null,"GET,POST,PATCH,DELETE")])]),l("tr",null,[l("td",null,[l("code",null,"CORS_ALLOWED_HEADERS")]),l("td",null,[e("Value for the "),l("code",null,"Access-Control-Allow-Headers"),e(" header.")]),l("td",null,[l("code",null,"Content-Type,Authorization")])]),l("tr",null,[l("td",null,[l("code",null,"CORS_EXPOSED_HEADERS")]),l("td",null,[e("Value for the "),l("code",null,"Access-Control-Expose-Headers"),e(" header.")]),l("td",null,[l("code",null,"Content-Range")])]),l("tr",null,[l("td",null,[l("code",null,"CORS_CREDENTIALS")]),l("td",null,[e("Whether or not to send the "),l("code",null,"Access-Control-Allow-Credentials"),e(" header.")]),l("td",null,[l("code",null,"true")])]),l("tr",null,[l("td",null,[l("code",null,"CORS_MAX_AGE")]),l("td",null,[e("Value for the "),l("code",null,"Access-Control-Max-Age"),e(" header.")]),l("td",null,[l("code",null,"18000")])])])],-1),Nl=l("h2",{id:"rate-limiting",tabindex:"-1"},[l("a",{class:"header-anchor",href:"#rate-limiting"},"#"),e(" Rate Limiting")],-1),xl=l("p",null,[e("You can use the built-in rate-limiter to prevent users from hitting the API too much. Simply enabling the rate-limiter will set a default maximum of 50 requests per second, tracked in memory. Once you have multiple copies of Directus running under a load balancer, or your user base grows so much that memory is no longer a viable place to store the rate limiter information, you can use an external "),l("code",null,"memcache"),e(" or "),l("code",null,"redis"),e(" instance to store the rate limiter data.")],-1),Ml=l("table",null,[l("thead",null,[l("tr",null,[l("th",null,"Variable"),l("th",null,"Description"),l("th",null,"Default Value")])]),l("tbody",null,[l("tr",null,[l("td",null,[l("code",null,"RATE_LIMITER_ENABLED")]),l("td",null,"Whether or not to enable rate limiting on the API."),l("td",null,[l("code",null,"false")])]),l("tr",null,[l("td",null,[l("code",null,"RATE_LIMITER_POINTS")]),l("td",null,"The amount of allowed hits per duration."),l("td",null,[l("code",null,"50")])]),l("tr",null,[l("td",null,[l("code",null,"RATE_LIMITER_DURATION")]),l("td",null,"The time window in seconds in which the points are counted."),l("td",null,[l("code",null,"1")])]),l("tr",null,[l("td",null,[l("code",null,"RATE_LIMITER_STORE")]),l("td",null,[e("Where to store the rate limiter counts. One of "),l("code",null,"memory"),e(", "),l("code",null,"redis"),e(", or "),l("code",null,"memcache"),e(".")]),l("td",null,[l("code",null,"memory")])]),l("tr",null,[l("td",null,[l("code",null,"RATE_LIMITER_HEALTHCHECK_THRESHOLD")]),l("td",null,"Healthcheck timeout threshold in ms."),l("td",null,[l("code",null,"150")])])])],-1),Vl=l("p",null,[e("Based on the "),l("code",null,"RATE_LIMITER_STORE"),e(" used, you must also provide the following configurations:")],-1),jl=l("h3",{id:"memory",tabindex:"-1"},[l("a",{class:"header-anchor",href:"#memory"},"#"),e(" Memory")],-1),kl=l("p",null,"No additional configuration required.",-1),Bl=l("h3",{id:"redis",tabindex:"-1"},[l("a",{class:"header-anchor",href:"#redis"},"#"),e(" Redis")],-1),Gl=l("table",null,[l("thead",null,[l("tr",null,[l("th",null,"Variable"),l("th",null,"Description"),l("th",null,"Default Value")])]),l("tbody",null,[l("tr",null,[l("td",null,[l("code",null,"RATE_LIMITER_REDIS")]),l("td",null,[e("Redis connection string, e.g., "),l("code",null,"redis://:authpassword@127.0.0.1:6380/4")]),l("td",null,"\u2014")])])],-1),Fl=l("p",null,"Alternatively, you can provide the individual connection parameters:",-1),Wl=l("table",null,[l("thead",null,[l("tr",null,[l("th",null,"Variable"),l("th",null,"Description"),l("th",null,"Default Value")])]),l("tbody",null,[l("tr",null,[l("td",null,[l("code",null,"RATE_LIMITER_REDIS_HOST")]),l("td",null,[e("Hostname of the Redis instance, e.g., "),l("code",null,'"127.0.0.1"')]),l("td",null,"\u2013")]),l("tr",null,[l("td",null,[l("code",null,"RATE_LIMITER_REDIS_PORT")]),l("td",null,[e("Port of the Redis instance, e.g., "),l("code",null,"6379")]),l("td",null,"\u2013")]),l("tr",null,[l("td",null,[l("code",null,"RATE_LIMITER_REDIS_USERNAME")]),l("td",null,[e("Username for your Redis instance, e.g., "),l("code",null,'"default"')]),l("td",null,"\u2013")]),l("tr",null,[l("td",null,[l("code",null,"RATE_LIMITER_REDIS_PASSWORD")]),l("td",null,[e("Password for your Redis instance, e.g., "),l("code",null,'"yourRedisPassword"')]),l("td",null,"\u2013")]),l("tr",null,[l("td",null,[l("code",null,"RATE_LIMITER_REDIS_DB")]),l("td",null,[e("Database of your Redis instance to connect, e.g., "),l("code",null,"1")]),l("td",null,"\u2013")])])],-1),ql=l("h3",{id:"memcache",tabindex:"-1"},[l("a",{class:"header-anchor",href:"#memcache"},"#"),e(" Memcache")],-1),Kl=l("table",null,[l("thead",null,[l("tr",null,[l("th",null,"Variable"),l("th",null,"Description"),l("th",null,"Default Value")])]),l("tbody",null,[l("tr",null,[l("td",null,[l("code",null,"RATE_LIMITER_MEMCACHE")]),l("td",null,[e("Location of your memcache instance. You can use "),l("a",{href:"#environment-syntax-prefix"},[l("code",null,"array:"),e(" syntax")]),e(", e.g., "),l("code",null,"array:<instance-1>,<instance-2>"),e(" for multiple memcache instances.")]),l("td",null,"\u2014")])])],-1),Yl=l("div",{class:"tip hint"},[l("div",{class:"hint-title"},"Additional Rate Limiter Variables"),l("p",null,[e("All "),l("code",null,"RATE_LIMITER_*"),e(" variables are passed directly to a "),l("code",null,"rate-limiter-flexible"),e(" instance. Depending on your project\u2019s needs, you can extend the above environment variables to configure any of "),l("a",{href:"https://github.com/animir/node-rate-limiter-flexible/wiki/Options",target:"_blank",rel:"noopener noreferrer"},[e("the "),l("code",null,"rate-limiter-flexible"),e(" options")]),e(".")])],-1),zl=l("h3",{id:"example%3A-basic",tabindex:"-1"},[l("a",{class:"header-anchor",href:"#example%3A-basic"},"#"),e(" Example: Basic")],-1),Xl=l("pre",null,[l("code",null,`// 10 requests per 5 seconds

RATE_LIMITER_POINTS="10"
RATE_LIMITER_DURATION="5"
`)],-1),Zl=l("h3",{id:"example%3A-redis",tabindex:"-1"},[l("a",{class:"header-anchor",href:"#example%3A-redis"},"#"),e(" Example: Redis")],-1),Jl=l("pre",null,[l("code",null,`RATE_LIMITER_ENABLED="true"

RATE_LIMITER_POINTS="10"
RATE_LIMITER_DURATION="5"

RATE_LIMITER_STORE="redis"

RATE_LIMITER_REDIS="redis://@127.0.0.1"

# If you are using Redis ACL
RATE_LIMITER_REDIS_USERNAME="default"
RATE_LIMITER_REDIS_PASSWORD="yourRedisPassword"
RATE_LIMITER_REDIS_HOST="127.0.0.1"
RATE_LIMITER_REDIS_PORT=6379
RATE_LIMITER_REDIS_DB=0
`)],-1),Ql=l("h2",{id:"cache",tabindex:"-1"},[l("a",{class:"header-anchor",href:"#cache"},"#"),e(" Cache")],-1),$l=l("p",null,"Directus has a built-in data-caching option. Enabling this will cache the output of requests (based on the current user and exact query parameters used) into configured cache storage location. This drastically improves API performance, as subsequent requests are served straight from this cache. Enabling cache will also make Directus return accurate cache-control headers. Depending on your setup, this will further improve performance by caching the request in middleman servers (like CDNs) and even the browser.",-1),le=l("div",{class:"tip hint"},[l("div",{class:"hint-title"},"Internal Caching"),l("p",null,[e("In addition to data-caching, Directus also does some internal caching. Note "),l("code",null,"SCHEMA_CACHE"),e(" and "),l("code",null,"CACHE_PERMISSIONS"),e(" which are enabled by default. These speed up the overall performance of Directus, as we don\u2019t want to introspect the whole database or check all permissions on every request. When running Directus load balanced, you\u2019ll need to use a shared cache storage (like "),l("a",{href:"#redis-2"},"Redis"),e(" or "),l("a",{href:"#memcache-2"},"Memcache"),e(") or else disable all caching.")])],-1),ee=l("div",{class:"tip hint"},[l("div",{class:"hint-title"},"Assets Cache"),l("p",null,[l("code",null,"Cache-Control"),e(" and "),l("code",null,"Last-Modified"),e(" headers for the "),l("code",null,"/assets"),e(" endpoint are separate from the regular data-cache. "),l("code",null,"Last-Modified"),e(" comes from "),l("code",null,"modified_on"),e(" DB field. This is useful as it\u2019s often possible to cache assets for far longer than you would cache database content. To learn more, see "),l("a",{href:"#assets"},"Assets"),e(".")])],-1),ne=l("table",null,[l("thead",null,[l("tr",null,[l("th",null,"Variable"),l("th",null,"Description"),l("th",null,"Default Value")])]),l("tbody",null,[l("tr",null,[l("td",null,[l("code",null,"CACHE_ENABLED")]),l("td",null,"Whether or not data caching is enabled."),l("td",null,[l("code",null,"false")])]),l("tr",null,[l("td",null,[l("code",null,"CACHE_TTL"),l("sup",null,"[1]")]),l("td",null,"How long the data cache is persisted."),l("td",null,[l("code",null,"5m")])]),l("tr",null,[l("td",null,[l("code",null,"CACHE_CONTROL_S_MAXAGE")]),l("td",null,[e("Whether to not to add the "),l("code",null,"s-maxage"),e(" expiration flag. Set to a number for a custom value.")]),l("td",null,[l("code",null,"0")])]),l("tr",null,[l("td",null,[l("code",null,"CACHE_AUTO_PURGE"),l("sup",null,"[2]")]),l("td",null,[e("Automatically purge the data cache on "),l("code",null,"create"),e(", "),l("code",null,"update"),e(", and "),l("code",null,"delete"),e(" actions.")]),l("td",null,[l("code",null,"false")])]),l("tr",null,[l("td",null,[l("code",null,"CACHE_SYSTEM_TTL"),l("sup",null,"[3]")]),l("td",null,[e("How long "),l("code",null,"CACHE_SCHEMA"),e(" and "),l("code",null,"CACHE_PERMISSIONS"),e(" are persisted.")]),l("td",null,[l("code",null,"10m")])]),l("tr",null,[l("td",null,[l("code",null,"CACHE_SCHEMA"),l("sup",null,"[3]")]),l("td",null,[e("Whether or not the database schema is cached. One of "),l("code",null,"false"),e(", "),l("code",null,"true")]),l("td",null,[l("code",null,"true")])]),l("tr",null,[l("td",null,[l("code",null,"CACHE_PERMISSIONS"),l("sup",null,"[3]")]),l("td",null,[e("Whether or not the user permissions are cached. One of "),l("code",null,"false"),e(", "),l("code",null,"true")]),l("td",null,[l("code",null,"true")])]),l("tr",null,[l("td",null,[l("code",null,"CACHE_NAMESPACE")]),l("td",null,"How to scope the cache data."),l("td",null,[l("code",null,"directus-cache")])]),l("tr",null,[l("td",null,[l("code",null,"CACHE_STORE"),l("sup",null,"[4]")]),l("td",null,[e("Where to store the cache data. Either "),l("code",null,"memory"),e(", "),l("code",null,"redis"),e(", or "),l("code",null,"memcache"),e(".")]),l("td",null,[l("code",null,"memory")])]),l("tr",null,[l("td",null,[l("code",null,"CACHE_STATUS_HEADER")]),l("td",null,[e("If set, returns the cache status in the configured header. One of "),l("code",null,"HIT"),e(", "),l("code",null,"MISS"),e(".")]),l("td",null,"\u2013")]),l("tr",null,[l("td",null,[l("code",null,"CACHE_VALUE_MAX_SIZE")]),l("td",null,[e("Maximum size of values that will be cached. Accepts number of bytes, or human readable string. Use "),l("code",null,"false"),e(" for no limit")]),l("td",null,"false")]),l("tr",null,[l("td",null,[l("code",null,"CACHE_HEALTHCHECK_THRESHOLD")]),l("td",null,"Healthcheck timeout threshold in ms."),l("td",null,[l("code",null,"150")])])])],-1),te=l("p",null,[l("sup",null,"[1]"),e(),l("code",null,"CACHE_TTL"),e(" Based on your project\u2019s needs, you might be able to aggressively cache your data, only requiring new data to be fetched every hour or so. This allows you to squeeze the most performance out of your Directus instance. This can be incredibly useful for applications where you have a lot of (public) read-access and where updates aren\u2019t real-time (for example a website). "),l("code",null,"CACHE_TTL"),e(" uses "),l("a",{href:"https://www.npmjs.com/package/ms",target:"_blank",rel:"noopener noreferrer"},[l("code",null,"ms")]),e(" to parse the value, so you configure it using human readable values (like "),l("code",null,"2 days"),e(", "),l("code",null,"7 hrs"),e(", "),l("code",null,"5m"),e(").")],-1),oe=l("p",null,[l("sup",null,"[2]"),e(),l("code",null,"CACHE_AUTO_PURGE"),e(" allows you to keep the Directus API real-time, while still getting the performance benefits on quick subsequent reads.")],-1),ue=l("p",null,[l("sup",null,"[3]"),e(" Not affected by the "),l("code",null,"CACHE_ENABLED"),e(" value.")],-1),se=l("p",null,[l("sup",null,"[4]"),e(),l("code",null,"CACHE_STORE"),e(" For larger projects, you most likely don\u2019t want to rely on local memory for caching. Instead, you can use the above "),l("code",null,"CACHE_STORE"),e(" environment variable to use either "),l("code",null,"memcache"),e(" or "),l("code",null,"redis"),e(" as the cache store. Based on the chosen "),l("code",null,"CACHE_STORE"),e(", you must also provide the following configurations:")],-1),ae=l("h3",{id:"memory-1",tabindex:"-1"},[l("a",{class:"header-anchor",href:"#memory-1"},"#"),e(" Memory")],-1),de=l("p",null,"No additional configuration required.",-1),re=l("h3",{id:"redis-1",tabindex:"-1"},[l("a",{class:"header-anchor",href:"#redis-1"},"#"),e(" Redis")],-1),ie=l("table",null,[l("thead",null,[l("tr",null,[l("th",null,"Variable"),l("th",null,"Description"),l("th",null,"Default Value")])]),l("tbody",null,[l("tr",null,[l("td",null,[l("code",null,"CACHE_REDIS")]),l("td",null,[e("Redis connection string, e.g., "),l("code",null,"redis://:authpassword@127.0.0.1:6380/4")]),l("td",null,"\u2014")])])],-1),ce=l("p",null,"Alternatively, you can provide the individual connection parameters:",-1),he=l("table",null,[l("thead",null,[l("tr",null,[l("th",null,"Variable"),l("th",null,"Description"),l("th",null,"Default Value")])]),l("tbody",null,[l("tr",null,[l("td",null,[l("code",null,"CACHE_REDIS_HOST")]),l("td",null,[e("Hostname of the Redis instance, e.g., "),l("code",null,'"127.0.0.1"')]),l("td",null,"\u2013")]),l("tr",null,[l("td",null,[l("code",null,"CACHE_REDIS_PORT")]),l("td",null,[e("Port of the Redis instance, e.g., "),l("code",null,"6379")]),l("td",null,"\u2013")]),l("tr",null,[l("td",null,[l("code",null,"CACHE_REDIS_USERNAME")]),l("td",null,[e("Username for your Redis instance, e.g., "),l("code",null,'"default"')]),l("td",null,"\u2013")]),l("tr",null,[l("td",null,[l("code",null,"CACHE_REDIS_PASSWORD")]),l("td",null,[e("Password for your Redis instance, e.g., "),l("code",null,'"yourRedisPassword"')]),l("td",null,"\u2013")]),l("tr",null,[l("td",null,[l("code",null,"CACHE_REDIS_DB")]),l("td",null,[e("Database of your Redis instance to connect, e.g., "),l("code",null,"1")]),l("td",null,"\u2013")])])],-1),_e=l("h3",{id:"memcache-1",tabindex:"-1"},[l("a",{class:"header-anchor",href:"#memcache-1"},"#"),e(" Memcache")],-1),pe=l("table",null,[l("thead",null,[l("tr",null,[l("th",null,"Variable"),l("th",null,"Description"),l("th",null,"Default Value")])]),l("tbody",null,[l("tr",null,[l("td",null,[l("code",null,"CACHE_MEMCACHE")]),l("td",null,[e("Location of your memcache instance. You can use "),l("a",{href:"#environment-syntax-prefix"},[l("code",null,"array:"),e(" syntax")]),e(", e.g., "),l("code",null,"array:<instance-1>,<instance-2>"),e(" for multiple memcache instances.")]),l("td",null,"\u2014")])])],-1),fe=l("h2",{id:"file-storage",tabindex:"-1"},[l("a",{class:"header-anchor",href:"#file-storage"},"#"),e(" File Storage")],-1),me=l("p",null,[e("By default, Directus stores all uploaded files locally on disk. However, you can also configure Directus to use S3, Google Cloud Storage, or Azure. You can also configure "),l("em",null,"multiple"),e(" storage adapters at the same time. This allows you to choose where files are being uploaded on a file-by-file basis. In the Admin App, files will automatically be uploaded to the first configured storage location (in this case "),l("code",null,"local"),e("). The used storage location is saved under "),l("code",null,"storage"),e(" in "),l("code",null,"directus_files"),e(".")],-1),Ee=l("div",{class:"tip hint"},[l("div",{class:"hint-title"},"File Storage Default"),l("p",null,"If you don\u2019t provide any configuration for storage adapters, this default will be used:"),l("pre",null,[l("code",null,`STORAGE_LOCATIONS="local"
STORAGE_LOCAL_ROOT="./uploads"
`)])],-1),Ae=l("div",{class:"warning hint"},[l("div",{class:"hint-title"},"Case sensitivity"),l("p",null,"The location value(s) you specify should be capitalized when specifying the additional configuration values. For example, this will not work:"),l("pre",null,[l("code",null,`STORAGE_LOCATIONS="s3"
STORAGE_s3_DRIVER="s3" # Will not work, lowercase "s3" \u274C
`)]),l("p",null,"but this will work:"),l("pre",null,[l("code",null,`STORAGE_LOCATIONS="s3"
STORAGE_S3_DRIVER="s3" # Will work, "s3" is uppercased \u2705
`)])],-1),Te=l("table",null,[l("thead",null,[l("tr",null,[l("th",null,"Variable"),l("th",null,"Description"),l("th",null,"Default Value")])]),l("tbody",null,[l("tr",null,[l("td",null,[l("code",null,"STORAGE_LOCATIONS")]),l("td",null,[e("A CSV of storage locations (e.g., "),l("code",null,"local,digitalocean,amazon"),e(") to use. You can use any names you\u2019d like for these keys.")]),l("td",null,[l("code",null,"local")])])])],-1),ge=l("p",null,"For each of the storage locations listed, you must provide the following configuration:",-1),Re=l("table",null,[l("thead",null,[l("tr",null,[l("th",null,"Variable"),l("th",null,"Description"),l("th",null,"Default Value")])]),l("tbody",null,[l("tr",null,[l("td",null,[l("code",null,"STORAGE_<LOCATION>_DRIVER")]),l("td",null,[e("Which driver to use, either "),l("code",null,"local"),e(", "),l("code",null,"s3"),e(", "),l("code",null,"gcs"),e(", "),l("code",null,"azure")]),l("td")]),l("tr",null,[l("td",null,[l("code",null,"STORAGE_<LOCATION>_ROOT")]),l("td",null,"Where to store the files on disk"),l("td",null,[l("code",null,"''")])]),l("tr",null,[l("td",null,[l("code",null,"STORAGE_<LOCATION>_HEALTHCHECK_THRESHOLD")]),l("td",null,"Healthcheck timeout threshold in ms."),l("td",null,[l("code",null,"750")])])])],-1),be=l("p",null,"Based on your configured driver, you must also provide the following configurations:",-1),Se=l("h3",{id:"local-(local)",tabindex:"-1"},[l("a",{class:"header-anchor",href:"#local-(local)"},"#"),e(" Local ("),l("code",null,"local"),e(")")],-1),Ie=l("table",null,[l("thead",null,[l("tr",null,[l("th",null,"Variable"),l("th",null,"Description"),l("th",null,"Default Value")])]),l("tbody",null,[l("tr",null,[l("td",null,[l("code",null,"STORAGE_<LOCATION>_ROOT")]),l("td",null,"Where to store the files on disk"),l("td",null,"\u2013")])])],-1),Oe=l("h3",{id:"s3-(s3)",tabindex:"-1"},[l("a",{class:"header-anchor",href:"#s3-(s3)"},"#"),e(" S3 ("),l("code",null,"s3"),e(")")],-1),De=l("table",null,[l("thead",null,[l("tr",null,[l("th",null,"Variable"),l("th",null,"Description"),l("th",null,"Default Value")])]),l("tbody",null,[l("tr",null,[l("td",null,[l("code",null,"STORAGE_<LOCATION>_KEY")]),l("td",null,"User key"),l("td",null,"\u2013")]),l("tr",null,[l("td",null,[l("code",null,"STORAGE_<LOCATION>_SECRET")]),l("td",null,"User secret"),l("td",null,"\u2013")]),l("tr",null,[l("td",null,[l("code",null,"STORAGE_<LOCATION>_BUCKET")]),l("td",null,"S3 Bucket"),l("td",null,"\u2013")]),l("tr",null,[l("td",null,[l("code",null,"STORAGE_<LOCATION>_REGION")]),l("td",null,"S3 Region"),l("td",null,"\u2013")]),l("tr",null,[l("td",null,[l("code",null,"STORAGE_<LOCATION>_ENDPOINT")]),l("td",null,"S3 Endpoint"),l("td",null,[l("code",null,"s3.amazonaws.com")])]),l("tr",null,[l("td",null,[l("code",null,"STORAGE_<LOCATION>_ACL")]),l("td",null,"S3 ACL"),l("td",null,"\u2013")]),l("tr",null,[l("td",null,[l("code",null,"STORAGE_<LOCATION>_SERVER_SIDE_ENCRYPTION")]),l("td",null,"S3 Server Side Encryption"),l("td",null,"\u2013")])])],-1),ye=l("h3",{id:"azure-(azure)",tabindex:"-1"},[l("a",{class:"header-anchor",href:"#azure-(azure)"},"#"),e(" Azure ("),l("code",null,"azure"),e(")")],-1),Le=l("table",null,[l("thead",null,[l("tr",null,[l("th",null,"Variable"),l("th",null,"Description"),l("th",null,"Default Value")])]),l("tbody",null,[l("tr",null,[l("td",null,[l("code",null,"STORAGE_<LOCATION>_CONTAINER_NAME")]),l("td",null,"Azure Storage container"),l("td",null,"\u2013")]),l("tr",null,[l("td",null,[l("code",null,"STORAGE_<LOCATION>_ACCOUNT_NAME")]),l("td",null,"Azure Storage account name"),l("td",null,"\u2013")]),l("tr",null,[l("td",null,[l("code",null,"STORAGE_<LOCATION>_ACCOUNT_KEY")]),l("td",null,"Azure Storage key"),l("td",null,"\u2013")]),l("tr",null,[l("td",null,[l("code",null,"STORAGE_<LOCATION>_ENDPOINT")]),l("td",null,"Azure URL"),l("td",null,[l("code",null,"https://{ACCOUNT_KEY}.blob.core.windows.net")])])])],-1),Ce=l("h3",{id:"google-cloud-storage-(gcs)",tabindex:"-1"},[l("a",{class:"header-anchor",href:"#google-cloud-storage-(gcs)"},"#"),e(" Google Cloud Storage ("),l("code",null,"gcs"),e(")")],-1),ve=l("table",null,[l("thead",null,[l("tr",null,[l("th",null,"Variable"),l("th",null,"Description"),l("th",null,"Default Value")])]),l("tbody",null,[l("tr",null,[l("td",null,[l("code",null,"STORAGE_<LOCATION>_KEY_FILENAME")]),l("td",null,"Path to key file on disk"),l("td",null,"\u2013")]),l("tr",null,[l("td",null,[l("code",null,"STORAGE_<LOCATION>_BUCKET")]),l("td",null,"Google Cloud Storage bucket"),l("td",null,"\u2013")])])],-1),He=l("h3",{id:"example%3A-multiple-storage-adapters",tabindex:"-1"},[l("a",{class:"header-anchor",href:"#example%3A-multiple-storage-adapters"},"#"),e(" Example: Multiple Storage Adapters")],-1),we=l("p",null,"Below showcases a CSV of storage location names, with a config block for each:",-1),Ue=l("pre",null,[l("code",null,`STORAGE_LOCATIONS="local,aws"

STORAGE_LOCAL_DRIVER="local"
STORAGE_LOCAL_ROOT="local"

STORAGE_AWS_KEY="tp15c...510vk"
STORAGE_AWS_SECRET="yk29b...b932n"
STORAGE_AWS_REGION="us-east-2"
STORAGE_AWS_BUCKET="my-files"
`)],-1),Pe=l("h3",{id:"metadata",tabindex:"-1"},[l("a",{class:"header-anchor",href:"#metadata"},"#"),e(" Metadata")],-1),Ne=l("p",null,[e("When uploading an image, Directus persists the "),l("em",null,"description, title, and tags"),e(" from available EXIF metadata. For security purposes, collection of additional metadata must be configured:")],-1),xe=l("table",null,[l("thead",null,[l("tr",null,[l("th",null,"Variable"),l("th",null,"Description"),l("th",null,"Default Value")])]),l("tbody",null,[l("tr",null,[l("td",null,[l("code",null,"FILE_METADATA_ALLOW_LIST")]),l("td",null,[e("A comma-separated list of metadata keys to collect during file upload. Use "),l("code",null,"*"),e(" for all"),l("sup",null,"[1]"),e(".")]),l("td",null,"ifd0.Make,ifd0.Model,exif.FNumber,exif.ExposureTime,exif.FocalLength,exif.ISO")])])],-1),Me=l("p",null,[l("sup",null,"[1]"),e(": Extracting all metadata might cause memory issues when the file has an unusually large set of metadata")],-1),Ve=l("h2",{id:"assets",tabindex:"-1"},[l("a",{class:"header-anchor",href:"#assets"},"#"),e(" Assets")],-1),je=l("table",null,[l("thead",null,[l("tr",null,[l("th",null,"Variable"),l("th",null,"Description"),l("th",null,"Default Value")])]),l("tbody",null,[l("tr",null,[l("td",null,[l("code",null,"ASSETS_CACHE_TTL")]),l("td",null,[e("How long assets will be cached for in the browser. Sets the "),l("code",null,"max-age"),e(" value of the "),l("code",null,"Cache-Control"),e(" header.")]),l("td",null,[l("code",null,"30m")])]),l("tr",null,[l("td",null,[l("code",null,"ASSETS_TRANSFORM_MAX_CONCURRENT")]),l("td",null,"How many file transformations can be done simultaneously"),l("td",null,[l("code",null,"4")])]),l("tr",null,[l("td",null,[l("code",null,"ASSETS_TRANSFORM_IMAGE_MAX_DIMENSION")]),l("td",null,"The max pixel dimensions size (width/height) that is allowed to be transformed"),l("td",null,[l("code",null,"6000")])]),l("tr",null,[l("td",null,[l("code",null,"ASSETS_TRANSFORM_MAX_OPERATIONS")]),l("td",null,"The max number of transform operations that is allowed to be processed (excludes saved presets)"),l("td",null,[l("code",null,"5")])]),l("tr",null,[l("td",null,[l("code",null,"ASSETS_CONTENT_SECURITY_POLICY")]),l("td",null,[e("Custom overrides for the Content-Security-Policy header. See "),l("a",{href:"https://helmetjs.github.io",target:"_blank",rel:"noopener noreferrer"},"helmet\u2019s documentation"),e(" for more information.")]),l("td",null,"\u2013")])])],-1),ke=l("p",null,"Image transformations can be fairly heavy on memory usage. If you\u2019re using a system with 1GB or less available memory, we recommend lowering the allowed concurrent transformations to prevent you from overflowing your server.",-1),Be=l("h2",{id:"authentication",tabindex:"-1"},[l("a",{class:"header-anchor",href:"#authentication"},"#"),e(" Authentication")],-1),Ge=l("table",null,[l("thead",null,[l("tr",null,[l("th",null,"Variable"),l("th",null,"Description"),l("th",null,"Default Value")])]),l("tbody",null,[l("tr",null,[l("td",null,[l("code",null,"AUTH_PROVIDERS")]),l("td",null,"A comma-separated list of auth providers."),l("td",null,"\u2013")]),l("tr",null,[l("td",null,[l("code",null,"AUTH_DISABLE_DEFAULT")]),l("td",null,"Disable the default auth provider"),l("td",null,[l("code",null,"false")])])])],-1),Fe=l("p",null,"For each auth provider you list, you must also provide the following configuration:",-1),We=l("table",null,[l("thead",null,[l("tr",null,[l("th",null,"Variable"),l("th",null,"Description"),l("th",null,"Default Value")])]),l("tbody",null,[l("tr",null,[l("td",null,[l("code",null,"AUTH_<PROVIDER>_DRIVER")]),l("td",null,[e("Which driver to use, either "),l("code",null,"local"),e(", "),l("code",null,"oauth2"),e(", "),l("code",null,"openid"),e(", "),l("code",null,"ldap"),e(", "),l("code",null,"saml")]),l("td",null,"\u2013")])])],-1),qe=l("p",null,"You may also be required to specify additional variables depending on the auth driver. See configuration details below.",-1),Ke=l("div",{class:"tip hint"},[l("div",{class:"hint-title"},"Multiple Providers"),l("p",null,"Directus users can only authenticate using the auth provider they are created with. It is not possible to authenticate with multiple providers for the same user.")],-1),Ye=l("h3",{id:"local-(local)-1",tabindex:"-1"},[l("a",{class:"header-anchor",href:"#local-(local)-1"},"#"),e(" Local ("),l("code",null,"local"),e(")")],-1),ze=l("p",null,"The default Directus email/password authentication flow.",-1),Xe=l("p",null,"No additional configuration required.",-1),Ze=l("h3",{id:"sso-(oauth2-and-openid)",tabindex:"-1"},[l("a",{class:"header-anchor",href:"#sso-(oauth2-and-openid)"},"#"),e(" SSO ("),l("code",null,"oauth2"),e(" and "),l("code",null,"openid"),e(")")],-1),Je=l("p",null,"Directus\u2019 SSO integrations provide powerful alternative ways to authenticate into your project. Directus will ask you to login on the external service, and return authenticated with a Directus account linked to that service.",-1),Qe=l("p",null,[e("For example, you can login to Directus using a GitHub account by creating an "),l("a",{href:"https://github.com/settings/developers",target:"_blank",rel:"noopener noreferrer"},"OAuth 2.0 app in GitHub"),e(" and adding the following configuration to Directus:")],-1),$e=l("pre",null,[l("code",null,`AUTH_PROVIDERS="github"

AUTH_GITHUB_DRIVER="oauth2"
AUTH_GITHUB_CLIENT_ID="99d3...c3c4"
AUTH_GITHUB_CLIENT_SECRET="34ae...f963"
AUTH_GITHUB_AUTHORIZE_URL="https://github.com/login/oauth/authorize"
AUTH_GITHUB_ACCESS_URL="https://github.com/login/oauth/access_token"
AUTH_GITHUB_PROFILE_URL="https://api.github.com/user"
`)],-1),ln=l("div",{class:"warning hint"},[l("div",{class:"hint-title"},"PUBLIC_URL"),l("p",null,[e("These flows rely on the "),l("code",null,"PUBLIC_URL"),e(" variable for redirecting. Ensure the variable is correctly configured.")])],-1),en=l("h3",{id:"oauth-2.0",tabindex:"-1"},[l("a",{class:"header-anchor",href:"#oauth-2.0"},"#"),e(" OAuth 2.0")],-1),nn=l("thead",null,[l("tr",null,[l("th",null,"Variable"),l("th",null,"Description"),l("th",null,"Default Value")])],-1),tn=l("tr",null,[l("td",null,[l("code",null,"AUTH_<PROVIDER>_CLIENT_ID")]),l("td",null,"Client identifier for the OAuth provider."),l("td",null,"\u2013")],-1),on=l("tr",null,[l("td",null,[l("code",null,"AUTH_<PROVIDER>_CLIENT_SECRET")]),l("td",null,"Client secret for the OAuth provider."),l("td",null,"\u2013")],-1),un=l("tr",null,[l("td",null,[l("code",null,"AUTH_<PROVIDER>_SCOPE")]),l("td",null,"A white-space separated list of permissions to request."),l("td",null,[l("code",null,"email")])],-1),sn=l("tr",null,[l("td",null,[l("code",null,"AUTH_<PROVIDER>_AUTHORIZE_URL")]),l("td",null,"Authorization page URL of the OAuth provider."),l("td",null,"\u2013")],-1),an=l("tr",null,[l("td",null,[l("code",null,"AUTH_<PROVIDER>_ACCESS_URL")]),l("td",null,"Access token URL of the OAuth provider."),l("td",null,"\u2013")],-1),dn=l("tr",null,[l("td",null,[l("code",null,"AUTH_<PROVIDER>_PROFILE_URL")]),l("td",null,"User profile URL of the OAuth provider."),l("td",null,"\u2013")],-1),rn=l("tr",null,[l("td",null,[l("code",null,"AUTH_<PROVIDER>_IDENTIFIER_KEY")]),l("td",null,[e("User profile identifier key "),l("sup",null,"[1]"),e(". Will default to "),l("code",null,"EMAIL_KEY"),e(".")]),l("td",null,"\u2013")],-1),cn=l("tr",null,[l("td",null,[l("code",null,"AUTH_<PROVIDER>_EMAIL_KEY")]),l("td",null,"User profile email key."),l("td",null,[l("code",null,"email")])],-1),hn=l("tr",null,[l("td",null,[l("code",null,"AUTH_<PROVIDER>_FIRST_NAME_KEY")]),l("td",null,"User profile first name key."),l("td",null,"\u2013")],-1),_n=l("tr",null,[l("td",null,[l("code",null,"AUTH_<PROVIDER>_LAST_NAME_KEY")]),l("td",null,"User profile last name key."),l("td",null,"\u2013")],-1),pn=l("tr",null,[l("td",null,[l("code",null,"AUTH_<PROVIDER>_ALLOW_PUBLIC_REGISTRATION")]),l("td",null,"Automatically create accounts for authenticating users."),l("td",null,[l("code",null,"false")])],-1),fn=l("tr",null,[l("td",null,[l("code",null,"AUTH_<PROVIDER>_DEFAULT_ROLE_ID")]),l("td",null,"A Directus role ID to assign created users."),l("td",null,"\u2013")],-1),mn=l("td",null,[l("code",null,"AUTH_<PROVIDER>_ICON")],-1),En=l("td",null,[l("code",null,"account_circle")],-1),An=l("tr",null,[l("td",null,[l("code",null,"AUTH_<PROVIDER>_LABEL")]),l("td",null,"Text to be presented on SSO button within App."),l("td",null,[l("code",null,"<PROVIDER>")])],-1),Tn=l("tr",null,[l("td",null,[l("code",null,"AUTH_<PROVIDER>_PARAMS")]),l("td",null,"Custom query parameters applied to the authorization URL."),l("td",null,"\u2013")],-1),gn=l("p",null,[l("sup",null,"[1]"),e(" When authenticating, Directus will match the identifier value from the external user profile to a Directus users \u201CExternal Identifier\u201D.")],-1),Rn=l("h3",{id:"openid",tabindex:"-1"},[l("a",{class:"header-anchor",href:"#openid"},"#"),e(" OpenID")],-1),bn=l("p",null,"OpenID is an authentication protocol built on OAuth 2.0, and should be preferred over standard OAuth 2.0 where possible.",-1),Sn=l("thead",null,[l("tr",null,[l("th",null,"Variable"),l("th",null,"Description"),l("th",null,"Default Value")])],-1),In=l("tr",null,[l("td",null,[l("code",null,"AUTH_<PROVIDER>_CLIENT_ID")]),l("td",null,"Client identifier for the external service."),l("td",null,"\u2013")],-1),On=l("tr",null,[l("td",null,[l("code",null,"AUTH_<PROVIDER>_CLIENT_SECRET")]),l("td",null,"Client secret for the external service."),l("td",null,"\u2013")],-1),Dn=l("tr",null,[l("td",null,[l("code",null,"AUTH_<PROVIDER>_SCOPE")]),l("td",null,"A white-space separated list of permissions to request."),l("td",null,[l("code",null,"openid profile email")])],-1),yn=l("tr",null,[l("td",null,[l("code",null,"AUTH_<PROVIDER>_ISSUER_URL")]),l("td",null,[e("OpenID "),l("code",null,".well-known"),e(" discovery document URL of the external service.")]),l("td",null,"\u2013")],-1),Ln=l("tr",null,[l("td",null,[l("code",null,"AUTH_<PROVIDER>_IDENTIFIER_KEY")]),l("td",null,[e("User profile identifier key "),l("sup",null,"[1]"),e(".")]),l("td",null,[l("code",null,"sub"),l("sup",null,"[2]")])],-1),Cn=l("tr",null,[l("td",null,[l("code",null,"AUTH_<PROVIDER>_ALLOW_PUBLIC_REGISTRATION")]),l("td",null,"Automatically create accounts for authenticating users."),l("td",null,[l("code",null,"false")])],-1),vn=l("tr",null,[l("td",null,[l("code",null,"AUTH_<PROVIDER>_REQUIRE_VERIFIED_EMAIL")]),l("td",null,"Require created users to have a verified email address."),l("td",null,[l("code",null,"false")])],-1),Hn=l("tr",null,[l("td",null,[l("code",null,"AUTH_<PROVIDER>_DEFAULT_ROLE_ID")]),l("td",null,"A Directus role ID to assign created users."),l("td",null,"\u2013")],-1),wn=l("td",null,[l("code",null,"AUTH_<PROVIDER>_ICON")],-1),Un=l("td",null,[l("code",null,"account_circle")],-1),Pn=l("tr",null,[l("td",null,[l("code",null,"AUTH_<PROVIDER>_LABEL")]),l("td",null,"Text to be presented on SSO button within App."),l("td",null,[l("code",null,"<PROVIDER>")])],-1),Nn=l("tr",null,[l("td",null,[l("code",null,"AUTH_<PROVIDER>_PARAMS")]),l("td",null,"Custom query parameters applied to the authorization URL."),l("td",null,"\u2013")],-1),xn=l("p",null,[l("sup",null,"[1]"),e(" When authenticating, Directus will match the identifier value from the external user profile to a Directus users \u201CExternal Identifier\u201D.")],-1),Mn=l("p",null,[l("sup",null,"[2]"),e(),l("code",null,"sub"),e(" represents a unique user identifier defined by the OpenID provider. For users not relying on "),l("code",null,"PUBLIC_REGISTRATION"),e(" it is recommended to use a human-readable identifier, such as "),l("code",null,"email"),e(".")],-1),Vn=l("h3",{id:"ldap-(ldap)",tabindex:"-1"},[l("a",{class:"header-anchor",href:"#ldap-(ldap)"},"#"),e(" LDAP ("),l("code",null,"ldap"),e(")")],-1),jn=l("p",null,"LDAP allows Active Directory users to authenticate and use Directus without having to be manually configured. User information and roles will be assigned from Active Directory.",-1),kn=l("table",null,[l("thead",null,[l("tr",null,[l("th",null,"Variable"),l("th",null,"Description"),l("th",null,"Default Value")])]),l("tbody",null,[l("tr",null,[l("td",null,[l("code",null,"AUTH_<PROVIDER>_CLIENT_URL")]),l("td",null,"LDAP connection URL."),l("td",null,"\u2013")]),l("tr",null,[l("td",null,[l("code",null,"AUTH_<PROVIDER>_BIND_DN")]),l("td",null,[e("Bind user "),l("sup",null,"[1]"),e(" distinguished name.")]),l("td",null,"\u2013")]),l("tr",null,[l("td",null,[l("code",null,"AUTH_<PROVIDER>_BIND_PASSWORD")]),l("td",null,"Bind user password."),l("td",null,"\u2013")]),l("tr",null,[l("td",null,[l("code",null,"AUTH_<PROVIDER>_USER_DN")]),l("td",null,"Directory path containing users."),l("td",null,"\u2013")]),l("tr",null,[l("td",null,[l("code",null,"AUTH_<PROVIDER>_USER_ATTRIBUTE")]),l("td",null,"Attribute to identify the user."),l("td",null,[l("code",null,"cn")])]),l("tr",null,[l("td",null,[l("code",null,"AUTH_<PROVIDER>_USER_SCOPE")]),l("td",null,[e("Scope of the user search, either "),l("code",null,"base"),e(", "),l("code",null,"one"),e(", "),l("code",null,"sub"),e(),l("sup",null,"[2]"),e(".")]),l("td",null,[l("code",null,"one")])]),l("tr",null,[l("td",null,[l("code",null,"AUTH_<PROVIDER>_MAIL_ATTRIBUTE")]),l("td",null,"User email attribute."),l("td",null,[l("code",null,"mail")])]),l("tr",null,[l("td",null,[l("code",null,"AUTH_<PROVIDER>_FIRST_NAME_ATTRIBUTE")]),l("td",null,"User first name attribute."),l("td",null,[l("code",null,"givenName")])]),l("tr",null,[l("td",null,[l("code",null,"AUTH_<PROVIDER>_LAST_NAME_ATTRIBUTE")]),l("td",null,"User last name attribute."),l("td",null,[l("code",null,"sn")])]),l("tr",null,[l("td",null,[l("code",null,"AUTH_<PROVIDER>_GROUP_DN"),l("sup",null,"[3]")]),l("td",null,"Directory path containing groups."),l("td",null,"\u2013")]),l("tr",null,[l("td",null,[l("code",null,"AUTH_<PROVIDER>_GROUP_ATTRIBUTE")]),l("td",null,"Attribute to identify user as a member of a group."),l("td",null,[l("code",null,"member")])]),l("tr",null,[l("td",null,[l("code",null,"AUTH_<PROVIDER>_GROUP_SCOPE")]),l("td",null,[e("Scope of the group search, either "),l("code",null,"base"),e(", "),l("code",null,"one"),e(", "),l("code",null,"sub"),e(),l("sup",null,"[2]"),e(".")]),l("td",null,[l("code",null,"one")])]),l("tr",null,[l("td",null,[l("code",null,"AUTH_<PROVIDER>_DEFAULT_ROLE_ID")]),l("td",null,"A fallback Directus role ID to assign created users."),l("td",null,"\u2013")])])],-1),Bn=l("p",null,[l("sup",null,"[1]"),e(" The bind user must have permission to query users and groups to perform authentication. Anonymous binding can by achieved by setting an empty value for "),l("code",null,"BIND_DN"),e(" and "),l("code",null,"BIND_PASSWORD"),e(".")],-1),Gn=l("p",null,[l("sup",null,"[2]"),e(" The scope defines the following behaviors:")],-1),Fn=l("ul",null,[l("li",null,[l("code",null,"base"),e(": Limits the scope to a single object defined by the associated DN.")]),l("li",null,[l("code",null,"one"),e(": Searches all objects within the associated DN.")]),l("li",null,[l("code",null,"sub"),e(": Searches all objects and sub-objects within the associated DN.")])],-1),Wn=l("p",null,[l("sup",null,"[3]"),e(" If "),l("code",null,"GROUP_DN"),e(" is specified, the user\u2019s role will always be updated on authentication to a matching group configured in AD, or fallback to the "),l("code",null,"DEFAULT_ROLE_ID"),e(".")],-1),qn=l("h3",{id:"example%3A-ldap",tabindex:"-1"},[l("a",{class:"header-anchor",href:"#example%3A-ldap"},"#"),e(" Example: LDAP")],-1),Kn=l("pre",null,[l("code",null,`AUTH_PROVIDERS="ldap"

AUTH_LDAP_DRIVER="ldap"
AUTH_LDAP_CLIENT_URL="ldap://ldap.directus.io"
AUTH_LDAP_BIND_DN="CN=Bind User,OU=Users,DC=ldap,DC=directus,DC=io"
AUTH_LDAP_BIND_PASSWORD="p455w0rd"
AUTH_LDAP_USER_DN="OU=Users,DC=ldap,DC=directus,DC=io"
AUTH_LDAP_GROUP_DN="OU=Groups,DC=ldap,DC=directus,DC=io"
`)],-1),Yn=l("h3",{id:"saml",tabindex:"-1"},[l("a",{class:"header-anchor",href:"#saml"},"#"),e(" SAML")],-1),zn=l("p",null,"SAML is an open-standard, XML-based authentication framework for authentication and authorization between two entities without a password.",-1),Xn=l("ul",null,[l("li",null,[l("p",null,"Service provider (SP) agrees to trust the identity provider to authenticate users.")]),l("li",null,[l("p",null,"Identity provider (IdP) authenticates users and provides to service providers an authentication assertion that indicates a user has been authenticated.")])],-1),Zn=l("table",null,[l("thead",null,[l("tr",null,[l("th",null,"Variable"),l("th",null,"Description"),l("th",null,"Default Value")])]),l("tbody",null,[l("tr",null,[l("td",null,[l("code",null,"AUTH_<PROVIDER>_SP_metadata")]),l("td",null,"String containing XML metadata for service provider or URL to a remote URL"),l("td",null,"\u2013")]),l("tr",null,[l("td",null,[l("code",null,"AUTH_<PROVIDER>_IDP_metadata")]),l("td",null,"String container XML metadata for identity provider or URL to a remote URL"),l("td",null,"\u2013")]),l("tr",null,[l("td",null,[l("code",null,"AUTH_<PROVIDER>_ALLOW_PUBLIC_REGISTRATION")]),l("td",null,"Automatically create accounts for authenticating users."),l("td",null,[l("code",null,"false")])]),l("tr",null,[l("td",null,[l("code",null,"AUTH_<PROVIDER>_DEFAULT_ROLE_ID")]),l("td",null,"A Directus role ID to assign created users."),l("td",null,"\u2013")]),l("tr",null,[l("td",null,[l("code",null,"AUTH_<PROVIDER>_IDENTIFIER_KEY")]),l("td",null,[e("User profile identifier key "),l("sup",null,"[1]"),e(". Will default to "),l("code",null,"EMAIL_KEY"),e(".")]),l("td",null,"\u2013")]),l("tr",null,[l("td",null,[l("code",null,"AUTH_<PROVIDER>_EMAIL_KEY")]),l("td",null,"User profile email key."),l("td",null,[l("code",null,"email")])])])],-1),Jn=l("p",null,[l("sup",null,"[1]"),e(" When authenticating, Directus will match the identifier value from the external user profile to a Directus users \u201CExternal Identifier\u201D.")],-1),Qn=l("p",null,[e("The "),l("code",null,"SP_metadata"),e(" and "),l("code",null,"IDP_metadata"),e(" variables should be set to the XML metadata provided by the service provider and identity provider respectively or can be set to a URL that will be fetched on startup.")],-1),$n=l("h3",{id:"example%3A-multiple-auth-providers",tabindex:"-1"},[l("a",{class:"header-anchor",href:"#example%3A-multiple-auth-providers"},"#"),e(" Example: Multiple Auth Providers")],-1),lt=l("p",null,"You can configure multiple providers for handling authentication in Directus. This allows for different options when logging in. To do this, provide a comma-separated list of provider names, and a config block for each provider:",-1),et=l("pre",null,[l("code",null,`AUTH_PROVIDERS="google,facebook"

AUTH_GOOGLE_DRIVER="openid"
AUTH_GOOGLE_CLIENT_ID="830d...29sd"
AUTH_GOOGLE_CLIENT_SECRET="la23...4k2l"
AUTH_GOOGLE_ISSUER_URL="https://accounts.google.com/.well-known/openid-configuration"
AUTH_GOOGLE_IDENTIFIER_KEY="email"
AUTH_GOOGLE_ICON="google"
AUTH_GOOGLE_LABEL="Google"

AUTH_FACEBOOK_DRIVER="oauth2"
AUTH_FACEBOOK_CLIENT_ID="830d...29sd"
AUTH_FACEBOOK_CLIENT_SECRET="jd8x...685z"
AUTH_FACEBOOK_AUTHORIZE_URL="https://www.facebook.com/dialog/oauth"
AUTH_FACEBOOK_ACCESS_URL="https://graph.facebook.com/oauth/access_token"
AUTH_FACEBOOK_PROFILE_URL="https://graph.facebook.com/me?fields=email"
AUTH_FACEBOOK_ICON="facebook"
AUTH_FACEBOOK_LABEL="Facebook"
`)],-1),nt=l("h2",{id:"extensions",tabindex:"-1"},[l("a",{class:"header-anchor",href:"#extensions"},"#"),e(" Extensions")],-1),tt=l("table",null,[l("thead",null,[l("tr",null,[l("th",null,"Variable"),l("th",null,"Description"),l("th",null,"Default Value")])]),l("tbody",null,[l("tr",null,[l("td",null,[l("code",null,"EXTENSIONS_PATH")]),l("td",null,"Path to your local extensions folder."),l("td",null,[l("code",null,"./extensions")])]),l("tr",null,[l("td",null,[l("code",null,"EXTENSIONS_AUTO_RELOAD")]),l("td",null,"Automatically reload extensions when they have changed."),l("td",null,[l("code",null,"false")])])])],-1),ot=l("h2",{id:"messenger",tabindex:"-1"},[l("a",{class:"header-anchor",href:"#messenger"},"#"),e(" Messenger")],-1),ut=l("table",null,[l("thead",null,[l("tr",null,[l("th",null,"Variable"),l("th",null,"Description"),l("th",null,"Default Value")])]),l("tbody",null,[l("tr",null,[l("td",null,[l("code",null,"MESSENGER_STORE")]),l("td",null,[e("One of "),l("code",null,"memory"),e(", "),l("code",null,"redis"),l("sup",null,"[1]")]),l("td",null,[l("code",null,"memory")])]),l("tr",null,[l("td",null,[l("code",null,"MESSENGER_NAMESPACE")]),l("td",null,"How to scope the channels in Redis"),l("td",null,[l("code",null,"directus")])]),l("tr",null,[l("td",null,[l("code",null,"MESSENGER_REDIS_*")]),l("td",null,"The Redis configuration for the pub/sub connection"),l("td",null,"\u2013")])])],-1),st=l("p",null,[l("sup",null,"[1]"),e(),l("code",null,"redis"),e(" should be used in load-balanced installations of Directus")],-1),at=l("h2",{id:"email",tabindex:"-1"},[l("a",{class:"header-anchor",href:"#email"},"#"),e(" Email")],-1),dt=l("table",null,[l("thead",null,[l("tr",null,[l("th",null,"Variable"),l("th",null,"Description"),l("th",null,"Default Value")])]),l("tbody",null,[l("tr",null,[l("td",null,[l("code",null,"EMAIL_VERIFY_SETUP")]),l("td",null,"Check if email setup is properly configured."),l("td",null,[l("code",null,"true")])]),l("tr",null,[l("td",null,[l("code",null,"EMAIL_FROM")]),l("td",null,"Email address from which emails are sent."),l("td",null,[l("code",null,"no-reply@directus.io")])]),l("tr",null,[l("td",null,[l("code",null,"EMAIL_TRANSPORT")]),l("td",null,[e("What to use to send emails. One of "),l("code",null,"sendmail"),e(", "),l("code",null,"smtp"),e(", "),l("code",null,"mailgun"),e(", "),l("code",null,"sendgrid"),e(", "),l("code",null,"ses"),e(".")]),l("td",null,[l("code",null,"sendmail")])])])],-1),rt=l("p",null,[e("Based on the "),l("code",null,"EMAIL_TRANSPORT"),e(" used, you must also provide the following configurations:")],-1),it=l("h3",{id:"sendmail-(sendmail)",tabindex:"-1"},[l("a",{class:"header-anchor",href:"#sendmail-(sendmail)"},"#"),e(" Sendmail ("),l("code",null,"sendmail"),e(")")],-1),ct=l("table",null,[l("thead",null,[l("tr",null,[l("th",null,"Variable"),l("th",null,"Description"),l("th",null,"Default Value")])]),l("tbody",null,[l("tr",null,[l("td",null,[l("code",null,"EMAIL_SENDMAIL_NEW_LINE")]),l("td",null,"What new line style to use in sendmail."),l("td",null,[l("code",null,"unix")])]),l("tr",null,[l("td",null,[l("code",null,"EMAIL_SENDMAIL_PATH")]),l("td",null,"Path to your sendmail executable."),l("td",null,[l("code",null,"/usr/sbin/sendmail")])])])],-1),ht=l("h3",{id:"smtp-(smtp)",tabindex:"-1"},[l("a",{class:"header-anchor",href:"#smtp-(smtp)"},"#"),e(" SMTP ("),l("code",null,"smtp"),e(")")],-1),_t=l("table",null,[l("thead",null,[l("tr",null,[l("th",null,"Variable"),l("th",null,"Description"),l("th",null,"Default Value")])]),l("tbody",null,[l("tr",null,[l("td",null,[l("code",null,"EMAIL_SMTP_NAME")]),l("td",null,"SMTP Name"),l("td",null,"\u2013")]),l("tr",null,[l("td",null,[l("code",null,"EMAIL_SMTP_HOST")]),l("td",null,"SMTP Host"),l("td",null,"\u2013")]),l("tr",null,[l("td",null,[l("code",null,"EMAIL_SMTP_PORT")]),l("td",null,"SMTP Port"),l("td",null,"\u2013")]),l("tr",null,[l("td",null,[l("code",null,"EMAIL_SMTP_USER")]),l("td",null,"SMTP User"),l("td",null,"\u2013")]),l("tr",null,[l("td",null,[l("code",null,"EMAIL_SMTP_PASSWORD")]),l("td",null,"SMTP Password"),l("td",null,"\u2013")]),l("tr",null,[l("td",null,[l("code",null,"EMAIL_SMTP_POOL")]),l("td",null,"Use SMTP pooling"),l("td",null,"\u2013")]),l("tr",null,[l("td",null,[l("code",null,"EMAIL_SMTP_SECURE")]),l("td",null,"Enable TLS"),l("td",null,"\u2013")]),l("tr",null,[l("td",null,[l("code",null,"EMAIL_SMTP_IGNORE_TLS")]),l("td",null,"Ignore TLS"),l("td",null,"\u2013")])])],-1),pt=l("h3",{id:"mailgun-(mailgun)",tabindex:"-1"},[l("a",{class:"header-anchor",href:"#mailgun-(mailgun)"},"#"),e(" Mailgun ("),l("code",null,"mailgun"),e(")")],-1),ft=l("table",null,[l("thead",null,[l("tr",null,[l("th",null,"Variable"),l("th",null,"Description"),l("th",null,"Default Value")])]),l("tbody",null,[l("tr",null,[l("td",null,[l("code",null,"EMAIL_MAILGUN_API_KEY")]),l("td",null,"Your Mailgun API key."),l("td",null,"\u2013")]),l("tr",null,[l("td",null,[l("code",null,"EMAIL_MAILGUN_DOMAIN")]),l("td",null,[e("A domain from "),l("a",{href:"https://app.mailgun.com/app/sending/domains",target:"_blank",rel:"noopener noreferrer"},"your Mailgun account")]),l("td",null,"\u2013")]),l("tr",null,[l("td",null,[l("code",null,"EMAIL_MAILGUN_HOST")]),l("td",null,"Allows you to specify a custom host."),l("td",null,[l("code",null,"api.mailgun.net")])])])],-1),mt=l("h3",{id:"sendgrid-(sendgrid)",tabindex:"-1"},[l("a",{class:"header-anchor",href:"#sendgrid-(sendgrid)"},"#"),e(" SendGrid ("),l("code",null,"sendgrid"),e(")")],-1),Et=l("table",null,[l("thead",null,[l("tr",null,[l("th",null,"Variable"),l("th",null,"Description"),l("th",null,"Default Value")])]),l("tbody",null,[l("tr",null,[l("td",null,[l("code",null,"EMAIL_SENDGRID_API_KEY")]),l("td",null,"Your SendGrid API key."),l("td",null,"\u2013")])])],-1),At=l("h3",{id:"aws-ses-(ses)",tabindex:"-1"},[l("a",{class:"header-anchor",href:"#aws-ses-(ses)"},"#"),e(" AWS SES ("),l("code",null,"ses"),e(")")],-1),Tt=l("table",null,[l("thead",null,[l("tr",null,[l("th",null,"Variable"),l("th",null,"Description"),l("th",null,"Default Value")])]),l("tbody",null,[l("tr",null,[l("td",null,[l("code",null,"EMAIL_SES_CREDENTIALS__ACCESS_KEY_ID")]),l("td",null,"Your AWS SES access key. ID."),l("td",null,"\u2013")]),l("tr",null,[l("td",null,[l("code",null,"EMAIL_SES_CREDENTIALS__SECRET_ACCESS_KEY")]),l("td",null,"Your AWS SES secret key."),l("td",null,"\u2013")]),l("tr",null,[l("td",null,[l("code",null,"EMAIL_SES_REGION")]),l("td",null,"Your AWS SES region."),l("td",null,"\u2013")])])],-1),gt=l("h2",{id:"admin-account",tabindex:"-1"},[l("a",{class:"header-anchor",href:"#admin-account"},"#"),e(" Admin Account")],-1),Rt=l("p",null,[e("If you\u2019re relying on Docker and/or the "),l("code",null,"directus bootstrap"),e(" CLI command, you can pass the following two environment variables to automatically configure the first user:")],-1),bt=l("table",null,[l("thead",null,[l("tr",null,[l("th",null,"Variable"),l("th",null,"Description"),l("th",null,"Default Value")])]),l("tbody",null,[l("tr",null,[l("td",null,[l("code",null,"ADMIN_EMAIL")]),l("td",null,[e("The email address of the first user that\u2019s automatically created when using "),l("code",null,"directus bootstrap"),e(".")]),l("td",null,"\u2013")]),l("tr",null,[l("td",null,[l("code",null,"ADMIN_PASSWORD")]),l("td",null,[e("The password of the first user that\u2019s automatically created when using "),l("code",null,"directus bootstrap"),e(".")]),l("td",null,"\u2013")])])],-1),St=l("h2",{id:"telemetry",tabindex:"-1"},[l("a",{class:"header-anchor",href:"#telemetry"},"#"),e(" Telemetry")],-1),It=l("p",null,"To more accurately gauge the frequency of installation, version fragmentation, and general size of the userbase, Directus collects little and anonymized data about your environment. You can easily opt-out with the following environment variable:",-1),Ot=l("table",null,[l("thead",null,[l("tr",null,[l("th",null,"Variable"),l("th",null,"Description"),l("th",null,"Default Value")])]),l("tbody",null,[l("tr",null,[l("td",null,[l("code",null,"TELEMETRY")]),l("td",null,"Allow Directus to collect anonymized data about your environment."),l("td",null,[l("code",null,"true")])])])],-1),Dt=l("h2",{id:"limits-%26-optimizations",tabindex:"-1"},[l("a",{class:"header-anchor",href:"#limits-%26-optimizations"},"#"),e(" Limits & Optimizations")],-1),yt=l("p",null,"Allows you to configure hard technical limits, to prevent abuse and optimize for your particular server environment.",-1),Lt=l("table",null,[l("thead",null,[l("tr",null,[l("th",null,"Variable"),l("th",null,"Description"),l("th",null,"Default Value")])]),l("tbody",null,[l("tr",null,[l("td",null,[l("code",null,"RELATIONAL_BATCH_SIZE")]),l("td",null,"How many rows are read into memory at a time when constructing nested relational datasets"),l("td",null,"25000")]),l("tr",null,[l("td",null,[l("code",null,"EXPORT_BATCH_SIZE")]),l("td",null,"How many rows are read into memory at a time when constructing exports"),l("td",null,"5000")])])],-1),Ut="Configuration Options",Pt=!1,Nt="Environment variables are used for all configuration within a Directus project. These variables can be defined in a number of ways, which we cover below.",xt="28 min read",Mt={__name:"config-options",setup(Ct,{expose:a}){const u={title:"Configuration Options",modularExtension:!1,description:"Environment variables are used for all configuration within a Directus project. These variables can be defined in a number of ways, which we cover below.",readTime:"28 min read"};return a({frontmatter:u}),(vt,Ht)=>{const t=s("router-link"),d=s("docs-wrapper");return r(),i(d,{frontmatter:u},{default:n(()=>[l("div",c,[h,_,p,f,m,E,A,T,g,R,b,S,I,O,D,y,L,C,v,H,w,U,P,N,x,M,V,j,k,B,G,F,W,q,K,Y,z,X,Z,J,Q,$,ll,el,nl,tl,l("table",null,[ol,l("tbody",null,[ul,sl,al,dl,rl,il,cl,hl,_l,l("tr",null,[pl,l("td",null,[e("List of URLs that can be used "),o(t,{to:"/docs/reference/authentication#request-password-reset"},{default:n(()=>[e("as "),fl,e(" in /password/request")]),_:1})]),ml]),l("tr",null,[El,l("td",null,[e("List of URLs that can be used "),o(t,{to:"/docs/reference/system/users#invite-a-new-user"},{default:n(()=>[e("as "),Al,e(" in /users/invite")]),_:1})]),Tl]),gl,Rl,bl,Sl,Il,Ol,Dl])]),yl,Ll,Cl,l("p",null,[e("Argon2\u2019s hashing function is used by Directus for three purposes: 1) hashing user passwords, 2) generating hashes for the "),vl,e(" field type in collections, and 3) the "),o(t,{to:"/docs/reference/system/utilities#generate-a-hash"},{default:n(()=>[e("generate a hash API endpoint")]),_:1}),e(".")]),Hl,wl,Ul,Pl,Nl,xl,Ml,Vl,jl,kl,Bl,Gl,Fl,Wl,ql,Kl,Yl,zl,Xl,Zl,Jl,Ql,$l,le,ee,ne,te,oe,ue,se,ae,de,re,ie,ce,he,_e,pe,fe,me,Ee,Ae,Te,ge,Re,be,Se,Ie,Oe,De,ye,Le,Ce,ve,He,we,Ue,Pe,Ne,xe,Me,Ve,je,ke,Be,Ge,Fe,We,qe,Ke,Ye,ze,Xe,Ze,Je,Qe,$e,l("p",null,[e("More example SSO configurations "),o(t,{to:"/docs/self-hosted/sso-examples"},{default:n(()=>[e("can be found here")]),_:1}),e(".")]),ln,en,l("table",null,[nn,l("tbody",null,[tn,on,un,sn,an,dn,rn,cn,hn,_n,pn,fn,l("tr",null,[mn,l("td",null,[e("SVG icon to display with the login link. "),o(t,{to:"/docs/getting-started/glossary#icons"},{default:n(()=>[e("See options here")]),_:1}),e(".")]),En]),An,Tn])]),gn,Rn,bn,l("table",null,[Sn,l("tbody",null,[In,On,Dn,yn,Ln,Cn,vn,Hn,l("tr",null,[wn,l("td",null,[e("SVG icon to display with the login link. "),o(t,{to:"/docs/getting-started/glossary#icons"},{default:n(()=>[e("See options here")]),_:1}),e(".")]),Un]),Pn,Nn])]),xn,Mn,Vn,jn,kn,Bn,Gn,Fn,Wn,qn,Kn,Yn,zn,Xn,Zn,Jn,Qn,$n,lt,et,nt,tt,ot,ut,st,at,dt,rt,it,ct,ht,_t,pt,ft,mt,Et,At,Tt,gt,Rt,bt,St,It,Ot,Dt,yt,Lt])]),_:1})}}};export{Mt as default,Nt as description,Pt as modularExtension,xt as readTime,Ut as title};
