import{a as o,o as r,e as h,y as n,u as s,q as t,z as l}from"./runtime-core.esm-bundler.22ec0346.js";const d={class:"markdown-body"},p=s("hr",null,null,-1),u=s("h2",{id:"the-collection-object",tabindex:"-1"},[s("a",{class:"header-anchor",href:"#the-collection-object"},"#"),t(" The Collection Object")],-1),_=s("p",null,[s("code",null,"collection"),t(),s("strong",null,"string"),s("br"),t(" Name of the collection. This matches the table name in the database.")],-1),m=s("h4",{id:"meta",tabindex:"-1"},[s("a",{class:"header-anchor",href:"#meta"},"#"),t(" Meta")],-1),j=s("p",null,"Directus metadata, primarily used in the Admin App.",-1),g=s("p",null,[s("code",null,"collection"),t(),s("strong",null,"string"),s("br"),t(" Name of the collection. This matches the table name in the database.")],-1),f=s("p",null,[s("code",null,"icon"),t(),s("strong",null,"string"),s("br"),t(" Icon displayed in the Admin App when working with this collection.")],-1),b=s("p",null,[s("code",null,"note"),t(),s("strong",null,"string"),s("br"),t(" Short description displayed in the Admin App.")],-1),y=s("p",null,[s("code",null,"display_template"),t(),s("strong",null,"string"),s("br"),t(" How items in this collection should be displayed when viewed relationally in the Admin App.")],-1),x=s("p",null,[s("code",null,"hidden"),t(),s("strong",null,"boolean"),s("br"),t(" Whether or not this collection is hidden in the Admin App.")],-1),q=s("p",null,[s("code",null,"singleton"),t(),s("strong",null,"boolean"),s("br"),t(" Whether or not this collection is treated as a singleton.")],-1),v=s("p",null,[s("code",null,"translations"),t(),s("strong",null,"array"),s("br"),t(" How this collection\u2019s name is displayed in the different languages in the Admin App.")],-1),w=s("p",null,[s("code",null,"archive_field"),t(),s("strong",null,"string"),s("br"),t(" What field in the collection holds the archived state.")],-1),T=s("p",null,[s("code",null,"archive_value"),t(),s("strong",null,"string"),s("br"),t(" What value the archive field should be set to when archiving an item.")],-1),A=s("p",null,[s("code",null,"unarchive_value"),t(),s("strong",null,"string"),s("br"),t(" What value the archive field should be set to when unarchiving an item.")],-1),k=s("p",null,[s("code",null,"archive_app_filter"),t(),s("strong",null,"boolean"),s("br"),t(" Whether or not the Admin App should allow the user to view archived items.")],-1),E=s("p",null,[s("code",null,"sort_field"),t(),s("strong",null,"boolean"),s("br"),t(" What field holds the sort value on the collection. The Admin App uses this to allow drag-and-drop manual sorting.")],-1),S=s("code",null,"accountability",-1),C=s("strong",null,"string",-1),P=s("br",null,null,-1),R=s("code",null,"all",-1),L=s("code",null,"activity",-1),Q=s("code",null,"item_duplication_fields",-1),W=s("strong",null,"array",-1),G=s("br",null,null,-1),O=s("code",null,"group",-1),D=s("strong",null,"string",-1),B=s("br",null,null,-1),I=s("code",null,"sort",-1),H=s("strong",null,"number",-1),N=s("br",null,null,-1),M=s("p",null,[s("code",null,"collapse"),t(),s("strong",null,"string"),s("br"),t(" What is the default behavior of this collection or \u201Cfolder\u201D collection when it has nested collections. One of "),s("code",null,"open"),t(", "),s("code",null,"closed"),t(", "),s("code",null,"locked"),t(".")],-1),U=s("h4",{id:"schema",tabindex:"-1"},[s("a",{class:"header-anchor",href:"#schema"},"#"),t(" Schema")],-1),V=s("p",null,"\u201CRaw\u201D database information. Based on the database vendor used, different information might be returned. The following are available for all drivers.",-1),Y=s("p",null,[s("code",null,"name"),t(),s("strong",null,"string"),s("br"),t(" The table name.")],-1),z=s("p",null,[s("code",null,"comment"),t(),s("strong",null,"string"),s("br"),t(" The table comment.")],-1),F={class:"tip hint"},J=s("code",null,"null",-1),K=s("pre",null,[s("code",{class:"language-json"},[s("span",{class:"hljs-punctuation"},"{"),t(`
	`),s("span",{class:"hljs-attr"},'"collection"'),s("span",{class:"hljs-punctuation"},":"),t(),s("span",{class:"hljs-string"},'"articles"'),s("span",{class:"hljs-punctuation"},","),t(`
	`),s("span",{class:"hljs-attr"},'"meta"'),s("span",{class:"hljs-punctuation"},":"),t(),s("span",{class:"hljs-punctuation"},"{"),t(`
		`),s("span",{class:"hljs-attr"},'"collection"'),s("span",{class:"hljs-punctuation"},":"),t(),s("span",{class:"hljs-string"},'"articles"'),s("span",{class:"hljs-punctuation"},","),t(`
		`),s("span",{class:"hljs-attr"},'"icon"'),s("span",{class:"hljs-punctuation"},":"),t(),s("span",{class:"hljs-string"},'"article"'),s("span",{class:"hljs-punctuation"},","),t(`
		`),s("span",{class:"hljs-attr"},'"note"'),s("span",{class:"hljs-punctuation"},":"),t(),s("span",{class:"hljs-string"},'"Blog posts"'),s("span",{class:"hljs-punctuation"},","),t(`
		`),s("span",{class:"hljs-attr"},'"display_template"'),s("span",{class:"hljs-punctuation"},":"),t(),s("span",{class:"hljs-string"},'"{{ title }}"'),s("span",{class:"hljs-punctuation"},","),t(`
		`),s("span",{class:"hljs-attr"},'"hidden"'),s("span",{class:"hljs-punctuation"},":"),t(),s("span",{class:"hljs-literal"},[s("span",{class:"hljs-keyword"},"false")]),s("span",{class:"hljs-punctuation"},","),t(`
		`),s("span",{class:"hljs-attr"},'"singleton"'),s("span",{class:"hljs-punctuation"},":"),t(),s("span",{class:"hljs-literal"},[s("span",{class:"hljs-keyword"},"false")]),s("span",{class:"hljs-punctuation"},","),t(`
		`),s("span",{class:"hljs-attr"},'"translations"'),s("span",{class:"hljs-punctuation"},":"),t(),s("span",{class:"hljs-punctuation"},"["),t(`
			`),s("span",{class:"hljs-punctuation"},"{"),t(`
				`),s("span",{class:"hljs-attr"},'"language"'),s("span",{class:"hljs-punctuation"},":"),t(),s("span",{class:"hljs-string"},'"en-US"'),s("span",{class:"hljs-punctuation"},","),t(`
				`),s("span",{class:"hljs-attr"},'"translation"'),s("span",{class:"hljs-punctuation"},":"),t(),s("span",{class:"hljs-string"},'"Articles"'),t(`
			`),s("span",{class:"hljs-punctuation"},"}"),s("span",{class:"hljs-punctuation"},","),t(`
			`),s("span",{class:"hljs-punctuation"},"{"),t(`
				`),s("span",{class:"hljs-attr"},'"language"'),s("span",{class:"hljs-punctuation"},":"),t(),s("span",{class:"hljs-string"},'"nl-NL"'),s("span",{class:"hljs-punctuation"},","),t(`
				`),s("span",{class:"hljs-attr"},'"translation"'),s("span",{class:"hljs-punctuation"},":"),t(),s("span",{class:"hljs-string"},'"Artikelen"'),t(`
			`),s("span",{class:"hljs-punctuation"},"}"),t(`
		`),s("span",{class:"hljs-punctuation"},"]"),s("span",{class:"hljs-punctuation"},","),t(`
		`),s("span",{class:"hljs-attr"},'"archive_field"'),s("span",{class:"hljs-punctuation"},":"),t(),s("span",{class:"hljs-string"},'"status"'),s("span",{class:"hljs-punctuation"},","),t(`
		`),s("span",{class:"hljs-attr"},'"archive_value"'),s("span",{class:"hljs-punctuation"},":"),t(),s("span",{class:"hljs-string"},'"archived"'),s("span",{class:"hljs-punctuation"},","),t(`
		`),s("span",{class:"hljs-attr"},'"unarchive_value"'),s("span",{class:"hljs-punctuation"},":"),t(),s("span",{class:"hljs-string"},'"draft"'),s("span",{class:"hljs-punctuation"},","),t(`
		`),s("span",{class:"hljs-attr"},'"archive_app_filter"'),s("span",{class:"hljs-punctuation"},":"),t(),s("span",{class:"hljs-literal"},[s("span",{class:"hljs-keyword"},"true")]),s("span",{class:"hljs-punctuation"},","),t(`
		`),s("span",{class:"hljs-attr"},'"sort_field"'),s("span",{class:"hljs-punctuation"},":"),t(),s("span",{class:"hljs-string"},'"sort"'),s("span",{class:"hljs-punctuation"},","),t(`
		`),s("span",{class:"hljs-attr"},'"item_duplication_fields"'),s("span",{class:"hljs-punctuation"},":"),t(),s("span",{class:"hljs-literal"},[s("span",{class:"hljs-keyword"},"null")]),s("span",{class:"hljs-punctuation"},","),t(`
		`),s("span",{class:"hljs-attr"},'"sort"'),s("span",{class:"hljs-punctuation"},":"),t(),s("span",{class:"hljs-number"},"1"),t(`
	`),s("span",{class:"hljs-punctuation"},"}"),s("span",{class:"hljs-punctuation"},","),t(`
	`),s("span",{class:"hljs-attr"},'"schema"'),s("span",{class:"hljs-punctuation"},":"),t(),s("span",{class:"hljs-punctuation"},"{"),t(`
		`),s("span",{class:"hljs-attr"},'"name"'),s("span",{class:"hljs-punctuation"},":"),t(),s("span",{class:"hljs-string"},'"pages"'),s("span",{class:"hljs-punctuation"},","),t(`
		`),s("span",{class:"hljs-attr"},'"comment"'),s("span",{class:"hljs-punctuation"},":"),t(),s("span",{class:"hljs-literal"},[s("span",{class:"hljs-keyword"},"null")]),t(`
	`),s("span",{class:"hljs-punctuation"},"}"),t(`
`),s("span",{class:"hljs-punctuation"},"}"),t(`
`)])],-1),X=s("hr",null,null,-1),Z=s("h2",{id:"list-collections",tabindex:"-1"},[s("a",{class:"header-anchor",href:"#list-collections"},"#"),t(" List Collections")],-1),$=s("p",null,"List the available collections.",-1),ss=s("h3",{id:"query-parameters",tabindex:"-1"},[s("a",{class:"header-anchor",href:"#query-parameters"},"#"),t(" Query Parameters")],-1),ts=s("p",null,"This endpoint doesn\u2019t currently support any query parameters.",-1),ns=s("h3",{id:"returns",tabindex:"-1"},[s("a",{class:"header-anchor",href:"#returns"},"#"),t(" Returns")],-1),es=s("p",null,[t("An array of "),s("a",{href:"#the-collection-object"},"collection objects"),t(".")],-1),ls=s("h3",{id:"rest-api",tabindex:"-1"},[s("a",{class:"header-anchor",href:"#rest-api"},"#"),t(" REST API")],-1),as=s("pre",null,[s("code",null,`GET /collections
SEARCH /collections
`)],-1),os=s("h3",{id:"graphql",tabindex:"-1"},[s("a",{class:"header-anchor",href:"#graphql"},"#"),t(" GraphQL")],-1),cs=s("pre",null,[s("code",null,`POST /graphql/system
`)],-1),is=s("pre",null,[s("code",{class:"language-graphql"},[s("span",{class:"hljs-keyword"},"type"),s("span",{class:"hljs-type"}," Query"),t(` {
	collections: [directus_collections]
}
`)])],-1),rs=s("h5",{id:"example",tabindex:"-1"},[s("a",{class:"header-anchor",href:"#example"},"#"),t(" Example")],-1),hs=s("pre",null,[s("code",{class:"language-graphql"},[s("span",{class:"hljs-keyword"},"query"),t(` {
	collections {
		`),s("span",{class:"hljs-keyword"},"..."),t(`
	}
}
`)])],-1),ds=s("hr",null,null,-1),ps=s("h2",{id:"retrieve-a-collection",tabindex:"-1"},[s("a",{class:"header-anchor",href:"#retrieve-a-collection"},"#"),t(" Retrieve a Collection")],-1),us=s("p",null,"Retrieve a single collection by table name.",-1),_s=s("h3",{id:"query-parameters-1",tabindex:"-1"},[s("a",{class:"header-anchor",href:"#query-parameters-1"},"#"),t(" Query Parameters")],-1),ms=s("p",null,"This endpoint doesn\u2019t currently support any query parameters.",-1),js=s("h3",{id:"returns-1",tabindex:"-1"},[s("a",{class:"header-anchor",href:"#returns-1"},"#"),t(" Returns")],-1),gs=s("p",null,[t("A "),s("a",{href:"#the-collection-object"},"collection object"),t(".")],-1),fs=s("h3",{id:"rest-api-1",tabindex:"-1"},[s("a",{class:"header-anchor",href:"#rest-api-1"},"#"),t(" REST API")],-1),bs=s("pre",null,[s("code",null,`GET /collections/:collection
`)],-1),ys=s("h5",{id:"example-1",tabindex:"-1"},[s("a",{class:"header-anchor",href:"#example-1"},"#"),t(" Example")],-1),xs=s("pre",null,[s("code",null,`GET /collections/articles
`)],-1),qs=s("h3",{id:"graphql-1",tabindex:"-1"},[s("a",{class:"header-anchor",href:"#graphql-1"},"#"),t(" GraphQL")],-1),vs=s("pre",null,[s("code",null,`POST /graphql/system
`)],-1),ws=s("pre",null,[s("code",{class:"language-graphql"},[s("span",{class:"hljs-keyword"},"type"),s("span",{class:"hljs-type"}," Query"),t(` {
	collections_by_name(name:`),s("span",{class:"hljs-type"}," String"),t(`!): directus_collections
}
`)])],-1),Ts=s("h5",{id:"example-2",tabindex:"-1"},[s("a",{class:"header-anchor",href:"#example-2"},"#"),t(" Example")],-1),As=s("pre",null,[s("code",{class:"language-graphql"},[s("span",{class:"hljs-keyword"},"query"),t(` {
	collections_by_name(name: `),s("span",{class:"hljs-string"},'"articles"'),t(`) {
		`),s("span",{class:"hljs-keyword"},"..."),t(`
	}
}
`)])],-1),ks=s("hr",null,null,-1),Es=s("h2",{id:"create-a-collection",tabindex:"-1"},[s("a",{class:"header-anchor",href:"#create-a-collection"},"#"),t(" Create a Collection")],-1),Ss=s("p",null,"Create a new Collection. This will create a new table in the database as well.",-1),Cs=s("h3",{id:"query-parameters-2",tabindex:"-1"},[s("a",{class:"header-anchor",href:"#query-parameters-2"},"#"),t(" Query Parameters")],-1),Ps=s("p",null,"This endpoint doesn\u2019t currently support any query parameters.",-1),Rs=s("h3",{id:"request-body",tabindex:"-1"},[s("a",{class:"header-anchor",href:"#request-body"},"#"),t(" Request Body")],-1),Ls=s("p",null,[t("The "),s("code",null,"collection"),t(" property is required, all other properties of the "),s("a",{href:"#the-collection-object"},"collection object"),t(" are optional.")],-1),Qs=s("code",null,"fields",-1),Ws=s("h3",{id:"returns-2",tabindex:"-1"},[s("a",{class:"header-anchor",href:"#returns-2"},"#"),t(" Returns")],-1),Gs=s("p",null,[t("The "),s("a",{href:"#the-collection-object"},"collection object"),t(" for the collection created in this request.")],-1),Os={class:"tip hint"},Ds=s("code",null,"schema: {}",-1),Bs=s("code",null,"schema: null",-1),Is=s("h3",{id:"rest-api-2",tabindex:"-1"},[s("a",{class:"header-anchor",href:"#rest-api-2"},"#"),t(" REST API")],-1),Hs=s("pre",null,[s("code",null,`POST /collections
`)],-1),Ns=s("h5",{id:"example-3",tabindex:"-1"},[s("a",{class:"header-anchor",href:"#example-3"},"#"),t(" Example")],-1),Ms=s("pre",null,[s("code",{class:"language-json"},[s("span",{class:"hljs-comment"},"// POST /collections"),t(`

`),s("span",{class:"hljs-punctuation"},"{"),t(`
	`),s("span",{class:"hljs-attr"},'"collection"'),s("span",{class:"hljs-punctuation"},":"),t(),s("span",{class:"hljs-string"},'"testimonials"'),s("span",{class:"hljs-punctuation"},","),t(`
	`),s("span",{class:"hljs-attr"},'"meta"'),s("span",{class:"hljs-punctuation"},":"),t(),s("span",{class:"hljs-punctuation"},"{"),t(`
		`),s("span",{class:"hljs-attr"},'"icon"'),s("span",{class:"hljs-punctuation"},":"),t(),s("span",{class:"hljs-string"},'"format_quote"'),t(`
	`),s("span",{class:"hljs-punctuation"},"}"),t(`
`),s("span",{class:"hljs-punctuation"},"}"),t(`
`)])],-1),Us=s("h3",{id:"graphql-2",tabindex:"-1"},[s("a",{class:"header-anchor",href:"#graphql-2"},"#"),t(" GraphQL")],-1),Vs=s("pre",null,[s("code",null,`POST /graphql/system
`)],-1),Ys=s("pre",null,[s("code",{class:"language-graphql"},[s("span",{class:"hljs-keyword"},"type"),s("span",{class:"hljs-type"}," Mutation"),t(` {
	create_collections_item(data: directus_collections): directus_collections
}
`)])],-1),zs=s("h5",{id:"example-4",tabindex:"-1"},[s("a",{class:"header-anchor",href:"#example-4"},"#"),t(" Example")],-1),Fs=s("pre",null,[s("code",{class:"language-graphql"},[s("span",{class:"hljs-keyword"},"mutation"),t(` {
	create_collections_item(data: {
		collection: `),s("span",{class:"hljs-string"},'"testimonials"'),t(`,
		meta: {
			icon: `),s("span",{class:"hljs-string"},'"format_quote"'),t(`
		}
	}) {
		`),s("span",{class:"hljs-keyword"},"..."),t(`
	}
}
`)])],-1),Js=s("hr",null,null,-1),Ks=s("h2",{id:"update-a-collection",tabindex:"-1"},[s("a",{class:"header-anchor",href:"#update-a-collection"},"#"),t(" Update a Collection")],-1),Xs=s("p",null,"Update the metadata for an existing collection.",-1),Zs=s("h3",{id:"query-parameters-3",tabindex:"-1"},[s("a",{class:"header-anchor",href:"#query-parameters-3"},"#"),t(" Query Parameters")],-1),$s=s("p",null,"This endpoint doesn\u2019t currently support any query parameters.",-1),st=s("h3",{id:"request-body-1",tabindex:"-1"},[s("a",{class:"header-anchor",href:"#request-body-1"},"#"),t(" Request Body")],-1),tt=s("p",null,[t("You can only update the "),s("code",null,"meta"),t(" values of the "),s("a",{href:"#the-collection-object"},"collection object"),t(". Updating the collection name is not supported at this time.")],-1),nt=s("h3",{id:"returns-3",tabindex:"-1"},[s("a",{class:"header-anchor",href:"#returns-3"},"#"),t(" Returns")],-1),et=s("p",null,[t("The "),s("a",{href:"#the-collection-object"},"collection object"),t(" for the updated collection in this request.")],-1),lt=s("h3",{id:"rest-api-3",tabindex:"-1"},[s("a",{class:"header-anchor",href:"#rest-api-3"},"#"),t(" REST API")],-1),at=s("pre",null,[s("code",null,`PATCH /collections/:collection
`)],-1),ot=s("h5",{id:"example-5",tabindex:"-1"},[s("a",{class:"header-anchor",href:"#example-5"},"#"),t(" Example")],-1),ct=s("pre",null,[s("code",{class:"language-json"},[s("span",{class:"hljs-comment"},"// PATCH /collections/testimonials"),t(`

`),s("span",{class:"hljs-punctuation"},"{"),t(`
	`),s("span",{class:"hljs-attr"},'"meta"'),s("span",{class:"hljs-punctuation"},":"),t(),s("span",{class:"hljs-punctuation"},"{"),t(`
		`),s("span",{class:"hljs-attr"},'"note"'),s("span",{class:"hljs-punctuation"},":"),t(),s("span",{class:"hljs-string"},'"Short quotes from happy customers."'),t(`
	`),s("span",{class:"hljs-punctuation"},"}"),t(`
`),s("span",{class:"hljs-punctuation"},"}"),t(`
`)])],-1),it=s("h3",{id:"graphql-3",tabindex:"-1"},[s("a",{class:"header-anchor",href:"#graphql-3"},"#"),t(" GraphQL")],-1),rt=s("pre",null,[s("code",null,`POST /graphql/system
`)],-1),ht=s("pre",null,[s("code",{class:"language-graphql"},[s("span",{class:"hljs-keyword"},"type"),s("span",{class:"hljs-type"}," Mutation"),t(` {
	update_collections_item(collection:`),s("span",{class:"hljs-type"}," String"),t(`!, data: update_directus_collections_input!): directus_collections
}
`)])],-1),dt=s("h5",{id:"example-6",tabindex:"-1"},[s("a",{class:"header-anchor",href:"#example-6"},"#"),t(" Example")],-1),pt=s("pre",null,[s("code",{class:"language-graphql"},[s("span",{class:"hljs-keyword"},"mutation"),t(` {
	update_collections_item(collection: `),s("span",{class:"hljs-string"},'"testimonials"'),t(", data: { meta: { note: "),s("span",{class:"hljs-string"},'"Short quotes from happy customers."'),t(` } }) {
		collection
	}
}
`)])],-1),ut=s("hr",null,null,-1),_t=s("h2",{id:"delete-a-collection",tabindex:"-1"},[s("a",{class:"header-anchor",href:"#delete-a-collection"},"#"),t(" Delete a Collection")],-1),mt=s("p",null,"Delete a collection.",-1),jt=s("div",{class:"danger hint"},[s("div",{class:"hint-title"},"Destructive"),s("p",null,"Be aware, this will delete the table from the database, including all items in it. This action can\u2019t be undone.")],-1),gt=s("h3",{id:"rest-api-4",tabindex:"-1"},[s("a",{class:"header-anchor",href:"#rest-api-4"},"#"),t(" REST API")],-1),ft=s("pre",null,[s("code",null,`DELETE /collections/:collection
`)],-1),bt=s("h5",{id:"example-7",tabindex:"-1"},[s("a",{class:"header-anchor",href:"#example-7"},"#"),t(" Example")],-1),yt=s("pre",null,[s("code",null,`DELETE /collections/articles
`)],-1),xt=s("h3",{id:"graphql-4",tabindex:"-1"},[s("a",{class:"header-anchor",href:"#graphql-4"},"#"),t(" GraphQL")],-1),qt=s("pre",null,[s("code",null,`POST /graphql/system
`)],-1),vt=s("pre",null,[s("code",{class:"language-graphql"},[s("span",{class:"hljs-keyword"},"type"),s("span",{class:"hljs-type"}," Mutation"),t(` {
	delete_collections_item(collection:`),s("span",{class:"hljs-type"}," String"),t(`!): delete_collection
}
`)])],-1),wt=s("h5",{id:"example-8",tabindex:"-1"},[s("a",{class:"header-anchor",href:"#example-8"},"#"),t(" Example")],-1),Tt=s("pre",null,[s("code",{class:"language-graphql"},[s("span",{class:"hljs-keyword"},"mutation"),t(` {
	delete_collections_item(collection: `),s("span",{class:"hljs-string"},'"articles"'),t(`) {
		collection
	}
}
`)])],-1),At=s("hr",null,null,-1),Pt="Collections",Rt=!1,Lt='REST and GraphQL API documentation on the "Collections" collection in Directus.',Qt="5 min read",Wt="page-reference",Gt={__name:"collections",setup(kt,{expose:c}){const a={title:"Collections",modularExtension:!1,description:'REST and GraphQL API documentation on the "Collections" collection in Directus.',readTime:"5 min read",pageClass:"page-reference"};return c({frontmatter:a}),(Et,St)=>{const e=o("router-link"),i=o("docs-wrapper");return r(),h(i,{frontmatter:a},{default:n(()=>[s("div",d,[s("blockquote",null,[s("p",null,[t("Collections are the individual collections of items, similar to tables in a database. Changes to collections will alter the schema of the database. "),l(e,{to:"/docs/getting-started/glossary#collections"},{default:n(()=>[t("Learn more about Collections")]),_:1}),t(".")])]),p,u,_,m,j,g,f,b,y,x,q,v,w,T,A,k,E,s("p",null,[S,t(),C,P,t(" What data is tracked. One of "),R,t(", "),L,t(". See "),l(e,{to:"/docs/configuration/data-model#accountability"},{default:n(()=>[t("Accountability")]),_:1}),t(" for more information.")]),s("p",null,[Q,t(),W,G,t(" What fields are duplicated during \u201CSave as copy\u201D action of an item in this collection. See "),l(e,{to:"/docs/configuration/data-model#duplication"},{default:n(()=>[t("Duplication")]),_:1}),t(" for more information.")]),s("p",null,[O,t(),D,B,t(" The name of the parent collection. This is used in "),l(e,{to:"/docs/configuration/data-model#sorting-grouping"},{default:n(()=>[t("grouping/nesting of collections")]),_:1}),t(".")]),s("p",null,[I,t(),H,N,t(" What sort order of the collection relative to other collections of the same level. This is used in "),l(e,{to:"/docs/configuration/data-model#sorting-grouping"},{default:n(()=>[t("sorting of collections")]),_:1}),t(".")]),M,U,V,Y,z,s("div",F,[s("p",null,[l(e,{to:"/docs/configuration/data-model#sorting-grouping"},{default:n(()=>[t("\u201Cfolder\u201D collections do not hold any data")]),_:1}),t(", hence their schema would be "),J,t(".")])]),K,X,Z,$,ss,ts,ns,es,ls,as,s("p",null,[l(e,{to:"/docs/reference/introduction#search-http-method"},{default:n(()=>[t("Learn more about SEARCH ->")]),_:1})]),os,cs,is,rs,hs,ds,ps,us,_s,ms,js,gs,fs,bs,ys,xs,qs,vs,ws,Ts,As,ks,Es,Ss,Cs,Ps,Rs,Ls,s("p",null,[t("You are able to provide an array of "),Qs,t(" to be created during the creation of the collection. See the "),l(e,{to:"/docs/reference/system/fields#the-fields-object"},{default:n(()=>[t("fields object")]),_:1}),t(" for more information on what properties are available in a field.")]),Ws,Gs,s("div",Os,[s("p",null,[t("Make sure to pass an empty object for schema ("),Ds,t(") when creating collections. Alternatively, you can omit it entirely or use "),Bs,t(" to create "),l(e,{to:"/docs/configuration/data-model#sorting-grouping"},{default:n(()=>[t("\u201Cfolder\u201D collections")]),_:1}),t(".")])]),Is,Hs,Ns,Ms,Us,Vs,Ys,zs,Fs,Js,Ks,Xs,Zs,$s,st,tt,nt,et,lt,at,ot,ct,it,rt,ht,dt,pt,ut,_t,mt,jt,gt,ft,bt,yt,xt,qt,vt,wt,Tt,At])]),_:1})}}};export{Gt as default,Lt as description,Rt as modularExtension,Wt as pageClass,Qt as readTime,Pt as title};
