import{a as i,o as r,e as d,y as n,u as e,q as t,z as s}from"./runtime-core.esm-bundler.22ec0346.js";const h={class:"markdown-body"},u=e("blockquote",null,[e("p",null,"Directus has two command line interfaces (CLI) that you can use for various actions. One is used for server-side actions that relate to your on-prem instance, like migrating the database or resetting a user, while the other allows you to interact with a Directus instance as you would with an SDK.")],-1),p=e("h2",{id:"server",tabindex:"-1"},[e("a",{class:"header-anchor",href:"#server"},"#"),t(" Server")],-1),m=e("p",null,[t("For server-side CLI, all functionality can be accessed by running "),e("code",null,"npx directus <command>"),t(" in your project folder.")],-1),_=e("h3",{id:"initialize-a-new-project",tabindex:"-1"},[e("a",{class:"header-anchor",href:"#initialize-a-new-project"},"#"),t(" Initialize a New Project")],-1),g=e("pre",null,[e("code",{class:"language-bash"},`npx directus init
`)],-1),f=e("p",null,[t("Will install the required database driver, and create a "),e("code",null,".env"),t(" file based on the inputted values.")],-1),y=e("h3",{id:"bootstrap-a-project",tabindex:"-1"},[e("a",{class:"header-anchor",href:"#bootstrap-a-project"},"#"),t(" Bootstrap a Project")],-1),b=e("pre",null,[e("code",{class:"language-bash"},`npx directus bootstrap
`)],-1),w=e("p",null,[t("Will use an existing "),e("code",null,".env"),t(" file (or existing environment variables) to either install the database (if it\u2019s empty) or migrate it to the latest version (if it already exists and has missing migrations).")],-1),x={class:"tip hint"},v=e("div",{class:"hint-title"},"First User",-1),T=e("code",null,"ADMIN_EMAIL",-1),k=e("code",null,"ADMIN_PASSWORD",-1),j=e("code",null,"bootstrap",-1),D=e("div",{class:"tip hint"},[e("div",{class:"hint-title"},"Skip Admin User/Role"),e("p",null,[t("You can pass the "),e("code",null,"--skipAdminInit"),t(" option to "),e("code",null,"bootstrap"),t(", if you\u2019re creating your Admin role/user in another way (with a custom migration or an external service, for example).")])],-1),I=e("h3",{id:"install-the-database",tabindex:"-1"},[e("a",{class:"header-anchor",href:"#install-the-database"},"#"),t(" Install the Database")],-1),C=e("pre",null,[e("code",{class:"language-bash"},`npx directus database install
`)],-1),L=e("p",null,[t("Installs the initial Directus system tables on an empty database. Used internally by "),e("code",null,"bootstrap"),t(".")],-1),S=e("p",null,[t("It should be used only in specific cases, e.g. when you want to run something between "),e("code",null,"install"),t(" and "),e("code",null,"migrate"),t(". You probably should call "),e("code",null,"directus database migrate:latest"),t(" afterwards manually.")],-1),Y=e("p",null,[t("You may want to use "),e("code",null,"directus bootstrap"),t(" instead.")],-1),A=e("h3",{id:"upgrade-the-database",tabindex:"-1"},[e("a",{class:"header-anchor",href:"#upgrade-the-database"},"#"),t(" Upgrade the Database")],-1),M=e("pre",null,[e("code",{class:"language-bash"},`npx directus database migrate:latest
npx directus database migrate:up
npx directus database migrate:down
`)],-1),q=e("p",null,[t("Migrate the database up/down to match the versions of Directus. Once you update Directus itself, make sure to run "),e("code",null,"npx directus database migrate:latest"),t(" (or "),e("code",null,"npx directus bootstrap"),t(") to update your database.")],-1),N=e("h3",{id:"migrate-schema-to-a-different-environment",tabindex:"-1"},[e("a",{class:"header-anchor",href:"#migrate-schema-to-a-different-environment"},"#"),t(" Migrate Schema to a different Environment")],-1),B=e("p",null,"This allows you to do things like migrate a schema from development to production. To move your configured data model between Directus instances, you can use the schema \u201Csnapshot\u201D and \u201Capply\u201D commands.",-1),U=e("h4",{id:"snapshot-the-data-model",tabindex:"-1"},[e("a",{class:"header-anchor",href:"#snapshot-the-data-model"},"#"),t(" Snapshot the Data Model")],-1),O=e("p",null,"Directus can automatically generate a snapshot of your current data model in YAML or JSON format. This includes all collections, fields, and relations, and their configuration. This snapshot can be checked in version control and shared with your team. To generate the snapshot, run",-1),F=e("pre",null,[e("code",{class:"language-bash"},`npx directus schema snapshot ./snapshot.yaml
`)],-1),E=e("p",null,"To run non-interactively (e.g. when running in a CI/CD workflow), run",-1),P=e("pre",null,[e("code",{class:"language-bash"},[t("npx directus schema snapshot --"),e("span",{class:"hljs-built_in"},"yes"),t(` ./snapshot.yaml
`)])],-1),W=e("p",null,"Note, that this will force overwrite existing snapshot files.",-1),z=e("div",{class:"tip hint"},[e("div",{class:"hint-title"},"Date-based snapshots"),e("p",null,[t("To keep multiple snapshot organized by date, create a folder "),e("code",null,"snapshots"),t(" in your project root directory add the following custom script to your "),e("code",null,"package.json"),t(":")]),e("pre",null,[e("code",{class:"language-bash"},[e("span",{class:"hljs-string"},'"create-snapshot"'),t(": "),e("span",{class:"hljs-string"},[t('"npx directus schema snapshot ./snapshots/\\"'),e("span",{class:"hljs-subst"},'$(date \\"+%F\\")'),t('\\"-snapshot-\\"'),e("span",{class:"hljs-subst"},'$(date \\"+%s\\")'),t('\\".yaml"')]),t(`
`)])]),e("p",null,[t("When you run the command via "),e("code",null,"npm run create-snapshot"),t(" it will create a new snapshot with the following naming schema: "),e("code",null,"[YYYY-MM-DD]-snapshot-[timestamp].yaml"),t(". This command can be run e.g by your deployment pipeline before each deploy on your server to keep a schema backup.")])],-1),K=e("h4",{id:"applying-a-snapshot",tabindex:"-1"},[e("a",{class:"header-anchor",href:"#applying-a-snapshot"},"#"),t(" Applying a Snapshot")],-1),V=e("p",null,"To make a different instance up to date with the latest changes in your data model, you can apply the snapshot. By applying the snapshot, Directus will auto-detect the changes required to make the current instance up to date with the proposed data model in the snapshot file, and will run the required migrations to the database to make it match the snapshot.",-1),J=e("p",null,"To apply the generated snapshot, run",-1),R=e("pre",null,[e("code",{class:"language-bash"},`npx directus schema apply ./path/to/snapshot.yaml
`)],-1),$=e("p",null,"To run non-interactively (e.g. when running in a CI/CD workflow), run",-1),G=e("pre",null,[e("code",{class:"language-bash"},[t("npx directus schema apply --"),e("span",{class:"hljs-built_in"},"yes"),t(` ./path/to/snapshot.yaml
`)])],-1),H=e("p",null,"To diff the schema and database and print out the planned changes, run",-1),Q=e("pre",null,[e("code",{class:"language-bash"},`npx directus schema apply --dry-run ./path/to/snapshot.yaml
`)],-1),X=e("h3",{id:"creating-users",tabindex:"-1"},[e("a",{class:"header-anchor",href:"#creating-users"},"#"),t(" Creating Users")],-1),Z=e("p",null,"To create a new user with a specific role, run",-1),ee=e("pre",null,[e("code",{class:"language-bash"},[t("npx directus "),e("span",{class:"hljs-built_in"},"users"),t(` create --email <user-email> --password <password> --role <role-uuid>
`)])],-1),te=e("h4",{id:"updating-user-password",tabindex:"-1"},[e("a",{class:"header-anchor",href:"#updating-user-password"},"#"),t(" Updating User Password")],-1),ne=e("p",null,"To update the password of an existing user, run",-1),ae=e("pre",null,[e("code",{class:"language-bash"},[t("npx directus "),e("span",{class:"hljs-built_in"},"users"),t(` passwd --email <user-email> --password <new-password>
`)])],-1),se=e("h3",{id:"creating-roles",tabindex:"-1"},[e("a",{class:"header-anchor",href:"#creating-roles"},"#"),t(" Creating Roles")],-1),oe=e("p",null,"To create a new role, run",-1),ie=e("pre",null,[e("code",{class:"language-bash"},`npx directus roles create --role <role-name>
`)],-1),le=e("p",null,[t("To create a new role with admin access, set the "),e("code",null,"--admin"),t(" flag to "),e("code",null,"true"),t(", such as")],-1),ce=e("pre",null,[e("code",{class:"language-bash"},[t("npx directus roles create --role <role-name> --admin "),e("span",{class:"hljs-literal"},"true"),t(`
`)])],-1),re=e("h3",{id:"count-items-in-a-collection",tabindex:"-1"},[e("a",{class:"header-anchor",href:"#count-items-in-a-collection"},"#"),t(" Count Items in a Collection")],-1),de=e("p",null,"To count the amount of items in a given collection, run",-1),he=e("pre",null,[e("code",{class:"language-bash"},`npx directus count <collection-name>
`)],-1),ue=e("hr",null,null,-1),pe=e("h2",{id:"client",tabindex:"-1"},[e("a",{class:"header-anchor",href:"#client"},"#"),t(" Client")],-1),me=e("p",null,[t("For the client-side CLI, all functionality can be accessed by running "),e("code",null,"npx directusctl <command>"),t(". You can also install "),e("code",null,"@directus/cli"),t(" on your project dependencies or globally on your machine. Note that if you run "),e("code",null,"directusctl"),t(" (installed globally) in a folder containing a project that has a version of "),e("code",null,"@directus/cli"),t(" installed, the running global CLI will forward it\u2019s execution to the local installed version instead.")],-1),_e=e("h3",{id:"help-%26-documentation",tabindex:"-1"},[e("a",{class:"header-anchor",href:"#help-%26-documentation"},"#"),t(" Help & Documentation")],-1),ge=e("p",null,[t("The documentation for all commands can be accessed through the CLI itself. You can list all the available commands through "),e("code",null,"directusctl --help"),t(" command. If you want help for a specific command you can use "),e("code",null,"directusctl <command> --help"),t(" instead.")],-1),fe=e("h3",{id:"instances",tabindex:"-1"},[e("a",{class:"header-anchor",href:"#instances"},"#"),t(" Instances")],-1),ye=e("p",null,[t("Most client-side CLI commands needs a running Directus instance in order to work. To connect the CLI to an instance, you can use "),e("code",null,"directusctl instance connect"),t(" command. These instance\u2019s configs are going to be saved on "),e("code",null,"~/.directus"),t(" folder.")],-1),be=e("p",null,[t("To manage the connected instances, you can use "),e("code",null,"directusctl instance <command>"),t(" commands.")],-1),we=e("h4",{id:"selecting-instances",tabindex:"-1"},[e("a",{class:"header-anchor",href:"#selecting-instances"},"#"),t(" Selecting instances")],-1),xe=e("p",null,[t("By default, commands will try using an instance named "),e("code",null,"default"),t(" when executing commands.")],-1),ve=e("p",null,[t("If you want to change which instance you want to use, either pass "),e("code",null,"--instance <name>"),t(" to the command, or configure "),e("code",null,"instance"),t(" variable on your project\u2019s Directus config file.")],-1),Te=e("p",null,"For example:",-1),ke=e("blockquote",null,[e("p",null,".directus.yml")],-1),je=e("pre",null,[e("code",{class:"language-yaml"},[e("span",{class:"hljs-attr"},"instance:"),t(),e("span",{class:"hljs-string"},"my-project"),t(`
`)])],-1),De=e("h3",{id:"i%2Fo",tabindex:"-1"},[e("a",{class:"header-anchor",href:"#i%2Fo"},"#"),t(" I/O")],-1),Ie=e("p",null,[t("The CLI is designed with ease of use and automation in mind, this means that you can change the way the output is made by setting how you want the data to be written to the terminal. We currently support three formats, "),e("code",null,"table"),t(" (the default one), "),e("code",null,"json"),t(" and "),e("code",null,"yaml"),t(".")],-1),Ce=e("p",null,[t("This makes it easier to parse and use data from Directus with other tools like "),e("code",null,"jq"),t(", "),e("code",null,"yq"),t(", "),e("code",null,"grep"),t(" or any other tools that accepts data from "),e("code",null,"stdin")],-1),Le=e("p",null,[t("It\u2019s also worth mentioning that everything is data. Try for example running "),e("code",null,"directusctl --help --format=json"),t(".")],-1),Se=e("h4",{id:"table",tabindex:"-1"},[e("a",{class:"header-anchor",href:"#table"},"#"),t(" Table")],-1),Ye=e("p",null,"The default output format. This is the \u201Cpretty\u201D output, you\u2019ll most likely want to use this if you\u2019re not dealing with data in a way you need to pipe it to another command and/or store it for parsing.",-1),Ae=e("p",null,"This output will output colors and highlight content if it detects you\u2019re running in TTL.",-1),Me=e("h4",{id:"json",tabindex:"-1"},[e("a",{class:"header-anchor",href:"#json"},"#"),t(" JSON")],-1),qe=e("p",null,"This format will output JSON notation strings to your terminal. By default if TTY is detected, it will highlight (can be turned off with special flags) and prettify the output to make it easier to read.",-1),Ne=e("p",null,[t("Useful when you need to parse data using tools like "),e("code",null,"jq"),t(" for example.")],-1),Be=e("h4",{id:"yaml",tabindex:"-1"},[e("a",{class:"header-anchor",href:"#yaml"},"#"),t(" YAML")],-1),Ue=e("p",null,"This format will output YAML strings to your terminal. By default if TTY is detected, it will highlight (can be turned off with special flags) and prettify the output to make it easier to read.",-1),Oe=e("p",null,[t("Useful when you need to parse data using tools like "),e("code",null,"jq"),t(" for example.")],-1),ze="Command Line Interface",Ke=!1,Ve="Directus has two command line interfaces (CLI) that you can use for various actions, one for server-side actions and another to interact with a Directus instance as you would with an SDK",Je="7 min read",Re={__name:"cli",setup(Fe,{expose:l}){const o={title:"Command Line Interface",modularExtension:!1,description:"Directus has two command line interfaces (CLI) that you can use for various actions, one for server-side actions and another to interact with a Directus instance as you would with an SDK",readTime:"7 min read"};return l({frontmatter:o}),(Ee,Pe)=>{const a=i("router-link"),c=i("docs-wrapper");return r(),d(c,{frontmatter:o},{default:n(()=>[e("div",h,[u,p,m,_,g,f,y,b,w,e("p",null,[t("This is very useful to use in environments where you\u2019re doing standalone automatic deployments, like a multi-container Kubernetes configuration, or a similar approach on "),s(a,{to:"/docs/self-hosted/installation/digitalocean-app-platform"},{default:n(()=>[t("DigitalOcean App Platform")]),_:1}),t(", "),s(a,{to:"/docs/self-hosted/installation/gcp"},{default:n(()=>[t("Google Cloud Platform")]),_:1}),t(" or "),s(a,{to:"/docs/self-hosted/installation/aws"},{default:n(()=>[t("AWS Elastic Beanstalk")]),_:1})]),e("div",x,[v,e("p",null,[t("You can use the "),T,t(" and "),k,t(" environment variables to automatically provision the first user on first creation using the "),j,t(" command. See "),s(a,{to:"/docs/self-hosted/config-options#general"},{default:n(()=>[t("Environment Variables")]),_:1}),t(" for more information.")])]),D,I,C,L,S,Y,A,M,q,N,B,U,O,F,E,P,W,z,K,V,J,R,$,G,H,Q,X,Z,ee,te,ne,ae,se,oe,ie,e("p",null,[t("These roles are created with the "),s(a,{to:"/docs/configuration/users-roles-permissions#configure-system-permissions"},{default:n(()=>[t("minimum permissions required")]),_:1}),t(" to properly access the App by default.")]),le,ce,re,de,he,ue,pe,me,_e,ge,fe,ye,be,we,xe,ve,Te,ke,je,De,Ie,Ce,Le,Se,Ye,Ae,Me,qe,Ne,Be,Ue,Oe])]),_:1})}}};export{Re as default,Ve as description,Ke as modularExtension,Je as readTime,ze as title};
