import{a as l,o as h,e as c,y as t,u as s,q as e,z as o}from"./runtime-core.esm-bundler.22ec0346.js";const u={class:"markdown-body"},d=s("hr",null,null,-1),p=s("h2",{id:"access-tokens",tabindex:"-1"},[s("a",{class:"header-anchor",href:"#access-tokens"},"#"),e(" Access Tokens")],-1),_=s("p",null,"There are two types of tokens that can be used to authenticate within Directus.",-1),g=s("p",null,[s("strong",null,"Temporary Token (JWT)"),e(" are returned by the "),s("a",{href:"#login"},"login"),e(" endpoint/mutation. These tokens have a relatively short expiration time, and are thus the most secure option to use. The tokens are returned with a "),s("code",null,"refresh_token"),e(" that can be used to retrieve a new access token via the "),s("a",{href:"#refresh"},"refresh"),e(" endpoint/mutation.")],-1),f=s("p",null,[s("strong",null,"Static Tokens"),e(" can be set for each platform user, and never expire. They are less secure, but quite useful for server-to-server communication. They are saved as plain-text within "),s("code",null,"directus_users.token"),e(".")],-1),j=s("p",null,[e("Once you have your access token, there are two ways to pass it to the API, via the "),s("code",null,"access_token"),e(" query parameter, or in the request\u2019s Authorization Header.")],-1),b=s("h3",{id:"query-parameter",tabindex:"-1"},[s("a",{class:"header-anchor",href:"#query-parameter"},"#"),e(" Query Parameter")],-1),m=s("pre",null,[s("code",null,`?access_token=<token>
`)],-1),k=s("h3",{id:"authorization-header",tabindex:"-1"},[s("a",{class:"header-anchor",href:"#authorization-header"},"#"),e(" Authorization Header")],-1),w=s("pre",null,[s("code",null,`Authorization: Bearer <token>
`)],-1),y=s("hr",null,null,-1),q=s("h2",{id:"login",tabindex:"-1"},[s("a",{class:"header-anchor",href:"#login"},"#"),e(" Login")],-1),v=s("p",null,"Retrieve a temporary access token and refresh token.",-1),x=s("h3",{id:"request-body",tabindex:"-1"},[s("a",{class:"header-anchor",href:"#request-body"},"#"),e(" Request Body")],-1),T=s("p",null,[s("code",null,"email"),e(),s("strong",null,"Required"),s("br"),e(" Email address of the user you\u2019re retrieving the access token for.")],-1),P=s("p",null,[s("code",null,"password"),e(),s("strong",null,"Required"),s("br"),e(" Password of the user.")],-1),S=s("p",null,[s("code",null,"otp"),s("br"),e(" The user\u2019s one-time-password (if MFA is enabled).")],-1),R=s("p",null,[s("code",null,"mode"),s("br"),e(" Whether to retrieve the refresh token in the JSON response, or in a "),s("code",null,"httpOnly"),e(),s("code",null,"secure"),e(" cookie. One of "),s("code",null,"json"),e(", "),s("code",null,"cookie"),e(". Defaults to "),s("code",null,"json"),e(".")],-1),A=s("h3",{id:"response-attributes",tabindex:"-1"},[s("a",{class:"header-anchor",href:"#response-attributes"},"#"),e(" Response Attributes")],-1),O=s("p",null,[s("code",null,"access_token"),e(),s("strong",null,"string"),s("br"),e(" Temporary access token to be used in follow-up requests.")],-1),E=s("p",null,[s("code",null,"expires"),e(),s("strong",null,"integer"),s("br"),e(" How long before the access token will expire. Value is in milliseconds.")],-1),L=s("p",null,[s("code",null,"refresh_token"),e(),s("strong",null,"string"),s("br"),e(" The token that can be used to retrieve a new access token through "),s("a",{href:"#refresh"},[s("code",null,"/auth/refresh")]),e(". Note: if you used "),s("code",null,"cookie"),e(" as the mode in the request, the refresh token won\u2019t be returned in the JSON.")],-1),I={class:"tip hint"},B=s("div",{class:"hint-title"},"Expiry time",-1),N=s("code",null,"ACCESS_TOKEN_TTL",-1),G=s("h3",{id:"rest-api",tabindex:"-1"},[s("a",{class:"header-anchor",href:"#rest-api"},"#"),e(" REST API")],-1),C=s("pre",null,[s("code",null,`POST /auth/login
`)],-1),D=s("pre",null,[s("code",null,`POST /auth/login/:provider
`)],-1),J=s("pre",null,[s("code",{class:"language-json"},[s("span",{class:"hljs-punctuation"},"{"),e(`
	`),s("span",{class:"hljs-attr"},'"email"'),s("span",{class:"hljs-punctuation"},":"),e(),s("span",{class:"hljs-string"},'"admin@example.com"'),s("span",{class:"hljs-punctuation"},","),e(`
	`),s("span",{class:"hljs-attr"},'"password"'),s("span",{class:"hljs-punctuation"},":"),e(),s("span",{class:"hljs-string"},'"d1r3ct5us"'),e(`
`),s("span",{class:"hljs-punctuation"},"}"),e(`
`)])],-1),W=s("h3",{id:"graphql",tabindex:"-1"},[s("a",{class:"header-anchor",href:"#graphql"},"#"),e(" GraphQL")],-1),z=s("pre",null,[s("code",null,`POST /graphql/system
`)],-1),Q=s("pre",null,[s("code",{class:"language-graphql"},[s("span",{class:"hljs-keyword"},"mutation"),e(` {
	auth_login(email: `),s("span",{class:"hljs-string"},'"admin@example.com"'),e(", password: "),s("span",{class:"hljs-string"},'"d1r3ctu5"'),e(`) {
		access_token
		refresh_token
	}
}
`)])],-1),H=s("hr",null,null,-1),V=s("h2",{id:"refresh",tabindex:"-1"},[s("a",{class:"header-anchor",href:"#refresh"},"#"),e(" Refresh")],-1),U=s("p",null,"Retrieve a new access token using a refresh token.",-1),K=s("h3",{id:"request-body-1",tabindex:"-1"},[s("a",{class:"header-anchor",href:"#request-body-1"},"#"),e(" Request Body")],-1),F=s("p",null,[s("code",null,"refresh_token"),s("br"),e(" The refresh token to use. If you have the refresh token in a cookie through "),s("a",{href:"#login"},[s("code",null,"/auth/login")]),e(", you don\u2019t have to submit it here.")],-1),M=s("p",null,[s("code",null,"mode"),s("br"),e(" Whether to retrieve the refresh token in the JSON response, or in a "),s("code",null,"httpOnly"),e(),s("code",null,"secure"),e(" cookie. One of "),s("code",null,"json"),e(", "),s("code",null,"cookie"),e(".")],-1),Y=s("h3",{id:"response-attributes-1",tabindex:"-1"},[s("a",{class:"header-anchor",href:"#response-attributes-1"},"#"),e(" Response Attributes")],-1),X=s("p",null,[s("code",null,"access_token"),e(),s("strong",null,"string"),s("br"),e(" Temporary access token to be used in follow-up requests.")],-1),Z=s("p",null,[s("code",null,"expires"),e(),s("strong",null,"integer"),s("br"),e(" How long before the access token will expire. Value is in milliseconds.")],-1),$=s("p",null,[s("code",null,"refresh_token"),e(),s("strong",null,"string"),s("br"),e(" The token that can be used to retrieve a new access token through "),s("a",{href:"#refresh"},[s("code",null,"/auth/refresh")]),e(". Note: if you used "),s("code",null,"cookie"),e(" as the mode in the request, the refresh token won\u2019t be returned in the JSON.")],-1),ss=s("h3",{id:"rest-api-1",tabindex:"-1"},[s("a",{class:"header-anchor",href:"#rest-api-1"},"#"),e(" REST API")],-1),es=s("pre",null,[s("code",null,`POST /auth/refresh
`)],-1),ts=s("pre",null,[s("code",{class:"language-json"},[s("span",{class:"hljs-punctuation"},"{"),e(`
	`),s("span",{class:"hljs-attr"},'"refresh_token"'),s("span",{class:"hljs-punctuation"},":"),e(),s("span",{class:"hljs-string"},'"gmPd...8wuB"'),s("span",{class:"hljs-punctuation"},","),e(`
	`),s("span",{class:"hljs-attr"},'"mode"'),s("span",{class:"hljs-punctuation"},":"),e(),s("span",{class:"hljs-string"},'"json"'),e(`
`),s("span",{class:"hljs-punctuation"},"}"),e(`
`)])],-1),ns=s("h3",{id:"graphql-1",tabindex:"-1"},[s("a",{class:"header-anchor",href:"#graphql-1"},"#"),e(" GraphQL")],-1),os=s("pre",null,[s("code",null,`POST /graphql/system
`)],-1),as=s("pre",null,[s("code",{class:"language-graphql"},[s("span",{class:"hljs-keyword"},"mutation"),e(` {
	auth_refresh(refresh_token: `),s("span",{class:"hljs-string"},'"abc...def"'),e(`, mode: json) {
		access_token
		refresh_token
	}
}
`)])],-1),ls=s("hr",null,null,-1),rs=s("h2",{id:"logout",tabindex:"-1"},[s("a",{class:"header-anchor",href:"#logout"},"#"),e(" Logout")],-1),is=s("p",null,"Invalidate the refresh token thus destroying the user\u2019s session.",-1),hs=s("h3",{id:"request-body-2",tabindex:"-1"},[s("a",{class:"header-anchor",href:"#request-body-2"},"#"),e(" Request Body")],-1),cs=s("p",null,[s("code",null,"refresh_token"),s("br"),e(" The refresh token to invalidate. If you have the refresh token in a cookie through "),s("a",{href:"#login"},[s("code",null,"/auth/login")]),e(", you don\u2019t have to submit it here.")],-1),us=s("h3",{id:"rest-api-2",tabindex:"-1"},[s("a",{class:"header-anchor",href:"#rest-api-2"},"#"),e(" REST API")],-1),ds=s("pre",null,[s("code",null,`POST /auth/logout
`)],-1),ps=s("pre",null,[s("code",{class:"language-json"},[s("span",{class:"hljs-punctuation"},"{"),e(`
	`),s("span",{class:"hljs-attr"},'"refresh_token"'),s("span",{class:"hljs-punctuation"},":"),e(),s("span",{class:"hljs-string"},'"gmPd...8wuB"'),e(`
`),s("span",{class:"hljs-punctuation"},"}"),e(`
`)])],-1),_s=s("h3",{id:"graphql-2",tabindex:"-1"},[s("a",{class:"header-anchor",href:"#graphql-2"},"#"),e(" GraphQL")],-1),gs=s("pre",null,[s("code",null,`POST /graphql/system
`)],-1),fs=s("pre",null,[s("code",{class:"language-graphql"},[s("span",{class:"hljs-keyword"},"mutation"),e(` {
	auth_logout(refresh_token: `),s("span",{class:"hljs-string"},'"gmPd...8wuB"'),e(`)
}
`)])],-1),js=s("hr",null,null,-1),bs=s("h2",{id:"request-password-reset",tabindex:"-1"},[s("a",{class:"header-anchor",href:"#request-password-reset"},"#"),e(" Request Password Reset")],-1),ms=s("p",null,"Request a password reset email to be sent to the given user.",-1),ks=s("h3",{id:"request-body-3",tabindex:"-1"},[s("a",{class:"header-anchor",href:"#request-body-3"},"#"),e(" Request Body")],-1),ws=s("p",null,[s("code",null,"email"),e(),s("strong",null,"Required"),s("br"),e(" Email address of the user you\u2019re requesting a password reset for.")],-1),ys=s("code",null,"reset_url",-1),qs=s("br",null,null,-1),vs=s("br",null,null,-1),xs=s("strong",null,"Note",-1),Ts=s("code",null,"PASSWORD_RESET_URL_ALLOW_LIST",-1),Ps=s("h3",{id:"rest-api-3",tabindex:"-1"},[s("a",{class:"header-anchor",href:"#rest-api-3"},"#"),e(" REST API")],-1),Ss=s("pre",null,[s("code",null,`POST /auth/password/request
`)],-1),Rs=s("pre",null,[s("code",{class:"language-json"},[s("span",{class:"hljs-punctuation"},"{"),e(`
	`),s("span",{class:"hljs-attr"},'"email"'),s("span",{class:"hljs-punctuation"},":"),e(),s("span",{class:"hljs-string"},'"admin@example.com"'),e(`
`),s("span",{class:"hljs-punctuation"},"}"),e(`
`)])],-1),As=s("h3",{id:"graphql-3",tabindex:"-1"},[s("a",{class:"header-anchor",href:"#graphql-3"},"#"),e(" GraphQL")],-1),Os=s("pre",null,[s("code",null,`POST /graphql/system
`)],-1),Es=s("pre",null,[s("code",{class:"language-graphql"},[s("span",{class:"hljs-keyword"},"mutation"),e(` {
	auth_password_request(email: `),s("span",{class:"hljs-string"},'"admin@example.com"'),e(`)
}
`)])],-1),Ls=s("hr",null,null,-1),Is=s("h2",{id:"reset-a-password",tabindex:"-1"},[s("a",{class:"header-anchor",href:"#reset-a-password"},"#"),e(" Reset a Password")],-1),Bs=s("p",null,"The request a password reset endpoint sends an email with a link to the admin app (or a custom route) which in turn uses this endpoint to allow the user to reset their password.",-1),Ns=s("h3",{id:"request-body-4",tabindex:"-1"},[s("a",{class:"header-anchor",href:"#request-body-4"},"#"),e(" Request Body")],-1),Gs=s("p",null,[s("code",null,"token"),e(),s("strong",null,"Required"),s("br"),e(" Password reset token, as provided in the email sent by the request endpoint.")],-1),Cs=s("p",null,[s("code",null,"password"),e(),s("strong",null,"Required"),s("br"),e(" New password for the user.")],-1),Ds=s("h3",{id:"rest-api-4",tabindex:"-1"},[s("a",{class:"header-anchor",href:"#rest-api-4"},"#"),e(" REST API")],-1),Js=s("pre",null,[s("code",null,`POST /auth/password/reset
`)],-1),Ws=s("pre",null,[s("code",{class:"language-json"},[s("span",{class:"hljs-punctuation"},"{"),e(`
	`),s("span",{class:"hljs-attr"},'"token"'),s("span",{class:"hljs-punctuation"},":"),e(),s("span",{class:"hljs-string"},'"eyJh...KmUk"'),s("span",{class:"hljs-punctuation"},","),e(`
	`),s("span",{class:"hljs-attr"},'"password"'),s("span",{class:"hljs-punctuation"},":"),e(),s("span",{class:"hljs-string"},'"d1r3ctu5"'),e(`
`),s("span",{class:"hljs-punctuation"},"}"),e(`
`)])],-1),zs=s("h3",{id:"graphql-4",tabindex:"-1"},[s("a",{class:"header-anchor",href:"#graphql-4"},"#"),e(" GraphQL")],-1),Qs=s("pre",null,[s("code",null,`POST /graphql/system
`)],-1),Hs=s("pre",null,[s("code",{class:"language-graphql"},[s("span",{class:"hljs-keyword"},"mutation"),e(` {
	auth_password_reset(token: `),s("span",{class:"hljs-string"},'"eyJh...KmUk"'),e(", password: "),s("span",{class:"hljs-string"},'"d1r3ctu5"'),e(`)
}
`)])],-1),Vs=s("hr",null,null,-1),Us=s("h2",{id:"list-auth-providers",tabindex:"-1"},[s("a",{class:"header-anchor",href:"#list-auth-providers"},"#"),e(" List Auth Providers")],-1),Ks=s("p",null,"List all the configured auth providers.",-1),Fs={class:"tip hint"},Ms=s("div",{class:"hint-title"},"Configuring auth providers",-1),Ys=s("h3",{id:"response-attributes-2",tabindex:"-1"},[s("a",{class:"header-anchor",href:"#response-attributes-2"},"#"),e(" Response Attributes")],-1),Xs=s("p",null,[s("code",null,"data"),e(),s("strong",null,"Array"),s("br"),e(" Array of configured auth providers.")],-1),Zs=s("p",null,[s("code",null,"disableDefault"),e(),s("strong",null,"boolean"),s("br"),e(" Whether or not the default authentication provider is disabled.")],-1),$s=s("pre",null,[s("code",null,`GET /auth
`)],-1),se=s("pre",null,[s("code",{class:"language-json"},[s("span",{class:"hljs-punctuation"},"{"),e(`
	`),s("span",{class:"hljs-attr"},'"data"'),s("span",{class:"hljs-punctuation"},":"),e(),s("span",{class:"hljs-punctuation"},"["),e(`
		`),s("span",{class:"hljs-punctuation"},"{"),e(`
			`),s("span",{class:"hljs-attr"},'"name"'),s("span",{class:"hljs-punctuation"},":"),e(),s("span",{class:"hljs-string"},'"GitHub"'),s("span",{class:"hljs-punctuation"},","),e(`
			`),s("span",{class:"hljs-attr"},'"driver"'),s("span",{class:"hljs-punctuation"},":"),e(),s("span",{class:"hljs-string"},'"oauth2"'),s("span",{class:"hljs-punctuation"},","),e(`
			`),s("span",{class:"hljs-attr"},'"icon"'),s("span",{class:"hljs-punctuation"},":"),e(),s("span",{class:"hljs-string"},'"github"'),e(`
		`),s("span",{class:"hljs-punctuation"},"}"),s("span",{class:"hljs-punctuation"},","),e(`
		`),s("span",{class:"hljs-punctuation"},"{"),e(`
			`),s("span",{class:"hljs-attr"},'"name"'),s("span",{class:"hljs-punctuation"},":"),e(),s("span",{class:"hljs-string"},'"Google"'),s("span",{class:"hljs-punctuation"},","),e(`
			`),s("span",{class:"hljs-attr"},'"driver"'),s("span",{class:"hljs-punctuation"},":"),e(),s("span",{class:"hljs-string"},'"openid"'),s("span",{class:"hljs-punctuation"},","),e(`
			`),s("span",{class:"hljs-attr"},'"icon"'),s("span",{class:"hljs-punctuation"},":"),e(),s("span",{class:"hljs-string"},'"google"'),e(`
		`),s("span",{class:"hljs-punctuation"},"}"),s("span",{class:"hljs-punctuation"},","),e(`
		`),s("span",{class:"hljs-punctuation"},"{"),e(`
			`),s("span",{class:"hljs-attr"},'"name"'),s("span",{class:"hljs-punctuation"},":"),e(),s("span",{class:"hljs-string"},'"Okta"'),s("span",{class:"hljs-punctuation"},","),e(`
			`),s("span",{class:"hljs-attr"},'"driver"'),s("span",{class:"hljs-punctuation"},":"),e(),s("span",{class:"hljs-string"},'"openid"'),e(`
		`),s("span",{class:"hljs-punctuation"},"}"),e(`
	`),s("span",{class:"hljs-punctuation"},"]"),s("span",{class:"hljs-punctuation"},","),e(`
	`),s("span",{class:"hljs-attr"},'"disableDefault"'),s("span",{class:"hljs-punctuation"},":"),e(),s("span",{class:"hljs-literal"},[s("span",{class:"hljs-keyword"},"false")]),e(`
`),s("span",{class:"hljs-punctuation"},"}"),e(`
`)])],-1),ee=s("hr",null,null,-1),te=s("h2",{id:"login-using-sso-providers",tabindex:"-1"},[s("a",{class:"header-anchor",href:"#login-using-sso-providers"},"#"),e(" Login Using SSO Providers")],-1),ne=s("p",null,"Will redirect to the configured SSO provider for the user to login.",-1),oe=s("pre",null,[s("code",null,`GET /auth/login/:provider
`)],-1),ae=s("hr",null,null,-1),ce="Authentication",ue=!1,de="API documentation on authentication in Directus.",pe="5 min read",_e="page-reference",ge={__name:"authentication",setup(le,{expose:r}){const a={title:"Authentication",modularExtension:!1,description:"API documentation on authentication in Directus.",readTime:"5 min read",pageClass:"page-reference"};return r({frontmatter:a}),(re,ie)=>{const n=l("router-link"),i=l("docs-wrapper");return h(),c(i,{frontmatter:a},{default:t(()=>[s("div",u,[s("blockquote",null,[s("p",null,[e("All data within the platform is private by default. The "),o(n,{to:"/docs/configuration/users-roles-permissions#configure-permissions"},{default:t(()=>[e("public role")]),_:1}),e(" can be configured to expose data without authentication, or you can pass an access token to the API to access private data.")])]),d,p,_,g,f,j,b,m,k,w,y,q,v,x,T,P,S,R,A,O,E,L,s("div",I,[B,s("p",null,[e("The token\u2019s expiration time can be configured through "),o(n,{to:"/docs/self-hosted/config-options#general"},{default:t(()=>[e("the "),N,e(" environment variable")]),_:1}),e(".")])]),G,C,D,J,W,z,Q,H,V,U,K,F,M,Y,X,Z,$,ss,es,ts,ns,os,as,ls,rs,is,hs,cs,us,ds,ps,_s,gs,fs,js,bs,ms,ks,ws,s("p",null,[ys,qs,e(" Provide a custom reset url which the link in the email will lead to. The reset token will be passed as a parameter."),vs,xs,e(": You need to configure the "),o(n,{to:"/docs/self-hosted/config-options#security"},{default:t(()=>[Ts,e(" environment variable")]),_:1}),e(" to enable this feature.")]),Ps,Ss,Rs,As,Os,Es,Ls,Is,Bs,Ns,Gs,Cs,Ds,Js,Ws,zs,Qs,Hs,Vs,Us,Ks,s("div",Fs,[Ms,s("p",null,[e("To learn more about setting up auth providers, see "),o(n,{to:"/docs/self-hosted/config-options#authentication"},{default:t(()=>[e("Configuring auth providers")]),_:1}),e(".")])]),Ys,Xs,Zs,$s,se,ee,te,ne,oe,ae])]),_:1})}}};export{ge as default,de as description,ue as modularExtension,_e as pageClass,pe as readTime,ce as title};
