import {
  Credentials,
  EventSigner,
  EventSigningArguments,
  FormattedEvent,
  HashConstructor,
  HttpRequest,
  Provider,
  RequestPresigner,
  RequestPresigningArguments,
  RequestSigner,
  RequestSigningArguments,
  SigningArguments,
  StringSigner,
} from "@aws-sdk/types";
export interface SignatureV4Init {
  service: string;
  region: string | Provider<string>;
  credentials: Credentials | Provider<Credentials>;
  sha256?: HashConstructor;
  uriEscapePath?: boolean;
  applyChecksum?: boolean;
}
export interface SignatureV4CryptoInit {
  sha256: HashConstructor;
}
export declare class SignatureV4
  implements RequestPresigner, RequestSigner, StringSigner, EventSigner
{
  private readonly service;
  private readonly regionProvider;
  private readonly credentialProvider;
  private readonly sha256;
  private readonly uriEscapePath;
  private readonly applyChecksum;
  constructor({
    applyChecksum,
    credentials,
    region,
    service,
    sha256,
    uriEscapePath,
  }: SignatureV4Init & SignatureV4CryptoInit);
  presign(
    originalRequest: HttpRequest,
    options?: RequestPresigningArguments
  ): Promise<HttpRequest>;
  sign(stringToSign: string, options?: SigningArguments): Promise<string>;
  sign(event: FormattedEvent, options: EventSigningArguments): Promise<string>;
  sign(
    requestToSign: HttpRequest,
    options?: RequestSigningArguments
  ): Promise<HttpRequest>;
  private signEvent;
  private signString;
  private signRequest;
  private createCanonicalRequest;
  private createStringToSign;
  private getCanonicalPath;
  private getSignature;
  private getSigningKey;
  private validateResolvedCredentials;
}
