import { ExceptionOptionType as __ExceptionOptionType } from "@aws-sdk/smithy-client";
import { SESServiceException as __BaseException } from "./SESServiceException";
export declare class AccountSendingPausedException extends __BaseException {
  readonly name: "AccountSendingPausedException";
  readonly $fault: "client";
  constructor(
    opts: __ExceptionOptionType<AccountSendingPausedException, __BaseException>
  );
}
export interface AddHeaderAction {
  HeaderName: string | undefined;
  HeaderValue: string | undefined;
}
export declare class AlreadyExistsException extends __BaseException {
  readonly name: "AlreadyExistsException";
  readonly $fault: "client";
  Name?: string;
  constructor(
    opts: __ExceptionOptionType<AlreadyExistsException, __BaseException>
  );
}
export declare enum BehaviorOnMXFailure {
  RejectMessage = "RejectMessage",
  UseDefaultValue = "UseDefaultValue",
}
export interface Content {
  Data: string | undefined;
  Charset?: string;
}
export interface Body {
  Text?: Content;
  Html?: Content;
}
export interface BounceAction {
  TopicArn?: string;
  SmtpReplyCode: string | undefined;
  StatusCode?: string;
  Message: string | undefined;
  Sender: string | undefined;
}
export declare enum BounceType {
  ContentRejected = "ContentRejected",
  DoesNotExist = "DoesNotExist",
  ExceededQuota = "ExceededQuota",
  MessageTooLarge = "MessageTooLarge",
  TemporaryFailure = "TemporaryFailure",
  Undefined = "Undefined",
}
export declare enum DsnAction {
  DELAYED = "delayed",
  DELIVERED = "delivered",
  EXPANDED = "expanded",
  FAILED = "failed",
  RELAYED = "relayed",
}
export interface ExtensionField {
  Name: string | undefined;
  Value: string | undefined;
}
export interface RecipientDsnFields {
  FinalRecipient?: string;
  Action: DsnAction | string | undefined;
  RemoteMta?: string;
  Status: string | undefined;
  DiagnosticCode?: string;
  LastAttemptDate?: Date;
  ExtensionFields?: ExtensionField[];
}
export interface BouncedRecipientInfo {
  Recipient: string | undefined;
  RecipientArn?: string;
  BounceType?: BounceType | string;
  RecipientDsnFields?: RecipientDsnFields;
}
export interface Destination {
  ToAddresses?: string[];
  CcAddresses?: string[];
  BccAddresses?: string[];
}
export interface MessageTag {
  Name: string | undefined;
  Value: string | undefined;
}
export interface BulkEmailDestination {
  Destination: Destination | undefined;
  ReplacementTags?: MessageTag[];
  ReplacementTemplateData?: string;
}
export declare enum BulkEmailStatus {
  AccountDailyQuotaExceeded = "AccountDailyQuotaExceeded",
  AccountSendingPaused = "AccountSendingPaused",
  AccountSuspended = "AccountSuspended",
  AccountThrottled = "AccountThrottled",
  ConfigurationSetDoesNotExist = "ConfigurationSetDoesNotExist",
  ConfigurationSetSendingPaused = "ConfigurationSetSendingPaused",
  Failed = "Failed",
  InvalidParameterValue = "InvalidParameterValue",
  InvalidSendingPoolName = "InvalidSendingPoolName",
  MailFromDomainNotVerified = "MailFromDomainNotVerified",
  MessageRejected = "MessageRejected",
  Success = "Success",
  TemplateDoesNotExist = "TemplateDoesNotExist",
  TransientFailure = "TransientFailure",
}
export interface BulkEmailDestinationStatus {
  Status?: BulkEmailStatus | string;
  Error?: string;
  MessageId?: string;
}
export declare class CannotDeleteException extends __BaseException {
  readonly name: "CannotDeleteException";
  readonly $fault: "client";
  Name?: string;
  constructor(
    opts: __ExceptionOptionType<CannotDeleteException, __BaseException>
  );
}
export interface CloneReceiptRuleSetRequest {
  RuleSetName: string | undefined;
  OriginalRuleSetName: string | undefined;
}
export interface CloneReceiptRuleSetResponse {}
export declare class LimitExceededException extends __BaseException {
  readonly name: "LimitExceededException";
  readonly $fault: "client";
  constructor(
    opts: __ExceptionOptionType<LimitExceededException, __BaseException>
  );
}
export declare class RuleSetDoesNotExistException extends __BaseException {
  readonly name: "RuleSetDoesNotExistException";
  readonly $fault: "client";
  Name?: string;
  constructor(
    opts: __ExceptionOptionType<RuleSetDoesNotExistException, __BaseException>
  );
}
export declare enum DimensionValueSource {
  EMAIL_HEADER = "emailHeader",
  LINK_TAG = "linkTag",
  MESSAGE_TAG = "messageTag",
}
export interface CloudWatchDimensionConfiguration {
  DimensionName: string | undefined;
  DimensionValueSource: DimensionValueSource | string | undefined;
  DefaultDimensionValue: string | undefined;
}
export interface CloudWatchDestination {
  DimensionConfigurations: CloudWatchDimensionConfiguration[] | undefined;
}
export interface ConfigurationSet {
  Name: string | undefined;
}
export declare class ConfigurationSetAlreadyExistsException extends __BaseException {
  readonly name: "ConfigurationSetAlreadyExistsException";
  readonly $fault: "client";
  ConfigurationSetName?: string;
  constructor(
    opts: __ExceptionOptionType<
      ConfigurationSetAlreadyExistsException,
      __BaseException
    >
  );
}
export declare enum ConfigurationSetAttribute {
  DELIVERY_OPTIONS = "deliveryOptions",
  EVENT_DESTINATIONS = "eventDestinations",
  REPUTATION_OPTIONS = "reputationOptions",
  TRACKING_OPTIONS = "trackingOptions",
}
export declare class ConfigurationSetDoesNotExistException extends __BaseException {
  readonly name: "ConfigurationSetDoesNotExistException";
  readonly $fault: "client";
  ConfigurationSetName?: string;
  constructor(
    opts: __ExceptionOptionType<
      ConfigurationSetDoesNotExistException,
      __BaseException
    >
  );
}
export declare class ConfigurationSetSendingPausedException extends __BaseException {
  readonly name: "ConfigurationSetSendingPausedException";
  readonly $fault: "client";
  ConfigurationSetName?: string;
  constructor(
    opts: __ExceptionOptionType<
      ConfigurationSetSendingPausedException,
      __BaseException
    >
  );
}
export interface CreateConfigurationSetRequest {
  ConfigurationSet: ConfigurationSet | undefined;
}
export interface CreateConfigurationSetResponse {}
export declare class InvalidConfigurationSetException extends __BaseException {
  readonly name: "InvalidConfigurationSetException";
  readonly $fault: "client";
  constructor(
    opts: __ExceptionOptionType<
      InvalidConfigurationSetException,
      __BaseException
    >
  );
}
export interface KinesisFirehoseDestination {
  IAMRoleARN: string | undefined;
  DeliveryStreamARN: string | undefined;
}
export declare enum EventType {
  BOUNCE = "bounce",
  CLICK = "click",
  COMPLAINT = "complaint",
  DELIVERY = "delivery",
  OPEN = "open",
  REJECT = "reject",
  RENDERING_FAILURE = "renderingFailure",
  SEND = "send",
}
export interface SNSDestination {
  TopicARN: string | undefined;
}
export interface EventDestination {
  Name: string | undefined;
  Enabled?: boolean;
  MatchingEventTypes: (EventType | string)[] | undefined;
  KinesisFirehoseDestination?: KinesisFirehoseDestination;
  CloudWatchDestination?: CloudWatchDestination;
  SNSDestination?: SNSDestination;
}
export interface CreateConfigurationSetEventDestinationRequest {
  ConfigurationSetName: string | undefined;
  EventDestination: EventDestination | undefined;
}
export interface CreateConfigurationSetEventDestinationResponse {}
export declare class EventDestinationAlreadyExistsException extends __BaseException {
  readonly name: "EventDestinationAlreadyExistsException";
  readonly $fault: "client";
  ConfigurationSetName?: string;
  EventDestinationName?: string;
  constructor(
    opts: __ExceptionOptionType<
      EventDestinationAlreadyExistsException,
      __BaseException
    >
  );
}
export declare class InvalidCloudWatchDestinationException extends __BaseException {
  readonly name: "InvalidCloudWatchDestinationException";
  readonly $fault: "client";
  ConfigurationSetName?: string;
  EventDestinationName?: string;
  constructor(
    opts: __ExceptionOptionType<
      InvalidCloudWatchDestinationException,
      __BaseException
    >
  );
}
export declare class InvalidFirehoseDestinationException extends __BaseException {
  readonly name: "InvalidFirehoseDestinationException";
  readonly $fault: "client";
  ConfigurationSetName?: string;
  EventDestinationName?: string;
  constructor(
    opts: __ExceptionOptionType<
      InvalidFirehoseDestinationException,
      __BaseException
    >
  );
}
export declare class InvalidSNSDestinationException extends __BaseException {
  readonly name: "InvalidSNSDestinationException";
  readonly $fault: "client";
  ConfigurationSetName?: string;
  EventDestinationName?: string;
  constructor(
    opts: __ExceptionOptionType<InvalidSNSDestinationException, __BaseException>
  );
}
export interface TrackingOptions {
  CustomRedirectDomain?: string;
}
export interface CreateConfigurationSetTrackingOptionsRequest {
  ConfigurationSetName: string | undefined;
  TrackingOptions: TrackingOptions | undefined;
}
export interface CreateConfigurationSetTrackingOptionsResponse {}
export declare class InvalidTrackingOptionsException extends __BaseException {
  readonly name: "InvalidTrackingOptionsException";
  readonly $fault: "client";
  constructor(
    opts: __ExceptionOptionType<
      InvalidTrackingOptionsException,
      __BaseException
    >
  );
}
export declare class TrackingOptionsAlreadyExistsException extends __BaseException {
  readonly name: "TrackingOptionsAlreadyExistsException";
  readonly $fault: "client";
  ConfigurationSetName?: string;
  constructor(
    opts: __ExceptionOptionType<
      TrackingOptionsAlreadyExistsException,
      __BaseException
    >
  );
}
export interface CreateCustomVerificationEmailTemplateRequest {
  TemplateName: string | undefined;
  FromEmailAddress: string | undefined;
  TemplateSubject: string | undefined;
  TemplateContent: string | undefined;
  SuccessRedirectionURL: string | undefined;
  FailureRedirectionURL: string | undefined;
}
export declare class CustomVerificationEmailInvalidContentException extends __BaseException {
  readonly name: "CustomVerificationEmailInvalidContentException";
  readonly $fault: "client";
  constructor(
    opts: __ExceptionOptionType<
      CustomVerificationEmailInvalidContentException,
      __BaseException
    >
  );
}
export declare class CustomVerificationEmailTemplateAlreadyExistsException extends __BaseException {
  readonly name: "CustomVerificationEmailTemplateAlreadyExistsException";
  readonly $fault: "client";
  CustomVerificationEmailTemplateName?: string;
  constructor(
    opts: __ExceptionOptionType<
      CustomVerificationEmailTemplateAlreadyExistsException,
      __BaseException
    >
  );
}
export declare class FromEmailAddressNotVerifiedException extends __BaseException {
  readonly name: "FromEmailAddressNotVerifiedException";
  readonly $fault: "client";
  FromEmailAddress?: string;
  constructor(
    opts: __ExceptionOptionType<
      FromEmailAddressNotVerifiedException,
      __BaseException
    >
  );
}
export declare enum ReceiptFilterPolicy {
  Allow = "Allow",
  Block = "Block",
}
export interface ReceiptIpFilter {
  Policy: ReceiptFilterPolicy | string | undefined;
  Cidr: string | undefined;
}
export interface ReceiptFilter {
  Name: string | undefined;
  IpFilter: ReceiptIpFilter | undefined;
}
export interface CreateReceiptFilterRequest {
  Filter: ReceiptFilter | undefined;
}
export interface CreateReceiptFilterResponse {}
export declare type InvocationType = "Event" | "RequestResponse";
export interface LambdaAction {
  TopicArn?: string;
  FunctionArn: string | undefined;
  InvocationType?: InvocationType | string;
}
export interface S3Action {
  TopicArn?: string;
  BucketName: string | undefined;
  ObjectKeyPrefix?: string;
  KmsKeyArn?: string;
}
export declare enum SNSActionEncoding {
  Base64 = "Base64",
  UTF8 = "UTF-8",
}
export interface SNSAction {
  TopicArn: string | undefined;
  Encoding?: SNSActionEncoding | string;
}
export declare enum StopScope {
  RULE_SET = "RuleSet",
}
export interface StopAction {
  Scope: StopScope | string | undefined;
  TopicArn?: string;
}
export interface WorkmailAction {
  TopicArn?: string;
  OrganizationArn: string | undefined;
}
export interface ReceiptAction {
  S3Action?: S3Action;
  BounceAction?: BounceAction;
  WorkmailAction?: WorkmailAction;
  LambdaAction?: LambdaAction;
  StopAction?: StopAction;
  AddHeaderAction?: AddHeaderAction;
  SNSAction?: SNSAction;
}
export declare enum TlsPolicy {
  Optional = "Optional",
  Require = "Require",
}
export interface ReceiptRule {
  Name: string | undefined;
  Enabled?: boolean;
  TlsPolicy?: TlsPolicy | string;
  Recipients?: string[];
  Actions?: ReceiptAction[];
  ScanEnabled?: boolean;
}
export interface CreateReceiptRuleRequest {
  RuleSetName: string | undefined;
  After?: string;
  Rule: ReceiptRule | undefined;
}
export interface CreateReceiptRuleResponse {}
export declare class InvalidLambdaFunctionException extends __BaseException {
  readonly name: "InvalidLambdaFunctionException";
  readonly $fault: "client";
  FunctionArn?: string;
  constructor(
    opts: __ExceptionOptionType<InvalidLambdaFunctionException, __BaseException>
  );
}
export declare class InvalidS3ConfigurationException extends __BaseException {
  readonly name: "InvalidS3ConfigurationException";
  readonly $fault: "client";
  Bucket?: string;
  constructor(
    opts: __ExceptionOptionType<
      InvalidS3ConfigurationException,
      __BaseException
    >
  );
}
export declare class InvalidSnsTopicException extends __BaseException {
  readonly name: "InvalidSnsTopicException";
  readonly $fault: "client";
  Topic?: string;
  constructor(
    opts: __ExceptionOptionType<InvalidSnsTopicException, __BaseException>
  );
}
export declare class RuleDoesNotExistException extends __BaseException {
  readonly name: "RuleDoesNotExistException";
  readonly $fault: "client";
  Name?: string;
  constructor(
    opts: __ExceptionOptionType<RuleDoesNotExistException, __BaseException>
  );
}
export interface CreateReceiptRuleSetRequest {
  RuleSetName: string | undefined;
}
export interface CreateReceiptRuleSetResponse {}
export interface Template {
  TemplateName: string | undefined;
  SubjectPart?: string;
  TextPart?: string;
  HtmlPart?: string;
}
export interface CreateTemplateRequest {
  Template: Template | undefined;
}
export interface CreateTemplateResponse {}
export declare class InvalidTemplateException extends __BaseException {
  readonly name: "InvalidTemplateException";
  readonly $fault: "client";
  TemplateName?: string;
  constructor(
    opts: __ExceptionOptionType<InvalidTemplateException, __BaseException>
  );
}
export declare enum CustomMailFromStatus {
  Failed = "Failed",
  Pending = "Pending",
  Success = "Success",
  TemporaryFailure = "TemporaryFailure",
}
export interface CustomVerificationEmailTemplate {
  TemplateName?: string;
  FromEmailAddress?: string;
  TemplateSubject?: string;
  SuccessRedirectionURL?: string;
  FailureRedirectionURL?: string;
}
export declare class CustomVerificationEmailTemplateDoesNotExistException extends __BaseException {
  readonly name: "CustomVerificationEmailTemplateDoesNotExistException";
  readonly $fault: "client";
  CustomVerificationEmailTemplateName?: string;
  constructor(
    opts: __ExceptionOptionType<
      CustomVerificationEmailTemplateDoesNotExistException,
      __BaseException
    >
  );
}
export interface DeleteConfigurationSetRequest {
  ConfigurationSetName: string | undefined;
}
export interface DeleteConfigurationSetResponse {}
export interface DeleteConfigurationSetEventDestinationRequest {
  ConfigurationSetName: string | undefined;
  EventDestinationName: string | undefined;
}
export interface DeleteConfigurationSetEventDestinationResponse {}
export declare class EventDestinationDoesNotExistException extends __BaseException {
  readonly name: "EventDestinationDoesNotExistException";
  readonly $fault: "client";
  ConfigurationSetName?: string;
  EventDestinationName?: string;
  constructor(
    opts: __ExceptionOptionType<
      EventDestinationDoesNotExistException,
      __BaseException
    >
  );
}
export interface DeleteConfigurationSetTrackingOptionsRequest {
  ConfigurationSetName: string | undefined;
}
export interface DeleteConfigurationSetTrackingOptionsResponse {}
export declare class TrackingOptionsDoesNotExistException extends __BaseException {
  readonly name: "TrackingOptionsDoesNotExistException";
  readonly $fault: "client";
  ConfigurationSetName?: string;
  constructor(
    opts: __ExceptionOptionType<
      TrackingOptionsDoesNotExistException,
      __BaseException
    >
  );
}
export interface DeleteCustomVerificationEmailTemplateRequest {
  TemplateName: string | undefined;
}
export interface DeleteIdentityRequest {
  Identity: string | undefined;
}
export interface DeleteIdentityResponse {}
export interface DeleteIdentityPolicyRequest {
  Identity: string | undefined;
  PolicyName: string | undefined;
}
export interface DeleteIdentityPolicyResponse {}
export interface DeleteReceiptFilterRequest {
  FilterName: string | undefined;
}
export interface DeleteReceiptFilterResponse {}
export interface DeleteReceiptRuleRequest {
  RuleSetName: string | undefined;
  RuleName: string | undefined;
}
export interface DeleteReceiptRuleResponse {}
export interface DeleteReceiptRuleSetRequest {
  RuleSetName: string | undefined;
}
export interface DeleteReceiptRuleSetResponse {}
export interface DeleteTemplateRequest {
  TemplateName: string | undefined;
}
export interface DeleteTemplateResponse {}
export interface DeleteVerifiedEmailAddressRequest {
  EmailAddress: string | undefined;
}
export interface DeliveryOptions {
  TlsPolicy?: TlsPolicy | string;
}
export interface DescribeActiveReceiptRuleSetRequest {}
export interface ReceiptRuleSetMetadata {
  Name?: string;
  CreatedTimestamp?: Date;
}
export interface DescribeActiveReceiptRuleSetResponse {
  Metadata?: ReceiptRuleSetMetadata;
  Rules?: ReceiptRule[];
}
export interface DescribeConfigurationSetRequest {
  ConfigurationSetName: string | undefined;
  ConfigurationSetAttributeNames?: (ConfigurationSetAttribute | string)[];
}
export interface ReputationOptions {
  SendingEnabled?: boolean;
  ReputationMetricsEnabled?: boolean;
  LastFreshStart?: Date;
}
export interface DescribeConfigurationSetResponse {
  ConfigurationSet?: ConfigurationSet;
  EventDestinations?: EventDestination[];
  TrackingOptions?: TrackingOptions;
  DeliveryOptions?: DeliveryOptions;
  ReputationOptions?: ReputationOptions;
}
export interface DescribeReceiptRuleRequest {
  RuleSetName: string | undefined;
  RuleName: string | undefined;
}
export interface DescribeReceiptRuleResponse {
  Rule?: ReceiptRule;
}
export interface DescribeReceiptRuleSetRequest {
  RuleSetName: string | undefined;
}
export interface DescribeReceiptRuleSetResponse {
  Metadata?: ReceiptRuleSetMetadata;
  Rules?: ReceiptRule[];
}
export declare type VerificationStatus =
  | "Failed"
  | "NotStarted"
  | "Pending"
  | "Success"
  | "TemporaryFailure";
export interface IdentityDkimAttributes {
  DkimEnabled: boolean | undefined;
  DkimVerificationStatus: VerificationStatus | string | undefined;
  DkimTokens?: string[];
}
export interface GetAccountSendingEnabledResponse {
  Enabled?: boolean;
}
export interface GetCustomVerificationEmailTemplateRequest {
  TemplateName: string | undefined;
}
export interface GetCustomVerificationEmailTemplateResponse {
  TemplateName?: string;
  FromEmailAddress?: string;
  TemplateSubject?: string;
  TemplateContent?: string;
  SuccessRedirectionURL?: string;
  FailureRedirectionURL?: string;
}
export interface GetIdentityDkimAttributesRequest {
  Identities: string[] | undefined;
}
export interface GetIdentityDkimAttributesResponse {
  DkimAttributes: Record<string, IdentityDkimAttributes> | undefined;
}
export interface GetIdentityMailFromDomainAttributesRequest {
  Identities: string[] | undefined;
}
export interface IdentityMailFromDomainAttributes {
  MailFromDomain: string | undefined;
  MailFromDomainStatus: CustomMailFromStatus | string | undefined;
  BehaviorOnMXFailure: BehaviorOnMXFailure | string | undefined;
}
export interface GetIdentityMailFromDomainAttributesResponse {
  MailFromDomainAttributes:
    | Record<string, IdentityMailFromDomainAttributes>
    | undefined;
}
export interface GetIdentityNotificationAttributesRequest {
  Identities: string[] | undefined;
}
export interface IdentityNotificationAttributes {
  BounceTopic: string | undefined;
  ComplaintTopic: string | undefined;
  DeliveryTopic: string | undefined;
  ForwardingEnabled: boolean | undefined;
  HeadersInBounceNotificationsEnabled?: boolean;
  HeadersInComplaintNotificationsEnabled?: boolean;
  HeadersInDeliveryNotificationsEnabled?: boolean;
}
export interface GetIdentityNotificationAttributesResponse {
  NotificationAttributes:
    | Record<string, IdentityNotificationAttributes>
    | undefined;
}
export interface GetIdentityPoliciesRequest {
  Identity: string | undefined;
  PolicyNames: string[] | undefined;
}
export interface GetIdentityPoliciesResponse {
  Policies: Record<string, string> | undefined;
}
export interface GetIdentityVerificationAttributesRequest {
  Identities: string[] | undefined;
}
export interface IdentityVerificationAttributes {
  VerificationStatus: VerificationStatus | string | undefined;
  VerificationToken?: string;
}
export interface GetIdentityVerificationAttributesResponse {
  VerificationAttributes:
    | Record<string, IdentityVerificationAttributes>
    | undefined;
}
export interface GetSendQuotaResponse {
  Max24HourSend?: number;
  MaxSendRate?: number;
  SentLast24Hours?: number;
}
export interface SendDataPoint {
  Timestamp?: Date;
  DeliveryAttempts?: number;
  Bounces?: number;
  Complaints?: number;
  Rejects?: number;
}
export interface GetSendStatisticsResponse {
  SendDataPoints?: SendDataPoint[];
}
export interface GetTemplateRequest {
  TemplateName: string | undefined;
}
export interface GetTemplateResponse {
  Template?: Template;
}
export declare class TemplateDoesNotExistException extends __BaseException {
  readonly name: "TemplateDoesNotExistException";
  readonly $fault: "client";
  TemplateName?: string;
  constructor(
    opts: __ExceptionOptionType<TemplateDoesNotExistException, __BaseException>
  );
}
export declare type IdentityType = "Domain" | "EmailAddress";
export declare class InvalidDeliveryOptionsException extends __BaseException {
  readonly name: "InvalidDeliveryOptionsException";
  readonly $fault: "client";
  constructor(
    opts: __ExceptionOptionType<
      InvalidDeliveryOptionsException,
      __BaseException
    >
  );
}
export declare class InvalidPolicyException extends __BaseException {
  readonly name: "InvalidPolicyException";
  readonly $fault: "client";
  constructor(
    opts: __ExceptionOptionType<InvalidPolicyException, __BaseException>
  );
}
export declare class InvalidRenderingParameterException extends __BaseException {
  readonly name: "InvalidRenderingParameterException";
  readonly $fault: "client";
  TemplateName?: string;
  constructor(
    opts: __ExceptionOptionType<
      InvalidRenderingParameterException,
      __BaseException
    >
  );
}
export interface ListConfigurationSetsRequest {
  NextToken?: string;
  MaxItems?: number;
}
export interface ListConfigurationSetsResponse {
  ConfigurationSets?: ConfigurationSet[];
  NextToken?: string;
}
export interface ListCustomVerificationEmailTemplatesRequest {
  NextToken?: string;
  MaxResults?: number;
}
export interface ListCustomVerificationEmailTemplatesResponse {
  CustomVerificationEmailTemplates?: CustomVerificationEmailTemplate[];
  NextToken?: string;
}
export interface ListIdentitiesRequest {
  IdentityType?: IdentityType | string;
  NextToken?: string;
  MaxItems?: number;
}
export interface ListIdentitiesResponse {
  Identities: string[] | undefined;
  NextToken?: string;
}
export interface ListIdentityPoliciesRequest {
  Identity: string | undefined;
}
export interface ListIdentityPoliciesResponse {
  PolicyNames: string[] | undefined;
}
export interface ListReceiptFiltersRequest {}
export interface ListReceiptFiltersResponse {
  Filters?: ReceiptFilter[];
}
export interface ListReceiptRuleSetsRequest {
  NextToken?: string;
}
export interface ListReceiptRuleSetsResponse {
  RuleSets?: ReceiptRuleSetMetadata[];
  NextToken?: string;
}
export interface ListTemplatesRequest {
  NextToken?: string;
  MaxItems?: number;
}
export interface TemplateMetadata {
  Name?: string;
  CreatedTimestamp?: Date;
}
export interface ListTemplatesResponse {
  TemplatesMetadata?: TemplateMetadata[];
  NextToken?: string;
}
export interface ListVerifiedEmailAddressesResponse {
  VerifiedEmailAddresses?: string[];
}
export declare class MailFromDomainNotVerifiedException extends __BaseException {
  readonly name: "MailFromDomainNotVerifiedException";
  readonly $fault: "client";
  constructor(
    opts: __ExceptionOptionType<
      MailFromDomainNotVerifiedException,
      __BaseException
    >
  );
}
export interface Message {
  Subject: Content | undefined;
  Body: Body | undefined;
}
export interface MessageDsn {
  ReportingMta: string | undefined;
  ArrivalDate?: Date;
  ExtensionFields?: ExtensionField[];
}
export declare class MessageRejected extends __BaseException {
  readonly name: "MessageRejected";
  readonly $fault: "client";
  constructor(opts: __ExceptionOptionType<MessageRejected, __BaseException>);
}
export declare class MissingRenderingAttributeException extends __BaseException {
  readonly name: "MissingRenderingAttributeException";
  readonly $fault: "client";
  TemplateName?: string;
  constructor(
    opts: __ExceptionOptionType<
      MissingRenderingAttributeException,
      __BaseException
    >
  );
}
export declare type NotificationType = "Bounce" | "Complaint" | "Delivery";
export declare class ProductionAccessNotGrantedException extends __BaseException {
  readonly name: "ProductionAccessNotGrantedException";
  readonly $fault: "client";
  constructor(
    opts: __ExceptionOptionType<
      ProductionAccessNotGrantedException,
      __BaseException
    >
  );
}
export interface PutConfigurationSetDeliveryOptionsRequest {
  ConfigurationSetName: string | undefined;
  DeliveryOptions?: DeliveryOptions;
}
export interface PutConfigurationSetDeliveryOptionsResponse {}
export interface PutIdentityPolicyRequest {
  Identity: string | undefined;
  PolicyName: string | undefined;
  Policy: string | undefined;
}
export interface PutIdentityPolicyResponse {}
export interface RawMessage {
  Data: Uint8Array | undefined;
}
export interface ReorderReceiptRuleSetRequest {
  RuleSetName: string | undefined;
  RuleNames: string[] | undefined;
}
export interface ReorderReceiptRuleSetResponse {}
export interface SendBounceRequest {
  OriginalMessageId: string | undefined;
  BounceSender: string | undefined;
  Explanation?: string;
  MessageDsn?: MessageDsn;
  BouncedRecipientInfoList: BouncedRecipientInfo[] | undefined;
  BounceSenderArn?: string;
}
export interface SendBounceResponse {
  MessageId?: string;
}
export interface SendBulkTemplatedEmailRequest {
  Source: string | undefined;
  SourceArn?: string;
  ReplyToAddresses?: string[];
  ReturnPath?: string;
  ReturnPathArn?: string;
  ConfigurationSetName?: string;
  DefaultTags?: MessageTag[];
  Template: string | undefined;
  TemplateArn?: string;
  DefaultTemplateData?: string;
  Destinations: BulkEmailDestination[] | undefined;
}
export interface SendBulkTemplatedEmailResponse {
  Status: BulkEmailDestinationStatus[] | undefined;
}
export interface SendCustomVerificationEmailRequest {
  EmailAddress: string | undefined;
  TemplateName: string | undefined;
  ConfigurationSetName?: string;
}
export interface SendCustomVerificationEmailResponse {
  MessageId?: string;
}
export interface SendEmailRequest {
  Source: string | undefined;
  Destination: Destination | undefined;
  Message: Message | undefined;
  ReplyToAddresses?: string[];
  ReturnPath?: string;
  SourceArn?: string;
  ReturnPathArn?: string;
  Tags?: MessageTag[];
  ConfigurationSetName?: string;
}
export interface SendEmailResponse {
  MessageId: string | undefined;
}
export interface SendRawEmailRequest {
  Source?: string;
  Destinations?: string[];
  RawMessage: RawMessage | undefined;
  FromArn?: string;
  SourceArn?: string;
  ReturnPathArn?: string;
  Tags?: MessageTag[];
  ConfigurationSetName?: string;
}
export interface SendRawEmailResponse {
  MessageId: string | undefined;
}
export interface SendTemplatedEmailRequest {
  Source: string | undefined;
  Destination: Destination | undefined;
  ReplyToAddresses?: string[];
  ReturnPath?: string;
  SourceArn?: string;
  ReturnPathArn?: string;
  Tags?: MessageTag[];
  ConfigurationSetName?: string;
  Template: string | undefined;
  TemplateArn?: string;
  TemplateData: string | undefined;
}
export interface SendTemplatedEmailResponse {
  MessageId: string | undefined;
}
export interface SetActiveReceiptRuleSetRequest {
  RuleSetName?: string;
}
export interface SetActiveReceiptRuleSetResponse {}
export interface SetIdentityDkimEnabledRequest {
  Identity: string | undefined;
  DkimEnabled: boolean | undefined;
}
export interface SetIdentityDkimEnabledResponse {}
export interface SetIdentityFeedbackForwardingEnabledRequest {
  Identity: string | undefined;
  ForwardingEnabled: boolean | undefined;
}
export interface SetIdentityFeedbackForwardingEnabledResponse {}
export interface SetIdentityHeadersInNotificationsEnabledRequest {
  Identity: string | undefined;
  NotificationType: NotificationType | string | undefined;
  Enabled: boolean | undefined;
}
export interface SetIdentityHeadersInNotificationsEnabledResponse {}
export interface SetIdentityMailFromDomainRequest {
  Identity: string | undefined;
  MailFromDomain?: string;
  BehaviorOnMXFailure?: BehaviorOnMXFailure | string;
}
export interface SetIdentityMailFromDomainResponse {}
export interface SetIdentityNotificationTopicRequest {
  Identity: string | undefined;
  NotificationType: NotificationType | string | undefined;
  SnsTopic?: string;
}
export interface SetIdentityNotificationTopicResponse {}
export interface SetReceiptRulePositionRequest {
  RuleSetName: string | undefined;
  RuleName: string | undefined;
  After?: string;
}
export interface SetReceiptRulePositionResponse {}
export interface TestRenderTemplateRequest {
  TemplateName: string | undefined;
  TemplateData: string | undefined;
}
export interface TestRenderTemplateResponse {
  RenderedTemplate?: string;
}
export interface UpdateAccountSendingEnabledRequest {
  Enabled?: boolean;
}
export interface UpdateConfigurationSetEventDestinationRequest {
  ConfigurationSetName: string | undefined;
  EventDestination: EventDestination | undefined;
}
export interface UpdateConfigurationSetEventDestinationResponse {}
export interface UpdateConfigurationSetReputationMetricsEnabledRequest {
  ConfigurationSetName: string | undefined;
  Enabled: boolean | undefined;
}
export interface UpdateConfigurationSetSendingEnabledRequest {
  ConfigurationSetName: string | undefined;
  Enabled: boolean | undefined;
}
export interface UpdateConfigurationSetTrackingOptionsRequest {
  ConfigurationSetName: string | undefined;
  TrackingOptions: TrackingOptions | undefined;
}
export interface UpdateConfigurationSetTrackingOptionsResponse {}
export interface UpdateCustomVerificationEmailTemplateRequest {
  TemplateName: string | undefined;
  FromEmailAddress?: string;
  TemplateSubject?: string;
  TemplateContent?: string;
  SuccessRedirectionURL?: string;
  FailureRedirectionURL?: string;
}
export interface UpdateReceiptRuleRequest {
  RuleSetName: string | undefined;
  Rule: ReceiptRule | undefined;
}
export interface UpdateReceiptRuleResponse {}
export interface UpdateTemplateRequest {
  Template: Template | undefined;
}
export interface UpdateTemplateResponse {}
export interface VerifyDomainDkimRequest {
  Domain: string | undefined;
}
export interface VerifyDomainDkimResponse {
  DkimTokens: string[] | undefined;
}
export interface VerifyDomainIdentityRequest {
  Domain: string | undefined;
}
export interface VerifyDomainIdentityResponse {
  VerificationToken: string | undefined;
}
export interface VerifyEmailAddressRequest {
  EmailAddress: string | undefined;
}
export interface VerifyEmailIdentityRequest {
  EmailAddress: string | undefined;
}
export interface VerifyEmailIdentityResponse {}
export declare const AddHeaderActionFilterSensitiveLog: (
  obj: AddHeaderAction
) => any;
export declare const ContentFilterSensitiveLog: (obj: Content) => any;
export declare const BodyFilterSensitiveLog: (obj: Body) => any;
export declare const BounceActionFilterSensitiveLog: (obj: BounceAction) => any;
export declare const ExtensionFieldFilterSensitiveLog: (
  obj: ExtensionField
) => any;
export declare const RecipientDsnFieldsFilterSensitiveLog: (
  obj: RecipientDsnFields
) => any;
export declare const BouncedRecipientInfoFilterSensitiveLog: (
  obj: BouncedRecipientInfo
) => any;
export declare const DestinationFilterSensitiveLog: (obj: Destination) => any;
export declare const MessageTagFilterSensitiveLog: (obj: MessageTag) => any;
export declare const BulkEmailDestinationFilterSensitiveLog: (
  obj: BulkEmailDestination
) => any;
export declare const BulkEmailDestinationStatusFilterSensitiveLog: (
  obj: BulkEmailDestinationStatus
) => any;
export declare const CloneReceiptRuleSetRequestFilterSensitiveLog: (
  obj: CloneReceiptRuleSetRequest
) => any;
export declare const CloneReceiptRuleSetResponseFilterSensitiveLog: (
  obj: CloneReceiptRuleSetResponse
) => any;
export declare const CloudWatchDimensionConfigurationFilterSensitiveLog: (
  obj: CloudWatchDimensionConfiguration
) => any;
export declare const CloudWatchDestinationFilterSensitiveLog: (
  obj: CloudWatchDestination
) => any;
export declare const ConfigurationSetFilterSensitiveLog: (
  obj: ConfigurationSet
) => any;
export declare const CreateConfigurationSetRequestFilterSensitiveLog: (
  obj: CreateConfigurationSetRequest
) => any;
export declare const CreateConfigurationSetResponseFilterSensitiveLog: (
  obj: CreateConfigurationSetResponse
) => any;
export declare const KinesisFirehoseDestinationFilterSensitiveLog: (
  obj: KinesisFirehoseDestination
) => any;
export declare const SNSDestinationFilterSensitiveLog: (
  obj: SNSDestination
) => any;
export declare const EventDestinationFilterSensitiveLog: (
  obj: EventDestination
) => any;
export declare const CreateConfigurationSetEventDestinationRequestFilterSensitiveLog: (
  obj: CreateConfigurationSetEventDestinationRequest
) => any;
export declare const CreateConfigurationSetEventDestinationResponseFilterSensitiveLog: (
  obj: CreateConfigurationSetEventDestinationResponse
) => any;
export declare const TrackingOptionsFilterSensitiveLog: (
  obj: TrackingOptions
) => any;
export declare const CreateConfigurationSetTrackingOptionsRequestFilterSensitiveLog: (
  obj: CreateConfigurationSetTrackingOptionsRequest
) => any;
export declare const CreateConfigurationSetTrackingOptionsResponseFilterSensitiveLog: (
  obj: CreateConfigurationSetTrackingOptionsResponse
) => any;
export declare const CreateCustomVerificationEmailTemplateRequestFilterSensitiveLog: (
  obj: CreateCustomVerificationEmailTemplateRequest
) => any;
export declare const ReceiptIpFilterFilterSensitiveLog: (
  obj: ReceiptIpFilter
) => any;
export declare const ReceiptFilterFilterSensitiveLog: (
  obj: ReceiptFilter
) => any;
export declare const CreateReceiptFilterRequestFilterSensitiveLog: (
  obj: CreateReceiptFilterRequest
) => any;
export declare const CreateReceiptFilterResponseFilterSensitiveLog: (
  obj: CreateReceiptFilterResponse
) => any;
export declare const LambdaActionFilterSensitiveLog: (obj: LambdaAction) => any;
export declare const S3ActionFilterSensitiveLog: (obj: S3Action) => any;
export declare const SNSActionFilterSensitiveLog: (obj: SNSAction) => any;
export declare const StopActionFilterSensitiveLog: (obj: StopAction) => any;
export declare const WorkmailActionFilterSensitiveLog: (
  obj: WorkmailAction
) => any;
export declare const ReceiptActionFilterSensitiveLog: (
  obj: ReceiptAction
) => any;
export declare const ReceiptRuleFilterSensitiveLog: (obj: ReceiptRule) => any;
export declare const CreateReceiptRuleRequestFilterSensitiveLog: (
  obj: CreateReceiptRuleRequest
) => any;
export declare const CreateReceiptRuleResponseFilterSensitiveLog: (
  obj: CreateReceiptRuleResponse
) => any;
export declare const CreateReceiptRuleSetRequestFilterSensitiveLog: (
  obj: CreateReceiptRuleSetRequest
) => any;
export declare const CreateReceiptRuleSetResponseFilterSensitiveLog: (
  obj: CreateReceiptRuleSetResponse
) => any;
export declare const TemplateFilterSensitiveLog: (obj: Template) => any;
export declare const CreateTemplateRequestFilterSensitiveLog: (
  obj: CreateTemplateRequest
) => any;
export declare const CreateTemplateResponseFilterSensitiveLog: (
  obj: CreateTemplateResponse
) => any;
export declare const CustomVerificationEmailTemplateFilterSensitiveLog: (
  obj: CustomVerificationEmailTemplate
) => any;
export declare const DeleteConfigurationSetRequestFilterSensitiveLog: (
  obj: DeleteConfigurationSetRequest
) => any;
export declare const DeleteConfigurationSetResponseFilterSensitiveLog: (
  obj: DeleteConfigurationSetResponse
) => any;
export declare const DeleteConfigurationSetEventDestinationRequestFilterSensitiveLog: (
  obj: DeleteConfigurationSetEventDestinationRequest
) => any;
export declare const DeleteConfigurationSetEventDestinationResponseFilterSensitiveLog: (
  obj: DeleteConfigurationSetEventDestinationResponse
) => any;
export declare const DeleteConfigurationSetTrackingOptionsRequestFilterSensitiveLog: (
  obj: DeleteConfigurationSetTrackingOptionsRequest
) => any;
export declare const DeleteConfigurationSetTrackingOptionsResponseFilterSensitiveLog: (
  obj: DeleteConfigurationSetTrackingOptionsResponse
) => any;
export declare const DeleteCustomVerificationEmailTemplateRequestFilterSensitiveLog: (
  obj: DeleteCustomVerificationEmailTemplateRequest
) => any;
export declare const DeleteIdentityRequestFilterSensitiveLog: (
  obj: DeleteIdentityRequest
) => any;
export declare const DeleteIdentityResponseFilterSensitiveLog: (
  obj: DeleteIdentityResponse
) => any;
export declare const DeleteIdentityPolicyRequestFilterSensitiveLog: (
  obj: DeleteIdentityPolicyRequest
) => any;
export declare const DeleteIdentityPolicyResponseFilterSensitiveLog: (
  obj: DeleteIdentityPolicyResponse
) => any;
export declare const DeleteReceiptFilterRequestFilterSensitiveLog: (
  obj: DeleteReceiptFilterRequest
) => any;
export declare const DeleteReceiptFilterResponseFilterSensitiveLog: (
  obj: DeleteReceiptFilterResponse
) => any;
export declare const DeleteReceiptRuleRequestFilterSensitiveLog: (
  obj: DeleteReceiptRuleRequest
) => any;
export declare const DeleteReceiptRuleResponseFilterSensitiveLog: (
  obj: DeleteReceiptRuleResponse
) => any;
export declare const DeleteReceiptRuleSetRequestFilterSensitiveLog: (
  obj: DeleteReceiptRuleSetRequest
) => any;
export declare const DeleteReceiptRuleSetResponseFilterSensitiveLog: (
  obj: DeleteReceiptRuleSetResponse
) => any;
export declare const DeleteTemplateRequestFilterSensitiveLog: (
  obj: DeleteTemplateRequest
) => any;
export declare const DeleteTemplateResponseFilterSensitiveLog: (
  obj: DeleteTemplateResponse
) => any;
export declare const DeleteVerifiedEmailAddressRequestFilterSensitiveLog: (
  obj: DeleteVerifiedEmailAddressRequest
) => any;
export declare const DeliveryOptionsFilterSensitiveLog: (
  obj: DeliveryOptions
) => any;
export declare const DescribeActiveReceiptRuleSetRequestFilterSensitiveLog: (
  obj: DescribeActiveReceiptRuleSetRequest
) => any;
export declare const ReceiptRuleSetMetadataFilterSensitiveLog: (
  obj: ReceiptRuleSetMetadata
) => any;
export declare const DescribeActiveReceiptRuleSetResponseFilterSensitiveLog: (
  obj: DescribeActiveReceiptRuleSetResponse
) => any;
export declare const DescribeConfigurationSetRequestFilterSensitiveLog: (
  obj: DescribeConfigurationSetRequest
) => any;
export declare const ReputationOptionsFilterSensitiveLog: (
  obj: ReputationOptions
) => any;
export declare const DescribeConfigurationSetResponseFilterSensitiveLog: (
  obj: DescribeConfigurationSetResponse
) => any;
export declare const DescribeReceiptRuleRequestFilterSensitiveLog: (
  obj: DescribeReceiptRuleRequest
) => any;
export declare const DescribeReceiptRuleResponseFilterSensitiveLog: (
  obj: DescribeReceiptRuleResponse
) => any;
export declare const DescribeReceiptRuleSetRequestFilterSensitiveLog: (
  obj: DescribeReceiptRuleSetRequest
) => any;
export declare const DescribeReceiptRuleSetResponseFilterSensitiveLog: (
  obj: DescribeReceiptRuleSetResponse
) => any;
export declare const IdentityDkimAttributesFilterSensitiveLog: (
  obj: IdentityDkimAttributes
) => any;
export declare const GetAccountSendingEnabledResponseFilterSensitiveLog: (
  obj: GetAccountSendingEnabledResponse
) => any;
export declare const GetCustomVerificationEmailTemplateRequestFilterSensitiveLog: (
  obj: GetCustomVerificationEmailTemplateRequest
) => any;
export declare const GetCustomVerificationEmailTemplateResponseFilterSensitiveLog: (
  obj: GetCustomVerificationEmailTemplateResponse
) => any;
export declare const GetIdentityDkimAttributesRequestFilterSensitiveLog: (
  obj: GetIdentityDkimAttributesRequest
) => any;
export declare const GetIdentityDkimAttributesResponseFilterSensitiveLog: (
  obj: GetIdentityDkimAttributesResponse
) => any;
export declare const GetIdentityMailFromDomainAttributesRequestFilterSensitiveLog: (
  obj: GetIdentityMailFromDomainAttributesRequest
) => any;
export declare const IdentityMailFromDomainAttributesFilterSensitiveLog: (
  obj: IdentityMailFromDomainAttributes
) => any;
export declare const GetIdentityMailFromDomainAttributesResponseFilterSensitiveLog: (
  obj: GetIdentityMailFromDomainAttributesResponse
) => any;
export declare const GetIdentityNotificationAttributesRequestFilterSensitiveLog: (
  obj: GetIdentityNotificationAttributesRequest
) => any;
export declare const IdentityNotificationAttributesFilterSensitiveLog: (
  obj: IdentityNotificationAttributes
) => any;
export declare const GetIdentityNotificationAttributesResponseFilterSensitiveLog: (
  obj: GetIdentityNotificationAttributesResponse
) => any;
export declare const GetIdentityPoliciesRequestFilterSensitiveLog: (
  obj: GetIdentityPoliciesRequest
) => any;
export declare const GetIdentityPoliciesResponseFilterSensitiveLog: (
  obj: GetIdentityPoliciesResponse
) => any;
export declare const GetIdentityVerificationAttributesRequestFilterSensitiveLog: (
  obj: GetIdentityVerificationAttributesRequest
) => any;
export declare const IdentityVerificationAttributesFilterSensitiveLog: (
  obj: IdentityVerificationAttributes
) => any;
export declare const GetIdentityVerificationAttributesResponseFilterSensitiveLog: (
  obj: GetIdentityVerificationAttributesResponse
) => any;
export declare const GetSendQuotaResponseFilterSensitiveLog: (
  obj: GetSendQuotaResponse
) => any;
export declare const SendDataPointFilterSensitiveLog: (
  obj: SendDataPoint
) => any;
export declare const GetSendStatisticsResponseFilterSensitiveLog: (
  obj: GetSendStatisticsResponse
) => any;
export declare const GetTemplateRequestFilterSensitiveLog: (
  obj: GetTemplateRequest
) => any;
export declare const GetTemplateResponseFilterSensitiveLog: (
  obj: GetTemplateResponse
) => any;
export declare const ListConfigurationSetsRequestFilterSensitiveLog: (
  obj: ListConfigurationSetsRequest
) => any;
export declare const ListConfigurationSetsResponseFilterSensitiveLog: (
  obj: ListConfigurationSetsResponse
) => any;
export declare const ListCustomVerificationEmailTemplatesRequestFilterSensitiveLog: (
  obj: ListCustomVerificationEmailTemplatesRequest
) => any;
export declare const ListCustomVerificationEmailTemplatesResponseFilterSensitiveLog: (
  obj: ListCustomVerificationEmailTemplatesResponse
) => any;
export declare const ListIdentitiesRequestFilterSensitiveLog: (
  obj: ListIdentitiesRequest
) => any;
export declare const ListIdentitiesResponseFilterSensitiveLog: (
  obj: ListIdentitiesResponse
) => any;
export declare const ListIdentityPoliciesRequestFilterSensitiveLog: (
  obj: ListIdentityPoliciesRequest
) => any;
export declare const ListIdentityPoliciesResponseFilterSensitiveLog: (
  obj: ListIdentityPoliciesResponse
) => any;
export declare const ListReceiptFiltersRequestFilterSensitiveLog: (
  obj: ListReceiptFiltersRequest
) => any;
export declare const ListReceiptFiltersResponseFilterSensitiveLog: (
  obj: ListReceiptFiltersResponse
) => any;
export declare const ListReceiptRuleSetsRequestFilterSensitiveLog: (
  obj: ListReceiptRuleSetsRequest
) => any;
export declare const ListReceiptRuleSetsResponseFilterSensitiveLog: (
  obj: ListReceiptRuleSetsResponse
) => any;
export declare const ListTemplatesRequestFilterSensitiveLog: (
  obj: ListTemplatesRequest
) => any;
export declare const TemplateMetadataFilterSensitiveLog: (
  obj: TemplateMetadata
) => any;
export declare const ListTemplatesResponseFilterSensitiveLog: (
  obj: ListTemplatesResponse
) => any;
export declare const ListVerifiedEmailAddressesResponseFilterSensitiveLog: (
  obj: ListVerifiedEmailAddressesResponse
) => any;
export declare const MessageFilterSensitiveLog: (obj: Message) => any;
export declare const MessageDsnFilterSensitiveLog: (obj: MessageDsn) => any;
export declare const PutConfigurationSetDeliveryOptionsRequestFilterSensitiveLog: (
  obj: PutConfigurationSetDeliveryOptionsRequest
) => any;
export declare const PutConfigurationSetDeliveryOptionsResponseFilterSensitiveLog: (
  obj: PutConfigurationSetDeliveryOptionsResponse
) => any;
export declare const PutIdentityPolicyRequestFilterSensitiveLog: (
  obj: PutIdentityPolicyRequest
) => any;
export declare const PutIdentityPolicyResponseFilterSensitiveLog: (
  obj: PutIdentityPolicyResponse
) => any;
export declare const RawMessageFilterSensitiveLog: (obj: RawMessage) => any;
export declare const ReorderReceiptRuleSetRequestFilterSensitiveLog: (
  obj: ReorderReceiptRuleSetRequest
) => any;
export declare const ReorderReceiptRuleSetResponseFilterSensitiveLog: (
  obj: ReorderReceiptRuleSetResponse
) => any;
export declare const SendBounceRequestFilterSensitiveLog: (
  obj: SendBounceRequest
) => any;
export declare const SendBounceResponseFilterSensitiveLog: (
  obj: SendBounceResponse
) => any;
export declare const SendBulkTemplatedEmailRequestFilterSensitiveLog: (
  obj: SendBulkTemplatedEmailRequest
) => any;
export declare const SendBulkTemplatedEmailResponseFilterSensitiveLog: (
  obj: SendBulkTemplatedEmailResponse
) => any;
export declare const SendCustomVerificationEmailRequestFilterSensitiveLog: (
  obj: SendCustomVerificationEmailRequest
) => any;
export declare const SendCustomVerificationEmailResponseFilterSensitiveLog: (
  obj: SendCustomVerificationEmailResponse
) => any;
export declare const SendEmailRequestFilterSensitiveLog: (
  obj: SendEmailRequest
) => any;
export declare const SendEmailResponseFilterSensitiveLog: (
  obj: SendEmailResponse
) => any;
export declare const SendRawEmailRequestFilterSensitiveLog: (
  obj: SendRawEmailRequest
) => any;
export declare const SendRawEmailResponseFilterSensitiveLog: (
  obj: SendRawEmailResponse
) => any;
export declare const SendTemplatedEmailRequestFilterSensitiveLog: (
  obj: SendTemplatedEmailRequest
) => any;
export declare const SendTemplatedEmailResponseFilterSensitiveLog: (
  obj: SendTemplatedEmailResponse
) => any;
export declare const SetActiveReceiptRuleSetRequestFilterSensitiveLog: (
  obj: SetActiveReceiptRuleSetRequest
) => any;
export declare const SetActiveReceiptRuleSetResponseFilterSensitiveLog: (
  obj: SetActiveReceiptRuleSetResponse
) => any;
export declare const SetIdentityDkimEnabledRequestFilterSensitiveLog: (
  obj: SetIdentityDkimEnabledRequest
) => any;
export declare const SetIdentityDkimEnabledResponseFilterSensitiveLog: (
  obj: SetIdentityDkimEnabledResponse
) => any;
export declare const SetIdentityFeedbackForwardingEnabledRequestFilterSensitiveLog: (
  obj: SetIdentityFeedbackForwardingEnabledRequest
) => any;
export declare const SetIdentityFeedbackForwardingEnabledResponseFilterSensitiveLog: (
  obj: SetIdentityFeedbackForwardingEnabledResponse
) => any;
export declare const SetIdentityHeadersInNotificationsEnabledRequestFilterSensitiveLog: (
  obj: SetIdentityHeadersInNotificationsEnabledRequest
) => any;
export declare const SetIdentityHeadersInNotificationsEnabledResponseFilterSensitiveLog: (
  obj: SetIdentityHeadersInNotificationsEnabledResponse
) => any;
export declare const SetIdentityMailFromDomainRequestFilterSensitiveLog: (
  obj: SetIdentityMailFromDomainRequest
) => any;
export declare const SetIdentityMailFromDomainResponseFilterSensitiveLog: (
  obj: SetIdentityMailFromDomainResponse
) => any;
export declare const SetIdentityNotificationTopicRequestFilterSensitiveLog: (
  obj: SetIdentityNotificationTopicRequest
) => any;
export declare const SetIdentityNotificationTopicResponseFilterSensitiveLog: (
  obj: SetIdentityNotificationTopicResponse
) => any;
export declare const SetReceiptRulePositionRequestFilterSensitiveLog: (
  obj: SetReceiptRulePositionRequest
) => any;
export declare const SetReceiptRulePositionResponseFilterSensitiveLog: (
  obj: SetReceiptRulePositionResponse
) => any;
export declare const TestRenderTemplateRequestFilterSensitiveLog: (
  obj: TestRenderTemplateRequest
) => any;
export declare const TestRenderTemplateResponseFilterSensitiveLog: (
  obj: TestRenderTemplateResponse
) => any;
export declare const UpdateAccountSendingEnabledRequestFilterSensitiveLog: (
  obj: UpdateAccountSendingEnabledRequest
) => any;
export declare const UpdateConfigurationSetEventDestinationRequestFilterSensitiveLog: (
  obj: UpdateConfigurationSetEventDestinationRequest
) => any;
export declare const UpdateConfigurationSetEventDestinationResponseFilterSensitiveLog: (
  obj: UpdateConfigurationSetEventDestinationResponse
) => any;
export declare const UpdateConfigurationSetReputationMetricsEnabledRequestFilterSensitiveLog: (
  obj: UpdateConfigurationSetReputationMetricsEnabledRequest
) => any;
export declare const UpdateConfigurationSetSendingEnabledRequestFilterSensitiveLog: (
  obj: UpdateConfigurationSetSendingEnabledRequest
) => any;
export declare const UpdateConfigurationSetTrackingOptionsRequestFilterSensitiveLog: (
  obj: UpdateConfigurationSetTrackingOptionsRequest
) => any;
export declare const UpdateConfigurationSetTrackingOptionsResponseFilterSensitiveLog: (
  obj: UpdateConfigurationSetTrackingOptionsResponse
) => any;
export declare const UpdateCustomVerificationEmailTemplateRequestFilterSensitiveLog: (
  obj: UpdateCustomVerificationEmailTemplateRequest
) => any;
export declare const UpdateReceiptRuleRequestFilterSensitiveLog: (
  obj: UpdateReceiptRuleRequest
) => any;
export declare const UpdateReceiptRuleResponseFilterSensitiveLog: (
  obj: UpdateReceiptRuleResponse
) => any;
export declare const UpdateTemplateRequestFilterSensitiveLog: (
  obj: UpdateTemplateRequest
) => any;
export declare const UpdateTemplateResponseFilterSensitiveLog: (
  obj: UpdateTemplateResponse
) => any;
export declare const VerifyDomainDkimRequestFilterSensitiveLog: (
  obj: VerifyDomainDkimRequest
) => any;
export declare const VerifyDomainDkimResponseFilterSensitiveLog: (
  obj: VerifyDomainDkimResponse
) => any;
export declare const VerifyDomainIdentityRequestFilterSensitiveLog: (
  obj: VerifyDomainIdentityRequest
) => any;
export declare const VerifyDomainIdentityResponseFilterSensitiveLog: (
  obj: VerifyDomainIdentityResponse
) => any;
export declare const VerifyEmailAddressRequestFilterSensitiveLog: (
  obj: VerifyEmailAddressRequest
) => any;
export declare const VerifyEmailIdentityRequestFilterSensitiveLog: (
  obj: VerifyEmailIdentityRequest
) => any;
export declare const VerifyEmailIdentityResponseFilterSensitiveLog: (
  obj: VerifyEmailIdentityResponse
) => any;
