import { SESServiceException as __BaseException } from "./SESServiceException";
export class AccountSendingPausedException extends __BaseException {
    constructor(opts) {
        super({
            name: "AccountSendingPausedException",
            $fault: "client",
            ...opts,
        });
        this.name = "AccountSendingPausedException";
        this.$fault = "client";
        Object.setPrototypeOf(this, AccountSendingPausedException.prototype);
    }
}
export class AlreadyExistsException extends __BaseException {
    constructor(opts) {
        super({
            name: "AlreadyExistsException",
            $fault: "client",
            ...opts,
        });
        this.name = "AlreadyExistsException";
        this.$fault = "client";
        Object.setPrototypeOf(this, AlreadyExistsException.prototype);
        this.Name = opts.Name;
    }
}
export var BehaviorOnMXFailure;
(function (BehaviorOnMXFailure) {
    BehaviorOnMXFailure["RejectMessage"] = "RejectMessage";
    BehaviorOnMXFailure["UseDefaultValue"] = "UseDefaultValue";
})(BehaviorOnMXFailure || (BehaviorOnMXFailure = {}));
export var BounceType;
(function (BounceType) {
    BounceType["ContentRejected"] = "ContentRejected";
    BounceType["DoesNotExist"] = "DoesNotExist";
    BounceType["ExceededQuota"] = "ExceededQuota";
    BounceType["MessageTooLarge"] = "MessageTooLarge";
    BounceType["TemporaryFailure"] = "TemporaryFailure";
    BounceType["Undefined"] = "Undefined";
})(BounceType || (BounceType = {}));
export var DsnAction;
(function (DsnAction) {
    DsnAction["DELAYED"] = "delayed";
    DsnAction["DELIVERED"] = "delivered";
    DsnAction["EXPANDED"] = "expanded";
    DsnAction["FAILED"] = "failed";
    DsnAction["RELAYED"] = "relayed";
})(DsnAction || (DsnAction = {}));
export var BulkEmailStatus;
(function (BulkEmailStatus) {
    BulkEmailStatus["AccountDailyQuotaExceeded"] = "AccountDailyQuotaExceeded";
    BulkEmailStatus["AccountSendingPaused"] = "AccountSendingPaused";
    BulkEmailStatus["AccountSuspended"] = "AccountSuspended";
    BulkEmailStatus["AccountThrottled"] = "AccountThrottled";
    BulkEmailStatus["ConfigurationSetDoesNotExist"] = "ConfigurationSetDoesNotExist";
    BulkEmailStatus["ConfigurationSetSendingPaused"] = "ConfigurationSetSendingPaused";
    BulkEmailStatus["Failed"] = "Failed";
    BulkEmailStatus["InvalidParameterValue"] = "InvalidParameterValue";
    BulkEmailStatus["InvalidSendingPoolName"] = "InvalidSendingPoolName";
    BulkEmailStatus["MailFromDomainNotVerified"] = "MailFromDomainNotVerified";
    BulkEmailStatus["MessageRejected"] = "MessageRejected";
    BulkEmailStatus["Success"] = "Success";
    BulkEmailStatus["TemplateDoesNotExist"] = "TemplateDoesNotExist";
    BulkEmailStatus["TransientFailure"] = "TransientFailure";
})(BulkEmailStatus || (BulkEmailStatus = {}));
export class CannotDeleteException extends __BaseException {
    constructor(opts) {
        super({
            name: "CannotDeleteException",
            $fault: "client",
            ...opts,
        });
        this.name = "CannotDeleteException";
        this.$fault = "client";
        Object.setPrototypeOf(this, CannotDeleteException.prototype);
        this.Name = opts.Name;
    }
}
export class LimitExceededException extends __BaseException {
    constructor(opts) {
        super({
            name: "LimitExceededException",
            $fault: "client",
            ...opts,
        });
        this.name = "LimitExceededException";
        this.$fault = "client";
        Object.setPrototypeOf(this, LimitExceededException.prototype);
    }
}
export class RuleSetDoesNotExistException extends __BaseException {
    constructor(opts) {
        super({
            name: "RuleSetDoesNotExistException",
            $fault: "client",
            ...opts,
        });
        this.name = "RuleSetDoesNotExistException";
        this.$fault = "client";
        Object.setPrototypeOf(this, RuleSetDoesNotExistException.prototype);
        this.Name = opts.Name;
    }
}
export var DimensionValueSource;
(function (DimensionValueSource) {
    DimensionValueSource["EMAIL_HEADER"] = "emailHeader";
    DimensionValueSource["LINK_TAG"] = "linkTag";
    DimensionValueSource["MESSAGE_TAG"] = "messageTag";
})(DimensionValueSource || (DimensionValueSource = {}));
export class ConfigurationSetAlreadyExistsException extends __BaseException {
    constructor(opts) {
        super({
            name: "ConfigurationSetAlreadyExistsException",
            $fault: "client",
            ...opts,
        });
        this.name = "ConfigurationSetAlreadyExistsException";
        this.$fault = "client";
        Object.setPrototypeOf(this, ConfigurationSetAlreadyExistsException.prototype);
        this.ConfigurationSetName = opts.ConfigurationSetName;
    }
}
export var ConfigurationSetAttribute;
(function (ConfigurationSetAttribute) {
    ConfigurationSetAttribute["DELIVERY_OPTIONS"] = "deliveryOptions";
    ConfigurationSetAttribute["EVENT_DESTINATIONS"] = "eventDestinations";
    ConfigurationSetAttribute["REPUTATION_OPTIONS"] = "reputationOptions";
    ConfigurationSetAttribute["TRACKING_OPTIONS"] = "trackingOptions";
})(ConfigurationSetAttribute || (ConfigurationSetAttribute = {}));
export class ConfigurationSetDoesNotExistException extends __BaseException {
    constructor(opts) {
        super({
            name: "ConfigurationSetDoesNotExistException",
            $fault: "client",
            ...opts,
        });
        this.name = "ConfigurationSetDoesNotExistException";
        this.$fault = "client";
        Object.setPrototypeOf(this, ConfigurationSetDoesNotExistException.prototype);
        this.ConfigurationSetName = opts.ConfigurationSetName;
    }
}
export class ConfigurationSetSendingPausedException extends __BaseException {
    constructor(opts) {
        super({
            name: "ConfigurationSetSendingPausedException",
            $fault: "client",
            ...opts,
        });
        this.name = "ConfigurationSetSendingPausedException";
        this.$fault = "client";
        Object.setPrototypeOf(this, ConfigurationSetSendingPausedException.prototype);
        this.ConfigurationSetName = opts.ConfigurationSetName;
    }
}
export class InvalidConfigurationSetException extends __BaseException {
    constructor(opts) {
        super({
            name: "InvalidConfigurationSetException",
            $fault: "client",
            ...opts,
        });
        this.name = "InvalidConfigurationSetException";
        this.$fault = "client";
        Object.setPrototypeOf(this, InvalidConfigurationSetException.prototype);
    }
}
export var EventType;
(function (EventType) {
    EventType["BOUNCE"] = "bounce";
    EventType["CLICK"] = "click";
    EventType["COMPLAINT"] = "complaint";
    EventType["DELIVERY"] = "delivery";
    EventType["OPEN"] = "open";
    EventType["REJECT"] = "reject";
    EventType["RENDERING_FAILURE"] = "renderingFailure";
    EventType["SEND"] = "send";
})(EventType || (EventType = {}));
export class EventDestinationAlreadyExistsException extends __BaseException {
    constructor(opts) {
        super({
            name: "EventDestinationAlreadyExistsException",
            $fault: "client",
            ...opts,
        });
        this.name = "EventDestinationAlreadyExistsException";
        this.$fault = "client";
        Object.setPrototypeOf(this, EventDestinationAlreadyExistsException.prototype);
        this.ConfigurationSetName = opts.ConfigurationSetName;
        this.EventDestinationName = opts.EventDestinationName;
    }
}
export class InvalidCloudWatchDestinationException extends __BaseException {
    constructor(opts) {
        super({
            name: "InvalidCloudWatchDestinationException",
            $fault: "client",
            ...opts,
        });
        this.name = "InvalidCloudWatchDestinationException";
        this.$fault = "client";
        Object.setPrototypeOf(this, InvalidCloudWatchDestinationException.prototype);
        this.ConfigurationSetName = opts.ConfigurationSetName;
        this.EventDestinationName = opts.EventDestinationName;
    }
}
export class InvalidFirehoseDestinationException extends __BaseException {
    constructor(opts) {
        super({
            name: "InvalidFirehoseDestinationException",
            $fault: "client",
            ...opts,
        });
        this.name = "InvalidFirehoseDestinationException";
        this.$fault = "client";
        Object.setPrototypeOf(this, InvalidFirehoseDestinationException.prototype);
        this.ConfigurationSetName = opts.ConfigurationSetName;
        this.EventDestinationName = opts.EventDestinationName;
    }
}
export class InvalidSNSDestinationException extends __BaseException {
    constructor(opts) {
        super({
            name: "InvalidSNSDestinationException",
            $fault: "client",
            ...opts,
        });
        this.name = "InvalidSNSDestinationException";
        this.$fault = "client";
        Object.setPrototypeOf(this, InvalidSNSDestinationException.prototype);
        this.ConfigurationSetName = opts.ConfigurationSetName;
        this.EventDestinationName = opts.EventDestinationName;
    }
}
export class InvalidTrackingOptionsException extends __BaseException {
    constructor(opts) {
        super({
            name: "InvalidTrackingOptionsException",
            $fault: "client",
            ...opts,
        });
        this.name = "InvalidTrackingOptionsException";
        this.$fault = "client";
        Object.setPrototypeOf(this, InvalidTrackingOptionsException.prototype);
    }
}
export class TrackingOptionsAlreadyExistsException extends __BaseException {
    constructor(opts) {
        super({
            name: "TrackingOptionsAlreadyExistsException",
            $fault: "client",
            ...opts,
        });
        this.name = "TrackingOptionsAlreadyExistsException";
        this.$fault = "client";
        Object.setPrototypeOf(this, TrackingOptionsAlreadyExistsException.prototype);
        this.ConfigurationSetName = opts.ConfigurationSetName;
    }
}
export class CustomVerificationEmailInvalidContentException extends __BaseException {
    constructor(opts) {
        super({
            name: "CustomVerificationEmailInvalidContentException",
            $fault: "client",
            ...opts,
        });
        this.name = "CustomVerificationEmailInvalidContentException";
        this.$fault = "client";
        Object.setPrototypeOf(this, CustomVerificationEmailInvalidContentException.prototype);
    }
}
export class CustomVerificationEmailTemplateAlreadyExistsException extends __BaseException {
    constructor(opts) {
        super({
            name: "CustomVerificationEmailTemplateAlreadyExistsException",
            $fault: "client",
            ...opts,
        });
        this.name = "CustomVerificationEmailTemplateAlreadyExistsException";
        this.$fault = "client";
        Object.setPrototypeOf(this, CustomVerificationEmailTemplateAlreadyExistsException.prototype);
        this.CustomVerificationEmailTemplateName = opts.CustomVerificationEmailTemplateName;
    }
}
export class FromEmailAddressNotVerifiedException extends __BaseException {
    constructor(opts) {
        super({
            name: "FromEmailAddressNotVerifiedException",
            $fault: "client",
            ...opts,
        });
        this.name = "FromEmailAddressNotVerifiedException";
        this.$fault = "client";
        Object.setPrototypeOf(this, FromEmailAddressNotVerifiedException.prototype);
        this.FromEmailAddress = opts.FromEmailAddress;
    }
}
export var ReceiptFilterPolicy;
(function (ReceiptFilterPolicy) {
    ReceiptFilterPolicy["Allow"] = "Allow";
    ReceiptFilterPolicy["Block"] = "Block";
})(ReceiptFilterPolicy || (ReceiptFilterPolicy = {}));
export var SNSActionEncoding;
(function (SNSActionEncoding) {
    SNSActionEncoding["Base64"] = "Base64";
    SNSActionEncoding["UTF8"] = "UTF-8";
})(SNSActionEncoding || (SNSActionEncoding = {}));
export var StopScope;
(function (StopScope) {
    StopScope["RULE_SET"] = "RuleSet";
})(StopScope || (StopScope = {}));
export var TlsPolicy;
(function (TlsPolicy) {
    TlsPolicy["Optional"] = "Optional";
    TlsPolicy["Require"] = "Require";
})(TlsPolicy || (TlsPolicy = {}));
export class InvalidLambdaFunctionException extends __BaseException {
    constructor(opts) {
        super({
            name: "InvalidLambdaFunctionException",
            $fault: "client",
            ...opts,
        });
        this.name = "InvalidLambdaFunctionException";
        this.$fault = "client";
        Object.setPrototypeOf(this, InvalidLambdaFunctionException.prototype);
        this.FunctionArn = opts.FunctionArn;
    }
}
export class InvalidS3ConfigurationException extends __BaseException {
    constructor(opts) {
        super({
            name: "InvalidS3ConfigurationException",
            $fault: "client",
            ...opts,
        });
        this.name = "InvalidS3ConfigurationException";
        this.$fault = "client";
        Object.setPrototypeOf(this, InvalidS3ConfigurationException.prototype);
        this.Bucket = opts.Bucket;
    }
}
export class InvalidSnsTopicException extends __BaseException {
    constructor(opts) {
        super({
            name: "InvalidSnsTopicException",
            $fault: "client",
            ...opts,
        });
        this.name = "InvalidSnsTopicException";
        this.$fault = "client";
        Object.setPrototypeOf(this, InvalidSnsTopicException.prototype);
        this.Topic = opts.Topic;
    }
}
export class RuleDoesNotExistException extends __BaseException {
    constructor(opts) {
        super({
            name: "RuleDoesNotExistException",
            $fault: "client",
            ...opts,
        });
        this.name = "RuleDoesNotExistException";
        this.$fault = "client";
        Object.setPrototypeOf(this, RuleDoesNotExistException.prototype);
        this.Name = opts.Name;
    }
}
export class InvalidTemplateException extends __BaseException {
    constructor(opts) {
        super({
            name: "InvalidTemplateException",
            $fault: "client",
            ...opts,
        });
        this.name = "InvalidTemplateException";
        this.$fault = "client";
        Object.setPrototypeOf(this, InvalidTemplateException.prototype);
        this.TemplateName = opts.TemplateName;
    }
}
export var CustomMailFromStatus;
(function (CustomMailFromStatus) {
    CustomMailFromStatus["Failed"] = "Failed";
    CustomMailFromStatus["Pending"] = "Pending";
    CustomMailFromStatus["Success"] = "Success";
    CustomMailFromStatus["TemporaryFailure"] = "TemporaryFailure";
})(CustomMailFromStatus || (CustomMailFromStatus = {}));
export class CustomVerificationEmailTemplateDoesNotExistException extends __BaseException {
    constructor(opts) {
        super({
            name: "CustomVerificationEmailTemplateDoesNotExistException",
            $fault: "client",
            ...opts,
        });
        this.name = "CustomVerificationEmailTemplateDoesNotExistException";
        this.$fault = "client";
        Object.setPrototypeOf(this, CustomVerificationEmailTemplateDoesNotExistException.prototype);
        this.CustomVerificationEmailTemplateName = opts.CustomVerificationEmailTemplateName;
    }
}
export class EventDestinationDoesNotExistException extends __BaseException {
    constructor(opts) {
        super({
            name: "EventDestinationDoesNotExistException",
            $fault: "client",
            ...opts,
        });
        this.name = "EventDestinationDoesNotExistException";
        this.$fault = "client";
        Object.setPrototypeOf(this, EventDestinationDoesNotExistException.prototype);
        this.ConfigurationSetName = opts.ConfigurationSetName;
        this.EventDestinationName = opts.EventDestinationName;
    }
}
export class TrackingOptionsDoesNotExistException extends __BaseException {
    constructor(opts) {
        super({
            name: "TrackingOptionsDoesNotExistException",
            $fault: "client",
            ...opts,
        });
        this.name = "TrackingOptionsDoesNotExistException";
        this.$fault = "client";
        Object.setPrototypeOf(this, TrackingOptionsDoesNotExistException.prototype);
        this.ConfigurationSetName = opts.ConfigurationSetName;
    }
}
export class TemplateDoesNotExistException extends __BaseException {
    constructor(opts) {
        super({
            name: "TemplateDoesNotExistException",
            $fault: "client",
            ...opts,
        });
        this.name = "TemplateDoesNotExistException";
        this.$fault = "client";
        Object.setPrototypeOf(this, TemplateDoesNotExistException.prototype);
        this.TemplateName = opts.TemplateName;
    }
}
export class InvalidDeliveryOptionsException extends __BaseException {
    constructor(opts) {
        super({
            name: "InvalidDeliveryOptionsException",
            $fault: "client",
            ...opts,
        });
        this.name = "InvalidDeliveryOptionsException";
        this.$fault = "client";
        Object.setPrototypeOf(this, InvalidDeliveryOptionsException.prototype);
    }
}
export class InvalidPolicyException extends __BaseException {
    constructor(opts) {
        super({
            name: "InvalidPolicyException",
            $fault: "client",
            ...opts,
        });
        this.name = "InvalidPolicyException";
        this.$fault = "client";
        Object.setPrototypeOf(this, InvalidPolicyException.prototype);
    }
}
export class InvalidRenderingParameterException extends __BaseException {
    constructor(opts) {
        super({
            name: "InvalidRenderingParameterException",
            $fault: "client",
            ...opts,
        });
        this.name = "InvalidRenderingParameterException";
        this.$fault = "client";
        Object.setPrototypeOf(this, InvalidRenderingParameterException.prototype);
        this.TemplateName = opts.TemplateName;
    }
}
export class MailFromDomainNotVerifiedException extends __BaseException {
    constructor(opts) {
        super({
            name: "MailFromDomainNotVerifiedException",
            $fault: "client",
            ...opts,
        });
        this.name = "MailFromDomainNotVerifiedException";
        this.$fault = "client";
        Object.setPrototypeOf(this, MailFromDomainNotVerifiedException.prototype);
    }
}
export class MessageRejected extends __BaseException {
    constructor(opts) {
        super({
            name: "MessageRejected",
            $fault: "client",
            ...opts,
        });
        this.name = "MessageRejected";
        this.$fault = "client";
        Object.setPrototypeOf(this, MessageRejected.prototype);
    }
}
export class MissingRenderingAttributeException extends __BaseException {
    constructor(opts) {
        super({
            name: "MissingRenderingAttributeException",
            $fault: "client",
            ...opts,
        });
        this.name = "MissingRenderingAttributeException";
        this.$fault = "client";
        Object.setPrototypeOf(this, MissingRenderingAttributeException.prototype);
        this.TemplateName = opts.TemplateName;
    }
}
export class ProductionAccessNotGrantedException extends __BaseException {
    constructor(opts) {
        super({
            name: "ProductionAccessNotGrantedException",
            $fault: "client",
            ...opts,
        });
        this.name = "ProductionAccessNotGrantedException";
        this.$fault = "client";
        Object.setPrototypeOf(this, ProductionAccessNotGrantedException.prototype);
    }
}
export const AddHeaderActionFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const ContentFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const BodyFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const BounceActionFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const ExtensionFieldFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const RecipientDsnFieldsFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const BouncedRecipientInfoFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const DestinationFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const MessageTagFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const BulkEmailDestinationFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const BulkEmailDestinationStatusFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const CloneReceiptRuleSetRequestFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const CloneReceiptRuleSetResponseFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const CloudWatchDimensionConfigurationFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const CloudWatchDestinationFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const ConfigurationSetFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const CreateConfigurationSetRequestFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const CreateConfigurationSetResponseFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const KinesisFirehoseDestinationFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const SNSDestinationFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const EventDestinationFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const CreateConfigurationSetEventDestinationRequestFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const CreateConfigurationSetEventDestinationResponseFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const TrackingOptionsFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const CreateConfigurationSetTrackingOptionsRequestFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const CreateConfigurationSetTrackingOptionsResponseFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const CreateCustomVerificationEmailTemplateRequestFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const ReceiptIpFilterFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const ReceiptFilterFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const CreateReceiptFilterRequestFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const CreateReceiptFilterResponseFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const LambdaActionFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const S3ActionFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const SNSActionFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const StopActionFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const WorkmailActionFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const ReceiptActionFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const ReceiptRuleFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const CreateReceiptRuleRequestFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const CreateReceiptRuleResponseFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const CreateReceiptRuleSetRequestFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const CreateReceiptRuleSetResponseFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const TemplateFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const CreateTemplateRequestFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const CreateTemplateResponseFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const CustomVerificationEmailTemplateFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const DeleteConfigurationSetRequestFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const DeleteConfigurationSetResponseFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const DeleteConfigurationSetEventDestinationRequestFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const DeleteConfigurationSetEventDestinationResponseFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const DeleteConfigurationSetTrackingOptionsRequestFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const DeleteConfigurationSetTrackingOptionsResponseFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const DeleteCustomVerificationEmailTemplateRequestFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const DeleteIdentityRequestFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const DeleteIdentityResponseFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const DeleteIdentityPolicyRequestFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const DeleteIdentityPolicyResponseFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const DeleteReceiptFilterRequestFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const DeleteReceiptFilterResponseFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const DeleteReceiptRuleRequestFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const DeleteReceiptRuleResponseFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const DeleteReceiptRuleSetRequestFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const DeleteReceiptRuleSetResponseFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const DeleteTemplateRequestFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const DeleteTemplateResponseFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const DeleteVerifiedEmailAddressRequestFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const DeliveryOptionsFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const DescribeActiveReceiptRuleSetRequestFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const ReceiptRuleSetMetadataFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const DescribeActiveReceiptRuleSetResponseFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const DescribeConfigurationSetRequestFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const ReputationOptionsFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const DescribeConfigurationSetResponseFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const DescribeReceiptRuleRequestFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const DescribeReceiptRuleResponseFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const DescribeReceiptRuleSetRequestFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const DescribeReceiptRuleSetResponseFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const IdentityDkimAttributesFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const GetAccountSendingEnabledResponseFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const GetCustomVerificationEmailTemplateRequestFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const GetCustomVerificationEmailTemplateResponseFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const GetIdentityDkimAttributesRequestFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const GetIdentityDkimAttributesResponseFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const GetIdentityMailFromDomainAttributesRequestFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const IdentityMailFromDomainAttributesFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const GetIdentityMailFromDomainAttributesResponseFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const GetIdentityNotificationAttributesRequestFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const IdentityNotificationAttributesFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const GetIdentityNotificationAttributesResponseFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const GetIdentityPoliciesRequestFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const GetIdentityPoliciesResponseFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const GetIdentityVerificationAttributesRequestFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const IdentityVerificationAttributesFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const GetIdentityVerificationAttributesResponseFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const GetSendQuotaResponseFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const SendDataPointFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const GetSendStatisticsResponseFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const GetTemplateRequestFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const GetTemplateResponseFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const ListConfigurationSetsRequestFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const ListConfigurationSetsResponseFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const ListCustomVerificationEmailTemplatesRequestFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const ListCustomVerificationEmailTemplatesResponseFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const ListIdentitiesRequestFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const ListIdentitiesResponseFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const ListIdentityPoliciesRequestFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const ListIdentityPoliciesResponseFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const ListReceiptFiltersRequestFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const ListReceiptFiltersResponseFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const ListReceiptRuleSetsRequestFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const ListReceiptRuleSetsResponseFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const ListTemplatesRequestFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const TemplateMetadataFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const ListTemplatesResponseFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const ListVerifiedEmailAddressesResponseFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const MessageFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const MessageDsnFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const PutConfigurationSetDeliveryOptionsRequestFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const PutConfigurationSetDeliveryOptionsResponseFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const PutIdentityPolicyRequestFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const PutIdentityPolicyResponseFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const RawMessageFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const ReorderReceiptRuleSetRequestFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const ReorderReceiptRuleSetResponseFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const SendBounceRequestFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const SendBounceResponseFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const SendBulkTemplatedEmailRequestFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const SendBulkTemplatedEmailResponseFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const SendCustomVerificationEmailRequestFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const SendCustomVerificationEmailResponseFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const SendEmailRequestFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const SendEmailResponseFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const SendRawEmailRequestFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const SendRawEmailResponseFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const SendTemplatedEmailRequestFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const SendTemplatedEmailResponseFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const SetActiveReceiptRuleSetRequestFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const SetActiveReceiptRuleSetResponseFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const SetIdentityDkimEnabledRequestFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const SetIdentityDkimEnabledResponseFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const SetIdentityFeedbackForwardingEnabledRequestFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const SetIdentityFeedbackForwardingEnabledResponseFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const SetIdentityHeadersInNotificationsEnabledRequestFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const SetIdentityHeadersInNotificationsEnabledResponseFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const SetIdentityMailFromDomainRequestFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const SetIdentityMailFromDomainResponseFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const SetIdentityNotificationTopicRequestFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const SetIdentityNotificationTopicResponseFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const SetReceiptRulePositionRequestFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const SetReceiptRulePositionResponseFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const TestRenderTemplateRequestFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const TestRenderTemplateResponseFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const UpdateAccountSendingEnabledRequestFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const UpdateConfigurationSetEventDestinationRequestFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const UpdateConfigurationSetEventDestinationResponseFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const UpdateConfigurationSetReputationMetricsEnabledRequestFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const UpdateConfigurationSetSendingEnabledRequestFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const UpdateConfigurationSetTrackingOptionsRequestFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const UpdateConfigurationSetTrackingOptionsResponseFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const UpdateCustomVerificationEmailTemplateRequestFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const UpdateReceiptRuleRequestFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const UpdateReceiptRuleResponseFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const UpdateTemplateRequestFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const UpdateTemplateResponseFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const VerifyDomainDkimRequestFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const VerifyDomainDkimResponseFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const VerifyDomainIdentityRequestFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const VerifyDomainIdentityResponseFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const VerifyEmailAddressRequestFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const VerifyEmailIdentityRequestFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const VerifyEmailIdentityResponseFilterSensitiveLog = (obj) => ({
    ...obj,
});
