import { getEndpointPlugin } from "@aws-sdk/middleware-endpoint";
import { getSerdePlugin } from "@aws-sdk/middleware-serde";
import { Command as $Command } from "@aws-sdk/smithy-client";
import { SetIdentityFeedbackForwardingEnabledRequestFilterSensitiveLog, SetIdentityFeedbackForwardingEnabledResponseFilterSensitiveLog, } from "../models/models_0";
import { deserializeAws_querySetIdentityFeedbackForwardingEnabledCommand, serializeAws_querySetIdentityFeedbackForwardingEnabledCommand, } from "../protocols/Aws_query";
export class SetIdentityFeedbackForwardingEnabledCommand extends $Command {
    constructor(input) {
        super();
        this.input = input;
    }
    static getEndpointParameterInstructions() {
        return {
            UseFIPS: { type: "builtInParams", name: "useFipsEndpoint" },
            Endpoint: { type: "builtInParams", name: "endpoint" },
            Region: { type: "builtInParams", name: "region" },
            UseDualStack: { type: "builtInParams", name: "useDualstackEndpoint" },
        };
    }
    resolveMiddleware(clientStack, configuration, options) {
        this.middlewareStack.use(getSerdePlugin(configuration, this.serialize, this.deserialize));
        this.middlewareStack.use(getEndpointPlugin(configuration, SetIdentityFeedbackForwardingEnabledCommand.getEndpointParameterInstructions()));
        const stack = clientStack.concat(this.middlewareStack);
        const { logger } = configuration;
        const clientName = "SESClient";
        const commandName = "SetIdentityFeedbackForwardingEnabledCommand";
        const handlerExecutionContext = {
            logger,
            clientName,
            commandName,
            inputFilterSensitiveLog: SetIdentityFeedbackForwardingEnabledRequestFilterSensitiveLog,
            outputFilterSensitiveLog: SetIdentityFeedbackForwardingEnabledResponseFilterSensitiveLog,
        };
        const { requestHandler } = configuration;
        return stack.resolve((request) => requestHandler.handle(request.request, options || {}), handlerExecutionContext);
    }
    serialize(input, context) {
        return serializeAws_querySetIdentityFeedbackForwardingEnabledCommand(input, context);
    }
    deserialize(output, context) {
        return deserializeAws_querySetIdentityFeedbackForwardingEnabledCommand(output, context);
    }
}
