import { getEndpointPlugin } from "@aws-sdk/middleware-endpoint";
import { getSerdePlugin } from "@aws-sdk/middleware-serde";
import { Command as $Command } from "@aws-sdk/smithy-client";
import { SendBulkTemplatedEmailRequestFilterSensitiveLog, SendBulkTemplatedEmailResponseFilterSensitiveLog, } from "../models/models_0";
import { deserializeAws_querySendBulkTemplatedEmailCommand, serializeAws_querySendBulkTemplatedEmailCommand, } from "../protocols/Aws_query";
export class SendBulkTemplatedEmailCommand extends $Command {
    constructor(input) {
        super();
        this.input = input;
    }
    static getEndpointParameterInstructions() {
        return {
            UseFIPS: { type: "builtInParams", name: "useFipsEndpoint" },
            Endpoint: { type: "builtInParams", name: "endpoint" },
            Region: { type: "builtInParams", name: "region" },
            UseDualStack: { type: "builtInParams", name: "useDualstackEndpoint" },
        };
    }
    resolveMiddleware(clientStack, configuration, options) {
        this.middlewareStack.use(getSerdePlugin(configuration, this.serialize, this.deserialize));
        this.middlewareStack.use(getEndpointPlugin(configuration, SendBulkTemplatedEmailCommand.getEndpointParameterInstructions()));
        const stack = clientStack.concat(this.middlewareStack);
        const { logger } = configuration;
        const clientName = "SESClient";
        const commandName = "SendBulkTemplatedEmailCommand";
        const handlerExecutionContext = {
            logger,
            clientName,
            commandName,
            inputFilterSensitiveLog: SendBulkTemplatedEmailRequestFilterSensitiveLog,
            outputFilterSensitiveLog: SendBulkTemplatedEmailResponseFilterSensitiveLog,
        };
        const { requestHandler } = configuration;
        return stack.resolve((request) => requestHandler.handle(request.request, options || {}), handlerExecutionContext);
    }
    serialize(input, context) {
        return serializeAws_querySendBulkTemplatedEmailCommand(input, context);
    }
    deserialize(output, context) {
        return deserializeAws_querySendBulkTemplatedEmailCommand(output, context);
    }
}
