import { getEndpointPlugin } from "@aws-sdk/middleware-endpoint";
import { getSerdePlugin } from "@aws-sdk/middleware-serde";
import { Command as $Command } from "@aws-sdk/smithy-client";
import { ListIdentityPoliciesRequestFilterSensitiveLog, ListIdentityPoliciesResponseFilterSensitiveLog, } from "../models/models_0";
import { deserializeAws_queryListIdentityPoliciesCommand, serializeAws_queryListIdentityPoliciesCommand, } from "../protocols/Aws_query";
export class ListIdentityPoliciesCommand extends $Command {
    constructor(input) {
        super();
        this.input = input;
    }
    static getEndpointParameterInstructions() {
        return {
            UseFIPS: { type: "builtInParams", name: "useFipsEndpoint" },
            Endpoint: { type: "builtInParams", name: "endpoint" },
            Region: { type: "builtInParams", name: "region" },
            UseDualStack: { type: "builtInParams", name: "useDualstackEndpoint" },
        };
    }
    resolveMiddleware(clientStack, configuration, options) {
        this.middlewareStack.use(getSerdePlugin(configuration, this.serialize, this.deserialize));
        this.middlewareStack.use(getEndpointPlugin(configuration, ListIdentityPoliciesCommand.getEndpointParameterInstructions()));
        const stack = clientStack.concat(this.middlewareStack);
        const { logger } = configuration;
        const clientName = "SESClient";
        const commandName = "ListIdentityPoliciesCommand";
        const handlerExecutionContext = {
            logger,
            clientName,
            commandName,
            inputFilterSensitiveLog: ListIdentityPoliciesRequestFilterSensitiveLog,
            outputFilterSensitiveLog: ListIdentityPoliciesResponseFilterSensitiveLog,
        };
        const { requestHandler } = configuration;
        return stack.resolve((request) => requestHandler.handle(request.request, options || {}), handlerExecutionContext);
    }
    serialize(input, context) {
        return serializeAws_queryListIdentityPoliciesCommand(input, context);
    }
    deserialize(output, context) {
        return deserializeAws_queryListIdentityPoliciesCommand(output, context);
    }
}
