import { getEndpointPlugin } from "@aws-sdk/middleware-endpoint";
import { getSerdePlugin } from "@aws-sdk/middleware-serde";
import { Command as $Command } from "@aws-sdk/smithy-client";
import { DescribeReceiptRuleRequestFilterSensitiveLog, DescribeReceiptRuleResponseFilterSensitiveLog, } from "../models/models_0";
import { deserializeAws_queryDescribeReceiptRuleCommand, serializeAws_queryDescribeReceiptRuleCommand, } from "../protocols/Aws_query";
export class DescribeReceiptRuleCommand extends $Command {
    constructor(input) {
        super();
        this.input = input;
    }
    static getEndpointParameterInstructions() {
        return {
            UseFIPS: { type: "builtInParams", name: "useFipsEndpoint" },
            Endpoint: { type: "builtInParams", name: "endpoint" },
            Region: { type: "builtInParams", name: "region" },
            UseDualStack: { type: "builtInParams", name: "useDualstackEndpoint" },
        };
    }
    resolveMiddleware(clientStack, configuration, options) {
        this.middlewareStack.use(getSerdePlugin(configuration, this.serialize, this.deserialize));
        this.middlewareStack.use(getEndpointPlugin(configuration, DescribeReceiptRuleCommand.getEndpointParameterInstructions()));
        const stack = clientStack.concat(this.middlewareStack);
        const { logger } = configuration;
        const clientName = "SESClient";
        const commandName = "DescribeReceiptRuleCommand";
        const handlerExecutionContext = {
            logger,
            clientName,
            commandName,
            inputFilterSensitiveLog: DescribeReceiptRuleRequestFilterSensitiveLog,
            outputFilterSensitiveLog: DescribeReceiptRuleResponseFilterSensitiveLog,
        };
        const { requestHandler } = configuration;
        return stack.resolve((request) => requestHandler.handle(request.request, options || {}), handlerExecutionContext);
    }
    serialize(input, context) {
        return serializeAws_queryDescribeReceiptRuleCommand(input, context);
    }
    deserialize(output, context) {
        return deserializeAws_queryDescribeReceiptRuleCommand(output, context);
    }
}
