import { getEndpointPlugin } from "@aws-sdk/middleware-endpoint";
import { getSerdePlugin } from "@aws-sdk/middleware-serde";
import { Command as $Command } from "@aws-sdk/smithy-client";
import { CreateReceiptRuleSetRequestFilterSensitiveLog, CreateReceiptRuleSetResponseFilterSensitiveLog, } from "../models/models_0";
import { deserializeAws_queryCreateReceiptRuleSetCommand, serializeAws_queryCreateReceiptRuleSetCommand, } from "../protocols/Aws_query";
export class CreateReceiptRuleSetCommand extends $Command {
    constructor(input) {
        super();
        this.input = input;
    }
    static getEndpointParameterInstructions() {
        return {
            UseFIPS: { type: "builtInParams", name: "useFipsEndpoint" },
            Endpoint: { type: "builtInParams", name: "endpoint" },
            Region: { type: "builtInParams", name: "region" },
            UseDualStack: { type: "builtInParams", name: "useDualstackEndpoint" },
        };
    }
    resolveMiddleware(clientStack, configuration, options) {
        this.middlewareStack.use(getSerdePlugin(configuration, this.serialize, this.deserialize));
        this.middlewareStack.use(getEndpointPlugin(configuration, CreateReceiptRuleSetCommand.getEndpointParameterInstructions()));
        const stack = clientStack.concat(this.middlewareStack);
        const { logger } = configuration;
        const clientName = "SESClient";
        const commandName = "CreateReceiptRuleSetCommand";
        const handlerExecutionContext = {
            logger,
            clientName,
            commandName,
            inputFilterSensitiveLog: CreateReceiptRuleSetRequestFilterSensitiveLog,
            outputFilterSensitiveLog: CreateReceiptRuleSetResponseFilterSensitiveLog,
        };
        const { requestHandler } = configuration;
        return stack.resolve((request) => requestHandler.handle(request.request, options || {}), handlerExecutionContext);
    }
    serialize(input, context) {
        return serializeAws_queryCreateReceiptRuleSetCommand(input, context);
    }
    deserialize(output, context) {
        return deserializeAws_queryCreateReceiptRuleSetCommand(output, context);
    }
}
