import { getEndpointPlugin } from "@aws-sdk/middleware-endpoint";
import { getSerdePlugin } from "@aws-sdk/middleware-serde";
import { Command as $Command } from "@aws-sdk/smithy-client";
import { CloneReceiptRuleSetRequestFilterSensitiveLog, CloneReceiptRuleSetResponseFilterSensitiveLog, } from "../models/models_0";
import { deserializeAws_queryCloneReceiptRuleSetCommand, serializeAws_queryCloneReceiptRuleSetCommand, } from "../protocols/Aws_query";
export class CloneReceiptRuleSetCommand extends $Command {
    constructor(input) {
        super();
        this.input = input;
    }
    static getEndpointParameterInstructions() {
        return {
            UseFIPS: { type: "builtInParams", name: "useFipsEndpoint" },
            Endpoint: { type: "builtInParams", name: "endpoint" },
            Region: { type: "builtInParams", name: "region" },
            UseDualStack: { type: "builtInParams", name: "useDualstackEndpoint" },
        };
    }
    resolveMiddleware(clientStack, configuration, options) {
        this.middlewareStack.use(getSerdePlugin(configuration, this.serialize, this.deserialize));
        this.middlewareStack.use(getEndpointPlugin(configuration, CloneReceiptRuleSetCommand.getEndpointParameterInstructions()));
        const stack = clientStack.concat(this.middlewareStack);
        const { logger } = configuration;
        const clientName = "SESClient";
        const commandName = "CloneReceiptRuleSetCommand";
        const handlerExecutionContext = {
            logger,
            clientName,
            commandName,
            inputFilterSensitiveLog: CloneReceiptRuleSetRequestFilterSensitiveLog,
            outputFilterSensitiveLog: CloneReceiptRuleSetResponseFilterSensitiveLog,
        };
        const { requestHandler } = configuration;
        return stack.resolve((request) => requestHandler.handle(request.request, options || {}), handlerExecutionContext);
    }
    serialize(input, context) {
        return serializeAws_queryCloneReceiptRuleSetCommand(input, context);
    }
    deserialize(output, context) {
        return deserializeAws_queryCloneReceiptRuleSetCommand(output, context);
    }
}
